/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.BehaviorRecorder.jgraphwindow;

import edu.cmu.pact.BehaviorRecorder.Controller.PseudoTutorMessageHandler;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ExampleTracerTracer;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.Groups.GroupEditorContext;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.Groups.GroupModel;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.Groups.LinkGroup;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ProblemEdge;
import edu.cmu.pact.BehaviorRecorder.View.BRPanel;
import edu.cmu.pact.BehaviorRecorder.View.CheckLispLabel;
import edu.cmu.pact.BehaviorRecorder.View.RuleLabel;
import edu.cmu.pact.BehaviorRecorder.jgraphwindow.BR_JGraphEdgeView;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.List;
import java.util.Vector;
import javax.swing.ImageIcon;
import org.jgraph.JGraph;
import org.jgraph.graph.CellView;
import org.jgraph.graph.EdgeRenderer;

public class BR_EdgeRenderer
extends EdgeRenderer {
    private static final double SYMBOLLENFRACTION = 0.9;
    private static final int SYMBOLSPACING = 15;
    private static final int SYMBOLWIDTH = 10;
    private static final long serialVersionUID = 1L;
    private BR_JGraphEdgeView edgeView;
    private final Stroke lineStroke = new BasicStroke(1.5f);
    private boolean showActionLabels;
    private boolean showRuleLabels;
    private boolean showPreLispCheckLabels;

    public void paint(Graphics g) {
        super.paint(g);
        Rectangle jgraphClipBounds = this.edgeView.getProblemEdge().getController().getJGraphWindow().getJGraph().getClipBounds();
        this.showActionLabels = this.edgeView.getProblemEdge().getController().getShowActionLabels();
        this.showRuleLabels = this.edgeView.getProblemEdge().getController().getShowRuleLabels();
        this.showPreLispCheckLabels = this.edgeView.getProblemEdge().getController().isPreCheckLISPLabelsFlag();
        int labelCount = 0;
        if (this.showPreLispCheckLabels) {
            ++labelCount;
        }
        if (this.showActionLabels) {
            ++labelCount;
        }
        if (this.showRuleLabels) {
            labelCount += this.edgeView.getProblemEdge().getEdgeData().getRuleLabels().size();
        }
        GroupEditorContext editContext = this.edgeView.getProblemEdge().getController().getProblemModel().getEditContext();
        this.drawGroups(g, jgraphClipBounds, editContext);
        if (this.showPreLispCheckLabels) {
            this.drawPreLispCheckLabels(g, labelCount, jgraphClipBounds);
        }
        if (this.showActionLabels) {
            this.drawActionLabel(g, labelCount, jgraphClipBounds);
        }
        if (this.showRuleLabels) {
            this.drawRuleLabels(g, labelCount, jgraphClipBounds);
        }
    }

    private void drawGroups(Graphics g, Rectangle jgraphClipBounds, GroupEditorContext editContext) {
        GroupModel groupModel = editContext.getGroupModel();
        List<LinkGroup> groupsToDraw = editContext.getDisplayedGroupsByLink(this.edgeView.getProblemEdge().getController().getExampleTracerGraph().getLink(this.edgeView.getProblemEdge()));
        editContext.resetProblemEdgeMap(this.edgeView.getProblemEdge());
        Point2D startPoint = this.edgeView.getPoint(0);
        Point2D endPoint = this.edgeView.getPoint(this.edgeView.getPointCount() - 1);
        Point2D.Double edgeCenter = new Point2D.Double((startPoint.getX() + endPoint.getX()) / 2.0, (startPoint.getY() + endPoint.getY()) / 2.0);
        Point2D.Double arrowVector = new Point2D.Double(startPoint.getX() - endPoint.getX(), endPoint.getY() - startPoint.getY());
        double rotation = Math.atan2(((Point2D)arrowVector).getX(), ((Point2D)arrowVector).getY()) - 1.57079633;
        double groupSymbolLength = Point2D.distance(startPoint.getX(), startPoint.getY(), endPoint.getX(), endPoint.getY()) * 0.9;
        Graphics2D g2D = (Graphics2D)g;
        for (int i = 0; i < groupsToDraw.size(); ++i) {
            if (groupsToDraw.get(i) == null) continue;
            LinkGroup groupToDraw = groupsToDraw.get(i);
            g2D.setColor(Color.BLACK);
            Shape shapeToDraw = groupModel.isGroupOrdered(groupToDraw) ? new Rectangle2D.Double(((Point2D)edgeCenter).getX() - groupSymbolLength / 2.0, ((Point2D)edgeCenter).getY() + (double)(15 * (i + 1)), groupSymbolLength, 10.0) : new Ellipse2D.Double(((Point2D)edgeCenter).getX() - groupSymbolLength / 2.0, ((Point2D)edgeCenter).getY() + (double)(15 * (i + 1)), groupSymbolLength, 10.0);
            g2D.setClip(jgraphClipBounds);
            AffineTransform transform = g2D.getTransform();
            transform.rotate(rotation, ((Point2D)edgeCenter).getX(), ((Point2D)edgeCenter).getY());
            shapeToDraw = transform.createTransformedShape(shapeToDraw);
            g.setColor(editContext.getGroupColor(groupToDraw));
            g2D.fill(shapeToDraw);
            if (editContext.getGroupIsHovered(groupToDraw)) {
                g.setColor(Color.BLUE);
            }
            if (editContext.getSelectedGroup() != null && editContext.getSelectedGroup().equals(groupToDraw)) {
                g.setColor(Color.GREEN);
            }
            g2D.setStroke(new BasicStroke(2.0f));
            g2D.draw(shapeToDraw);
            editContext.addEdgeShapeGroupMap(this.edgeView.getProblemEdge(), shapeToDraw, groupToDraw);
        }
    }

    private void drawPreLispCheckLabels(Graphics g, int labelCount, Rectangle jgraphClipBounds) {
        CheckLispLabel PreLispCheckLabel = this.edgeView.getProblemEdge().getEdgeData().getPreLispCheckLabel();
        int slices = labelCount + 1;
        int currentLabel = 1;
        if (this.showActionLabels) {
            ++currentLabel;
        }
        int oneSlice = 1000 / slices;
        String text = PreLispCheckLabel.getText();
        Rectangle2D LispCheckLabelBounds = this.drawLabel(g, oneSlice * currentLabel, text, null, Color.black, PreLispCheckLabel.getFont(), jgraphClipBounds);
        this.edgeView.setLispCheckLabelBounds(LispCheckLabelBounds);
    }

    private void drawRuleLabels(Graphics g, int labelCount, Rectangle jgraphClipBounds) {
        this.edgeView.clearRuleBoundsList();
        Vector<RuleLabel> ruleList = this.edgeView.getProblemEdge().getEdgeData().getRuleLabels();
        Font font2 = this.edgeView.getProblemEdge().getEdgeData().getActionLabel().getFont();
        ExampleTracerTracer exampleTracer = this.edgeView.getProblemEdge().getController().getExampleTracer();
        if (PseudoTutorMessageHandler.USE_NEW_EXAMPLE_TRACER) {
            boolean visited = this.edgeIsVisited(exampleTracer);
            font2 = visited ? BRPanel.VISITED_EDGE_FONT : (this.edgeView.isMouseOver() ? BRPanel.NORMAL_FONT : BRPanel.SMALL_FONT);
        }
        int slices = labelCount + 1;
        int currentLabel = 1;
        if (this.showActionLabels) {
            ++currentLabel;
        }
        if (this.showPreLispCheckLabels) {
            ++currentLabel;
        }
        int oneSlice = 1000 / slices;
        for (RuleLabel ruleLabel : ruleList) {
            String text = ruleLabel.getText();
            Rectangle2D ruleLabelBounds = this.drawLabel(g, oneSlice * currentLabel, text, null, Color.black, font2, jgraphClipBounds);
            this.edgeView.addRuleBound(ruleLabelBounds);
            ++currentLabel;
        }
    }

    private boolean edgeIsVisited(ExampleTracerTracer exampleTracer) {
        boolean visited = false;
        ProblemEdge problemEdge = this.edgeView.getProblemEdge();
        visited = exampleTracer.isLinkVisited(problemEdge.getUniqueID());
        return visited;
    }

    private void drawActionLabel(Graphics g, int labelCount, Rectangle jgraphClipBounds) {
        int location = 1000 / (1 + labelCount);
        String label = this.edgeView.getProblemEdge().getEdgeData().getActionLabel().getText();
        Font font2 = this.edgeView.getProblemEdge().getEdgeData().getActionLabel().getFont();
        ExampleTracerTracer exampleTracer = this.edgeView.getProblemEdge().getController().getExampleTracer();
        if (PseudoTutorMessageHandler.USE_NEW_EXAMPLE_TRACER) {
            boolean visited = this.edgeIsVisited(exampleTracer);
            font2 = visited ? BRPanel.VISITED_EDGE_FONT : (this.edgeView.isMouseOver() ? BRPanel.NORMAL_FONT : BRPanel.SMALL_FONT);
        }
        Color textColor = this.edgeView.getProblemEdge().getActionLabel().getForeground();
        Rectangle2D actionLabelBounds = this.drawLabel(g, location, label, null, textColor, font2, jgraphClipBounds);
        this.edgeView.setActionLabelBounds(actionLabelBounds);
    }

    private Rectangle2D drawLabel(Graphics g, int lineLocation, String label, ImageIcon icon, Color textColor, Font font, Rectangle jgraphClipBounds) {
        Point2D labelPosition2 = this.getLabelPosition(new Point(lineLocation, 0));
        g.setFont(font);
        Graphics2D g2 = (Graphics2D)g;
        double x2 = labelPosition2.getX();
        double y2 = labelPosition2.getY();
        Rectangle2D stringBounds = this.getFontMetrics(font).getStringBounds(label, g);
        int newX = (int)(stringBounds.getX() + x2 - stringBounds.getWidth() / 2.0);
        int newY = (int)(stringBounds.getY() + y2);
        int iconWidth = 0;
        if (icon != null) {
            iconWidth = icon.getIconWidth();
        }
        Rectangle2D labelBounds = this.getClipBounds(stringBounds, newX, newY, iconWidth);
        labelBounds = labelBounds.createIntersection(jgraphClipBounds);
        g.setClip(labelBounds);
        g2.setColor(new Color(248, 248, 248));
        g2.fill(labelBounds);
        g2.setStroke(this.lineStroke);
        g2.setColor(Color.GRAY);
        g2.draw(labelBounds);
        g2.setColor(textColor);
        g2.drawString(label, (float)(x2 - stringBounds.getWidth() / 2.0) + (float)(iconWidth / 2), (float)y2);
        this.drawIcon(g, icon, labelBounds);
        return labelBounds;
    }

    private void drawIcon(Graphics g, ImageIcon icon, Rectangle2D actionLabelBounds) {
        if (icon == null) {
            return;
        }
        int iconX = (int)actionLabelBounds.getMinX();
        int iconY = (int)(actionLabelBounds.getMinY() + (actionLabelBounds.getHeight() - (double)icon.getIconHeight()) / 2.0);
        g.drawImage(icon.getImage(), iconX, iconY, null);
    }

    private Rectangle2D getClipBounds(Rectangle2D stringBounds, int newX, int newY, int iconWidth) {
        Rectangle2D.Float clipBounds = new Rectangle2D.Float(newX, newY, (int)stringBounds.getWidth(), (int)stringBounds.getHeight());
        int pad = 3;
        Rectangle2D.Double newclipBounds = new Rectangle2D.Double(((RectangularShape)clipBounds).getX() - (double)pad - (double)(iconWidth / 2), ((RectangularShape)clipBounds).getY() - (double)pad, ((RectangularShape)clipBounds).getWidth() + (double)(pad * 2) + (double)iconWidth, ((RectangularShape)clipBounds).getHeight() + (double)(pad * 2));
        return newclipBounds;
    }

    public Component getRendererComponent(JGraph graph, CellView view, boolean sel, boolean focus, boolean preview) {
        this.edgeView = (BR_JGraphEdgeView)view;
        return super.getRendererComponent(graph, view, sel, focus, preview);
    }
}

