/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.BehaviorRecorder.View;

import edu.cmu.pact.BehaviorRecorder.Controller.BR_Controller;
import edu.cmu.pact.BehaviorRecorder.Controller.CtatModeEvent;
import edu.cmu.pact.BehaviorRecorder.Controller.PseudoTutorMessageBuilder;
import edu.cmu.pact.BehaviorRecorder.Dialogs.InsertSubgraphDialog;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.EdgeCreatedEvent;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.EdgeData;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ProblemEdge;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ProblemGraph;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ProblemNode;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.NodeCreatedEvent;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.NodeUpdatedEvent;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.ProblemModel;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.ProblemModelEvent;
import edu.cmu.pact.BehaviorRecorder.View.BRPanel;
import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.ctat.MessageObject;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.border.Border;

public class NodeView
extends JTextField {
    private static final long serialVersionUID = 1179326355714681798L;
    private static final String RUN_TREE_LAYOUT = "Run Tree Layout";
    private String nodeName;
    private boolean locked = false;
    private Point incomingEdgePoint;
    private Point outgoingEdgePoint;
    private int widthBuffer = 10;
    public static final int VERTEX_SEPERATION_DISTANCE = 20;
    private Border originalBorder;
    private Border outlineBorder;
    private boolean pasteSubgraphFlag = true;
    private ProblemNode problemNode = null;
    private transient BR_Controller controller;
    private List<ProblemModelEvent> subEvents;
    public static final String DELETE = "Delete...";
    public static final String RENAME = "Rename...";
    public static final String CREATE = "Add Blank Step";
    public static final String CREATE_DISABLED = "Add Blank Step (Enabled in 'Demonstrate' Mode)";
    public static final String COPY = "Copy Subgraph";
    public static final String MOVE_SUBGRAPH = "Move Subgraph";
    public static final String PASTE = "Paste Subgraph";
    public static final String INSERT_SUBGRAPH = "Insert Subgraph from File";
    private static final String CANCEL_DEMONSTRATE_LINK = "Cancel Demonstrate This Link Mode";

    public void restoreTransients(BR_Controller controller) {
        this.controller = controller;
    }

    public void setPasteSubgraphFlag(boolean pasteSubgraphFlag) {
        this.pasteSubgraphFlag = pasteSubgraphFlag;
    }

    public boolean getPasteSubgraphFlag() {
        return this.pasteSubgraphFlag;
    }

    public void setProblemNode(ProblemNode problemNode) {
        this.problemNode = problemNode;
        if (problemNode != null) {
            problemNode.setName(this.getText());
        }
    }

    public NodeView(BR_Controller controller) {
        this("state" + controller.getProblemModel().getNodeUniqueIDGenerator(), controller);
    }

    public NodeView(String nodeName, BR_Controller controller) {
        super(nodeName);
        this.controller = controller;
        this.setText(nodeName);
        this.nodeName = nodeName;
        this.setVisible(true);
        this.updateSize();
        this.setEditable(false);
        this.setBackground(Color.white);
        ProblemModel pm = controller.getProblemModel();
        pm.updateNodeUniqueIDGenerator(pm.getNodeUniqueIDGenerator() + 1);
        this.setHorizontalAlignment(0);
        this.updateToolTip();
        this.originalBorder = this.getBorder();
        this.outlineBorder = BorderFactory.createLineBorder(Color.blue.brighter(), 5);
    }

    private void updateToolTip() {
        String click = "Right-click";
        if (System.getProperty("os.name").startsWith("Mac")) {
            click = "Ctrl-click";
        }
        this.setToolTipText("<html><b>Problem State \"" + this.getText() + "\"</b><br>" + click + " to edit, drag to move, click to go to state.</html>");
    }

    public Point getCenterPoint() {
        Point upperLeft = this.getLocation();
        upperLeft.x += this.getWidth() / 2;
        upperLeft.y += this.getHeight() / 2;
        return upperLeft;
    }

    public Point getBottomCenterPoint() {
        Point upperLeft = this.getLocation();
        upperLeft.x += this.getWidth() / 2;
        upperLeft.y += this.getHeight();
        return upperLeft;
    }

    public boolean isDoneState() {
        if (this.getText().startsWith("Done")) {
            return true;
        }
        return this.problemNode.getDoneState();
    }

    public void showOutline(boolean showOutline) {
        if (showOutline) {
            this.setBorder(this.outlineBorder);
        } else {
            this.setBorder(this.originalBorder);
        }
    }

    NodeView cloneVertex() {
        NodeView newVertex = this.getText().startsWith("Done") ? new NodeView(this.controller.getProblemModel().nextDoneName(), this.controller) : new NodeView(this.controller);
        newVertex.setLocked(this.locked);
        newVertex.setDoneState(this.problemNode, this.isDoneState());
        return newVertex;
    }

    boolean isVisitedPasteChildNode(Vector mapNodes, ProblemNode testNode) {
        for (int i = 0; i < mapNodes.size(); ++i) {
            Vector mapPair = (Vector)mapNodes.elementAt(i);
            ProblemNode nodeTemp = (ProblemNode)mapPair.elementAt(1);
            if (nodeTemp != testNode) continue;
            return true;
        }
        return false;
    }

    ProblemNode cloneStateAndEdge(ProblemNode pasteNode, ProblemEdge edgeCopy) {
        if (pasteNode == null || edgeCopy == null) {
            return null;
        }
        ProblemNode copyChildNode = edgeCopy.getNodes()[1];
        NodeView copyChildVertex = copyChildNode.getNodeView();
        NodeView newVertex = copyChildVertex.cloneVertex();
        ProblemGraph r = this.controller.getProblemModel().getProblemGraph();
        ProblemNode node = new ProblemNode(newVertex, this.controller.getProblemModel());
        ProblemNode nodeAdded = r.addProblemNode(node);
        this.setVertexLocation(newVertex, pasteNode);
        this.controller.getProblemModel().fireProblemModelEvent(new NodeCreatedEvent(this.controller, node));
        this.cloneEdge(pasteNode, nodeAdded, edgeCopy);
        return nodeAdded;
    }

    void cloneEdge(ProblemNode FromNode, ProblemNode todNode, ProblemEdge edgeCopy) {
        if (edgeCopy == null) {
            return;
        }
        EdgeData myEdgeCopy = edgeCopy.getEdgeData();
        EdgeData myEdgeNew = myEdgeCopy.cloneEdgeData();
        if (myEdgeNew.isPreferredEdge()) {
            EdgeData myEdgeTemp = null;
            ProblemEdge edgeTemp = null;
            Enumeration<ProblemEdge> iter = this.controller.getProblemModel().getProblemGraph().getOutgoingEdges(FromNode);
            while (iter.hasMoreElements()) {
                edgeTemp = iter.nextElement();
                myEdgeTemp = edgeTemp.getEdgeData();
                myEdgeTemp.setPreferredEdge(false);
            }
        }
        myEdgeNew.getActionLabel().resetForeground();
        ProblemEdge edge = this.controller.getProblemModel().getProblemGraph().addEdge(FromNode, todNode, myEdgeNew);
        myEdgeNew.getActionLabel().update();
        edge.addEdgeLabels();
        this.controller.getProblemModel().fireProblemModelEvent(new EdgeCreatedEvent(this.controller, edge));
    }

    ProblemNode findMapNode(ProblemNode testdNode, Vector mapNodes) {
        if (mapNodes == null) {
            return null;
        }
        if (mapNodes.size() == 0) {
            return null;
        }
        if (testdNode == null) {
            return null;
        }
        for (int i = 0; i < mapNodes.size(); ++i) {
            Vector mapPair = (Vector)mapNodes.elementAt(i);
            ProblemNode nodeTemp = (ProblemNode)mapPair.elementAt(0);
            if (testdNode != nodeTemp) continue;
            return (ProblemNode)mapPair.elementAt(1);
        }
        return null;
    }

    public boolean isPasteSubgraph() {
        if (BR_Controller.getCopySubgraphNode() == null) {
            trace.out(5, this, "no copy node is selected.");
            return false;
        }
        if (this.controller.getProblemModel().getProblemGraph().outDegree(BR_Controller.getCopySubgraphNode()) == 0) {
            trace.out(5, this, "copy node has no child.");
            BR_Controller.setCopySubgraphNode(null);
            return false;
        }
        return this.isOkForPasteSubgraph();
    }

    private boolean isOkForPasteSubgraph() {
        ProblemNode problemNode = this.controller.getProblemModel().getProblemNodeForNodeView(this);
        if (problemNode.isBuggyNode()) {
            if (trace.getDebugCode("borg")) {
                trace.out("borg", "buggy node");
            }
            return false;
        }
        if (this.isDoneState()) {
            trace.out(5, this, "done node");
            return false;
        }
        if (!this.pasteSubgraphFlag) {
            trace.out(5, this, "pasteSubgraphFlag = " + this.pasteSubgraphFlag);
            return false;
        }
        return true;
    }

    public MessageObject getAuthorCreateBlankStepMessage() {
        MessageObject mo = MessageObject.create("InterfaceAction", "NotePropertySet");
        mo.setSelection("No_Selection");
        mo.setAction("No_Action");
        mo.setInput("No_Value");
        return mo;
    }

    public void addBlankState() {
        Vector<String> selection = new Vector<String>();
        Vector<String> action = new Vector<String>();
        Vector<String> input = new Vector<String>();
        selection.addElement("No_Selection");
        action.addElement("No_Action");
        input.addElement("No_Value");
        MessageObject mo = PseudoTutorMessageBuilder.buildCommCorrectMessage(selection, action, input, this.controller);
        this.controller.createNewEdge(this.problemNode, null, selection, action, input, mo, "Correct Action", null, 0);
    }

    public void renameState() {
        String newName;
        Object response;
        trace.out("rename state");
        if (this.problemNode == null) {
            this.problemNode = this.controller.getProblemModel().getProblemNodeForNodeView(this);
        }
        String oldName = this.getText().trim();
        String title = "Rename state " + oldName;
        if (this.problemNode == this.controller.getProblemModel().getStartNode()) {
            String[] messages = new String[]{"The start node text is generally the same as the problem .brd file name.", "If you want to keep them the same you may select the menu item", "'Save Graph As...' under the menu 'File' after you change the node text."};
            response = JOptionPane.showInputDialog(this.controller.getActiveWindow(), messages, title, 3, null, null, oldName);
        } else {
            response = JOptionPane.showInputDialog(this.controller.getActiveWindow(), "Please enter the new state name:", title, 3, null, null, oldName);
        }
        String string = newName = response == null ? "" : response.toString();
        while (this.controller.getProblemModel().getNode(newName) != null) {
            String[] messages = new String[]{"The name \"+newName+\" matches a state name already in use.", "Please enter a different state name or an empty name to quit."};
            newName = JOptionPane.showInputDialog(this.controller.getActiveWindow(), messages, title, 3);
        }
        if (newName != null && !newName.equals("")) {
            this.setText(newName);
            if (this.problemNode == this.controller.getProblemModel().getStartNode()) {
                this.controller.updateStatusPanel("Select File->'Save Graph As ...' to save the problem");
            } else {
                this.controller.updateStatusPanel(null);
            }
            NodeUpdatedEvent nodeUpdatedEvent = new NodeUpdatedEvent(this.controller, this.getProblemNode());
            this.controller.getProblemModel().fireProblemModelEvent(nodeUpdatedEvent);
        }
        this.controller.fireCtatModeEvent(CtatModeEvent.REPAINT);
    }

    public void setIncomingEdgePoint(Point p) {
        this.incomingEdgePoint = p;
    }

    public void setOutgoingEdgePoint(Point p) {
        this.outgoingEdgePoint = p;
    }

    public Point getIncomingEdgePoint() {
        if (this.incomingEdgePoint != null) {
            return this.incomingEdgePoint;
        }
        return this.getMidPoints()[2];
    }

    public Point getOutgoingEdgePoint() {
        if (this.outgoingEdgePoint != null) {
            return this.outgoingEdgePoint;
        }
        return this.getMidPoints()[0];
    }

    public Point[] getMidPoints() {
        Point location = this.getLocation();
        Dimension size = this.getSize();
        Point[] midPoints = new Point[4];
        for (int i = 0; i < 4; ++i) {
            midPoints[i] = new Point();
        }
        midPoints[0].x = location.x + size.width / 2;
        midPoints[0].y = location.y;
        midPoints[1].x = location.x + size.width;
        midPoints[1].y = location.y + size.height / 2;
        midPoints[2].x = location.x + size.width / 2;
        midPoints[2].y = location.y + size.height;
        midPoints[3].x = location.x;
        midPoints[3].y = location.y + size.height / 2;
        return midPoints;
    }

    private void updateSize() {
        FontMetrics fontMetrics = this.getFontMetrics(BRPanel.BOLD_FONT);
        int width = fontMetrics.stringWidth(this.nodeName) + this.widthBuffer;
        this.setSize(new Dimension(width, 25));
    }

    @Override
    public void setText(String s) {
        if (this.problemNode != null) {
            this.problemNode.setName(s);
        }
        this.select(0, 0);
        this.nodeName = s;
        this.updateSize();
        this.updateToolTip();
        super.setText(s);
    }

    public boolean equals(NodeView v) {
        return this.getUniqueID() == v.getUniqueID();
    }

    public int getUniqueID() {
        return this.problemNode.getUniqueID();
    }

    public void setUniqueID(int uniqueIDValue) {
        this.problemNode.setUniqueID(uniqueIDValue);
    }

    public boolean getLocked() {
        return this.locked;
    }

    public void setLocked(boolean lockFlag) {
        this.locked = lockFlag;
    }

    public boolean getDoneState() {
        if (this.problemNode == null) {
            return false;
        }
        return this.problemNode.getDoneState();
    }

    public void setDoneState(ProblemNode problemNode, boolean doneStatelag) {
        problemNode.setDoneState(doneStatelag);
    }

    public static Point findClosestPoint(NodeView vertex, Point[] endPoints) {
        Point startPoint = vertex.getLocation();
        Dimension size = vertex.getSize();
        startPoint.x += size.width / 2;
        startPoint.y += size.height / 2;
        float distance = 10000.0f;
        int closest = 0;
        for (int i = 0; i < endPoints.length; ++i) {
            float newDistance = NodeView.distance(startPoint, endPoints[i]);
            if (!(newDistance < distance)) continue;
            distance = newDistance;
            closest = i;
        }
        return endPoints[closest];
    }

    protected static float distance(Point p1, Point p2) {
        int xd = p1.x - p2.x;
        int yd = p1.y - p2.y;
        return (float)Math.sqrt(xd * xd + yd * yd);
    }

    public static Point[] getEdgePoints(NodeView startVertex, NodeView endVertex) {
        Point[] startMidPoints = startVertex.getMidPoints();
        Point[] endMidPoints = endVertex.getMidPoints();
        Point[] points = new Point[]{startMidPoints[2], NodeView.findClosestPoint(startVertex, endMidPoints)};
        return points;
    }

    public void moveTree(int deltaX, int deltaY, int dragNum) {
    }

    public ProblemNode getProblemNode() {
        return this.problemNode;
    }

    @Override
    public void copy() {
        String errorMsg = null;
        if (this.controller.getProblemModel().getProblemGraph().outDegree(this.problemNode) == 0) {
            errorMsg = "The selected node has no outgoing links so the copy operation has been cancelled";
        }
        if (this.problemNode.isBuggyNode() || this.isDoneState()) {
            errorMsg = "You cannot copy the subgraph of a buggy or done state";
        }
        if (errorMsg != null) {
            if (trace.getDebugCode("borg")) {
                trace.out("borg", errorMsg);
            }
            BR_Controller.setCopySubgraphNode(null);
        } else {
            BR_Controller.setCopySubgraphNode(this.problemNode);
        }
    }

    @Override
    public void paste() {
        String errorMsg = null;
        ProblemNode copyNode = BR_Controller.getCopySubgraphNode();
        if (copyNode == null) {
            errorMsg = "No copynode selected";
        }
        if (this.controller.getProblemModel().isLeaf(copyNode)) {
            errorMsg = "The copynode has no outgoing edges";
        }
        if (errorMsg != null) {
            return;
        }
        BR_Controller.setCopySubgraphNode(null);
        this.paste(copyNode);
    }

    public Map<ProblemEdge, ProblemEdge> pasteUntil(ProblemNode copyNode, Set<String> stopNodes) {
        ProblemEdge tempEdge;
        HashMap<ProblemNode, ProblemNode> oldToNewMapping = new HashMap<ProblemNode, ProblemNode>();
        HashSet<ProblemEdge> allNewEdges = new HashSet<ProblemEdge>();
        HashMap<ProblemEdge, ProblemEdge> oldToNewEdges = new HashMap<ProblemEdge, ProblemEdge>();
        this.subEvents = new ArrayList<ProblemModelEvent>();
        if (trace.getDebugCode("mg")) {
            trace.out("mg", "NodeView.pasteUntil(copyNode=" + copyNode + ",\n  stopNodes=" + stopNodes + ")");
        }
        ProblemModel pm = this.problemNode.getProblemModel();
        ProblemGraph graph = pm.getProblemGraph();
        Enumeration<ProblemEdge> outEdges = graph.getOutgoingEdges(this.problemNode);
        ProblemEdge preferredEdge = null;
        while (outEdges.hasMoreElements()) {
            tempEdge = outEdges.nextElement();
            if (!tempEdge.isPreferredEdge()) continue;
            preferredEdge = tempEdge;
            break;
        }
        this.pasteSubGraph2Until(this.problemNode, copyNode, oldToNewMapping, allNewEdges, oldToNewEdges, stopNodes);
        if (preferredEdge != null) {
            outEdges = graph.getOutgoingEdges(this.problemNode);
            while (outEdges.hasMoreElements()) {
                tempEdge = outEdges.nextElement();
                if (tempEdge == preferredEdge) continue;
                tempEdge.getEdgeData().setPreferredEdge(false);
            }
        }
        return oldToNewEdges;
    }

    public Map<ProblemEdge, ProblemEdge> paste(ProblemNode copyNode) {
        ProblemEdge tempEdge;
        HashMap<ProblemNode, ProblemNode> oldToNewMapping = new HashMap<ProblemNode, ProblemNode>();
        HashSet<ProblemEdge> allNewEdges = new HashSet<ProblemEdge>();
        HashMap<ProblemEdge, ProblemEdge> oldToNewEdges = new HashMap<ProblemEdge, ProblemEdge>();
        this.subEvents = new ArrayList<ProblemModelEvent>();
        ProblemModel pm = this.problemNode.getProblemModel();
        ProblemGraph graph = pm.getProblemGraph();
        Enumeration<ProblemEdge> outEdges = graph.getOutgoingEdges(this.problemNode);
        ProblemEdge preferredEdge = null;
        while (outEdges.hasMoreElements()) {
            tempEdge = outEdges.nextElement();
            if (!tempEdge.isPreferredEdge()) continue;
            preferredEdge = tempEdge;
            break;
        }
        this.pasteSubGraph2(this.problemNode, copyNode, oldToNewMapping, allNewEdges, oldToNewEdges);
        if (preferredEdge != null) {
            outEdges = graph.getOutgoingEdges(this.problemNode);
            while (outEdges.hasMoreElements()) {
                tempEdge = outEdges.nextElement();
                if (tempEdge == preferredEdge) continue;
                tempEdge.getEdgeData().setPreferredEdge(false);
            }
        }
        NodeCreatedEvent fireMe = new NodeCreatedEvent(this, ((NodeCreatedEvent)this.subEvents.get(0)).getNode(), new ArrayList<ProblemModelEvent>(this.subEvents.subList(1, this.subEvents.size())));
        this.controller.getProblemModel().fireProblemModelEvent(fireMe);
        return oldToNewEdges;
    }

    private void pasteSubGraph2(ProblemNode pasteNode, ProblemNode copyNode, HashMap<ProblemNode, ProblemNode> oldToNewNodeMapping, HashSet<ProblemEdge> allInspectedEdges, HashMap<ProblemEdge, ProblemEdge> oldToNewEdges) {
        int i;
        List<ProblemEdge> outEdges = copyNode.getOutgoingEdges();
        if (outEdges.size() == 0) {
            return;
        }
        ArrayList<ProblemNode> newNodes = new ArrayList<ProblemNode>();
        ArrayList<ProblemNode> newNodesOldNodes = new ArrayList<ProblemNode>();
        for (i = 0; i < outEdges.size(); ++i) {
            ProblemEdge newEdge;
            ProblemEdge currEdge = outEdges.get(i);
            if (allInspectedEdges.contains(currEdge)) continue;
            EdgeData newData = currEdge.getEdgeData().cloneEdgeData(pasteNode.getProblemModel());
            ProblemNode currNode = currEdge.getDest();
            ProblemNode tempNode = oldToNewNodeMapping.get(currNode);
            if (tempNode == null) {
                ProblemNode newNode = this.controller.createProblemNode(pasteNode, newData.getSelection(), pasteNode.getOutDegree());
                newNodes.add(newNode);
                newNodesOldNodes.add(currNode);
                this.subEvents.add(new NodeCreatedEvent(this, newNode));
                oldToNewNodeMapping.put(copyNode, pasteNode);
                newEdge = this.controller.getProblemModel().getProblemGraph().addEdge(pasteNode, newNode, newData);
            } else {
                newEdge = this.controller.getProblemModel().getProblemGraph().addEdge(pasteNode, tempNode, newData);
            }
            newEdge.addEdgeLabels();
            newData.getActionLabel().update();
            allInspectedEdges.add(newEdge);
            allInspectedEdges.add(currEdge);
            oldToNewEdges.put(currEdge, newEdge);
            this.subEvents.add(new EdgeCreatedEvent(this, newEdge));
        }
        for (i = 0; i < newNodes.size(); ++i) {
            this.pasteSubGraph2((ProblemNode)newNodes.get(i), (ProblemNode)newNodesOldNodes.get(i), oldToNewNodeMapping, allInspectedEdges, oldToNewEdges);
        }
    }

    private void pasteSubGraph2Until(ProblemNode pasteNode, ProblemNode copyNode, HashMap<ProblemNode, ProblemNode> oldToNewNodeMapping, HashSet<ProblemEdge> allInspectedEdges, HashMap<ProblemEdge, ProblemEdge> oldToNewEdges, Set<String> stopNodes) {
        int i;
        List<ProblemEdge> outEdges = copyNode.getOutgoingEdges();
        if (outEdges.size() == 0) {
            return;
        }
        ArrayList<ProblemNode> newNodes = new ArrayList<ProblemNode>();
        ArrayList<ProblemNode> newNodesOldNodes = new ArrayList<ProblemNode>();
        for (i = 0; i < outEdges.size(); ++i) {
            ProblemEdge newEdge;
            ProblemEdge currEdge = outEdges.get(i);
            if (stopNodes.contains(currEdge.getEdgeData().getName()) || allInspectedEdges.contains(currEdge)) continue;
            EdgeData newData = currEdge.getEdgeData().cloneEdgeData(pasteNode.getProblemModel());
            ProblemNode currNode = currEdge.getDest();
            ProblemNode tempNode = oldToNewNodeMapping.get(currNode);
            if (tempNode == null) {
                ProblemNode newNode = this.controller.createProblemNode(pasteNode, newData.getSelection(), pasteNode.getOutDegree());
                newNodes.add(newNode);
                newNodesOldNodes.add(currNode);
                this.subEvents.add(new NodeCreatedEvent(this, newNode));
                oldToNewNodeMapping.put(copyNode, pasteNode);
                newEdge = this.controller.getProblemModel().getProblemGraph().addEdge(pasteNode, newNode, newData);
            } else {
                newEdge = this.controller.getProblemModel().getProblemGraph().addEdge(pasteNode, tempNode, newData);
            }
            newEdge.addEdgeLabels();
            newData.getActionLabel().update();
            allInspectedEdges.add(newEdge);
            allInspectedEdges.add(currEdge);
            oldToNewEdges.put(currEdge, newEdge);
            this.subEvents.add(new EdgeCreatedEvent(this, newEdge));
        }
        for (i = 0; i < newNodes.size(); ++i) {
            this.pasteSubGraph2Until((ProblemNode)newNodes.get(i), (ProblemNode)newNodesOldNodes.get(i), oldToNewNodeMapping, allInspectedEdges, oldToNewEdges, stopNodes);
        }
    }

    void setVertexLocation(NodeView atVertex, ProblemNode sourceNode) {
        int childCount = this.controller.getProblemModel().getProblemGraph().outDegree(sourceNode);
        trace.out(5, this, "childCount = " + childCount);
        NodeView sourceVertex = sourceNode.getNodeView();
        Point parentLocation = sourceVertex.getLocation();
        parentLocation.x += sourceVertex.getSize().width / 2;
        Point newLocation = NodeView.getNewVertexLocation(parentLocation, childCount);
        newLocation.x -= atVertex.getSize().width / 2;
        atVertex.setLocation(newLocation);
        System.err.println("New Location = " + newLocation);
    }

    public static Point getNewVertexLocation(Point parentLocation, int childCount) {
        double length = 130.0;
        if (childCount == 0) {
            length = 110.0;
        }
        double angle = 0.0;
        double baseAngle = 0.6283185307179586;
        if (childCount < 5) {
            angle = (double)((childCount + 1) / 2) * baseAngle;
        } else if (childCount < 7) {
            angle = (double)((childCount + 1) / 2) * baseAngle - baseAngle / 2.0;
        } else {
            angle = baseAngle * 1.5;
            angle += (double)((childCount - 7) / 2) * baseAngle / 2.0;
            length = 180.0;
        }
        if (childCount % 2 == 1) {
            angle *= -1.0;
        }
        int x = (int)(length * Math.sin(angle));
        int y = (int)(length * Math.cos(angle));
        angle = angle / Math.PI * 180.0;
        return new Point(parentLocation.x + x, parentLocation.y + y);
    }

    public static void evaluatePopup(MouseEvent e, final ProblemNode problemNode, final BR_Controller controller, boolean showLayoutMenu) {
        boolean notStartNode = true;
        if (problemNode == controller.getProblemModel().getStartNode()) {
            notStartNode = false;
        }
        JPopupMenu popupMenu = new JPopupMenu();
        if (controller.getCtatModeModel().isDemonstrateThisLinkMode()) {
            JMenuItem menuItem = new JMenuItem(CANCEL_DEMONSTRATE_LINK);
            popupMenu.add(menuItem);
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    controller.getCtatModeModel().exitDemonstrateThisLinkMode();
                }
            });
            popupMenu.show(e.getComponent(), e.getX(), e.getY());
            return;
        }
        JMenuItem menuItem = new JMenuItem(DELETE);
        menuItem.setEnabled(notStartNode);
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println("***DELETE***");
                trace.out("problem node = " + problemNode);
                trace.out("node view = " + problemNode.getNodeView());
                controller.processDeleteNode(problemNode);
            }
        });
        popupMenu.add(menuItem);
        menuItem = new JMenuItem(RENAME);
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                problemNode.getNodeView().renameState();
                ActionEvent ae = new ActionEvent(this, 0, "Rename State");
                controller.getUndoPacket().getCheckpointAction().actionPerformed(ae);
            }
        });
        popupMenu.add(menuItem);
        menuItem = new JMenuItem(CREATE);
        if (problemNode.isBuggyNode() || problemNode.isDoneState()) {
            menuItem.setEnabled(false);
            menuItem.setToolTipText("You cannot add a blank state to a buggyNode or a DoneState");
        }
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (trace.getDebugCode("br")) {
                    trace.out("br", "CREATE:CALLED");
                }
                problemNode.getNodeView().addBlankState();
                ActionEvent ae = new ActionEvent(this, 0, NodeView.CREATE);
                controller.getUndoPacket().getCheckpointAction().actionPerformed(ae);
            }
        });
        popupMenu.add(menuItem);
        menuItem = new JMenuItem(COPY);
        menuItem.setEnabled(notStartNode);
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (trace.getDebugCode("br")) {
                    trace.out("br", NodeView.COPY);
                }
                problemNode.getNodeView().copy();
            }
        });
        popupMenu.add(menuItem);
        if (problemNode.isLeaf()) {
            menuItem.setEnabled(false);
        }
        menuItem = new JMenuItem(PASTE);
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (trace.getDebugCode("br")) {
                    trace.out("br", NodeView.PASTE);
                }
                problemNode.getNodeView().paste();
                ActionEvent ae = new ActionEvent(this, 0, NodeView.PASTE);
                controller.getUndoPacket().getCheckpointAction().actionPerformed(ae);
            }
        });
        popupMenu.add(menuItem);
        if (!problemNode.getNodeView().isPasteSubgraph()) {
            menuItem.setEnabled(false);
        }
        menuItem = new JMenuItem(INSERT_SUBGRAPH);
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (trace.getDebugCode("br")) {
                    trace.out("br", "insert subgraph");
                }
                InsertSubgraphDialog.doDialog(controller, problemNode);
                ActionEvent ae = new ActionEvent(this, 0, NodeView.INSERT_SUBGRAPH);
                controller.getUndoPacket().getCheckpointAction().actionPerformed(ae);
            }
        });
        popupMenu.add(menuItem);
        if (!problemNode.getNodeView().isOkForPasteSubgraph()) {
            menuItem.setEnabled(false);
        }
        if (showLayoutMenu) {
            menuItem = new JMenuItem(RUN_TREE_LAYOUT);
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    controller.getJGraphWindow().getJGraph().runTreeLayout(problemNode.getJGraphNode());
                    ActionEvent ae = new ActionEvent(this, 0, NodeView.RUN_TREE_LAYOUT);
                    controller.getUndoPacket().getCheckpointAction().actionPerformed(ae);
                }
            });
            popupMenu.add(menuItem);
        }
        menuItem = new JMenuItem("Run Interactive Learning here");
        menuItem.setEnabled(controller.getCtatModeModel().isSimStudentMode());
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                controller.getMissController().getSimSt().runSimStInteractiveLearning();
            }
        });
        popupMenu.add(menuItem);
        menuItem = new JCheckBoxMenuItem("Start State", problemNode.isStudentBeginsHereState());
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                problemNode.getProblemModel().setStudentBeginsHereState(problemNode);
                ActionEvent ae = new ActionEvent(this, 0, "Designate state as start state");
                controller.getUndoPacket().getCheckpointAction().actionPerformed(ae);
            }
        });
        popupMenu.add(menuItem);
        popupMenu.show(e.getComponent(), e.getX(), e.getY());
    }
}

