/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.BehaviorRecorder.View;

import edu.cmu.pact.Utilities.trace;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.InputMap;
import javax.swing.JList;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;

public class JUndo {
    public static JTextUndoPacket makeTextUndoable(JTextComponent J) {
        final JTextUndoPacket undoPack = new JTextUndoPacket(J);
        InputMap map = J.getInputMap();
        int ctrlKeyMask = 2;
        if (System.getProperty("os.name").toUpperCase().startsWith("MAC")) {
            ctrlKeyMask = 4;
        }
        KeyStroke key = KeyStroke.getKeyStroke(90, ctrlKeyMask);
        map.put(key, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                undoPack.getUndoAction().actionPerformed(e);
            }
        });
        key = KeyStroke.getKeyStroke(89, ctrlKeyMask);
        map.put(key, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                undoPack.getRedoAction().actionPerformed(e);
            }
        });
        return undoPack;
    }

    public static JAbstractUndoPacket makeAbstractUndoable(Undoable S, int n) {
        JAbstractUndoPacket undoPack = new JAbstractUndoPacket(S, n);
        return undoPack;
    }

    public static class JAbstractUndoPacket {
        private Undoable mainComponent;
        private MyAbstractUndoManager undo;
        private int historySize;
        private CheckpointAction checkpointAction;
        private ClearAction clearAction;
        private InitializeAction initializeAction;
        private UndoAction undoAction;
        private RedoAction redoAction;
        private ValidateAction validateAction;
        private Vector<String> historyStringList;
        private JList historyJList;
        private int undoDepth;
        private final String JLIST_CURRENT_STATE_NAME = "Current";

        public JAbstractUndoPacket(Undoable S, int n) {
            this.mainComponent = S;
            this.historySize = n;
            this.undo = new MyAbstractUndoManager();
            this.checkpointAction = new CheckpointAction();
            this.checkpointAction.putValue("Name", Actions.Checkpoint.toString());
            this.clearAction = new ClearAction();
            this.clearAction.putValue("Name", Actions.Clear.toString());
            this.initializeAction = new InitializeAction();
            this.initializeAction.putValue("Name", Actions.Initialize.toString());
            this.undoAction = new UndoAction();
            this.undoAction.putValue("Name", Actions.Undo.toString());
            this.redoAction = new RedoAction();
            this.redoAction.putValue("Name", Actions.Redo.toString());
            this.validateAction = new ValidateAction();
            this.validateAction.putValue("Name", Actions.Validate.toString());
            this.historyStringList = new Vector();
            this.historyJList = new JList();
            this.undoDepth = 0;
            this.historyJList.getSelectionModel().setSelectionMode(0);
            this.historyJList.setListData(this.historyStringList);
            this.historyJList.setFocusable(false);
            this.historyJList.setSelectedIndex(this.undoDepth);
            this.historyJList.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (JAbstractUndoPacket.this.historyJList.getSelectedIndex() == -1) {
                        JAbstractUndoPacket.this.historyJList.setSelectedIndex(e.getFirstIndex());
                    } else if (!e.getValueIsAdjusting() && JAbstractUndoPacket.this.historyJList.getSelectedIndex() != -1) {
                        int stateSelected = JAbstractUndoPacket.this.historyJList.getSelectedIndex();
                        while (stateSelected < JAbstractUndoPacket.this.undoDepth) {
                            JAbstractUndoPacket.this.undo.forwardstep();
                        }
                        while (stateSelected > JAbstractUndoPacket.this.undoDepth) {
                            JAbstractUndoPacket.this.undo.backstep();
                        }
                        JAbstractUndoPacket.this.undo.derive();
                    }
                }
            });
        }

        public CheckpointAction getCheckpointAction() {
            return this.checkpointAction;
        }

        public InitializeAction getInitializeAction() {
            return this.initializeAction;
        }

        public ClearAction getClearAction() {
            return this.clearAction;
        }

        public UndoAction getUndoAction() {
            return this.undoAction;
        }

        public RedoAction getRedoAction() {
            return this.redoAction;
        }

        public ValidateAction getValidateAction() {
            return this.validateAction;
        }

        String getNextUndoActionName() {
            if (this.historyStringList == null || this.undoDepth < 1 || this.historyStringList.size() <= this.undoDepth) {
                if (trace.getDebugCode("undo")) {
                    trace.out("undo", "getNextUndoActionName(): historyStringList.size " + this.historyStringList.size() + " while undoDepth " + this.undoDepth);
                }
                return Actions.Undo.toString();
            }
            String undoName = this.historyStringList.get(this.undoDepth);
            return Actions.Undo.toString() + " " + undoName;
        }

        String getNextRedoActionName() {
            if (this.historyStringList == null || this.undoDepth < 2 || this.historyStringList.size() < this.undoDepth) {
                if (trace.getDebugCode("undo")) {
                    trace.out("undo", "getNextRedoActionName(): historyStringList.size " + this.historyStringList.size() + " while undoDepth " + this.undoDepth);
                }
                return Actions.Redo.toString();
            }
            String redoName = this.historyStringList.get(this.undoDepth - 1);
            return Actions.Redo.toString() + " " + redoName;
        }

        public class ValidateAction
        extends AbstractAction {
            public ValidateAction() {
                super(Actions.Validate.toString());
                this.setEnabled(true);
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                byte[] current = JAbstractUndoPacket.this.undo.currentState;
                byte[] compareAgainst = JAbstractUndoPacket.this.mainComponent.saveState();
                int length1 = current.length;
                int length2 = current.length;
                if (length1 != length2) {
                    this.printError("size");
                } else {
                    for (int i = 0; i < length1; ++i) {
                        if (current[i] == compareAgainst[i]) continue;
                        this.printError("data");
                        return;
                    }
                    this.printSuccess();
                }
            }

            private void printError(String s) {
                System.out.println("*********************************************");
                System.out.println("****************  " + s + " ERROR  ********************");
                System.out.println("*********************************************");
            }

            private void printSuccess() {
                System.out.println("++++++++++++ VALIDATION SUCCESSFULL +++++++++++");
            }
        }

        public class RedoAction
        extends AbstractAction {
            public RedoAction() {
                super(Actions.Redo.toString());
                this.setEnabled(false);
                int ctrlKeyMask = 2;
                if (System.getProperty("os.name").toUpperCase().startsWith("MAC")) {
                    ctrlKeyMask = 4;
                }
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(89, ctrlKeyMask));
                this.putValue("ShortDescription", "Redo last change undone");
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    JAbstractUndoPacket.this.undo.redo();
                }
                catch (CannotRedoException ex) {
                    System.out.println("Unable to redo: " + ex);
                }
                this.updateRedoAction();
                JAbstractUndoPacket.this.undoAction.updateUndoAction();
            }

            private void updateRedoAction() {
                boolean canRedo = JAbstractUndoPacket.this.undo.canRedo();
                this.setEnabled(canRedo);
                this.putValue("Name", JAbstractUndoPacket.this.getNextRedoActionName());
                if (trace.getDebugCode("undo")) {
                    trace.out("undo", "updateRedoAction() canRedo " + canRedo + ", undoDepth " + JAbstractUndoPacket.this.undoDepth + ",\n  historyStringList " + JAbstractUndoPacket.this.historyStringList);
                }
            }
        }

        public class UndoAction
        extends AbstractAction {
            public UndoAction() {
                super(Actions.Undo.toString());
                this.setEnabled(false);
                int ctrlKeyMask = 2;
                if (System.getProperty("os.name").toUpperCase().startsWith("MAC")) {
                    ctrlKeyMask = 4;
                }
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(90, ctrlKeyMask));
                this.putValue("ShortDescription", "Undo last change");
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    JAbstractUndoPacket.this.undo.undo();
                }
                catch (CannotUndoException ex) {
                    trace.errStack("Error on event " + e + " trying to undo " + JAbstractUndoPacket.this.undo.getClass().getName() + ", canUndo " + JAbstractUndoPacket.this.undo.canUndo(), ex);
                }
                this.updateUndoAction();
                JAbstractUndoPacket.this.redoAction.updateRedoAction();
            }

            private void updateUndoAction() {
                boolean canUndo = JAbstractUndoPacket.this.undo.canUndo();
                this.setEnabled(canUndo);
                this.putValue("Name", JAbstractUndoPacket.this.getNextUndoActionName());
                if (trace.getDebugCode("undo")) {
                    trace.out("undo", "updateUndoAction() canUndo " + canUndo + ", undoDepth " + JAbstractUndoPacket.this.undoDepth + ",\n  historyStringList " + JAbstractUndoPacket.this.historyStringList);
                }
            }
        }

        public class InitializeAction
        extends ClearAction {
            @Override
            public void actionPerformed(ActionEvent e) {
                super.actionPerformed(e);
                JAbstractUndoPacket.this.undo.initCurrentState(e.getActionCommand());
            }
        }

        public class ClearAction
        extends AbstractAction {
            @Override
            public void actionPerformed(ActionEvent e) {
                JAbstractUndoPacket.this.undo = new MyAbstractUndoManager();
                JAbstractUndoPacket.this.historyStringList = new Vector();
                JAbstractUndoPacket.this.historyJList.setListData(JAbstractUndoPacket.this.historyStringList);
                JAbstractUndoPacket.this.undoDepth = 0;
                JAbstractUndoPacket.this.historyJList.setSelectedIndex(JAbstractUndoPacket.this.undoDepth);
            }
        }

        public class CheckpointAction
        extends AbstractAction {
            @Override
            public void actionPerformed(ActionEvent e) {
                if (trace.getDebugCode("undo")) {
                    trace.out("undo", "Checkpoint(" + e + ")");
                }
                if (e != null) {
                    JAbstractUndoPacket.this.undo.undoableEditHappened(e.getActionCommand());
                } else {
                    trace.errStack("null ActionEvent to CheckpointAction.actionPerformed()", new IllegalArgumentException());
                    JAbstractUndoPacket.this.undo.undoableEditHappened(null);
                }
            }
        }

        private class MyAbstractUndoManager {
            private LinkedList<byte[]> prevStates = new LinkedList();
            private LinkedList<byte[]> undidStates = new LinkedList();
            private byte[] currentState = null;

            private MyAbstractUndoManager() {
            }

            private void initCurrentState(String name) {
                if (trace.getDebugCode("undo")) {
                    trace.out("undo", "initCurrentState(" + name + ")");
                }
                byte[] saveState = JAbstractUndoPacket.this.mainComponent.saveState();
                this.undidStates.clear();
                this.prevStates.clear();
                this.currentState = saveState;
                JAbstractUndoPacket.this.historyStringList.clear();
                JAbstractUndoPacket.this.historyStringList.add("Current");
                JAbstractUndoPacket.this.historyJList.setListData(JAbstractUndoPacket.this.historyStringList);
                JAbstractUndoPacket.this.undoDepth = 0;
                JAbstractUndoPacket.this.historyJList.getSelectionModel().setValueIsAdjusting(true);
                JAbstractUndoPacket.this.historyJList.setSelectedIndex(JAbstractUndoPacket.this.undoDepth);
                JAbstractUndoPacket.this.undoAction.updateUndoAction();
                JAbstractUndoPacket.this.redoAction.updateRedoAction();
            }

            private void undoableEditHappened(String name) {
                byte[] saveState = JAbstractUndoPacket.this.mainComponent.saveState();
                this.undidStates.clear();
                if (this.currentState != null) {
                    this.prevStates.push(this.currentState);
                }
                this.currentState = saveState;
                while (JAbstractUndoPacket.this.historySize > 0 && this.prevStates.size() > JAbstractUndoPacket.this.historySize) {
                    this.prevStates.removeLast();
                }
                if (trace.getDebugCode("undo")) {
                    trace.out("undo", "undoableEditHappened[0] undoDepth " + JAbstractUndoPacket.this.undoDepth + ",\n  historyStringList " + JAbstractUndoPacket.this.historyStringList);
                }
                for (int i = 0; i < JAbstractUndoPacket.this.undoDepth - 1; ++i) {
                    JAbstractUndoPacket.this.historyStringList.remove(1);
                }
                if (trace.getDebugCode("undo")) {
                    trace.out("undo", "undoableEditHappened[1] undoDepth " + JAbstractUndoPacket.this.undoDepth + ",\n  historyStringList " + JAbstractUndoPacket.this.historyStringList);
                }
                if (JAbstractUndoPacket.this.historyStringList.isEmpty()) {
                    JAbstractUndoPacket.this.historyStringList.add("Current");
                } else {
                    if (name == null) {
                        name = "";
                    } else if (name.endsWith("...")) {
                        name = name.substring(0, name.length() - 3);
                    }
                    JAbstractUndoPacket.this.historyStringList.insertElementAt(name, 1);
                }
                JAbstractUndoPacket.this.historyJList.getSelectionModel().setValueIsAdjusting(true);
                JAbstractUndoPacket.this.historyJList.setListData(JAbstractUndoPacket.this.historyStringList);
                JAbstractUndoPacket.this.undoDepth = JAbstractUndoPacket.this.historyStringList.size() > 1 ? 1 : 0;
                JAbstractUndoPacket.this.historyJList.setSelectedIndex(JAbstractUndoPacket.this.undoDepth);
                JAbstractUndoPacket.this.undoAction.updateUndoAction();
                JAbstractUndoPacket.this.redoAction.updateRedoAction();
            }

            private boolean canUndo() {
                return this.prevStates.size() > 0;
            }

            private boolean canRedo() {
                return this.undidStates.size() > 0;
            }

            private byte[] backstep() {
                if (!this.canUndo()) {
                    throw new CannotUndoException();
                }
                JAbstractUndoPacket.this.undoDepth++;
                byte[] revert = this.prevStates.pop();
                this.undidStates.push(this.currentState);
                this.currentState = revert;
                return revert;
            }

            private byte[] forwardstep() {
                if (!this.canRedo()) {
                    throw new CannotRedoException();
                }
                JAbstractUndoPacket.this.undoDepth--;
                byte[] forward = this.undidStates.pop();
                this.prevStates.push(this.currentState);
                this.currentState = forward;
                return forward;
            }

            private void derive() {
                JAbstractUndoPacket.this.mainComponent.derive(this.currentState);
                JAbstractUndoPacket.this.historyJList.getSelectionModel().setValueIsAdjusting(true);
                JAbstractUndoPacket.this.historyJList.setSelectedIndex(JAbstractUndoPacket.this.undoDepth);
            }

            private void undo() throws CannotUndoException {
                this.backstep();
                this.derive();
                JAbstractUndoPacket.this.historyJList.getSelectionModel().setValueIsAdjusting(true);
                JAbstractUndoPacket.this.historyJList.setSelectedIndex(JAbstractUndoPacket.this.undoDepth);
            }

            private void redo() throws CannotRedoException {
                this.forwardstep();
                this.derive();
                JAbstractUndoPacket.this.historyJList.getSelectionModel().setValueIsAdjusting(true);
                JAbstractUndoPacket.this.historyJList.setSelectedIndex(JAbstractUndoPacket.this.undoDepth);
            }
        }
    }

    public static enum Actions {
        Checkpoint,
        Clear,
        Undo,
        Redo,
        Validate,
        Initialize;

    }

    static interface Undoable {
        public byte[] saveState();

        public void derive(byte[] var1);
    }

    public static class JTextUndoPacket {
        private JTextComponent textComponent;
        private char[] delimiters = new char[]{' ', '\n', ',', '%'};
        private MyTextUndoManager undo;
        private UndoAction undoAction;
        private RedoAction redoAction;

        public JTextUndoPacket(JTextComponent J) {
            this.textComponent = J;
            this.undo = new MyTextUndoManager();
            this.undoAction = new UndoAction();
            this.undoAction.putValue("Name", Actions.Undo.toString());
            this.redoAction = new RedoAction();
            this.redoAction.putValue("Name", Actions.Redo.toString());
            Document doc = J.getDocument();
            doc.addUndoableEditListener(this.undo);
        }

        public void setDelimiters(char[] c) {
            this.delimiters = c;
        }

        public UndoAction getUndoAction() {
            return this.undoAction;
        }

        public RedoAction getRedoAction() {
            return this.redoAction;
        }

        public UndoableEditListener getUndoListener() {
            return this.undo;
        }

        public JTextComponent getJTextComponent() {
            return this.textComponent;
        }

        public class RedoAction
        extends AbstractAction {
            public RedoAction() {
                super(Actions.Redo.toString());
                this.setEnabled(false);
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    JTextUndoPacket.this.undo.redo();
                }
                catch (CannotRedoException ex) {
                    System.out.println("Unable to redo: " + ex);
                }
                this.updateRedoAction();
                JTextUndoPacket.this.undoAction.updateUndoAction();
            }

            private void updateRedoAction() {
                if (JTextUndoPacket.this.undo.canRedo()) {
                    this.setEnabled(true);
                    this.putValue("Name", JTextUndoPacket.this.undo.getRedoPresentationName());
                } else {
                    this.setEnabled(false);
                    this.putValue("Name", Actions.Redo.toString());
                }
            }
        }

        public class UndoAction
        extends AbstractAction
        implements ActionListener {
            public UndoAction() {
                super(Actions.Undo.toString());
                this.setEnabled(false);
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    JTextUndoPacket.this.undo.undo();
                }
                catch (CannotUndoException ex) {
                    trace.errStack("Error on event " + e + " trying to undo " + JTextUndoPacket.this.undo.getPresentationName() + ", limit " + JTextUndoPacket.this.undo.getLimit() + ", undoPresName " + JTextUndoPacket.this.undo.getUndoPresentationName() + ", canUndo " + JTextUndoPacket.this.undo.canUndo() + ", inProgress " + JTextUndoPacket.this.undo.isInProgress(), ex);
                }
                this.updateUndoAction();
                JTextUndoPacket.this.redoAction.updateRedoAction();
            }

            private void updateUndoAction() {
                if (JTextUndoPacket.this.undo.canUndo()) {
                    this.setEnabled(true);
                    this.putValue("Name", JTextUndoPacket.this.undo.getUndoPresentationName());
                } else {
                    this.setEnabled(false);
                    this.putValue("Name", Actions.Undo.toString());
                }
            }
        }

        private class MyTextUndoManager
        extends UndoManager
        implements UndoableEditListener {
            private DocumentEvent prevEdit;

            private MyTextUndoManager() {
            }

            @Override
            public void undoableEditHappened(UndoableEditEvent e) {
                AbstractDocument.DefaultDocumentEvent changed = (AbstractDocument.DefaultDocumentEvent)e.getEdit();
                DocumentEvent.EventType thisType = changed.getType();
                int offset = changed.getOffset();
                int length = changed.getLength();
                boolean newGroupRequired = false;
                if (!this.canUndo()) {
                    newGroupRequired = true;
                } else if (this.prevEdit == null || this.editToBeUndone() == null) {
                    newGroupRequired = true;
                } else if (!this.prevEdit.getType().equals(thisType) || length > 1) {
                    newGroupRequired = true;
                } else if (thisType.equals(DocumentEvent.EventType.INSERT)) {
                    try {
                        String delta = changed.getDocument().getText(offset, length);
                        for (char c : JTextUndoPacket.this.delimiters) {
                            if (!delta.contains("" + c)) continue;
                            newGroupRequired = true;
                        }
                    }
                    catch (BadLocationException e1) {
                        e1.printStackTrace();
                    }
                    if (this.prevEdit.getOffset() != offset - 1) {
                        newGroupRequired = true;
                    }
                } else if (thisType.equals(DocumentEvent.EventType.REMOVE) && this.prevEdit.getOffset() != offset + 1) {
                    newGroupRequired = true;
                }
                UndoableEdit currentGroup = this.editToBeUndone();
                this.prevEdit = changed;
                if (!newGroupRequired) {
                    currentGroup.addEdit(changed);
                } else {
                    MyCompoundGroupEdit newGroup = new MyCompoundGroupEdit();
                    newGroup.addEdit(changed);
                    this.addEdit(newGroup);
                }
                JTextUndoPacket.this.undoAction.updateUndoAction();
                JTextUndoPacket.this.redoAction.updateRedoAction();
            }

            private class MyCompoundGroupEdit
            extends CompoundEdit {
                private boolean isDone = true;

                public int getLength() {
                    return this.edits.size();
                }

                public boolean isDone() {
                    return this.isDone;
                }

                @Override
                public boolean addEdit(UndoableEdit anEdit) {
                    if (anEdit instanceof MyCompoundGroupEdit) {
                        return false;
                    }
                    return super.addEdit(anEdit);
                }

                @Override
                public boolean isSignificant() {
                    return true;
                }

                @Override
                public void undo() throws CannotUndoException {
                    super.undo();
                    this.isDone = false;
                }

                @Override
                public void redo() throws CannotUndoException {
                    super.redo();
                    this.isDone = true;
                }

                @Override
                public boolean canUndo() {
                    return this.edits.size() > 0 && this.isDone;
                }

                @Override
                public boolean canRedo() {
                    return this.edits.size() > 0 && !this.isDone;
                }
            }
        }
    }
}

