/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.BehaviorRecorder.View;

import edu.cmu.pact.BehaviorRecorder.Controller.ActionLabelHandler;
import edu.cmu.pact.BehaviorRecorder.Controller.BR_Controller;
import edu.cmu.pact.BehaviorRecorder.Controller.CtatModeEvent;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.EdgeData;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ProblemEdge;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.ProblemModel;
import edu.cmu.pact.BehaviorRecorder.View.BRPanel;
import edu.cmu.pact.BehaviorRecorder.View.BR_Label;
import edu.cmu.pact.BehaviorRecorder.View.NodeView;
import edu.cmu.pact.BehaviorRecorder.jgraphwindow.MarathonElement;
import edu.cmu.pact.Utilities.trace;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;

public class ActionLabel
extends BR_Label
implements MarathonElement {
    private static final long serialVersionUID = -3182422487549005269L;
    public static final String FAILBEFORE_CORRECT = "Fail before, Correct now";
    public static final String CORRECTBEFORE_INCORRECT = "Correct before, Fail now";
    public static final Color correctColor = Color.green.darker().darker();
    public static final Color untacebleColor = Color.yellow.darker().darker();
    public static final Color buggyColor = Color.red.darker();
    public static final Color fireableBuggyColor = Color.blue.darker();
    public static final Color unknownColor = Color.black;
    public static final int VIEW_SHORT = 0;
    public static int classView = 0;
    private EdgeData edgeData;
    private boolean mouseEntered;
    String defaultHint = "";
    private static ImageIcon hintIcon;
    private ProblemModel problemModel;
    private transient BR_Controller controller;
    private ActionLabelHandler handler;

    public void restoreTransients(BR_Controller controller) {
        this.controller = controller;
        if (this.handler != null) {
            this.handler.restoreTransients(controller);
        }
    }

    public ActionLabel(EdgeData edge, ProblemModel problemModel) {
        this("unnamed action", edge, problemModel);
    }

    public ActionLabelHandler getHandler() {
        return this.handler;
    }

    public ActionLabel(String actionTypeText, EdgeData edgeData, ProblemModel problemModel) {
        super(actionTypeText, edgeData);
        this.problemModel = problemModel;
        this.controller = problemModel.getController();
        this.setText(actionTypeText);
        this.edgeData = edgeData;
        if (edgeData != null) {
            this.resetForeground();
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    ActionLabel.this.mouseEntered(e);
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    ActionLabel.this.mouseExited(e);
                }
            });
            ActionLabel.loadHintIcon();
            this.setIcon(hintIcon);
        }
    }

    public void setEdgeData(EdgeData edge) {
        this.edgeData = edge;
    }

    public boolean equals(ActionLabel label) {
        return this.getUniqueID() == label.getUniqueID();
    }

    @Override
    public int getUniqueID() {
        if (this.edgeData == null) {
            return -1;
        }
        return this.edgeData.getUniqueID();
    }

    public EdgeData getEdge() {
        return this.edgeData;
    }

    private boolean testActionLabelInCommutEdgesAdded(ActionLabel testActionLabel) {
        for (int i = 0; i < this.controller.getSolutionState().getUserVisitedEdges().size(); ++i) {
            ProblemEdge tempEdge = this.controller.getSolutionState().getUserVisitedEdges().get(i);
            EdgeData tempMyEdge = tempEdge.getEdgeData();
            ActionLabel tempActionLabel = tempMyEdge.getActionLabel();
            if (tempActionLabel != testActionLabel) continue;
            return true;
        }
        return false;
    }

    private static void loadHintIcon() {
        if (hintIcon != null) {
            return;
        }
        try {
            URL iconURL = ClassLoader.getSystemResource("pact/HintIcon.gif");
            if (iconURL != null) {
                hintIcon = new ImageIcon(iconURL, "connected");
            }
        }
        catch (Exception e) {
            trace.out("error loading images for connection icon: exception = " + e);
        }
    }

    public void updateToolTip() {
        this.setToolTipText(null);
    }

    @Override
    public void setText(String text) {
        this.update();
    }

    public void mouseEntered(MouseEvent e) {
        boolean continueFlag = true;
        if (this.controller != null) {
            return;
        }
        if (this.controller.getCtatModeModel().isExampleTracingMode()) {
            boolean bl = continueFlag = !this.testActionLabelInCommutEdgesAdded(this);
        }
        if (continueFlag) {
            this.setFont(null);
        }
        this.mouseEntered = true;
        this.update();
        this.controller.fireCtatModeEvent(CtatModeEvent.REPAINT);
    }

    public void mouseExited(MouseEvent e) {
        boolean continueFlag = true;
        if (this.controller != null) {
            return;
        }
        if (this.controller.getCtatModeModel().isExampleTracingMode()) {
            boolean bl = continueFlag = !this.testActionLabelInCommutEdgesAdded(this);
        }
        if (continueFlag) {
            this.setFont(BRPanel.SMALL_FONT);
        }
        this.mouseEntered = false;
        this.update();
        this.controller.fireCtatModeEvent(CtatModeEvent.REPAINT);
    }

    public void resetForeground() {
        if (this.edgeData == null || this.edgeData.getActionType().equalsIgnoreCase("Correct Action")) {
            this.setForeground(correctColor);
        } else if (this.edgeData.getActionType().equalsIgnoreCase("Untraceable Error")) {
            this.setForeground(untacebleColor);
        } else if (this.edgeData.getActionType().equalsIgnoreCase("Buggy Action")) {
            this.setForeground(buggyColor);
        } else if (this.edgeData.getActionType().equalsIgnoreCase("Fireable Buggy Action")) {
            this.setForeground(fireableBuggyColor);
        } else if (this.edgeData.getActionType().equalsIgnoreCase("Unknown Action")) {
            this.setForeground(unknownColor);
        }
    }

    public void update() {
        if (this.edgeData == null) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ActionLabel.this.updateToolTip();
                ActionLabel.super.setText(ActionLabel.this.edgeData.getActionLabelText(false, classView));
                ActionLabel.this.resetSize();
                ActionLabel.this.updateLocation();
                ActionLabel.this.repaint();
            }
        });
    }

    private void updateLocation() {
        if (this.edgeData.getSourceProblemNode() == null) {
            return;
        }
        if (this.edgeData.getEndProblemNode() == null) {
            return;
        }
        NodeView startVertex = this.edgeData.getSourceProblemNode().getNodeView();
        NodeView endVertex = this.edgeData.getEndProblemNode().getNodeView();
        if (startVertex == null || endVertex == null) {
            return;
        }
        Point startPoint = startVertex.getOutgoingEdgePoint();
        Point endPoint = endVertex.getIncomingEdgePoint();
        Dimension size = this.getSize();
        boolean showLabels = false;
        if (this.controller != null) {
            showLabels = this.controller.getPreferencesModel().getBooleanValue("Show Rule Labels");
        }
        double factor = showLabels ? 0.6 : 0.75;
        Point LabelLocation = new Point();
        LabelLocation.x = startPoint.x + (int)((double)(endPoint.x - startPoint.x) * factor) - size.width / 2;
        LabelLocation.y = startPoint.y + (int)((double)(endPoint.y - startPoint.y) * factor) - size.height / 2;
        this.setLocation(LabelLocation);
        if (this.controller != null) {
            if (this.controller.isPreferredPathOnlyFlag()) {
                this.setVisible(this.controller.getShowActionLabels() && this.edgeData.isPreferredEdge());
            } else {
                this.setVisible(this.controller.getShowActionLabels());
            }
        }
    }

    public void addHandler(ActionLabelHandler handler) {
        this.edgeData.getActionLabel().addMouseListener(new ActionLabelHandler(this.edgeData.getActionLabel(), this.controller));
        this.handler = handler;
    }

    public void setMouseEntered(boolean entered) {
        this.mouseEntered = entered;
        this.update();
    }

    @Override
    public String getMarathonIdentifier() {
        return "Edge" + this.getUniqueID() + "::ActionLabel";
    }

    @Override
    public int getTextStyle() {
        try {
            return this.edgeData.getActionLabel().getFont().getStyle();
        }
        catch (NullPointerException npe) {
            System.out.println("Marathon threw NPE getting text style for action label");
            System.out.println("Couldn't get text style for " + this.getMarathonIdentifier() + "; return 0 instead");
            return 0;
        }
    }

    @Override
    public String getToolTipText() {
        return "";
    }
}

