/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.BehaviorRecorder.StartStateEditor;

import edu.cmu.pact.BehaviorRecorder.StartStateEditor.CTATNumberFieldFilter;
import java.awt.Color;
import javax.swing.JTextField;
import javax.swing.text.Document;

public class CTATSheetCellNumber
extends JTextField {
    private static final long serialVersionUID = 1L;
    protected CTATNumberFieldFilter numberFieldFilter;

    public CTATSheetCellNumber() {
        this(10, 3);
        this.numberFieldFilter = new CTATNumberFieldFilter();
    }

    public CTATSheetCellNumber(int iMaxLen) {
        this(iMaxLen, 2);
        this.numberFieldFilter = new CTATNumberFieldFilter();
    }

    public CTATSheetCellNumber(int iMaxLen, int iFormat) {
        if (this.numberFieldFilter == null) {
            this.numberFieldFilter = new CTATNumberFieldFilter();
        }
        this.setMaxLength(iMaxLen);
        this.setFormat(iFormat);
        super.setDocument(this.numberFieldFilter);
    }

    public void setMaxLength(int maxLen) {
        this.numberFieldFilter.maxLength = maxLen > 0 ? maxLen : 0;
    }

    public int getMaxLength() {
        return this.numberFieldFilter.maxLength;
    }

    @Override
    public void setEnabled(boolean enable) {
        super.setEnabled(enable);
        if (enable) {
            this.setBackground(Color.white);
            this.setForeground(Color.black);
        } else {
            this.setBackground(Color.lightGray);
            this.setForeground(Color.darkGray);
        }
    }

    @Override
    public void setEditable(boolean enable) {
        super.setEditable(enable);
        if (enable) {
            this.setBackground(Color.white);
            this.setForeground(Color.black);
        } else {
            this.setBackground(Color.lightGray);
            this.setForeground(Color.darkGray);
        }
    }

    public void setPrecision(int iPrecision) {
        if (this.numberFieldFilter.format == 2) {
            return;
        }
        this.numberFieldFilter.precision = iPrecision >= 0 ? iPrecision : 2;
    }

    public int getPrecision() {
        return this.numberFieldFilter.precision;
    }

    public Number getNumber() {
        Number number = null;
        number = this.numberFieldFilter.format == 2 ? (Number)new Integer(this.getText()) : (Number)new Double(this.getText());
        return number;
    }

    public void setNumber(Number value) {
        this.setText(String.valueOf(value));
    }

    public int getInt() {
        return Integer.parseInt(this.getText());
    }

    public void setInt(int value) {
        this.setText(String.valueOf(value));
    }

    public float getFloat() {
        return new Float(this.getText()).floatValue();
    }

    public void setFloat(float value) {
        this.setText(String.valueOf(value));
    }

    public double getDouble() {
        return new Double(this.getText());
    }

    public void setDouble(double value) {
        this.setText(String.valueOf(value));
    }

    public int getFormat() {
        return this.numberFieldFilter.format;
    }

    public void setFormat(int iFormat) {
        switch (iFormat) {
            default: {
                this.numberFieldFilter.format = 2;
                this.numberFieldFilter.precision = 0;
                this.numberFieldFilter.allowedChars = "0123456789";
                break;
            }
            case 3: {
                this.numberFieldFilter.format = 3;
                this.numberFieldFilter.precision = 2;
                this.numberFieldFilter.allowedChars = "0123456789.";
            }
        }
    }

    public void setAllowNegative(boolean b) {
        this.numberFieldFilter.allowNegative = b;
        this.numberFieldFilter.negativeChars = b ? "-" : "";
    }

    public boolean isAllowNegative() {
        return this.numberFieldFilter.allowNegative;
    }

    @Override
    public void setDocument(Document document) {
    }
}

