/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.BehaviorRecorder.ProblemModel.XMLElements;

import com.megginson.sax.DataWriter;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.XMLElements.PropertiesElement;
import edu.cmu.pact.Utilities.trace;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.jdom.Element;
import org.xml.sax.SAXException;

public class VectorProperty {
    String propertyName;
    private ValueSubElement vseList;
    private List<Element> eltList;

    public VectorProperty(String propertyName) {
        this(propertyName, null);
    }

    public VectorProperty(String propertyName, Vector propertyValue) {
        this.propertyName = propertyName;
        if (propertyValue == null || propertyValue.size() < 1) {
            return;
        }
        if (propertyValue.get(0) instanceof Element) {
            this.vseList = null;
            this.eltList = new ArrayList<Element>();
            for (int k = 0; k < propertyValue.size(); ++k) {
                Object elt = propertyValue.get(k);
                if (!(elt instanceof Element)) {
                    trace.err("item[" + k + "] in Element list-valued property not an Element:\n  " + propertyValue);
                    continue;
                }
                this.eltList.add((Element)elt);
            }
        } else {
            this.vseList = new ValueSubElement();
            this.eltList = null;
            for (int k = 0; k < propertyValue.size(); ++k) {
                String inputvalue = propertyValue.elementAt(k).toString();
                this.vseList.addValue(inputvalue);
            }
        }
    }

    public void addValue(String in) {
        if (this.eltList != null) {
            trace.err("addValue(\"" + in + "\") illegal when Element list already started");
            return;
        }
        if (this.vseList == null) {
            this.vseList = new ValueSubElement();
        }
        this.vseList.addValue(in);
    }

    public void addValue(Element elt) {
        if (this.vseList != null) {
            trace.err("addValue(\"" + elt + "\") illegal when <value> list already started");
            return;
        }
        if (this.eltList == null) {
            this.eltList = new ArrayList<Element>();
        }
        this.eltList.add(elt);
    }

    public void printXML(DataWriter w) throws SAXException {
        w.startElement(this.propertyName);
        if (this.vseList != null) {
            this.vseList.printXML(w);
        } else if (this.eltList != null) {
            for (Element elt : this.eltList) {
                PropertiesElement.printElement(elt, w);
            }
        }
        w.endElement(this.propertyName);
    }

    class ValueSubElement {
        private ArrayList<String> valuelist = new ArrayList();

        public void addValue(String in) {
            if (this.valuelist == null) {
                this.valuelist = new ArrayList();
            }
            this.valuelist.add(in);
        }

        public void printXML(DataWriter w) throws SAXException {
            if (trace.getDebugCode("hint")) {
                trace.out("hint", "VectorProperty.ValueSubElement.printXML() valuelist " + this.valuelist);
            }
            for (int i = 0; i < this.valuelist.size(); ++i) {
                w.dataElement("value", this.valuelist.get(i));
            }
        }
    }
}

