/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.BehaviorRecorder.ProblemModel.Matcher.Functions;

import edu.cmu.pact.Utilities.trace;
import fri.patterns.interpreter.parsergenerator.Lexer;
import fri.patterns.interpreter.parsergenerator.Token;
import fri.patterns.interpreter.parsergenerator.lexer.LexerBuilder;
import fri.patterns.interpreter.parsergenerator.semantics.TreeBuilderSemantic;
import fri.patterns.interpreter.parsergenerator.syntax.Syntax;
import fri.patterns.interpreter.parsergenerator.syntax.builder.SyntaxSeparation;
import java.util.Arrays;
import java.util.regex.Pattern;

public class constantsConform
extends TreeBuilderSemantic {
    private Pattern[] patterns = null;
    private static String[][] rules = new String[][]{{"token", "OPERATOR"}, {"token", "`number`"}, {"token", "`letter`"}, {"OPERATOR", "'+'"}, {"OPERATOR", "'-'"}, {"OPERATOR", "'*'"}, {"OPERATOR", "'/'"}, {"OPERATOR", "'^'"}, {"OPERATOR", "'('"}, {"OPERATOR", "')'"}, {"OPERATOR", "'='"}, {"OPERATOR", "'<'"}, {"OPERATOR", "'>'"}, {"ignored", "`whitespaces`"}};

    public boolean constantsConform(String expr, String ... strPatterns) {
        int result = this.exec(expr, strPatterns);
        return result == 0;
    }

    public static void main(String[] args) throws Throwable {
        if (args.length < 1 || args[0].contains("h")) {
            System.err.println("Usage:\n  constantsConform expr pattern ...\nwhere--\n  expr is the expression to scan;\n  pattern ... is one or more regular expressions");
        }
        constantsConform cc = new constantsConform();
        String expr = args[0];
        Object[] patternArgs = Arrays.copyOfRange(args, 1, args.length);
        int result = cc.exec(expr, (String[])patternArgs);
        System.out.printf("%d = constantsConform(%s, %s)\n", result, expr, Arrays.toString(patternArgs));
        System.exit(result);
    }

    int exec(String expr, String ... strPatterns) {
        Pattern[] patterns = new Pattern[strPatterns.length];
        int i = 0;
        try {
            for (String s : strPatterns) {
                patterns[i++] = Pattern.compile(s, 2);
            }
            return this.exec(expr, patterns);
        }
        catch (Exception e) {
            trace.err("Error compiling pattern[" + i + "] \"+strPatterns[i]+\" in constantsConform(" + expr + "): " + e + (e.getCause() == null ? "" : "; cause " + e.getCause().toString()));
            e.printStackTrace(System.err);
            return 2;
        }
    }

    int exec(String expr, Pattern ... patterns) {
        if (expr == null || expr.length() < 1) {
            return 2;
        }
        try {
            Token token;
            SyntaxSeparation separation = new SyntaxSeparation(new Syntax(rules));
            LexerBuilder builder = new LexerBuilder(separation.getLexerSyntax(), separation.getIgnoredSymbols());
            Lexer lexer = builder.getLexer();
            lexer.setTerminals(separation.getTokenSymbols());
            lexer.setInput((Object)expr);
            int result = 0;
            do {
                token = lexer.getNextToken(null);
                if (token.symbol == null) {
                    lexer.dump(System.err);
                    continue;
                }
                if (this.numberConforms(token, patterns)) continue;
                result = 1;
            } while (result == 0 && token.symbol != null && !Token.isEpsilon((Token)token));
            if (result == 0 && !Token.isEpsilon((Token)token)) {
                result = 2;
            }
            if (trace.getDebugCode("functions")) {
                trace.out("functions", "scan returns " + result + ", last token symbol " + token.symbol + ", text " + token.text + ", eof " + Token.isEpsilon((Token)token));
            }
            return result;
        }
        catch (Exception e) {
            trace.err("Error from constantsConform \"" + expr + "\"" + e + (e.getCause() == null ? "" : "; cause " + e.getCause().toString()));
            e.printStackTrace(System.err);
            return 2;
        }
    }

    public boolean numberConforms(Token t, Pattern[] patterns) {
        boolean result = true;
        int i = 0;
        if ("`number`".equals(t.symbol) && t.text != null) {
            String number = t.text.toString();
            for (Pattern pattern : patterns) {
                if (pattern.matcher(number).matches()) break;
                ++i;
            }
        }
        if (trace.getDebugCode("functions")) {
            trace.outNT("functions", "constantsConform.numberConforms() symbol " + t.symbol + ", text " + t.text + "\n     matches pattern " + (i >= patterns.length ? "(none)" : patterns[i].toString()));
        }
        if (i >= patterns.length) {
            result = false;
        }
        return result;
    }
}

