/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.BehaviorRecorder.ProblemModel.Matcher.Functions;

import edu.cmu.pact.BehaviorRecorder.ExpressionMatcher.CTATExpressionParser;
import edu.cmu.pact.BehaviorRecorder.ExpressionMatcher.ExpressionTreeProperties;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Matcher.Functions.UsesVariableTable;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Matcher.Functions.fmtDecimal;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.VariableTable;
import edu.cmu.pact.Utilities.trace;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;

public class algEval
implements UsesVariableTable,
Serializable {
    ExpressionTreeProperties properties;

    public Double algEval(String expression) {
        CTATExpressionParser matcher = new CTATExpressionParser(this.properties);
        Double result = matcher.evaluate(expression);
        if (trace.getDebugCode("functions")) {
            trace.out("functions", "CTATEvaluate result = " + result);
        }
        return result;
    }

    @Override
    public void setVariableTable(VariableTable variableTable) {
        if (this.properties == null) {
            this.properties = new ExpressionTreeProperties();
        }
        this.properties.variableTable = variableTable == null ? new VariableTable() : variableTable;
    }

    public static void main(String[] args) {
        int i;
        List<String> argList;
        algEval ae = new algEval();
        fmtDecimal fd = null;
        int prec = 4;
        if (args.length < 1 || args[0].startsWith("-h")) {
            System.err.printf("Usage:\njava -cp ... %s [-f[p]] \"expression to evaluate\"\nwhere--\n  -f[p] means post-process with fmtDecimal() using precision p (default %d);\n  \"expression to evaluate\" is an algebraic expression.\n", ae.getClass().getSimpleName(), prec);
            System.exit(2);
        }
        if ((argList = Arrays.asList(args)).get(i = 0).startsWith("-f")) {
            String p;
            fd = new fmtDecimal();
            if ((p = argList.get(i++).substring(2)).length() > 0) {
                prec = Integer.valueOf(p);
            }
        }
        for (String arg : argList.subList(i, argList.size())) {
            Double d = ae.algEval(arg);
            if (fd == null) {
                System.out.printf("%11.6f = %s\n", d, arg);
                continue;
            }
            System.out.printf("%11s = %11.6f = %s\n", fd.fmtDecimal(d, prec), d, arg);
        }
    }
}

