/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.BehaviorRecorder.ProblemModel.Matcher;

import edu.cmu.pact.BehaviorRecorder.ProblemModel.Matcher.CTATFunctions;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Matcher.ExactMatcher;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Matcher.Functions.equals;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Matcher.Matcher;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.ProblemModel;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.VariableTable;
import edu.cmu.pact.Utilities.XMLSpecialCharsTransform;
import edu.cmu.pact.Utilities.trace;
import fri.patterns.interpreter.parsergenerator.Parser;
import java.util.Date;
import java.util.Vector;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;

public class ExpressionMatcher
extends ExactMatcher {
    private CTATFunctions functions;
    private String expression;
    private int relation;
    private static final int EQ_RELATION = 0;
    private static final int LT_RELATION = 1;
    private static final int GT_RELATION = 2;
    private static final int NOT_EQ_RELATION = 3;
    private static final int GTE_RELATION = 4;
    private static final int LTE_RELATION = 5;
    private static final int BOOL_RELATION = 6;
    public static final String[] RELATIONS = new String[]{"=", "<", ">", "!=", ">=", "<=", "boolean"};
    private String lastInput;
    private String lastError;
    private Date lastEvaluationTime;
    private boolean lastComparison;
    private ProblemModel problemModel;

    public ExpressionMatcher(boolean concat2, int vector, String text) {
        super(concat2, vector, text);
        String expression;
        int endQuote;
        this.relation = 0;
        if (text == null) {
            return;
        }
        int beginQuote = text.indexOf("\"");
        if (beginQuote >= 0 && (endQuote = text.lastIndexOf("\"")) >= 0) {
            expression = text.substring(beginQuote + 1, endQuote);
            String testRel = text.substring(0, text.indexOf(" "));
            for (int i = 0; i < RELATIONS.length; ++i) {
                if (!testRel.equals(RELATIONS[i])) continue;
                this.relation = i;
                break;
            }
        } else {
            expression = text;
        }
        this.setInputExpression(expression);
    }

    public ExpressionMatcher(boolean concat2, int vector, int relation, String expression) {
        super(concat2, vector, null);
        this.setRelation(relation);
        this.setInputExpression(expression);
    }

    @Override
    public Object clone() {
        ExpressionMatcher m = new ExpressionMatcher(this.concat, this.vector, this.relation, this.expression);
        m.copyFrom(this);
        if (this.functions != null) {
            m.setExternalResources(this.functions.getVariableTable(), this.problemModel, this.functions.getParser());
        }
        return m;
    }

    public ExpressionMatcher() {
        this.relation = 0;
    }

    @Override
    public void setExternalResources(VariableTable variableTable, ProblemModel problemModel, Parser parser) {
        this.problemModel = problemModel;
        this.functions = new CTATFunctions(variableTable, problemModel, parser);
    }

    public String getInputExpression() {
        return this.expression;
    }

    public void setInputExpression(String value) {
        this.expression = value;
    }

    @Override
    public String getMatcherType() {
        return "Formula Match";
    }

    @Override
    public String getMatcherTypeText() {
        return "Formula";
    }

    @Override
    public String getMatcherClassType() {
        return "ExpressionMatcher";
    }

    @Override
    public String getSingleLabelText() {
        return this.expression;
    }

    @Override
    public String getToolTipText() {
        return XMLSpecialCharsTransform.transformSpecialChars(this.getRelation() + " " + this.expression);
    }

    @Override
    public Object getParameter(int index) {
        if (this.single) {
            if (index == 0) {
                return this.getInputExpression();
            }
            if (index == 1) {
                return this.getRelation();
            }
        }
        switch (index) {
            case 0: {
                return this.getDefaultSelection();
            }
            case 1: {
                return this.getDefaultAction();
            }
            case 2: {
                return this.getInputExpression();
            }
            case 3: {
                return this.getDefaultActor();
            }
            case 4: {
                return this.getInputExpression();
            }
            case 5: {
                return this.getRelation();
            }
        }
        return null;
    }

    @Override
    public void setParameterByIndex(String stringValue, int index) {
        if (trace.getDebugCode("functions")) {
            trace.outln("functions", "setParameterByIndex(" + stringValue + ", " + index + ")");
        }
        if (this.single) {
            switch (index) {
                case 0: {
                    this.setInputExpression(stringValue);
                }
                case 1: {
                    this.setRelation(stringValue);
                    return;
                }
            }
        }
        switch (index) {
            case 0: {
                this.setDefaultSelection(stringValue);
                return;
            }
            case 1: {
                this.setDefaultInput(stringValue);
                return;
            }
            case 2: {
                this.setDefaultAction(stringValue);
                return;
            }
            case 3: {
                this.setDefaultActor(stringValue);
                return;
            }
            case 4: {
                this.setInputExpression(stringValue);
                return;
            }
            case 5: {
                this.setRelation(stringValue);
                return;
            }
        }
        trace.err("ExactMatcher.setParameterByIndex(): unknown index " + index);
    }

    @Override
    protected void setParameterInternal(Element element2, int index) {
        this.setParameterByIndex(element2.getText(), index);
    }

    public Object evaluate(String selection, String action, String input, VariableTable vt) {
        CTATFunctions tempfunc = vt != null ? new CTATFunctions(vt, this.problemModel, this.functions.getParser()) : this.functions;
        try {
            if (trace.getDebugCode("functions")) {
                trace.outln("functions", "evaluating with vt#" + (vt == null ? -1 : vt.getInstance()) + ": " + this.getInputExpression());
            }
            return tempfunc.evaluate(this.getInputExpression(), selection, action, input);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            this.lastError = e.getMessage();
            return null;
        }
    }

    public Object interpolate(String expression, String selection, String action, String input) {
        try {
            System.out.println("interpolating " + this.getInputExpression());
            return this.functions.interpolate(expression, selection, action, input);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            this.lastError = e.getMessage();
            return null;
        }
    }

    private boolean testInput(String selection, String action, String input) throws Exception {
        return this.testVector(selection, action, input, 2, null);
    }

    private boolean testVector(String selection, String action, String input, int vector, VariableTable vt) {
        Object result = this.evaluate(selection, action, input, vt);
        if (trace.getDebugCode("functions")) {
            trace.outNT("functions", "ExpressionMatcher.testVector() evaluate " + result);
        }
        String comparee = null;
        switch (vector) {
            case 0: {
                comparee = selection;
                break;
            }
            case 1: {
                comparee = action;
                break;
            }
            case -1: 
            case 2: {
                comparee = input;
            }
        }
        this.lastResult = result;
        this.lastInput = comparee;
        this.lastEvaluationTime = new Date();
        try {
            equals eq = new equals();
            if (this.relation == 0 || this.relation == 3) {
                boolean rtnVal = eq.equals(comparee, result);
                return this.relation == 3 ? !rtnVal : rtnVal;
            }
            if (this.relation == 6) {
                if (result instanceof Boolean) {
                    return (Boolean)result;
                }
                if (result instanceof String) {
                    return Boolean.parseBoolean((String)result);
                }
                return false;
            }
            Double resultVal = CTATFunctions.toDouble(result);
            Double compareeVal = CTATFunctions.toDouble(comparee);
            if (resultVal != null && compareeVal != null) {
                switch (this.relation) {
                    case 0: {
                        return compareeVal == resultVal;
                    }
                    case 3: {
                        return compareeVal != resultVal;
                    }
                    case 1: {
                        return compareeVal < resultVal;
                    }
                    case 2: {
                        return compareeVal > resultVal;
                    }
                    case 5: {
                        return compareeVal <= resultVal;
                    }
                    case 4: {
                        return compareeVal >= resultVal;
                    }
                }
            }
            if (comparee == null) {
                switch (this.relation) {
                    case 0: {
                        return result == null;
                    }
                    case 3: {
                        return result != null;
                    }
                    case 1: {
                        return false;
                    }
                    case 2: {
                        return false;
                    }
                    case 5: {
                        return result == null;
                    }
                    case 4: {
                        return result == null;
                    }
                }
            }
            if (result == null) {
                return false;
            }
            int comparison = comparee.compareTo(result.toString());
            switch (this.relation) {
                case 0: {
                    return comparison == 0;
                }
                case 3: {
                    return comparison != 0;
                }
                case 1: {
                    return comparison < 0;
                }
                case 2: {
                    return comparison > 0;
                }
                case 5: {
                    return comparison < 0 || eq.equals(comparee, result);
                }
                case 4: {
                    return comparison > 0 || eq.equals(comparee, result);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        return false;
    }

    public boolean matchConcatenation(Vector s, Vector a, Vector i) {
        return this.matchConcatenation(s, a, i, null);
    }

    public boolean matchConcatenation(Vector s, boolean b, VariableTable vt) {
        this.lastComparison = this.testVector((String)s.get(0), null, null, this.vector, vt);
        return this.lastComparison;
    }

    public boolean matchConcatenation(Vector s, Vector a, Vector i, VariableTable vt) {
        this.lastComparison = this.testVector((String)s.get(0), (String)a.get(0), (String)i.get(0), this.vector, vt);
        return this.lastComparison;
    }

    @Override
    public boolean match(Vector selection, Vector action, Vector input, String actor, VariableTable vt) {
        return this.matchConcatenation(selection, action, input, vt);
    }

    @Override
    public boolean matchSingle(String s) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean matchConcatenation(Vector s) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean match(Vector selection, Vector action, Vector input, String actor) {
        boolean comparisonValue = false;
        String actualSelection = selection.elementAt(0).toString();
        String actualAction = action.elementAt(0).toString();
        String actualInput = input == null || input.elementAt(0) == null ? null : input.elementAt(0).toString();
        String expectedSelection = this.getSelection().toString();
        String expectedAction = this.getAction().toString();
        try {
            comparisonValue = this.getCaseInsensitive() ? expectedSelection.equalsIgnoreCase(actualSelection) && expectedAction.equalsIgnoreCase(actualAction) && this.testInput(actualSelection, actualAction, actualInput) : expectedSelection.equals(actualSelection) && expectedAction.equals(actualAction) && this.testInput(actualSelection, actualAction, actualInput);
        }
        catch (Exception ex) {
            trace.err(ex.toString());
            ex.printStackTrace(System.err);
        }
        if (comparisonValue) {
            trace.out("matcher", this.getActor() + " vs " + actor);
        }
        this.lastComparison = comparisonValue = comparisonValue && this.matchActor(actor);
        return comparisonValue;
    }

    @Override
    public boolean checkExpression() {
        System.out.println("validating " + this.getInputExpression());
        boolean check = this.functions.validate(this.getInputExpression());
        if (this.functions.getReturnType() == Boolean.TYPE) {
            this.setRelation("boolean");
        } else if (this.getRelation().equals("boolean")) {
            this.setRelation("=");
        }
        return check;
    }

    @Override
    public String error() {
        return this.functions.errorString();
    }

    private void addMatcherParameter(Element matcherElt, String nameAttr, String content) {
        Element paramElt = new Element("matcherParameter");
        paramElt.setAttribute("name", nameAttr);
        paramElt.addContent(content);
        matcherElt.addContent((Content)paramElt);
    }

    @Override
    protected Document doc() {
        Element element2 = new Element("matcher");
        Element type = new Element("matcherType");
        type.addContent("ExpressionMatcher");
        element2.addContent((Content)type);
        this.addMatcherParameter(element2, "Selection", this.getSelection());
        this.addMatcherParameter(element2, "Action", this.getAction());
        this.addMatcherParameter(element2, "Input", this.getInput());
        this.addMatcherParameter(element2, "Actor", this.getActor());
        this.addMatcherParameter(element2, "InputExpression", this.getInputExpression());
        if (trace.getDebugCode("functions")) {
            trace.printStack("functions", "are we writing relation parameter? " + this.getRelation());
        }
        this.addMatcherParameter(element2, "relation", this.getRelation());
        return new Document(element2);
    }

    @Override
    public Matcher.MatcherParameter getMatcherParameter(int index) {
        if (trace.getDebugCode("functions")) {
            trace.outln("functions", this.getClass() + ".getMatcherParameter(" + index + ")");
        }
        if (this.single) {
            switch (index) {
                case 0: {
                    return new Matcher.MatcherParameter("InputExpression", this.getParameter(index));
                }
                case 1: {
                    return new Matcher.MatcherParameter("relation", this.getParameter(index));
                }
            }
            return null;
        }
        switch (index) {
            case 0: {
                return new Matcher.MatcherParameter("selection", this.getParameter(index));
            }
            case 1: {
                return new Matcher.MatcherParameter("action", this.getParameter(index));
            }
            case 2: {
                return new Matcher.MatcherParameter("input", this.getParameter(index));
            }
            case 3: {
                return new Matcher.MatcherParameter("actor", this.getParameter(index));
            }
            case 4: {
                return new Matcher.MatcherParameter("InputExpression", this.getParameter(index));
            }
            case 5: {
                return new Matcher.MatcherParameter("relation", this.getParameter(index));
            }
        }
        return null;
    }

    @Override
    public int getParameterCount() {
        return this.single ? 2 : 6;
    }

    public void setRelation(int relationIndex) {
        if (0 <= relationIndex && relationIndex < RELATIONS.length) {
            this.relation = relationIndex;
            return;
        }
        trace.err("ExpressionMatcher.setRelation(" + relationIndex + ") arg outside [0," + RELATIONS.length + "), setting default " + RELATIONS[0]);
        this.relation = 0;
    }

    public void setRelation(String relationName) {
        for (int i = 0; i < RELATIONS.length; ++i) {
            if (!RELATIONS[i].equals(relationName)) continue;
            this.relation = i;
            break;
        }
    }

    public String getRelation() {
        return RELATIONS[this.relation];
    }

    public boolean isEqualRelation() {
        return this.relation == 0;
    }

    public boolean isBooleanRelation() {
        return this.relation == 6;
    }

    public Object lastResult() {
        return this.lastResult;
    }

    public String lastInput() {
        return this.lastInput;
    }

    public String lastError() {
        return this.lastError;
    }

    public Date lastEvaluationTime() {
        return this.lastEvaluationTime;
    }

    public boolean lastComparison() {
        return this.lastComparison;
    }

    @Override
    public String getEvaluatedInput() {
        if (this.lastResult == null) {
            return "";
        }
        return this.lastResult.toString();
    }

    public void print(String s) {
    }

    @Override
    public String toString() {
        return RELATIONS[this.relation] + " \"" + this.expression + "\"";
    }

    @Override
    public String[] getValuesVector() {
        String[] arr = new String[]{this.toString()};
        return arr;
    }

    @Override
    public String getActionMatcherType() {
        return "Exact";
    }

    @Override
    public String getInputMatcherType() {
        return this.getMatcherTypeText();
    }

    @Override
    public String getSelectionMatcherType() {
        return "Exact";
    }

    public String errorString() {
        if (this.functions == null) {
            return null;
        }
        return this.functions.errorString();
    }
}

