/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.ctat;

import edu.cmu.hcii.ctat.CTATBase;
import edu.cmu.hcii.ctat.CTATLink;
import edu.cmu.pact.Utilities.trace;
import java.util.LinkedHashMap;
import java.util.Map;

public class CTATDirectoryEntry
extends CTATBase {
    private String directory = "";
    private String name = "";
    private String description = "";
    private int index = -1;

    int getIndex() {
        return this.index;
    }

    public CTATDirectoryEntry() {
        this.setClassName("CTATDirectoryEntry");
        this.debug("CTATDirectoryEntry ()");
    }

    public void setDirectory(String directory) {
        this.directory = directory;
    }

    public String getDirectory() {
        return this.directory;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    static Map<String, CTATDirectoryEntry> createMapFromFile(String filename) {
        String dirTXT = CTATLink.fManager.getContents(filename);
        if (dirTXT == null) {
            return null;
        }
        LinkedHashMap<String, CTATDirectoryEntry> entries = new LinkedHashMap<String, CTATDirectoryEntry>();
        String[] lines = dirTXT.split("\\r?\\n");
        int j = 0;
        for (int i = 0; i < lines.length; ++i) {
            String key;
            String[] pieces = lines[i].split("\\|");
            if (trace.getDebugCode("localts")) {
                trace.out("localts", "Name: " + pieces[0] + ", Dir: " + pieces[1] + ", Desc: " + pieces[2]);
            }
            if ((key = pieces[1]) == null || key.length() < 1) continue;
            CTATDirectoryEntry entry = new CTATDirectoryEntry();
            entry.setName(pieces[0]);
            entry.setDirectory(key);
            entry.setDescription(pieces[2]);
            entry.index = j++;
            entries.put(key, entry);
        }
        return entries;
    }
}

