/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.BehaviorRecorder.View;

import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.EdgeData;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ProblemEdge;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ProblemGraph;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ProblemNode;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Matcher.Matcher;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;
import java.util.regex.Pattern;

public class JFind {
    private static final String NODE_NAME = "State Name";
    private static final String NODE_ID = "State ID";
    private static final String EDGE_SKILLS = "Skills";
    private static final String EDGE_SUCC_MSG = "Success Messages";
    private static final String EDGE_SELECTION = "Demonstrated Selection";
    private static final String EDGE_ACTION = "Demonstrated Action";
    private static final String EDGE_INPUT = "Demonstrated Input";
    private static final String EDGE_BUGGY_MSG = "Buggy Messages";
    private static final String EDGE_HINTS = "Hints";
    private static final String EDGE_MATCHER_SELECTION = "Matcher Selection";
    private static final String EDGE_MATCHER_ACTION = "Matcher Action";
    private static final String EDGE_MATCHER_INPUT = "Matcher Input";
    private static final String EDGE_REPLACEMENT = "Replacement Formula";
    private static final String EDGE_ID = "Link ID";
    private static final String EDGE_MATCHER_TYPE = "Matcher Type";
    public static final List<String> searchableFields = Arrays.asList("State Name", "State ID", "Skills", "Success Messages", "Demonstrated Selection", "Demonstrated Action", "Demonstrated Input", "Buggy Messages", "Hints", "Matcher Selection", "Matcher Action", "Matcher Input", "Matcher Type", "Replacement Formula", "Link ID");

    private static boolean vectorMatches(Vector<String> vector, Pattern findStr) {
        Enumeration<String> enumer = vector.elements();
        while (enumer.hasMoreElements()) {
            String next = enumer.nextElement();
            if (!JFind.singleMatches(next, findStr)) continue;
            return true;
        }
        return false;
    }

    private static boolean singleMatches(String possibleMatch, Pattern findStr) {
        if (possibleMatch == null) {
            return false;
        }
        return findStr.matcher(possibleMatch).matches();
    }

    private static void addNode(HashMap<String, ProblemNode> map, ProblemNode node, String field) {
        map.put(node.getName() + " (" + field + ")", node);
    }

    public static HashMap<String, ProblemNode> nodeMatches(ProblemGraph g, Pattern findStr, HashSet<String> search) {
        HashMap<String, ProblemNode> map = new HashMap<String, ProblemNode>();
        Enumeration<ProblemNode> nodes = g.nodes();
        while (nodes.hasMoreElements()) {
            ProblemNode node = nodes.nextElement();
            if (search.contains(NODE_NAME) && JFind.singleMatches(node.getName(), findStr)) {
                JFind.addNode(map, node, NODE_NAME);
            }
            String id = Integer.toString(node.getUniqueID());
            if (!search.contains(NODE_ID) || !JFind.singleMatches(id, findStr)) continue;
            JFind.addNode(map, node, NODE_ID);
        }
        return map;
    }

    private static void addEdge(HashMap<String, ProblemEdge> map, ProblemEdge edge, String field) {
        map.put("Link " + Integer.toString(edge.getUniqueID()) + " (" + field + ")", edge);
    }

    public static HashMap<String, ProblemEdge> edgeMatches(ProblemGraph g, Pattern findStr, HashSet<String> search) {
        HashMap<String, ProblemEdge> map = new HashMap<String, ProblemEdge>();
        Enumeration<ProblemEdge> edges = g.edges();
        while (edges.hasMoreElements()) {
            ProblemEdge edge = edges.nextElement();
            EdgeData data = edge.getEdgeData();
            if (search.contains(EDGE_SKILLS) && JFind.vectorMatches(data.getSkills(), findStr)) {
                JFind.addEdge(map, edge, EDGE_SKILLS);
            }
            if (search.contains(EDGE_SUCC_MSG) && JFind.singleMatches(data.getSuccessMsg(), findStr)) {
                JFind.addEdge(map, edge, EDGE_SUCC_MSG);
            }
            if (search.contains(EDGE_SELECTION) && JFind.vectorMatches(data.getSelection(), findStr)) {
                JFind.addEdge(map, edge, EDGE_SELECTION);
            }
            if (search.contains(EDGE_ACTION) && JFind.vectorMatches(data.getAction(), findStr)) {
                JFind.addEdge(map, edge, EDGE_ACTION);
            }
            if (search.contains(EDGE_INPUT) && JFind.vectorMatches(data.getInput(), findStr)) {
                JFind.addEdge(map, edge, EDGE_INPUT);
            }
            if (search.contains(EDGE_BUGGY_MSG) && JFind.singleMatches(data.getBuggyMsg(), findStr)) {
                JFind.addEdge(map, edge, EDGE_BUGGY_MSG);
            }
            if (search.contains(EDGE_HINTS) && JFind.vectorMatches(data.getHints(), findStr)) {
                JFind.addEdge(map, edge, EDGE_HINTS);
            }
            Matcher m = data.getMatcher();
            if (search.contains(EDGE_MATCHER_SELECTION) && JFind.singleMatches(m.getSelection(), findStr)) {
                JFind.addEdge(map, edge, EDGE_MATCHER_SELECTION);
            }
            if (search.contains(EDGE_MATCHER_ACTION) && JFind.singleMatches(m.getAction(), findStr)) {
                JFind.addEdge(map, edge, EDGE_MATCHER_ACTION);
            }
            if (search.contains(EDGE_MATCHER_INPUT) && JFind.singleMatches(m.getInput(), findStr)) {
                JFind.addEdge(map, edge, EDGE_MATCHER_INPUT);
            }
            if (search.contains(EDGE_REPLACEMENT) && JFind.singleMatches(m.getReplacementFormula(), findStr)) {
                JFind.addEdge(map, edge, EDGE_REPLACEMENT);
            }
            Vector<String> matcherType = new Vector<String>();
            matcherType.add(m.getSelectionMatcherType());
            matcherType.add(m.getActionMatcherType());
            matcherType.add(m.getInputMatcherType());
            if (search.contains(EDGE_MATCHER_TYPE) && JFind.vectorMatches(matcherType, findStr)) {
                JFind.addEdge(map, edge, EDGE_MATCHER_TYPE);
            }
            String id = Integer.toString(edge.getUniqueID());
            if (!search.contains(EDGE_ID) || !JFind.singleMatches(id, findStr)) continue;
            JFind.addEdge(map, edge, EDGE_ID);
        }
        return map;
    }
}

