/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.BehaviorRecorder.Controller;

import edu.cmu.pact.BehaviorRecorder.Controller.AuthorUI;
import edu.cmu.pact.BehaviorRecorder.Controller.BR_Controller;
import edu.cmu.pact.BehaviorRecorder.Controller.CTAT_Launcher;
import edu.cmu.pact.BehaviorRecorder.Controller.CTAT_Options;
import edu.cmu.pact.BehaviorRecorder.Controller.PseudoTutorMessageHandler;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.ProblemModel;
import edu.cmu.pact.BehaviorRecorder.Tab.CTATTab;
import edu.cmu.pact.BehaviorRecorder.Tab.CTATTabManager;
import edu.cmu.pact.JavascriptBridge.JSProxy;
import edu.cmu.pact.Preferences.PreferencesModel;
import edu.cmu.pact.SocketProxy.SocketProxy;
import edu.cmu.pact.SocketProxy.SocketToolProxy;
import edu.cmu.pact.TutoringService.Collaborators;
import edu.cmu.pact.TutoringService.LauncherServer;
import edu.cmu.pact.TutoringService.TSLauncherServer;
import edu.cmu.pact.Utilities.NtpClient;
import edu.cmu.pact.Utilities.Utils;
import edu.cmu.pact.Utilities.VersionInformation;
import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.ctat.MessageObject;
import edu.cmu.pact.ctat.StudentInterfacePanel;
import edu.cmu.pact.ctat.TutorController;
import edu.cmu.pact.ctat.model.ProblemSummary;
import edu.cmu.pact.ctat.view.CtatFrame;
import edu.cmu.pact.ctatview.CtatMenuBar;
import edu.cmu.pact.miss.MissControllerExternal;
import edu.cmu.pact.miss.WebStartFileDownloader;
import java.applet.Applet;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.lang.reflect.Method;
import java.net.Socket;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.StringTokenizer;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.UIManager;
import pact.CommWidgets.StudentInterfaceWrapper;
import pact.CommWidgets.TutorWrapper;
import pact.CommWidgets.UniversalToolProxy;
import pact.CommWidgets.UniversalToolProxyForLisp;

public class SingleSessionLauncher {
    public static final String DEBUG_CODES = "debugCodes";
    public static final String USE_JS_BRIDGE = "useJsBridge";
    public static final String USE_HTTP = "useHTTP";
    private BR_Controller controller;
    private TSLauncherServer launcher = null;
    private String projectDir = null;
    private TutorWrapper wrapper;
    private Applet applet = null;
    private String sessionId = null;
    private boolean ssRunValidation = false;
    private boolean hideCTAT;
    private CTAT_Launcher ctatLauncher;
    private boolean simStPleOn = false;

    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    private void setProjectDir(String pDir) {
    }

    public String getProjectDir() {
        return this.projectDir;
    }

    public BR_Controller getController() {
        return this.controller;
    }

    public TSLauncherServer getLauncherServer() {
        return this.launcher;
    }

    public boolean inTutoringServiceMode() {
        return this.launcher instanceof LauncherServer;
    }

    public boolean inAppletMode() {
        return this.applet != null;
    }

    public Applet getApplet() {
        return this.applet;
    }

    public SingleSessionLauncher(boolean showCtatWindow) {
        this(null, showCtatWindow);
    }

    public SingleSessionLauncher() {
        this(true);
    }

    public SingleSessionLauncher(String[] argv, CTATTabManager tabManager, CTAT_Launcher ctatLauncher, CTATTab tab) {
        this(null, null, argv, true, null, null, null, tabManager, ctatLauncher, tab);
    }

    public SingleSessionLauncher(String[] argv) {
        this(argv, true);
    }

    public SingleSessionLauncher(String[] argv, boolean showCtatWindow) {
        this(null, null, argv, showCtatWindow, null, null, null);
    }

    public SingleSessionLauncher(Socket sock, BufferedReader br, String[] argv, boolean showCtatWindow, TSLauncherServer ls, MessageObject setPrefsMsg, Applet applet) {
        this(sock, br, argv, showCtatWindow, ls, setPrefsMsg, applet, null, null, null);
    }

    public SingleSessionLauncher(Socket sock, BufferedReader br, String[] argv, boolean showCtatWindow, TSLauncherServer ls, MessageObject setPrefsMsg, Applet applet, CTATTabManager tabManager, CTAT_Launcher ctatLauncher, CTATTab containerTab) {
        if (trace.getDebugCode("mg")) {
            trace.out("mg", String.format("SingleSessionLauncher(sock %s, br %s, argv.len %d, show %b,\n  ls %s, setPrefs %s, applet %s, tabMgr %s, ctatLauncher %s, tab %s)", sock, trace.nh(br), argv.length, showCtatWindow, trace.nh(ls), setPrefsMsg == null ? null : setPrefsMsg.summary(), trace.nh(applet), trace.nh(tabManager), trace.nh(ctatLauncher), trace.nh(containerTab)));
        }
        this.ctatLauncher = ctatLauncher;
        this.applet = applet;
        Utils.setRuntime((this.inAppletMode() || ctatLauncher == null) && !showCtatWindow);
        int tabNumber = 1;
        if (containerTab != null) {
            containerTab.setLauncher(this);
            tabNumber = containerTab.getTabNumber();
        }
        if (ls == null && ctatLauncher != null) {
            ls = ctatLauncher.getAuthorLauncherServer();
        }
        this.launcher = ls;
        if (!this.inTutoringServiceMode() && !this.inAppletMode()) {
            System.setProperty("swing.disableFileChooserSpeedFix", "true");
            SingleSessionLauncher.installNativeLookAndFeel();
        }
        String noTutorInterface = null;
        noTutorInterface = !this.inAppletMode() ? System.getProperty("noCtatWindow") : "true";
        if (noTutorInterface != null) {
            trace.out("No CTAT Window");
            showCtatWindow = false;
        }
        this.controller = argv != null ? new BR_Controller(showCtatWindow, this.PreCheckReducedMode(argv), new Boolean(this.inTutoringServiceMode()), this, tabNumber) : new BR_Controller(showCtatWindow, false, new Boolean(this.inTutoringServiceMode()), this, tabNumber);
        if (!Utils.isRuntime()) {
            AuthorUI.setJCommWidgetController(this.controller);
        }
        this.controller.setHomeDir(SingleSessionLauncher.getPackageNameAsPath(this));
        UniversalToolProxy utp = null;
        if (argv == null || !Arrays.asList(argv).contains("-useJsBridge")) {
            utp = VersionInformation.includesCL() ? new UniversalToolProxyForLisp() : new UniversalToolProxy();
            this.controller.setUniversalToolProxy(utp);
            utp.init(this.controller);
        }
        if (trace.getDebugCode("ssl")) {
            trace.out("ssl", "In the SingleSessionsLauncher constructor, the socket (sock) is " + (sock == null ? "null" : "not null"));
        }
        if (sock != null) {
            this.controller.setRemoteProxy(new SocketProxy(sock, SocketProxy.argvToMsgFormat(argv)));
            ((SocketProxy)this.controller.getRemoteProxy()).setController(this.controller, br);
        }
        if (argv != null) {
            trace.out("br", "going to parse Argv...");
            this.parseArgv(argv);
        }
        if (!Utils.isRuntime()) {
            utp.setStudentInterfaceConnectionStatus(null);
        }
        CtatMenuBar handler = null;
        if (!Utils.isRuntime()) {
            this.controller.getProblemModel().setCaseInsensitive(true);
            this.controller.getProblemModel().setAllowToolMode(true);
            this.controller.getProblemModel().setMaxStudents(1);
            this.controller.getSolutionState().resetUserVisitedEdges();
            handler = ctatLauncher.getCtatMenuBar();
            handler.applyPreferences();
        }
        this.controller.initializeInterfaceActions_NoneState_Tutor();
        this.controller.init(null);
        this.controller.loadControlFromSystemProperties();
        if (this.controller.getRemoteProxy() != null) {
            if (this.inTutoringServiceMode()) {
                this.controller.getRemoteProxy().setupLogServlet(setPrefsMsg);
            }
            if (trace.getDebugCode("sp")) {
                trace.out("sp", "SingleSessionLauncher starting socket proxy");
            }
            this.controller.getRemoteProxy().start();
        }
        if (!Utils.isRuntime()) {
            AuthorUI.addOpenFileListener(this.controller);
        }
    }

    private void setJCommWidgetController(TutorController controller) {
        String jcwName = "pact.CommWidgets.JCommWidget";
        String scName = "setController";
        Class<?> jcwClass = null;
        try {
            jcwClass = Class.forName(jcwName);
            Class[] argSignature = new Class[]{TutorController.class};
            Method scMethod = jcwClass.getMethod(scName, argSignature);
            Object[] args = new Object[]{controller};
            scMethod.invoke(null, args);
        }
        catch (Exception e) {
            trace.err("Error trying to invoke class " + jcwName + " method " + scName + ": " + e + ";\n  cause " + e.getCause());
            return;
        }
    }

    public static void installNativeLookAndFeel() {
        String nativeLF = UIManager.getSystemLookAndFeelClassName();
        try {
            UIManager.setLookAndFeel(nativeLF);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void launch() {
        this.controller.loadControlFromSystemProperties();
        this.controller.loadBRDFromSystemProperties();
    }

    public void launchCL(StudentInterfaceWrapper wrapper, JPanel clTutorPanel) {
        SingleSessionLauncher.installNativeLookAndFeel();
        wrapper.getWrapperSupport().setController(this.controller);
        this.getController().setStudentInterface(wrapper, clTutorPanel);
        this.continueLaunch(wrapper, clTutorPanel);
    }

    public void launch(JComponent tutorPanel) {
        SingleSessionLauncher.installNativeLookAndFeel();
        this.wrapper = this.getMissController().createWrapper(this.getMissController().isSimStPleOn(), this.getMissController().isSsContest(), this.controller);
        if (this.wrapper == null) {
            this.wrapper = new TutorWrapper(this.controller);
        }
        this.controller.setStudentInterface(this.wrapper, tutorPanel);
        this.continueLaunch(this.wrapper, tutorPanel);
        if (this.getMissController().isSimStPleOn()) {
            this.controller.setModeSimStAndDestroyProdRules();
            this.controller.getMissController().requestEnterNewProblem();
            this.getMissController().setTitle(this.wrapper.getActiveWindow());
        } else if (this.getMissController().isSsContest()) {
            this.controller.setModeSimStAndDestroyProdRules();
        } else if (this.controller.getOptions().getShowLoginWindow() || this.controller.getOptions().getConnectToLispAtStartup()) {
            this.wrapper.setVisible(false);
        } else {
            this.wrapper.setVisible(true);
        }
    }

    public void launchSimStPLE(JComponent tutorPanel) {
        if (trace.getDebugCode("miss")) {
            trace.out("miss", "Launching SimSt PLE...");
        }
        SingleSessionLauncher.installNativeLookAndFeel();
        this.wrapper = this.getMissController().createWrapper(true, false, this.controller);
        this.controller.setStudentInterface(this.wrapper, tutorPanel);
        this.continueLaunch(this.wrapper, tutorPanel);
        this.controller.setModeSimStAndDestroyProdRules();
        this.controller.getMissController().requestEnterNewProblem();
    }

    private void continueLaunch(StudentInterfaceWrapper wrapper, JComponent tutorPanel) {
        String projDir;
        String homeDirPath;
        CTAT_Options ctatOptions = wrapper.setTutorPanel(tutorPanel);
        if (trace.getDebugCode("inter")) {
            trace.out("inter", "options = " + ctatOptions);
        }
        if (tutorPanel instanceof StudentInterfacePanel) {
            ((StudentInterfacePanel)((Object)tutorPanel)).setController(this.controller);
        }
        if (ctatOptions == null) {
            ctatOptions = new CTAT_Options();
        }
        if (this.hideCTAT) {
            ctatOptions.setShowBehaviorRecorder(false);
        }
        if (trace.getDebugCode("inter")) {
            trace.out("inter", "options = " + ctatOptions);
        }
        if (ctatOptions != null && trace.getDebugCode("inter")) {
            trace.out("inter", "options.showBR = " + ctatOptions.getShowBehaviorRecorder());
        }
        this.controller.setOptions(ctatOptions);
        if (!this.hideCTAT) {
            wrapper.setVisible(true);
        }
        if (this.controller.getDockedFrame() != null) {
            ((CtatFrame)this.controller.getDockedFrame()).getCtatMenuBar().enableInterfaceMenus(true);
        }
        String string = homeDirPath = (projDir = this.getProjectDir()) != null ? projDir : SingleSessionLauncher.getPackageNameAsPath(tutorPanel);
        if (trace.getDebugCode("miss")) {
            trace.out("miss", "homeDirPath = " + homeDirPath);
        }
        this.setInterfaceHome(homeDirPath, tutorPanel);
        this.controller.loadControlFromSystemProperties();
        this.controller.loadBRDFromSystemProperties();
        if (this.getMissController() != null && this.getMissController().getSimSt() != null && this.getMissController().getSimSt().getMissController().isSsRunValidation()) {
            this.controller.setModeSimStAndDestroyProdRules();
            this.getMissController().getSimSt().getMissController().runSimStValidationTest();
            System.exit(0);
        } else if (this.controller.getMissController().getSimSt() != null && this.controller.getMissController().getSimSt().isSsBatchMode()) {
            if (trace.getDebugCode("miss")) {
                trace.out("miss", "ssBatchMode ON...");
            }
            this.controller.setModeSimStAndDestroyProdRules();
            this.controller.getMissController().runSimStNoTutorInterface();
            System.exit(0);
        }
        if (!this.controller.getShowBehaviorRecorder() && this.controller.getCtatFrameController() != null) {
            this.controller.getCtatFrameController().getDockedFrame().setVisible(false);
        }
    }

    private void setInterfaceHome(String path, Object studentInterface) {
        PreferencesModel pm;
        if (this.controller != null && (pm = this.controller.getPreferencesModel()) != null) {
            pm.setStringValue("Interface Directory", path);
        }
        this.controller.setHomeDir(path);
        URL url = Utils.getURL(path, studentInterface);
        if (trace.getDebugCode("inter")) {
            trace.out("inter", "setInterfaceHome() path " + path + ", studentInterface " + studentInterface + ", url " + url);
        }
        trace.out("url = " + url);
        if (url == null) {
            return;
        }
        String urlStr = url.toString();
        String parentUrlStr = urlStr.substring(0, urlStr.length() - path.length());
        if (!this.inAppletMode()) {
            System.setProperty("studentInterface.url", parentUrlStr);
        }
        this.controller.getProperties().setProperty("studentInterface.url", parentUrlStr);
        if (this.controller.getMissController() != null && this.controller.getMissController().getSimSt() != null && this.controller.getMissController().getSimSt().isWebStartMode()) {
            this.controller.getPreferencesModel().setStringValue("Problem Directory", WebStartFileDownloader.SimStWebStartDir);
            trace.out("miss", "WebStart Mode: CTAT_Controller.PROBLEM_DIRECTORY: Problem Directory");
        }
        if (trace.getDebugCode("inter")) {
            trace.out("inter", "setInterfaceHome() INTERFACE_HOME_PROPERTY now set to " + parentUrlStr);
        }
    }

    public static String getPackageNameAsPath(Object obj) {
        if (obj.getClass().getPackage() == null) {
            return "";
        }
        String packageName = obj.getClass().getPackage().getName();
        StringTokenizer st = new StringTokenizer(packageName, ".");
        String dirName = "";
        String currDir = "";
        while (st.hasMoreTokens()) {
            currDir = st.nextToken();
            dirName = dirName + currDir + "/";
        }
        return dirName;
    }

    private String[] getArgvParameter(String[] argv, int keyIndex) {
        ArrayList<String> paramList = new ArrayList<String>();
        for (int i = keyIndex + 1; i < argv.length; ++i) {
            if (argv[i].length() < 1) continue;
            if (argv[i].charAt(0) == '-') break;
            paramList.add(argv[i]);
        }
        String[] getArgvParameter = null;
        if (!paramList.isEmpty()) {
            getArgvParameter = new String[paramList.size()];
            for (int i = 0; i < paramList.size(); ++i) {
                getArgvParameter[i] = (String)paramList.get(i);
            }
        }
        return getArgvParameter;
    }

    private void setSystemProperty(String propName, String[] values) {
        if (propName.length() < 2) {
            throw new IllegalArgumentException("missing system property");
        }
        String pName = propName.substring(1);
        int eqIndex = pName.indexOf("=");
        if (eqIndex > 0) {
            if (!this.inAppletMode()) {
                System.setProperty(pName.substring(0, eqIndex), pName.substring(eqIndex + 1));
            }
            this.controller.getProperties().setProperty(pName.substring(0, eqIndex), pName.substring(eqIndex + 1));
        } else if (eqIndex < 0) {
            String value = "";
            if (values != null && values.length > 0) {
                value = values[0];
            }
            if (!this.inAppletMode()) {
                System.setProperty(pName, value);
            }
            this.controller.getProperties().setProperty(pName, value);
        } else {
            throw new IllegalArgumentException("bad system property");
        }
    }

    private boolean PreCheckReducedMode(String[] argv) {
        for (int i = 0; i < argv.length; ++i) {
            String key = argv[i];
            if (key == null || key.length() <= 0 || key.charAt(0) != '-') continue;
            try {
                String keyStem = key.substring(1);
                if (!keyStem.startsWith("reduced")) continue;
                return true;
            }
            catch (IllegalArgumentException iae) {
                trace.err("Error on command line argument " + i + " '" + key + "': " + iae);
            }
        }
        return false;
    }

    private void parseArgv(String[] argv) {
        for (int i = 0; i < argv.length; ++i) {
            String key;
            if (trace.getDebugCode("miss")) {
                trace.out("miss", "argv[" + i + "] = " + argv[i]);
            }
            if ((key = argv[i]).length() < 1 || key.charAt(0) != '-') continue;
            try {
                String keyStem = key.substring(1);
                if (trace.getDebugCode("miss")) {
                    trace.out("miss", "keyStem=" + keyStem);
                }
                String[] parameter = this.getArgvParameter(argv, i);
                if (keyStem.startsWith("D")) {
                    this.setSystemProperty(keyStem, parameter);
                    continue;
                }
                if (keyStem.equalsIgnoreCase("useOldExampleTracer")) {
                    this.setUseNewExampleTracer(false);
                    continue;
                }
                if (keyStem.equalsIgnoreCase("traceLevel")) {
                    this.setTraceLevel(parameter[0]);
                    continue;
                }
                if (keyStem.equalsIgnoreCase(DEBUG_CODES)) {
                    this.addDebugCodes(parameter);
                    continue;
                }
                if (keyStem.startsWith("sp")) {
                    this.setSocketProxyOptions(keyStem, parameter);
                    continue;
                }
                if (keyStem.equalsIgnoreCase(USE_JS_BRIDGE)) {
                    this.configureJSBridge();
                    continue;
                }
                if (keyStem.equalsIgnoreCase("reduced")) {
                    this.setReducedMode(true);
                    continue;
                }
                if (keyStem.equalsIgnoreCase(USE_HTTP)) {
                    this.controller.setStudentInterfaceLocal(false);
                    continue;
                }
                if (keyStem.equalsIgnoreCase(USE_JS_BRIDGE) || keyStem.equalsIgnoreCase("skipmonitor") || keyStem.equalsIgnoreCase("wsPort") || keyStem.equalsIgnoreCase("wssPort") || keyStem.equalsIgnoreCase("keystore") || keyStem.startsWith("ss")) continue;
                throw new IllegalArgumentException("Unknown command line argument: " + keyStem);
            }
            catch (IllegalArgumentException iae) {
                trace.err("Error on command line argument " + i + " '" + key + "': " + iae);
            }
        }
    }

    private void setSocketProxyOptions(String key, String[] parameters) {
        this.controller.setStudentInterfaceLocal(false);
        if (!(this.controller.getUniversalToolProxy() instanceof SocketToolProxy)) {
            SocketToolProxy stp = new SocketToolProxy(this.controller);
            this.controller.setUniversalToolProxy(stp);
        }
    }

    private void configureJSBridge() {
        JSProxy jsProxy = new JSProxy(this.controller);
        this.controller.setRemoteProxy(jsProxy);
        this.controller.setUniversalToolProxy(jsProxy.getToolProxy());
        this.controller.setStudentInterfaceLocal(false);
    }

    public void addDebugCodes(String[] debugCode) {
        if (debugCode != null) {
            for (int i = 0; i < debugCode.length; ++i) {
                if (debugCode[i] == null || debugCode[i].length() <= 0) continue;
                trace.addDebugCode(debugCode[i]);
            }
        }
    }

    private void setUseNewExampleTracer(boolean flag) {
        PseudoTutorMessageHandler.USE_NEW_EXAMPLE_TRACER = flag;
    }

    private void setTraceLevel(String level) {
        trace.setTraceLevel(Integer.parseInt(level));
    }

    private void setSimStPleOn(boolean flag) {
        this.simStPleOn = flag;
    }

    private boolean isSimStPleOn() {
        return this.simStPleOn;
    }

    MissControllerExternal getMissController() {
        if (this.getCTATLauncher() == null) {
            return null;
        }
        return this.getCTATLauncher().getMissController();
    }

    public void setKeepHidden(boolean keepHidden) {
        this.hideCTAT = keepHidden;
    }

    public void setReducedMode(boolean isReduced) {
        this.controller.setIsReducedMode(isReduced);
    }

    public void setSimStUserId(String userID) {
        this.getMissController().setSsUserID(userID);
    }

    public void setSimStName(String name) {
        this.getMissController().setSsSimStName(name);
    }

    public void setSimStImage(String img) {
        this.getMissController().setSsSimStImage(img);
    }

    public void setSimStProblemsPerQuizSection(String num) {
        this.getMissController().setSimStProblemsPerQuizSection(Integer.parseInt(num));
    }

    public void setSimStLogURL(String logURL) {
        this.getMissController().setSimStLogURL(logURL);
    }

    private void setSsCLQuizReqMode() {
        this.getMissController().setSsCLQuizReqMode();
    }

    private void setSsSelfExplainMode() {
        this.getMissController().setSsSelfExplainMode();
    }

    public TutorWrapper getWrapper() {
        return this.wrapper;
    }

    public void setWrapper(TutorWrapper wrapper) {
        this.wrapper = wrapper;
    }

    public NtpClient getNtpClient() {
        TSLauncherServer ls = this.getLauncherServer();
        if (ls == null) {
            return null;
        }
        return ls.getNtpClient();
    }

    public Collaborators checkForCollaborators(MessageObject setPrefs) throws Collaborators.NotReadyException {
        if (this.getLauncherServer() == null) {
            return null;
        }
        return this.getLauncherServer().checkForCollaborators(this.getSessionId(), setPrefs);
    }

    public Collaborators.Collaborator findCollaborator() {
        if (this.getLauncherServer() == null) {
            return null;
        }
        return this.getLauncherServer().findCollaborator(this.getSessionId());
    }

    public void endCollaboration() {
        if (this.getLauncherServer() == null) {
            return;
        }
        this.getLauncherServer().endCollaboration(this.getSessionId());
    }

    public String getProblemSummary() {
        try {
            ProblemModel pm = this.controller.getProblemModel();
            ProblemSummary ps = pm.getProblemSummary();
            return ps.toXML();
        }
        catch (Exception e) {
            trace.errStack("Error getting problem summary text: " + e + "; cause " + e.getCause(), e);
            return "<ProblemSummary />";
        }
    }

    public CTATTabManager getTabManager() {
        return this.ctatLauncher == null ? null : this.ctatLauncher.getTabManager();
    }

    public CTAT_Launcher getCTATLauncher() {
        return this.ctatLauncher;
    }

    public MessageObject editSetPreferences(MessageObject setPrefs) {
        return this.getLauncherServer().editSetPreferences(setPrefs, this.getSessionId());
    }

    public void addNewSession(String guid) {
        String sessId = this.getLauncherServer().addNewSession(guid);
        this.setSessionId(sessId);
        TSLauncherServer.Session session = this.getLauncherServer().getSession(sessId);
        session.setLauncher(this);
        session.setController(this.getController());
        this.getController().getProperties().setProperty("guid", sessId);
    }

    public void addNewSession(TSLauncherServer.Session sess) {
        this.getLauncherServer().addSession(sess);
        String sessId = sess.getGuid();
        this.setSessionId(sessId);
        sess.setLauncher(this);
        sess.setController(this.getController());
        this.getController().getProperties().setProperty("guid", sessId);
    }

    public void removeSession(TSLauncherServer.Session sess) {
        this.getLauncherServer().removeSession(sess.getGuid());
        this.setSessionId(null);
        sess.setController(this.getController());
    }

    public Collaborators getCollaborators() {
        if (this.getLauncherServer() == null) {
            return null;
        }
        return this.getLauncherServer().getCollaborators(this.getSessionId());
    }

    public void launchHTMLPage(String htmlFilename) {
        try {
            if (trace.getDebugCode("html")) {
                trace.out("html", "SSL.launchHTMLPage(" + htmlFilename + ")");
            }
            CTATTab tab1 = this.getTabManager().getTabByNumber(1);
            File htmlFile = new File(htmlFilename);
            if (!htmlFile.canRead()) {
                throw new FileNotFoundException("Cannot read file " + htmlFilename);
            }
            tab1.setTargetHTMLFile(htmlFile);
            tab1.launchHTMLPage();
        }
        catch (Exception e) {
            String errMsg = "Error launching HTML page \"" + htmlFilename + "\": " + e;
            Utils.showExceptionOccuredDialog(null, errMsg, "Error launching HTML tutor");
        }
    }
}

