/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.ctat.monitor;

import edu.cmu.hcii.ctat.CTATBase;
import edu.cmu.hcii.ctat.monitor.CTATMessageReceiver;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;

public class CTATStreamedSocket
extends CTATBase
implements Runnable {
    private String data = "";
    private PrintWriter outWriter = null;
    private Socket clientSocket = null;
    private BufferedReader in = null;
    private int socketTimeout = 2000;
    private CTATMessageReceiver receiver;
    private Boolean threadRunning = false;

    public CTATStreamedSocket() {
        this.setClassName("CTATStreamedSocket");
        this.debug("CTATStreamedSocket ()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String convertStreamToString(InputStream is) {
        this.debug("convertStreamToString ()");
        if (is != null) {
            StringWriter writer = new StringWriter();
            char[] buffer = new char[1024];
            try {
                BufferedReader reader = null;
                try {
                    reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                    this.debug("UnsupportedEncodingException");
                }
                try {
                    int n;
                    while ((n = reader.read(buffer)) != -1) {
                        ((Writer)writer).write(buffer, 0, n);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    this.debug("IOException");
                }
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    this.debug("IOException");
                }
            }
            return ((Object)writer).toString();
        }
        return "";
    }

    public String sendAndReceiveXML(String aHost, int aPort, String aMessage) {
        this.debug("sendAndReceive (" + aHost + "," + aPort + ")");
        return this.sendAndReceive(aHost, aPort, "<?xml version=\"1.0\" encoding=\"utf-8\"?>" + aMessage);
    }

    public String sendAndReceive(String aHost, int aPort, String aMessage) {
        this.debug("sendAndReceive (" + aHost + "," + aPort + ")");
        InputStream is = null;
        if (this.clientSocket == null) {
            this.outWriter = null;
            this.in = null;
            try {
                InetSocketAddress sockaddr = new InetSocketAddress(aHost, aPort);
                this.clientSocket = new Socket();
                this.clientSocket.connect(sockaddr, this.socketTimeout);
                this.outWriter = new PrintWriter(this.clientSocket.getOutputStream(), true);
                is = this.clientSocket.getInputStream();
                if (is == null) {
                    return "";
                }
            }
            catch (UnknownHostException e) {
                this.debug("Unknown host: " + aHost);
                return "";
            }
            catch (IOException e) {
                this.debug("No I/O or connection timeout");
                return "";
            }
        }
        this.outWriter.println(aMessage + "\u0000");
        this.debug("Sent: " + aMessage);
        this.data = this.convertStreamToString(is);
        return this.data;
    }

    public Boolean sendAndKeepOpen(String aHost, int aPort, String aMessage, CTATMessageReceiver aReceiver) {
        this.debug("sendAndKeepOpen (" + aHost + "," + aPort + ")");
        this.receiver = aReceiver;
        if (this.clientSocket == null) {
            this.debug("Creating connection ...");
            this.close();
            try {
                this.debug("Creating socket ...");
                InetSocketAddress sockaddr = new InetSocketAddress(aHost, aPort);
                this.clientSocket = new Socket();
                this.clientSocket.connect(sockaddr, this.socketTimeout);
                this.debug("Created socket, creating printwriter ...");
                this.outWriter = new PrintWriter(this.clientSocket.getOutputStream(), true);
                this.debug("Created socket, connecting input stream ...");
                this.in = new BufferedReader(new InputStreamReader(this.clientSocket.getInputStream(), "UTF-8"));
            }
            catch (UnknownHostException e) {
                this.debug("Unknown host: " + aHost);
                this.close();
                if (this.receiver != null) {
                    this.receiver.handleConnectionClosed();
                }
                return false;
            }
            catch (SecurityException e) {
                this.debug("A security exception occurred while connecting to the remote host");
                this.close();
                if (this.receiver != null) {
                    this.receiver.handleConnectionClosed();
                }
                return false;
            }
            catch (IOException e) {
                this.debug("No I/O or connection timeout");
                this.close();
                if (this.receiver != null) {
                    this.receiver.handleConnectionClosed();
                }
                return false;
            }
            Thread thread = new Thread(this);
            this.threadRunning = true;
            thread.start();
        }
        this.debug("Connection open, sending ...");
        if (this.outWriter == null) {
            this.debug("Internal error: outwriter is null");
            return false;
        }
        this.outWriter.print(aMessage + "\u0000");
        this.outWriter.flush();
        this.debug("Sent " + (aMessage.length() + 1) + " characters");
        return true;
    }

    public void close() {
        this.debug("close ()");
        if (this.clientSocket != null) {
            try {
                this.clientSocket.close();
            }
            catch (IOException e) {
                this.debug("Error closing socket");
                e.printStackTrace();
            }
        }
        if (this.in != null) {
            try {
                this.in.close();
            }
            catch (IOException e) {
                this.debug("Error closing input stream");
                e.printStackTrace();
            }
        }
        this.outWriter = null;
        this.in = null;
        this.clientSocket = null;
        this.threadRunning = false;
    }

    private String readToEom(Reader rdr, int eom) throws IOException {
        int c;
        this.debug("readToEom (Reader rdr, int eom)");
        StringWriter result = new StringWriter(4096);
        int count = 0;
        while (0 <= (c = rdr.read()) && c != eom) {
            ++count;
            if (c == 13) {
                this.debug("CR return is found at offset " + count);
            }
            result.write(c);
        }
        if (count == 0) {
            return null;
        }
        return result.toString();
    }

    public String readToEom(DataInputStream rdr, int eom) throws IOException {
        int c;
        this.debug("readToEom (DataInputStream rdr, int eom)");
        StringWriter result = new StringWriter(4096);
        int count = 0;
        while (0 <= (c = rdr.read()) && c != eom) {
            ++count;
            if (c == 13) {
                this.debug("CR return is found at offset " + count);
            }
            result.write(c);
        }
        if (count == 0) {
            return null;
        }
        return result.toString();
    }

    @Override
    public void run() {
        this.debug("run ()");
        while (this.threadRunning.booleanValue()) {
            try {
                this.data = this.readToEom(this.in, 0);
            }
            catch (IOException e) {
                this.debug("Error reading data, most likely connection reset or closed");
                this.close();
                if (this.receiver != null) {
                    this.receiver.handleConnectionClosed();
                }
                this.threadRunning = false;
                return;
            }
            if (this.data != null) {
                if (this.receiver == null) continue;
                if (this.data.isEmpty()) {
                    this.debug("Internal error: empty string received!");
                    this.close();
                    continue;
                }
                this.receiver.handleIncomingData(this.data);
                continue;
            }
            this.debug("Received null data, probably closed the socket");
            if (this.receiver != null) {
                this.receiver.handleConnectionClosed();
            }
            this.close();
            return;
        }
    }
}

