/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.miss.PeerLearning;

import edu.cmu.pact.BehaviorRecorder.Controller.BR_Controller;
import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.miss.jess.APlusModelTracing;
import edu.cmu.pact.miss.jess.ModelTraceWorkingMemory;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Hashtable;

public class SimStConversation {
    public static final String METATUTOR = "<MT>";
    public static final String QUIZ = "<Q>";
    public static final String MODEL_TRACE_ERROR = "<ERR>";
    public static final String SELECTION = "<s>";
    public static final String INPUT = "<i>";
    public static final String OPERATION = "<o>";
    public static final String NO_ACTIVATIONS = "<A0>";
    public static final String NOT_FIRST_ACTIVATION = "<A2>";
    public static final String BEHAVIOUR_DISCREPENCY = "<BD>";
    public static final String NEW_PROBLEM_TOPIC = "NEW_PROBLEM";
    public static final String START_PROBLEM_TOPIC = "START_PROBLEM";
    public static final String THINK_TOPIC = "THINK";
    public static final String DONE_FEEDBACK_TOPIC = "DONE_FEEDBACK";
    public static final String FEEDBACK_TOPIC = "FEEDBACK";
    public static final String SOLVED_TOPIC = "SOLVED";
    public static final String TRANSFORMATION_HINT_TOPIC = "TRANSFORMATION_HINT";
    public static final String TYPEIN_HINT_TOPIC = "TYPEIN_HINT";
    public static final String FAIL_TO_LEARN_GIVE_UP_TOPIC = "FAIL_TO_LEARN_GIVE_UP";
    public static final String START_PROBLEM_NO_TOPIC = "START_PROBLEM_NO";
    public static final String STEP_CORRECT_TOPIC = "STEP_CORRECT";
    public static final String STEP_INCORRECT_TOPIC = "STEP_INCORRECT";
    public static final String CHECK_ANSWER = "CHECK_ANSWER";
    public static final String NO_VAR_VALUE_CHECK_ANS = "NO_VAR_VALUE_CHECK_ANS";
    public static final String PLUG_IN = "PLUG_IN";
    public static final String NO_VAR_TO_PLUG = "NO_VAR_TO_PLUG";
    public static final String BALANCE_CHECK_ANSWER = "BALANCE_CHECK_ANSWER";
    public static final String NO_BALANCE_CHECK_ANSWER = "NO_BALANCE_CHECK_ANSWER";
    public static final String VERIFY_WRONG = "VERIFY_WRONG";
    public static final String CONFIRM_TOPIC = "CONFIRM";
    public static final String SKIPPED_TOPIC = "SKIPPED";
    public static final String UNDO_CONFIRM_STEPS_TOPIC = "UNDO_CONFIRM_STEPS";
    public static final String NOTHING_TO_UNDO_TOPIC = "NOTHING_TO_UNDO";
    public static final String UNDO_RESUME_TOPIC = "UNDO_RESUME";
    public static final String UNDO_SHOULD_DO_TOPIC = "UNDO_SHOULD_DO";
    public static final String UNDO_REMEMBER_PREVIOUS_TOPIC = "UNDO_REMEMBER_PREVIOUS";
    public static final String NO_UNDO_TOPIC = "NO_UNDO";
    public static final String NO_UNDO_DONE_TOPIC = "NO_UNDO_DONE";
    public static final String NO_UNDO_FAIL_TO_LEARN_TOPIC = "NO_UNDO_FAIL_TO_LEARN";
    public static final String FEEDBACK_NEGATIVE_TOPIC = "FEEDBACK_NEGATIVE";
    public static final int ERROR_THRESHOLD = 4;
    private BR_Controller brController;
    private boolean modelTraced = false;
    private boolean metatutored = false;
    private ModelTraceWorkingMemory mtwm;
    private APlusModelTracing apmt;
    private Hashtable<String, ArrayList<String>> topics;
    private boolean behaviourDiscrepency = false;
    boolean behaviourDiscrepencyBroughtUp = false;

    public void setBehaviourDiscrepency(boolean flag) {
        this.behaviourDiscrepency = flag;
        if (flag) {
            this.setBehaviourDiscrepencyBroughtUp(true);
        }
    }

    private boolean getBehaviourDiscrepency() {
        return this.behaviourDiscrepency;
    }

    public void setBehaviourDiscrepencyBroughtUp(boolean flag) {
        this.behaviourDiscrepencyBroughtUp = flag;
    }

    public boolean getBehaviourDiscrepencyBroughtUp() {
        return this.behaviourDiscrepencyBroughtUp;
    }

    public SimStConversation(BR_Controller brController, String filename) {
        this.brController = brController;
        this.topics = new Hashtable();
        this.readTopics(filename);
        if (brController.getAmt() != null && brController.getMissController().getSimSt().getModelTraceWM() != null) {
            this.modelTraced = true;
            this.mtwm = brController.getMissController().getSimSt().getModelTraceWM();
            this.apmt = brController.getAmt().getaPlusModelTracing();
        }
        if (brController.getMissController().getSimSt().isSsMetaTutorMode()) {
            this.metatutored = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readTopics(String filename) {
        String file = this.brController.getMissController().getSimSt().getPackageName() + "/" + filename;
        ClassLoader cl = this.getClass().getClassLoader();
        InputStream is = cl.getResourceAsStream(file);
        InputStreamReader isr = new InputStreamReader(is);
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(isr);
            String line = reader.readLine();
            while (line != null) {
                String topic = line;
                if (topic.length() > 0) {
                    line = reader.readLine();
                    ArrayList<String> values = new ArrayList<String>();
                    while (line != null && line.length() > 0) {
                        values.add(line);
                        line = reader.readLine();
                    }
                    trace.out("ss", "Added topic " + topic + " with " + values.size() + " choices.");
                    this.topics.put(topic, values);
                }
                if (line == null) continue;
                line = reader.readLine();
            }
        }
        catch (Exception e) {
            if (trace.getDebugCode("miss")) {
                trace.out("miss", "Unable to read config file: " + e.getMessage());
            }
            e.printStackTrace();
        }
        finally {
            try {
                reader.close();
            }
            catch (Exception exception) {}
        }
    }

    public String getMessage(String topic) {
        return this.getMessage(topic, null, null, null, -1);
    }

    public String getMessage(String topic, String selection, String input) {
        return this.getMessage(topic, selection, input, null, -1);
    }

    public String getMessage(String topic, String operation) {
        return this.getMessage(topic, null, null, operation, -1);
    }

    public String getMessage(String topic, int activationNum) {
        return this.getMessage(topic, null, null, null, activationNum);
    }

    public String getMessage(String topic, String selection, String input, int activationNum) {
        return this.getMessage(topic, selection, input, null, activationNum);
    }

    public String getMessage(String topic, String selection, String input, String operation, int activationNum) {
        ArrayList<String> messages = this.topics.get(topic);
        String message = messages.get((int)(Math.random() * (double)messages.size()));
        if (!this.messageWorks(message, selection, input, operation, activationNum)) {
            message = this.getFilteredMessage(messages, selection, input, operation, activationNum);
        }
        return this.replaceVariables(message, selection, input, operation);
    }

    public String getFilteredMessage(ArrayList<String> messages, String selection, String input, String operation, int activationNum) {
        ArrayList<String> filtered = new ArrayList<String>();
        for (int i = 0; i < messages.size(); ++i) {
            String message = messages.get(i);
            if (!this.messageWorks(message, selection, input, operation, activationNum)) continue;
            filtered.add(message);
        }
        if (filtered.size() == 0) {
            return "";
        }
        return (String)filtered.get((int)(Math.random() * (double)filtered.size()));
    }

    public boolean isTextInTopic(String topic, String text) {
        ArrayList<String> messages = this.topics.get(topic);
        int loc = text.indexOf(":");
        String pureText = text.substring(loc + 2, text.length());
        return messages.contains(pureText);
    }

    public boolean messageWorks(String message, String selection, String input, String operation, int activationNum) {
        trace.out("ss", "Checking if message works: " + message);
        if (!(this.modelTraced && this.metatutored || !message.contains(METATUTOR))) {
            return false;
        }
        if (this.getBehaviourDiscrepency() && !message.contains(BEHAVIOUR_DISCREPENCY)) {
            return false;
        }
        if ((!this.modelTraced || "false".equals(this.mtwm.getQuizTaken())) && message.contains(QUIZ)) {
            return false;
        }
        if ((!this.metatutored || this.apmt.getTraceHistoryIncorrectCount() < 4) && message.contains(MODEL_TRACE_ERROR)) {
            return false;
        }
        if (selection == null && message.contains(SELECTION)) {
            return false;
        }
        if (input == null && message.contains(INPUT)) {
            return false;
        }
        if (operation == null && message.contains(OPERATION)) {
            return false;
        }
        if (activationNum == -1 && (message.contains(NO_ACTIVATIONS) || message.contains(NOT_FIRST_ACTIVATION))) {
            return false;
        }
        if (activationNum < 1 && message.contains(NOT_FIRST_ACTIVATION)) {
            return false;
        }
        return activationNum <= 0 || !message.contains(NO_ACTIVATIONS);
    }

    public String replaceVariables(String message, String selection, String input, String operation) {
        message = message.replaceAll(BEHAVIOUR_DISCREPENCY, "");
        message = message.replaceAll(METATUTOR, "");
        message = message.replaceAll(SELECTION, selection);
        message = message.replaceAll(INPUT, input);
        message = message.replaceAll(OPERATION, operation);
        message = message.replaceAll(NO_ACTIVATIONS, "");
        message = message.replaceAll(NOT_FIRST_ACTIVATION, "");
        message = message.replaceAll(MODEL_TRACE_ERROR, "");
        message = message.replaceAll(QUIZ, "");
        return message;
    }
}

