/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.jess;

import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.jess.UIRecorder;
import jess.Deftemplate;
import jess.Fact;
import jess.JessException;
import jess.Rete;

public class StudentValuesRecorder
extends UIRecorder {
    private final String[] slotNames = new String[]{"selection", "action", "input"};
    private final String QUERY_NAME = "get-studentValues";
    private final String QUERY = "(defquery get-studentValues \"Retrieve the fact holding the student SAI.\"?result <- (studentValues))";
    private final Boolean useSVFact;

    public StudentValuesRecorder(Boolean useSVFact, Rete rete) {
        super(rete);
        this.coerceSymbolsToStrings = true;
        this.useSVFact = useSVFact;
    }

    @Override
    protected Deftemplate makeTemplate() {
        if (this.useSVFact != null) {
            return this.useSVFact != false ? super.makeTemplate() : null;
        }
        try {
            return this.rete.findDeftemplate(this.getTemplateName());
        }
        catch (JessException je) {
            trace.err("Error finding deftemplate " + this.getTemplateName() + ": " + (Object)((Object)je) + "; cause " + je.getCause() + ".\n  " + je.getProgramText() + "\n  " + je.getDetail());
            return null;
        }
    }

    @Override
    protected Boolean modifyFact(Fact fact, String ... newValues) {
        try {
            Deftemplate dt = fact.getDeftemplate();
            this.rete.retract(fact);
            return this.assertFact(dt, newValues);
        }
        catch (Exception e) {
            trace.err("error retracting studentValues fact " + fact + ": " + e);
            e.printStackTrace();
            return null;
        }
    }

    public Boolean update(String selection, String action, String input) {
        if (trace.getDebugCode("uic")) {
            trace.out("uic", "StudentValuesRecorder.update(" + selection + ", " + action + ", " + input + "): useSVFact " + this.useSVFact);
        }
        if (this.useSVFact != null && !this.useSVFact.booleanValue()) {
            return null;
        }
        return this.updateFirst(selection, action, input);
    }

    @Override
    protected String getQueryName() {
        return "get-studentValues";
    }

    @Override
    public String getQuery() {
        return "(defquery get-studentValues \"Retrieve the fact holding the student SAI.\"?result <- (studentValues))";
    }

    @Override
    protected int getNParams() {
        return 0;
    }

    @Override
    public String[] getSlotNames() {
        return this.slotNames;
    }

    @Override
    protected String getTemplateName() {
        return "studentValues";
    }

    @Override
    protected String getTemplate() {
        return "(deftemplate " + this.getTemplateName() + " (slot selection) (slot action) (slot input))";
    }
}

