/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.Utilities;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import pact.CommWidgets.JCommPicture;

public class PictureTransferHandler
extends TransferHandler {
    DataFlavor pictureFlavor = DataFlavor.imageFlavor;
    public JCommPicture sourcePic;
    public JCommPicture destPic;
    boolean shouldRemove;

    public PictureTransferHandler(JCommPicture pic) {
        this.setDestPic(pic);
    }

    @Override
    public boolean importData(JComponent c, Transferable t) {
        System.err.println("Enter importData: " + ((JCommPicture)c).getCommName() + " +++ " + t);
        if (this.canImport(c, t.getTransferDataFlavors())) {
            this.destPic = (JCommPicture)c;
            if (this.sourcePic == this.destPic) {
                System.out.println("importData: don't drop to the same picture");
                this.shouldRemove = false;
                return true;
            }
            try {
                System.out.println("importData: " + this.destPic.getCommName());
                ImageIcon image = (ImageIcon)t.getTransferData(this.pictureFlavor);
                this.destPic.setImage(image);
                return true;
            }
            catch (UnsupportedFlavorException ufe) {
                System.out.println("importData: unsupported data flavor");
            }
            catch (IOException ioe) {
                System.out.println("importData: I/O exception");
            }
        }
        return false;
    }

    @Override
    public Transferable createTransferable(JComponent c) {
        System.err.println("createTransferable: " + ((JCommPicture)c).getCommName());
        this.sourcePic = (JCommPicture)c;
        this.shouldRemove = true;
        return new PictureTransferable(this.sourcePic);
    }

    @Override
    public int getSourceActions(JComponent c) {
        System.err.println("getSourceActions: " + ((JCommPicture)c).getCommName());
        return 3;
    }

    @Override
    protected void exportDone(JComponent c, Transferable data, int action) {
        System.err.println("exportDone: " + ((JCommPicture)c).getCommName());
        if (this.shouldRemove && action == 2) {
            this.sourcePic.setImage(null);
        }
        this.sourcePic = null;
    }

    @Override
    public boolean canImport(JComponent c, DataFlavor[] flavors) {
        System.err.println("canImport: " + ((JCommPicture)c).getCommName());
        for (int i = 0; i < flavors.length; ++i) {
            if (!this.pictureFlavor.equals(flavors[i])) continue;
            return true;
        }
        return false;
    }

    public JCommPicture getSourcePic() {
        return this.sourcePic;
    }

    public void setSourcePic(JCommPicture sourcePic) {
        this.sourcePic = sourcePic;
    }

    public JCommPicture getDestPic() {
        return this.destPic;
    }

    public void setDestPic(JCommPicture destPic) {
        this.destPic = destPic;
    }

    class PictureTransferable
    implements Transferable {
        private ImageIcon image;

        PictureTransferable(JCommPicture pic) {
            this.image = pic.image;
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
            System.err.println("getTransferData: " + flavor);
            if (!this.isDataFlavorSupported(flavor)) {
                throw new UnsupportedFlavorException(flavor);
            }
            return this.image;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            System.err.println("getTransferDataFlavors: ");
            return new DataFlavor[]{PictureTransferHandler.this.pictureFlavor};
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            System.err.println("isDataFlavorSupported: ");
            return PictureTransferHandler.this.pictureFlavor.equals(flavor);
        }
    }
}

