/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.TutoringService;

import edu.cmu.hcii.ctat.CTATHTTPExchange;
import edu.cmu.pact.BehaviorRecorder.Controller.BR_Controller;
import edu.cmu.pact.BehaviorRecorder.Controller.SingleSessionLauncher;
import edu.cmu.pact.SocketProxy.HTTPActionHandler;
import edu.cmu.pact.SocketProxy.LogServlet;
import edu.cmu.pact.SocketProxy.SocketProxy;
import edu.cmu.pact.TutoringService.LauncherHandler;
import edu.cmu.pact.TutoringService.TSLauncherServer;
import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.ctat.HTTPMessageObject;
import edu.cmu.pact.ctat.MessageObject;
import java.io.BufferedReader;
import java.util.Date;
import pact.CommWidgets.RemoteToolProxy;

public class HTTPSession
extends TSLauncherServer.Session {
    private HTTPActionHandler actionHandler;
    private LogServlet logServlet;

    public LogServlet getLogServlet() {
        return this.logServlet;
    }

    protected void setLogServlet(LogServlet logServlet) {
        this.logServlet = logServlet;
    }

    protected HTTPSession(TSLauncherServer launcherServer, String guid) {
        TSLauncherServer tSLauncherServer = launcherServer;
        tSLauncherServer.getClass();
        super(tSLauncherServer, guid, null);
        this.actionHandler = null;
        if (launcherServer != this.getLauncherServer()) {
            throw new IllegalArgumentException("HTTPSession() given LauncherServer " + trace.nh(launcherServer) + " not same as superclass enclosing " + trace.nh(this.getLauncherServer()));
        }
        if (trace.getDebugCode("http")) {
            trace.out("http", "HTTPSession() guid " + guid);
        }
    }

    public HTTPSession(TSLauncherServer launcherServer, String guid, String requestBody, CTATHTTPExchange exchange, LauncherHandler handler) {
        this(launcherServer, guid);
        if (trace.getDebugCode("http")) {
            trace.out("http", "HTTPSession() guid " + guid + ", requestBody '" + requestBody + "'");
        }
        try {
            if (requestBody == null) {
                requestBody = HTTPMessageObject.messageFromExchange(exchange);
            }
            this.msgFormat = RemoteToolProxy.deriveMsgFormat(requestBody);
        }
        catch (Exception e) {
            LauncherHandler.sendResponse(exchange, "Error reading request: " + e + "; cause " + e.getCause(), 400);
            return;
        }
        MessageObject tempSetPrefs = SocketProxy.convertMsg(requestBody, this.getMsgFormat());
        if (!this.findBRDFilename(tempSetPrefs)) {
            LauncherHandler.sendResponse(exchange, "No graph file specified", 400);
            return;
        }
        if (trace.getDebugCode("ls")) {
            trace.out("ls", "LauncherHandler: new session: guid " + guid + ", school " + this.getSchoolName() + ", userGuid " + this.getUserGuid() + "\n  BRD File = " + this.brdFile);
        }
        this.setupController(null);
        this.setSetPreferencesMsg(new HTTPMessageObject(requestBody, exchange, this.getMsgFormat(), this.getController()));
        if (trace.getDebugCode("ls")) {
            trace.out("ls", "HTTPSession about to addSession " + this);
        }
        this.getLauncherServer().addSession(this);
        this.setLoggingProperties(this.getSetPreferencesMsg());
        this.getSetPreferencesMsg().setTransactionInfo(this.getTxInfo().create());
        this.setupLogServlet(this.getSetPreferencesMsg());
        this.processSetPreferences();
        this.setTimeStamp(new Date());
        this.setIPAddr(exchange.getIPAddress());
    }

    @Override
    public void setSetPreferencesMsg(MessageObject msg) {
        super.setSetPreferencesMsg(msg);
        if (trace.getDebugCode("http") && msg instanceof HTTPMessageObject) {
            HTTPMessageObject hMsg = (HTTPMessageObject)msg;
            trace.out("http", "Session.setSetPreferencesMsg() tool proxy " + trace.nh(hMsg.getHttpToolProxy()) + ", exch " + trace.nh(hMsg.getHttpExchange()) + ", exch.toolProxy " + (hMsg.getHttpExchange() == null ? null : trace.nh(hMsg.getHttpExchange().getHTTPToolProxy())));
        }
    }

    public void setupLogServlet(MessageObject setPrefsMsg) {
        Object guidObj;
        String guid = this.getGuid();
        Object object = guidObj = setPrefsMsg == null ? null : setPrefsMsg.getProperty("session_id");
        if (guidObj instanceof String) {
            guid = (String)guidObj;
        }
        LogServlet logServlet = new LogServlet(this.controller.getPreferencesModel(), setPrefsMsg, this.controller.inTutoringServiceMode(), guid);
        if (trace.getDebugCode("log")) {
            trace.out("log", "HTTPSession.setupLogServlet(" + logServlet + ")");
        }
        this.logServlet = logServlet;
        TSLauncherServer ls = this.getController().getLauncher().getLauncherServer();
        if (trace.getDebugCode("log")) {
            trace.out("log", "SocketProxy TSLaunchServer ls = " + trace.nh(ls) + ";\n  guid = " + guid + "; getGuid() = " + this.getGuid() + ";\n  BR_Controller =" + this.controller + " (" + trace.nh(this.controller) + ")");
        }
        if (ls != null) {
            logServlet.setLogInfo(ls.getLogInfo(guid));
        }
        new Thread(logServlet).start();
    }

    public HTTPActionHandler getActionHandler() {
        return this.actionHandler;
    }

    protected void setActionHandler(HTTPActionHandler actionHandler) {
        this.actionHandler = actionHandler;
    }

    @Override
    protected void createLauncher(BufferedReader br) {
        String[] argv = new String[]{"-Dguid=" + this.getGuid(), "-DisOnline=true", "-useHTTP", "-debugCodes", "ls", "-debugCodes", "tsltsp", "-debugCodes", "tsltstp"};
        this.setLauncher(new SingleSessionLauncher(null, null, argv, false, this.getLauncherServer(), null, null));
    }

    public void startActionHandler() {
        BR_Controller controller = this.getController();
        if (this.actionHandler != null) {
            trace.err("HTTPSession warning: startActionHandler(" + controller + ") called when actionHandler " + this.actionHandler + " already set, queue length " + this.actionHandler.size() + "; exiting old one");
            this.actionHandler.halt();
        }
        this.actionHandler = new HTTPActionHandler(controller);
        Thread t = new Thread((Runnable)this.actionHandler, "ActionHandler" + this.getGuid());
        t.start();
    }

    public void postRequestToActionHandler(String requestBody, CTATHTTPExchange exchange) {
        HTTPMessageObject mo = new HTTPMessageObject(requestBody, exchange, this.getMsgFormat(), this.getController());
        TSLauncherServer ls = this.getLauncherServer();
        if (trace.getDebugCode("collab")) {
            trace.out("collab", "HTTPSess.postRequestToAH(): ls " + trace.nh(ls) + "; guid " + this.getGuid());
        }
        String guid = null;
        if (ls != null) {
            guid = this.getGuid();
            ls.updateTimeStamp(guid);
            mo.setTransactionInfo(ls.createTransactionInfo(guid));
        }
        if (ls == null || ls.enqueueToCollaborators(guid, mo) < 1) {
            if (trace.getDebugCode("http")) {
                trace.out("http", "guid " + guid + " enqueue to ActionHandler: " + mo);
            }
            this.getActionHandler().enqueue(mo);
        }
    }
}

