/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.BehaviorRecorder.View.HintWindow;

import edu.cmu.pact.BehaviorRecorder.View.HintWindow.HintWindowInterface;
import edu.cmu.pact.BehaviorRecorder.View.HintWindow.Hints;
import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.client.HintMessagesManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import pact.CommWidgets.JCommWidget;
import pact.CommWidgets.event.IncorrectActionEvent;
import pact.CommWidgets.event.IncorrectActionListener;
import pact.CommWidgets.event.ProblemDoneEvent;
import pact.CommWidgets.event.ProblemDoneListener;
import pact.CommWidgets.event.StudentActionEvent;
import pact.CommWidgets.event.StudentActionListener;

public class HintWindow
extends JDialog
implements ActionListener,
StudentActionListener,
IncorrectActionListener,
ProblemDoneListener,
HintWindowInterface {
    private static final String NEXT_HINT = "  Next Hint >>  ";
    private static final String PREVIOUS_HINT = "  << Previous Hint  ";
    HintMessagesManager messagesManager;
    String message;
    private JEditorPane hintsJEditorPane;
    protected JScrollPane hintsJEditorPaneScrollPane;
    private JPanel okCancelPanel = new JPanel();
    private Hints.HintJButton previousJButton = new Hints.HintJButton("  << Previous Hint  ");
    private Hints.HintJButton nextJButton = new Hints.HintJButton("  Next Hint >>  ");
    private Hints.HintJButton okJButton = new Hints.HintJButton("    OK    ");
    String fontFamily = JCommWidget.getDefaultFont().getFamily();
    int fontSize = JCommWidget.getDefaultFont().getSize();
    Font bugFont = new Font(this.fontFamily, 1, 12);
    Container contentPane = this.getContentPane();
    boolean visibleFlag = false;
    private boolean suppressFeedback = false;

    public HintWindow(Frame parent, HintMessagesManager messagesManager) {
        super(parent, false);
        this.init(messagesManager);
    }

    private void init(HintMessagesManager messagesManager_a) {
        this.setTitle("Hint Window");
        this.messagesManager = messagesManager_a;
        this.messagesManager.setHintInterface(this);
        this.setLocation(new Point(400, 200));
        this.setSize(400, 260);
        this.setResizable(true);
        this.contentPane.setLayout(new BorderLayout());
        this.hintsJEditorPane = new JEditorPane();
        this.hintsJEditorPane.setName("hintsJEditorPane");
        this.hintsJEditorPane.setContentType("text/html");
        this.hintsJEditorPane.setText("<html><br><br><br><br></html>");
        this.hintsJEditorPane.setAutoscrolls(true);
        this.hintsJEditorPane.setEditable(false);
        this.hintsJEditorPane.setFocusable(false);
        this.hintsJEditorPaneScrollPane = new JScrollPane(this.hintsJEditorPane);
        this.contentPane.add((Component)this.hintsJEditorPaneScrollPane, "Center");
        this.okCancelPanel.setLayout(new FlowLayout(1));
        this.okCancelPanel.add(this.previousJButton);
        this.okCancelPanel.add(this.nextJButton);
        this.okCancelPanel.add(this.okJButton);
        this.contentPane.add((Component)this.okCancelPanel, "South");
        this.previousJButton.addActionListener(this);
        this.nextJButton.addActionListener(this);
        this.okJButton.addActionListener(this);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                HintWindow.this.messagesManager.dialogCloseCleanup();
                HintWindow.this.reset();
                HintWindow.this.visibleFlag = false;
                HintWindow.this.setVisible(false);
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        JButton selectedButton = (JButton)ae.getSource();
        trace.out(5, this, "actionPerformed ae.getSource() = " + selectedButton.getText());
        if (selectedButton == this.okJButton) {
            this.messagesManager.dialogCloseCleanup();
            this.reset();
            this.visibleFlag = false;
            this.setVisible(false);
            return;
        }
        if (selectedButton == this.nextJButton) {
            this.message = this.messagesManager.getNextMessage();
        } else if (selectedButton == this.previousJButton) {
            this.message = this.messagesManager.getPreviousMessage();
        }
        this.showMessage(this.message);
    }

    @Override
    public void showMessage(String message) {
        if (trace.getDebugCode("inter")) {
            trace.out("inter", "show message: " + message);
        }
        this.hintsJEditorPane.setText("");
        if (message == null) {
            trace.out(5, this, "show message is null");
            this.reset();
            this.messagesManager.dialogCloseCleanup();
            this.visibleFlag = false;
            this.setVisible(false);
            return;
        }
        if (this.messagesManager.getMessageType().equals("BuggyMessage")) {
            this.hintsJEditorPane.setFont(this.bugFont);
            this.hintsJEditorPane.setText("<b>" + message);
        } else {
            this.hintsJEditorPane.setFont(JCommWidget.getDefaultFont());
            this.hintsJEditorPane.setText(message);
            System.err.println("hintsJEditorPane Text = " + this.hintsJEditorPane.getText());
        }
        trace.out(5, this, "repaint hintsJEditorPane.");
        this.resetButtonEnables();
        this.messagesManager.resetHighlightWidgets();
        if (message.trim().equalsIgnoreCase("HighlightNextCell") || message.trim().equals("")) {
            this.visibleFlag = false;
            this.setVisible(false);
        } else {
            this.visibleFlag = true;
            this.setVisible(true);
        }
    }

    private void resetButtonEnables() {
        this.previousJButton.setEnabled(this.messagesManager.hasPreviousMessage());
        this.nextJButton.setEnabled(this.messagesManager.hasNextMessage());
        if (this.visibleFlag) {
            this.repaint();
            this.validate();
        }
    }

    @Override
    public void reset() {
        if (!this.visibleFlag) {
            return;
        }
        trace.out(5, this, "reset hint window");
        this.hintsJEditorPane.setText("");
        this.previousJButton.setEnabled(false);
        this.nextJButton.setEnabled(false);
        this.messagesManager.reset();
        this.repaint();
    }

    @Override
    public void studentActionPerformed(StudentActionEvent sae) {
    }

    @Override
    public void incorrectActionPerformed(IncorrectActionEvent e) {
    }

    @Override
    public void problemDone(ProblemDoneEvent e) {
    }

    @Override
    public void setDisplayHint(boolean displayHint) {
    }

    @Override
    public void displaySuccessMessage() {
    }

    @Override
    public Component getDoneButton() {
        return null;
    }

    @Override
    public Component getHintButton() {
        return null;
    }

    @Override
    public void displayBuggyMessage(String buggyMessage) {
    }

    @Override
    public JButton getNextHintButton() {
        return this.nextJButton;
    }

    @Override
    public JButton getPrevHintButton() {
        return this.previousJButton;
    }

    @Override
    public void setSuppressFeedback(boolean suppressFeedback) {
        this.suppressFeedback = suppressFeedback;
        if (this.okJButton != null) {
            this.okJButton.setEnabled(!suppressFeedback);
        }
        if (this.nextJButton != null) {
            this.nextJButton.setEnabled(!suppressFeedback);
        }
        if (this.previousJButton != null) {
            this.previousJButton.setEnabled(!suppressFeedback);
        }
    }

    @Override
    public boolean getSuppressFeedback() {
        return this.suppressFeedback;
    }
}

