/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.BehaviorRecorder.ProblemModel.Matcher;

import edu.cmu.pact.BehaviorRecorder.ProblemModel.Matcher.ExactMatcher;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Matcher.ExpressionMatcher;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Matcher.Matcher;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.ProblemModel;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.VariableTable;
import edu.cmu.pact.Utilities.trace;
import fri.patterns.interpreter.parsergenerator.Parser;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import org.jdom.Content;
import org.jdom.Element;

public class VectorMatcher
extends Matcher {
    private final List<Matcher> selectionMatchers;
    private final List<Matcher> actionMatchers;
    private final List<Matcher> inputMatchers;
    private List<Matcher>[] matchers;

    public VectorMatcher() {
        this(true, new LinkedList<Matcher>(), new LinkedList<Matcher>(), new LinkedList<Matcher>());
    }

    public VectorMatcher(boolean concat2, List<Matcher> sMatchers, List<Matcher> aMatchers, List<Matcher> iMatchers) {
        this(concat2, sMatchers, aMatchers, iMatchers, "Student");
    }

    public VectorMatcher(boolean concat2, List<Matcher> sMatchers, List<Matcher> aMatchers, List<Matcher> iMatchers, String actor) {
        super(concat2, 3);
        this.selectionMatchers = sMatchers;
        this.actionMatchers = aMatchers;
        this.inputMatchers = iMatchers;
        this.matchers = new List[3];
        this.matchers[0] = this.selectionMatchers;
        this.matchers[1] = this.actionMatchers;
        this.matchers[2] = this.inputMatchers;
        if (actor == null) {
            actor = "Student";
        }
        this.setDefaultActor(actor);
    }

    @Override
    public Object clone() {
        ArrayList<Matcher> sMatchers = new ArrayList<Matcher>(this.selectionMatchers.size());
        ArrayList<Matcher> aMatchers = new ArrayList<Matcher>(this.actionMatchers.size());
        ArrayList<Matcher> iMatchers = new ArrayList<Matcher>(this.inputMatchers.size());
        for (Matcher m : this.selectionMatchers) {
            sMatchers.add(m);
        }
        for (Matcher m : this.actionMatchers) {
            aMatchers.add(m);
        }
        for (Matcher m : this.inputMatchers) {
            iMatchers.add(m);
        }
        VectorMatcher m = new VectorMatcher(this.concat, sMatchers, aMatchers, iMatchers, this.getDefaultActor());
        m.copyFrom(this);
        return m;
    }

    @Override
    public String getMatcherClassType() {
        return "MultipleVectorsMatcher";
    }

    @Override
    public String getMatcherTypeText() {
        if (this.actionMatchers.get(0).getMatcherTypeText().equals(this.inputMatchers.get(0).getMatcherTypeText()) && this.actionMatchers.get(0).getMatcherTypeText().equals(this.selectionMatchers.get(0).getMatcherTypeText())) {
            return this.actionMatchers.get(0).getMatcherTypeText();
        }
        return "Mixed";
    }

    @Override
    public String getMatcherType() {
        return "Multiple Vectors Match";
    }

    @Override
    public Object getParameter(int index) {
        return null;
    }

    @Override
    public int getParameterCount() {
        return 0;
    }

    private boolean matchElements(List<Matcher> matchers, Vector<String> values) {
        if (values.size() < matchers.size()) {
            return false;
        }
        for (int i = 0; i < matchers.size(); ++i) {
            if (matchers.get(i).getMatcherType().equals("Any")) continue;
            matchers.get(i).matchSingle(values.get(i));
        }
        return true;
    }

    @Override
    public boolean match(Vector selection, Vector action, Vector input) {
        VariableTable temp = null;
        return this.match(selection, action, input, temp);
    }

    @Override
    public boolean match(Vector selection, Vector action, Vector input, String actor, VariableTable vt) {
        boolean matched = this.match(selection, action, input, vt);
        if (trace.getDebugCode("matchers")) {
            trace.out("matchers", "match(" + selection + "," + action + "," + input + "," + actor + ",vt): matched " + matched + ", defaultActor " + this.getDefaultActor());
        }
        if (!matched) {
            return false;
        }
        return actor != null && (actor.equalsIgnoreCase(this.getDefaultActor()) || "Any".equalsIgnoreCase(this.getDefaultActor()));
    }

    public boolean match(Vector selection, Vector action, Vector input, VariableTable vt) {
        if (trace.getDebugCode("match")) {
            trace.out("match", "VectorMatcher.match() caseInsensitive " + this.getCaseInsensitive() + ", selectionMatchers " + this.selectionMatchers + ", actionMatchers " + this.actionMatchers + ", inputMatchers " + this.inputMatchers);
        }
        if ((this.selectionMatchers.size() == 0 || this.actionMatchers.size() == 0 || this.inputMatchers.size() == 0) && this.concat) {
            this.selectionMatchers.add(this.createSingleMatcher(0, this.getDefaultSelectionVector()));
            this.actionMatchers.add(this.createSingleMatcher(1, this.getDefaultActionVector()));
            this.inputMatchers.add(this.createSingleMatcher(2, this.getDefaultInputVector()));
        }
        Vector[] values = new Vector[]{selection, action, input};
        if (this.concat) {
            for (int i = 0; i < 3; ++i) {
                boolean t;
                Matcher m = this.matchers[i].get(0);
                if (!(m instanceof ExpressionMatcher ? !((ExpressionMatcher)m).matchConcatenation(selection, action, input, vt) : !(t = m.matchConcatenation(values[i])))) continue;
                return false;
            }
            return true;
        }
        return this.matchElements(this.selectionMatchers, selection) && this.matchElements(this.actionMatchers, action) && this.matchElements(this.inputMatchers, input);
    }

    private Matcher createSingleMatcher(int role, Vector defaultVector) {
        ExactMatcher m = new ExactMatcher(this.concat, role, VectorMatcher.vector2ConcatString(defaultVector));
        m.setCaseInsensitive(this.getCaseInsensitive());
        return m;
    }

    @Override
    public boolean match(Vector selection, Vector action, Vector input, String actor) {
        boolean mResult = this.match(selection, action, input, (VariableTable)null);
        if (!mResult) {
            return false;
        }
        return this.getDefaultActor() == actor || this.getDefaultActor() == "Any";
    }

    @Override
    public boolean matchForHint(Vector selection, Vector action, String actor, VariableTable vt) {
        return this.match(selection, action, actor, vt);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean match(Vector selection, Vector action, String actor, VariableTable vt) {
        boolean selectionsMatch;
        if (!this.matchActor(actor)) {
            return false;
        }
        boolean actionsMatch = true;
        if (this.concat) {
            Matcher sm = this.selectionMatchers.get(0);
            Matcher am = this.actionMatchers.get(0);
            if (sm instanceof ExpressionMatcher) {
                selectionsMatch = ((ExpressionMatcher)sm).matchConcatenation(selection, true, vt);
                if (action != null && am instanceof ExpressionMatcher) {
                    actionsMatch = ((ExpressionMatcher)am).matchConcatenation(action, true, vt);
                }
            } else {
                if (selection == null) return false;
                selectionsMatch = sm.matchSingle(VectorMatcher.vector2ConcatString(selection));
                if (action != null) {
                    actionsMatch = am.matchSingle(VectorMatcher.vector2ConcatString(action));
                }
            }
        } else {
            selectionsMatch = this.matchElements(this.selectionMatchers, selection);
            if (action != null) {
                actionsMatch = this.matchElements(this.actionMatchers, action);
            }
        }
        if (!selectionsMatch) return false;
        if (!actionsMatch) return false;
        return true;
    }

    @Override
    public boolean match(int i, Vector v) {
        throw new UnsupportedOperationException();
    }

    public List<Matcher> getMatchers(int vector) {
        return this.matchers[vector];
    }

    @Override
    public void setCaseInsensitive(boolean caseInsensitive) {
        super.setCaseInsensitive(caseInsensitive);
        for (Matcher matcher : this.selectionMatchers) {
            matcher.setCaseInsensitive(caseInsensitive);
        }
        for (Matcher matcher : this.actionMatchers) {
            matcher.setCaseInsensitive(caseInsensitive);
        }
        for (Matcher matcher : this.inputMatchers) {
            matcher.setCaseInsensitive(caseInsensitive);
        }
    }

    @Override
    public void setExternalResources(VariableTable variableTable, ProblemModel problemModel, Parser parser) {
        for (Matcher matcher : this.selectionMatchers) {
            matcher.setExternalResources(variableTable, problemModel, parser);
        }
        for (Matcher matcher : this.actionMatchers) {
            matcher.setExternalResources(variableTable, problemModel, parser);
        }
        for (Matcher matcher : this.inputMatchers) {
            matcher.setExternalResources(variableTable, problemModel, parser);
        }
    }

    @Override
    public void setParameterByIndex(String stringValue, int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void setParameterInternal(Element element2, int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String toXML() {
        return null;
    }

    @Override
    public String toXML(String prefix) {
        return null;
    }

    @Override
    public String getActionLabelText() {
        return this.actionMatchers.get(0).getSingleLabelText();
    }

    @Override
    public String getInputLabelText() {
        return this.inputMatchers.get(0).getSingleLabelText();
    }

    @Override
    public String getSelectionLabelText() {
        return this.selectionMatchers.get(0).getSingleLabelText();
    }

    @Override
    public String getActionToolTipText() {
        return this.actionMatchers.get(0).getToolTipText();
    }

    @Override
    public String getInputToolTipText() {
        return this.inputMatchers.get(0).getToolTipText();
    }

    @Override
    public String getSelectionToolTipText() {
        return this.selectionMatchers.get(0).getToolTipText();
    }

    @Override
    public String getToolTipText() {
        return this.getSingleLabelText();
    }

    @Override
    public String getSingleLabelText() {
        return "";
    }

    @Override
    public String getActionMatcherType() {
        return this.actionMatchers.get(0).getMatcherTypeText();
    }

    @Override
    public String getInputMatcherType() {
        return this.inputMatchers.get(0).getMatcherTypeText();
    }

    @Override
    public String getSelectionMatcherType() {
        return this.selectionMatchers.get(0).getMatcherTypeText();
    }

    @Override
    public String getEvaluatedInput() {
        if (this.inputMatchers.size() == 0) {
            return this.getInput();
        }
        Matcher inputMatcher = this.inputMatchers.get(0);
        if (!(inputMatcher instanceof ExpressionMatcher)) {
            return this.getInput();
        }
        ExpressionMatcher exInputMatcher = (ExpressionMatcher)inputMatcher;
        if (exInputMatcher.isEqualRelation()) {
            return exInputMatcher.getEvaluatedInput();
        }
        return this.getInput();
    }

    @Override
    public String getSelection() {
        if (this.selectionMatchers.size() == 0) {
            return this.getDefaultSelection();
        }
        return this.selectionMatchers.get(0).toString();
    }

    @Override
    public String getAction() {
        if (this.actionMatchers.size() == 0) {
            return this.getDefaultAction();
        }
        return this.actionMatchers.get(0).toString();
    }

    @Override
    public String getInput() {
        if (this.inputMatchers.size() == 0) {
            return this.getDefaultInput();
        }
        return this.inputMatchers.get(0).toString();
    }

    public Matcher getSingleMatcher(String which) {
        if ("selection".equalsIgnoreCase(which)) {
            return this.selectionMatchers.get(0);
        }
        if ("action".equalsIgnoreCase(which)) {
            return this.actionMatchers.get(0);
        }
        return this.inputMatchers.get(0);
    }

    public String getInputMatcher() {
        Matcher inputMatcher = this.inputMatchers.get(0);
        if (inputMatcher instanceof ExactMatcher && inputMatcher.toString().equals("")) {
            return this.getDefaultInput();
        }
        return inputMatcher.toString();
    }

    public String getSelectionMatcher() {
        Matcher selectionMatcher = this.selectionMatchers.get(0);
        if (selectionMatcher instanceof ExactMatcher && selectionMatcher.toString().equals("")) {
            return this.getDefaultSelection();
        }
        return selectionMatcher.toString();
    }

    public String getActionMatcher() {
        Matcher actionMatcher = this.actionMatchers.get(0);
        if (actionMatcher instanceof ExactMatcher && actionMatcher.toString().equals("")) {
            return this.getDefaultAction();
        }
        return actionMatcher.toString();
    }

    @Override
    public boolean replaceInput() {
        Matcher inputMatcher = this.inputMatchers.get(0);
        if (inputMatcher == null) {
            return false;
        }
        return inputMatcher.replaceInput();
    }

    @Override
    public String getReplacementFormula() {
        Matcher inputMatcher = this.inputMatchers.get(0);
        if (inputMatcher == null) {
            return null;
        }
        return inputMatcher.getReplacementFormula();
    }

    @Override
    public void setReplacementFormula(String replacementFormula) {
        Matcher inputMatcher = this.inputMatchers.get(0);
        if (inputMatcher != null) {
            inputMatcher.setReplacementFormula(replacementFormula);
        }
    }

    @Override
    public Element toElement() {
        Element elt = new Element("matchers");
        this.setXMLAttributes(elt);
        Element mElt = null;
        mElt = new Element("Selection");
        for (Matcher m : this.getMatchers(0)) {
            mElt.addContent((Content)m.toElement());
        }
        elt.addContent((Content)mElt);
        mElt = new Element("Action");
        for (Matcher m : this.getMatchers(1)) {
            mElt.addContent((Content)m.toElement());
        }
        elt.addContent((Content)mElt);
        mElt = new Element("Input");
        for (Matcher m : this.getMatchers(2)) {
            mElt.addContent((Content)m.toElement());
        }
        elt.addContent((Content)mElt);
        mElt = new Element("Actor").setText(this.getDefaultActor());
        mElt.setAttribute("linkTriggered", Boolean.toString(this.isLinkTriggered()));
        elt.addContent((Content)mElt);
        return elt;
    }

    protected void setXMLAttributes(Element elt) {
        elt.setAttribute("Concatenation", Boolean.toString(this.isConcat()));
    }
}

