/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.BehaviorRecorder.Controller;

import edu.cmu.hcii.ctat.CTATHTTPSServer;
import edu.cmu.hcii.ctat.CTATHTTPServer;
import edu.cmu.hcii.ctat.ExitableServer;
import edu.cmu.pact.BehaviorRecorder.Controller.AuthorLauncherHandler;
import edu.cmu.pact.BehaviorRecorder.Tab.CTATTabManager;
import edu.cmu.pact.SocketProxy.SocketProxy;
import edu.cmu.pact.TutoringService.Collaborators;
import edu.cmu.pact.TutoringService.TSLauncherServer;
import edu.cmu.pact.TutoringService.TransactionInfo;
import edu.cmu.pact.Utilities.NtpClient;
import edu.cmu.pact.Utilities.SocketReader;
import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.ctat.MessageObject;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import pact.CommWidgets.RemoteToolProxy;

public class AuthorLauncherServer
extends TSLauncherServer {
    private final CTATTabManager tabManager;
    private final Map<String, String> socketArgs;
    private int eom = 0;
    private Listener listener = null;
    private CTATHTTPServer wsServer = null;
    private CTATHTTPSServer wssServer = null;
    private String[] collabSessionIDs = new String[0];
    private String collabId = "";
    private List<ChangeListener> changeListeners = new LinkedList<ChangeListener>();

    public AuthorLauncherServer(CTATTabManager tabManager, String[] cmdLineArgs) {
        ArrayList<Integer> tcpPorts = new ArrayList<Integer>();
        ArrayList<Integer> wsPorts = new ArrayList<Integer>();
        ArrayList<Integer> wssPorts = new ArrayList<Integer>();
        AuthorLauncherServer.parseCmdLine(cmdLineArgs, null, wsPorts, wssPorts, null, null, tcpPorts, "-spServerPort");
        this.tabManager = tabManager;
        this.socketArgs = this.createSocketArgsList(cmdLineArgs == null ? new String[]{} : cmdLineArgs);
        try {
            int eom = -1;
            String eomStr = null;
            eomStr = this.socketArgs.get("eom");
            if (eomStr != null && (eom = Integer.valueOf(eomStr, 16).intValue()) >= 0) {
                this.eom = eom;
            }
        }
        catch (Exception e) {
            trace.errStack("Error converting end of message (eom) argument to integer", e);
        }
        if (tcpPorts.size() > 0) {
            this.listener = new Listener((Integer)tcpPorts.get(0));
        }
        try {
            if (wsPorts.size() < 1) {
                wsPorts.add(20080);
            }
            this.wsServer = new CTATHTTPServer((Integer)wsPorts.get(0), "logfiles", "wslog.txt", new AuthorLauncherHandler(this));
        }
        catch (Exception e) {
            trace.errStack("Error instantiating CTATHTTPServer on port " + wsPorts.get(0) + ", \"logfiles\", \"wslog.txt\", ...)", e);
            this.wsServer = null;
        }
        try {
            if (wssPorts.size() < 1) {
                wssPorts.add(20443);
            }
            this.wssServer = new CTATHTTPSServer((Integer)wssPorts.get(0), "logfiles", "wsslog.txt", new AuthorLauncherHandler(this));
            this.wssServer.setKeystore(keystore);
        }
        catch (Exception e) {
            trace.errStack("Error instantiating CTATHTTPSServer on port " + wssPorts.get(0) + ", \"logfiles\", \"wsslog.txt\", ...)", e);
            this.wssServer = null;
        }
    }

    void startListeners() {
        if (trace.getDebugCode("ls")) {
            trace.out("ls", "AuthorLauncherServer.startListeners(): Starting websocket server on port " + this.wsServer.getPort() + " ...");
        }
        if (this.wsServer != null && !this.wsServer.startWebServer()) {
            trace.err("Unable to start websocket server on port " + this.wsServer.getPort() + ", aborting ...");
        }
        if (trace.getDebugCode("ls")) {
            trace.out("ls", "AuthorLauncherServer.startListeners(): Starting secure websocket server on port " + this.wssServer.getPort() + " ...");
        }
        if (this.wssServer != null && !this.wssServer.startWebServer()) {
            trace.err("Unable to start secure websocket server on port " + this.wssServer.getPort() + ", aborting ...");
        }
        if (this.listener != null) {
            if (trace.getDebugCode("ls")) {
                trace.out("ls", "AuthorLauncherServer.startListeners(): Starting regular tcp listener on port " + (this.listener.ss != null ? this.listener.ss.getLocalPort() : -1) + " ...");
            }
            this.listener.start();
        }
    }

    private Map<String, String> createSocketArgsList(String[] cmdLineArgs) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>(){
            private static final long serialVersionUID = 201401141600L;

            public String get(String key) {
                String result = key == null ? null : (String)super.get(key.toLowerCase());
                if (trace.getDebugCode("sp")) {
                    trace.out("socketArgs.get(" + key + ") returns " + result + ";");
                }
                return result;
            }

            public boolean containsKey(String key) {
                if (key == null) {
                    return false;
                }
                return super.containsKey(key.toLowerCase());
            }
        };
        for (int i = 0; i < cmdLineArgs.length; ++i) {
            String value;
            String option = cmdLineArgs[i];
            if (!option.startsWith("-sp")) continue;
            int eq = option.indexOf(61);
            if (eq >= 0) {
                value = option.substring(eq + 1);
                option = option.substring(3, eq).toLowerCase();
            } else {
                value = ++i < cmdLineArgs.length ? cmdLineArgs[i] : null;
                option = option.substring(3).toLowerCase();
            }
            result.put(option, value);
        }
        return result;
    }

    @Override
    public synchronized boolean removeSession(String guid) {
        if (guid == null) {
            return false;
        }
        this.removeCollabSession(guid);
        TSLauncherServer.Session sess = (TSLauncherServer.Session)this.sessions.remove(guid);
        return sess != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeCollabSession(String guid) {
        if (guid == null) {
            return false;
        }
        this.endCollaboration(guid);
        AuthorLauncherServer authorLauncherServer = this;
        synchronized (authorLauncherServer) {
            int i;
            for (i = 0; i < this.collabSessionIDs.length && !guid.equalsIgnoreCase(this.collabSessionIDs[i]); ++i) {
            }
            if (i >= this.collabSessionIDs.length) {
                return false;
            }
            this.collabSessionIDs[i] = null;
        }
        this.fireChangeEvent(this);
        return true;
    }

    private void sendDisconnect(Socket sock, String guid) {
        PrintWriter out = null;
        try {
            if (sock == null || (out = new PrintWriter(sock.getOutputStream())) == null) {
                return;
            }
        }
        catch (Exception e) {
            trace.errStack("AuthorLauncherServer.sendDisconnect() could not open output stream for socket " + sock, e);
            return;
        }
        MessageObject mo = RemoteToolProxy.createInterfaceForceDisconnectMsg(guid + System.currentTimeMillis());
        String msg = RemoteToolProxy.insertXMLPrologue(mo.toString());
        if (trace.getDebugCode("tsltstp")) {
            trace.outNT("tsltstp", guid + " " + msg);
        }
        SocketReader.sendString(msg, out, this.eom);
    }

    @Override
    public void updateTimeStamp(String guid) {
    }

    @Override
    public TransactionInfo.Single createTransactionInfo(String sessionId) {
        return null;
    }

    @Override
    public void updateTransactionInfo(String sessionId, Object info) {
    }

    @Override
    public NtpClient getNtpClient() {
        return null;
    }

    @Override
    public void startAuthorTimeCollaboration(int teamSize) {
        if (trace.getDebugCode("collab")) {
            trace.out("collab", "AuthorLauncherServer.startAuthorTimeCollaboration(" + teamSize + ")");
        }
        this.stopAuthorTimeCollaboration(true);
        if (teamSize < 2) {
            return;
        }
        this.collabId = Collaborators.dateFmt.format(new Date());
        this.collabSessionIDs = new String[teamSize];
        this.fireChangeEvent(this);
    }

    @Override
    public void stopAuthorTimeCollaboration() {
        this.stopAuthorTimeCollaboration(false);
    }

    private void stopAuthorTimeCollaboration(boolean suppressEvent) {
        for (String sessionID : this.collabSessionIDs) {
            if (sessionID == null) continue;
            this.endCollaboration(sessionID);
        }
        this.collabSessionIDs = new String[0];
        this.collabId = "";
        if (!suppressEvent) {
            this.fireChangeEvent(this);
        }
    }

    @Override
    public MessageObject editSetPreferences(MessageObject setPrefs, String sessionID) {
        if (Collaborators.editSetPreferences(setPrefs, this.collabId, this.collabSessionIDs.length, sessionID)) {
            TSLauncherServer.Session session = this.getSession(sessionID);
            session.setUserGuid((String)setPrefs.getProperty("user_guid"));
            session.setSchoolName((String)setPrefs.getProperty("school_name"));
            session.setTeam(Collaborators.getUserids(setPrefs, null).toString());
        }
        return setPrefs;
    }

    public int[] getCollaborationCounts() {
        int count = 0;
        for (int i = 0; i < this.collabSessionIDs.length; ++i) {
            if (this.collabSessionIDs[i] == null) continue;
            ++count;
        }
        int[] result = new int[]{count, this.collabSessionIDs.length};
        return result;
    }

    @Override
    public String editGuidForCollaboration(String guid) {
        int i;
        for (i = 0; i < this.collabSessionIDs.length && this.collabSessionIDs[i] != null; ++i) {
        }
        if (i >= this.collabSessionIDs.length) {
            return guid;
        }
        this.collabSessionIDs[i] = Collaborators.editSessionIDForCollaboration(guid, this.collabId, i + 1, this.collabSessionIDs.length);
        this.fireChangeEvent(this);
        return this.collabSessionIDs[i];
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeListeners.add(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        if (trace.getDebugCode("startstate")) {
            trace.out("startstate", "TSLauncherServer.removeChangeListener(" + trace.nh(listener) + ")");
        }
        this.changeListeners.remove(listener);
    }

    public void fireChangeEvent(Object source) {
        ChangeEvent ce = new ChangeEvent(source);
        for (ChangeListener listener : this.changeListeners) {
            listener.stateChanged(ce);
        }
    }

    @Override
    public boolean isAuthorMode() {
        return false;
    }

    public synchronized CTATTabManager getTabManager() {
        return this.tabManager;
    }

    @Override
    public int getWSPort() {
        return this.wsServer == null ? super.getWSPort() : this.wsServer.getPort();
    }

    class Connection
    implements Runnable {
        private Socket sock;

        public Connection(Socket sock) {
            this.sock = sock;
        }

        private void close(Reader br) {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (Exception e) {
                trace.err("LauncherServer.close(): Error closing socket stream: " + e + "; cause " + e.getCause());
            }
            try {
                if (this.sock != null) {
                    this.sock.close();
                }
                this.sock = null;
            }
            catch (Exception es) {
                trace.err("Error closing socket: " + es + "; cause " + es.getCause());
            }
        }

        @Override
        public void run() {
            BufferedReader br = null;
            try {
                String guid;
                String result;
                if (trace.getDebugCode("ls")) {
                    trace.outNT("ls", "Trying to get GUID");
                }
                if (SocketProxy.handlePolicyFileRequest(result = SocketReader.readToEom(br = new BufferedReader(new InputStreamReader(this.sock.getInputStream(), "UTF-8")), 0), this.sock)) {
                    return;
                }
                if (trace.getDebugCode("ls")) {
                    trace.outNT("ls", "AuthorLauncherServer.Session possible Guid: " + result);
                }
                if ((guid = MessageObject.getPropertyFromXML(result, "Guid")) == null || !AuthorLauncherServer.this.tabManager.connectSocket(guid, this.sock, br, AuthorLauncherServer.this.socketArgs)) {
                    AuthorLauncherServer.this.sendDisconnect(this.sock, guid);
                    if (trace.getDebugCode("ls")) {
                        trace.outNT("ls", "AuthorLauncherServer.Session: guid " + guid + ", closing socket");
                    }
                    this.close(br);
                }
            }
            catch (Exception e) {
                trace.errStack("AuthorLauncherServer.Session.run() 1st half error, closing socket: ", e);
                if (trace.getDebugCode("ls")) {
                    trace.outNT("ls", "Exception in session.run : " + e);
                }
                this.close(br);
                return;
            }
        }
    }

    class Listener
    extends Thread
    implements ExitableServer {
        private ServerSocket ss;
        private volatile boolean nowExiting = false;
        private volatile Date shutdownTime = null;

        Listener(int port) {
            this.setName("AuthorLauncherServer.Listener_on_port_" + port);
            try {
                this.ss = new ServerSocket(port);
                if (trace.getDebugCode("ls")) {
                    trace.out("ls", "LauncherServer.Listener(" + port + ") created on local port " + this.ss.getLocalPort());
                }
            }
            catch (Exception e) {
                trace.err("Error opening server socket on port " + port + " in LauncherServer.Listener constructor: " + e + (e.getCause() == null ? "" : ";\n  cause: " + e.getCause()));
                e.printStackTrace();
            }
        }

        @Override
        public void run() {
            if (trace.getDebugCode("ls")) {
                trace.out("ls", "AuthorLauncherServer.Listener waiting on port " + this.ss.getLocalPort());
            }
            try {
                while (!this.nowExiting) {
                    Socket s = this.ss.accept();
                    Connection conn = new Connection(s);
                    if (trace.getDebugCode("ls")) {
                        trace.out("ls", "AuthorLauncherServer.Listener accepted socket " + s);
                    }
                    new Thread(conn).start();
                }
            }
            catch (SocketException se) {
                trace.err("Shutdown Time " + this.shutdownTime + ", nowExiting " + this.nowExiting + "; exception " + se + (se.getCause() == null ? "" : ";\n  cause: " + se.getCause()));
            }
            catch (IOException io) {
                trace.err("Fatal I/O error from LauncherServer top-level thread: exception " + io + (io.getCause() == null ? "" : ";\ncause: " + io.getCause()));
                io.printStackTrace();
            }
        }

        @Override
        public synchronized boolean isExiting() {
            return this.nowExiting;
        }

        @Override
        public boolean startExiting() {
            boolean result = this.nowExiting;
            this.nowExiting = true;
            if (trace.getDebugCode("ls")) {
                trace.out("ls", "LauncherServer.Listener.startExiting() server socket to close " + this.ss);
            }
            try {
                this.ss.close();
                this.ss = null;
            }
            catch (Exception e) {
                trace.errStack("LauncherServer.Listener.startExiting() error closing server socket " + e + ";\n  cause " + e.getCause(), e);
            }
            return result;
        }
    }
}

