/*
 * Decompiled with CFR 0.152.
 */
package pact.CommWidgets;

import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.ctat.MessageObject;
import edu.cmu.pact.ctat.TutorController;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.PopupMenu;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.text.Highlighter;
import pact.CommWidgets.JCommWidget;
import pact.CommWidgets.Scribble;
import pact.CommWidgets.event.StudentActionEvent;

public class JCommDrawingPad
extends JCommWidget
implements FocusListener,
ActionListener {
    protected int DrawingPadWidth = 500;
    protected int DrawingPadHeight = 500;
    protected Frame scribbleFrame = new Frame();
    protected Scribble scribble;
    protected JPanel drawingPanel = new JPanel();
    protected JPanel buttonsPanel = new JPanel();
    protected JScrollPane DrawingPadScrollPane;
    JButton clearButton = new JButton("  Clear  ");
    JButton saveButton = new JButton("  Submit  ");
    protected String previousValue;
    protected String resetValue = "";
    protected Highlighter defaultHighlighter;
    protected short last_x;
    protected short last_y;
    protected Color current_color = Color.black;
    protected int width;
    protected int height;
    protected PopupMenu popup;
    protected Frame frame = new Frame();
    BufferedImage scribbleImage;

    public JCommDrawingPad() {
        this.drawingPanel.setBackground(Color.WHITE);
        this.setLayout(new BorderLayout());
        this.scribble = new Scribble(this.scribbleFrame, this.DrawingPadWidth, this.DrawingPadHeight, this);
        this.drawingPanel.add(this.scribble);
        this.createButtonPanel();
        this.add((Component)this.drawingPanel, "Center");
        this.clearButton.addActionListener(this);
        this.saveButton.addActionListener(this);
        this.actionName = "UpdateDrawingPad";
        this.addFocusListener(this);
    }

    protected void createButtonPanel() {
        if (this.buttonsPanel != null) {
            this.buttonsPanel.removeAll();
        }
        this.buttonsPanel.setLayout(new FlowLayout(2));
        this.add((Component)this.buttonsPanel, "South");
        this.buttonsPanel.add(this.clearButton);
        this.buttonsPanel.add(this.saveButton);
    }

    @Override
    public void doInterfaceAction(String selection, String action, String input) {
        if (action.equalsIgnoreCase("UpdateDrawingPad")) {
            this.setText(input);
            if (this.getController().isStartStateInterface()) {
                this.setFocusable(false);
            }
            return;
        }
        if (action.equalsIgnoreCase("UpdateText")) {
            this.setText(input);
        } else if ("SetVisible".equalsIgnoreCase(action)) {
            if (trace.getDebugCode("inter")) {
                trace.out("inter", "SetVisible: " + input);
            }
            this.scribble.clear();
            this.setVisible(input);
        }
        trace.out("**Error**: don't know interface action " + action);
    }

    @Override
    public MessageObject getDescriptionMessage() {
        MessageObject mo = MessageObject.create("InterfaceDescription");
        mo.setVerb("SendNoteProperty");
        if (!this.initialize(this.getController())) {
            trace.out(5, this, "ERROR!: Can't create Comm message because can't initialize.  Returning empty comm message");
            return null;
        }
        mo.setProperty("WidgetType", "JCommDrawingPad");
        mo.setProperty("CommName", this.commName);
        mo.setProperty("UpdateEachCycle", new Boolean(this.updateEachCycle));
        Vector deftemplates = this.createJessDeftemplates();
        Vector instances = this.createJessInstances();
        if (deftemplates != null) {
            mo.setProperty("jessDeftemplates", deftemplates);
        }
        if (instances != null) {
            mo.setProperty("jessInstances", instances);
        }
        this.serializeGraphicalProperties(mo);
        return mo;
    }

    public Vector createJessDeftemplates() {
        Vector<String> deftemplates = new Vector<String>();
        String deftemplateStr = "(deftemplate DrawingPad (slot name) (slot value))";
        deftemplates.add(deftemplateStr);
        return deftemplates;
    }

    public Vector createJessInstances() {
        Vector<String> instances = new Vector<String>();
        String instanceStr = "(assert (DrawingPad (name " + this.commName + ")))";
        instances.add(instanceStr);
        return instances;
    }

    @Override
    public void doCorrectAction(String selection, String action, String input) {
        if ("SetVisible".equalsIgnoreCase(action)) {
            if (trace.getDebugCode("inter")) {
                trace.out("inter", "SetVisible: " + input);
            }
            this.setVisible(input);
        } else if (this.getController().getUniversalToolProxy().lockWidget()) {
            this.removeHighlight("");
            this.setFocusable(false);
        }
    }

    @Override
    public boolean getLock(String selection) {
        return true;
    }

    @Override
    public void doLISPCheckAction(String selection, String input) {
        this.setFocusable(false);
    }

    @Override
    public void doIncorrectAction(String selection, String input) {
        this.setFocusable(true);
    }

    @Override
    public void highlight(String commComponentName, Border highlightBorder) {
        this.setBorder(highlightBorder);
    }

    @Override
    public void removeHighlight(String subElement) {
        this.setBorder(this.originalBorder);
    }

    @Override
    public void setFocus(String subWidgetName) {
        this.saveButton.requestFocus();
    }

    @Override
    public Object getValue() {
        return "test";
    }

    public String getText() {
        return "test";
    }

    public void setText(String text) {
        this.previousValue = text;
    }

    @Override
    public void setFont(Font f) {
        super.setFont(f);
    }

    @Override
    public boolean isChangedFromResetState() {
        return false;
    }

    public boolean resetStartStateLock(boolean startStateLock) {
        return false;
    }

    @Override
    public void setFocusable(boolean focusFlag) {
        super.setFocusable(focusFlag);
    }

    @Override
    public void reset(TutorController controller) {
        this.initialize(controller);
    }

    public void changedUpdate(DocumentEvent e) {
    }

    public void insertUpdate(DocumentEvent e) {
        this.dirty = true;
    }

    public void removeUpdate(DocumentEvent e) {
        this.dirty = true;
    }

    @Override
    public void setBackground(Color c) {
    }

    @Override
    public void setToolTipText(String text) {
    }

    @Override
    public String getToolTipText() {
        return "test";
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        this.scribble.controller = this.getController();
        if (command.equals(this.clearButton.getText())) {
            this.scribble.clear();
        } else if (command.equals(this.saveButton.getText())) {
            this.scribble.saveImage(this.scribble.getFileSavingDirectory() + "/" + this.scribble.getImageFileName() + ".jpeg");
            this.scribble.clear();
            this.dirty = true;
            this.sendValue();
        } else if (command.equals("Save")) {
            this.scribble.saveImage(null);
            this.dirty = true;
            this.sendValue();
        }
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        graphics.setColor(Color.WHITE);
        graphics.fillRect(0, 0, this.scribble.getHeight(), this.scribble.getWidth());
        graphics.setColor(Color.BLACK);
        graphics.drawRect(0, 0, this.scribble.getHeight(), this.scribble.getWidth());
    }

    public int getDrawingPadWidth() {
        return this.DrawingPadWidth;
    }

    public void setDrawingPadWidth(int drawingPadWidth) {
        this.DrawingPadWidth = drawingPadWidth;
    }

    public int getDrawingPadHeight() {
        return this.DrawingPadHeight;
    }

    public void setDrawingPadHeight(int drawingPadHeight) {
        this.DrawingPadHeight = drawingPadHeight;
    }

    public void studentActionPerformed(StudentActionEvent sae) {
    }

    public Scribble getScribble() {
        return this.scribble;
    }

    public void autoSave() {
        this.scribble.controller = this.getController();
        this.scribble.saveImage(this.scribble.getFileSavingDirectory() + "/" + this.scribble.getImageFileName() + "_A.jpeg");
        this.scribble.clear();
    }

    public String getSavingFolder() {
        String defaultMappingDiskName = "L:";
        String studentFolderName = "CCWTemp";
        String problemFile = "test";
        if (this.getController() != null && this.getController().getLogger() != null) {
            studentFolderName = this.getController().getLogger().getStudentName();
            problemFile = this.getController().getLogger().getProblemName();
        }
        System.out.println("studentFolderName =" + studentFolderName);
        System.out.println("problemFile =" + problemFile);
        String currentDir = defaultMappingDiskName + "/" + studentFolderName;
        boolean success = new File(currentDir).mkdirs();
        if (success) {
            System.out.println("Remote Disk Directories: " + currentDir + " created");
        } else {
            currentDir = System.getProperty("user.dir");
            System.out.println("currentDir =" + currentDir);
            new File(currentDir);
        }
        return currentDir;
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }
}

