/*
 * Decompiled with CFR 0.152.
 */
package org.tiling.scheduling.examples.iterators;

import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import org.tiling.scheduling.ScheduleIterator;

public class RestrictedDailyIterator
implements ScheduleIterator {
    private final int hourOfDay;
    private final int minute;
    private final int second;
    private final int[] days;
    private final Calendar calendar = Calendar.getInstance();

    public RestrictedDailyIterator(int hourOfDay, int minute, int second, int[] days) {
        this(hourOfDay, minute, second, days, new Date());
    }

    public RestrictedDailyIterator(int hourOfDay, int minute, int second, int[] days, Date date) {
        this.hourOfDay = hourOfDay;
        this.minute = minute;
        this.second = second;
        this.days = (int[])days.clone();
        Arrays.sort(this.days);
        this.calendar.setTime(date);
        this.calendar.set(11, hourOfDay);
        this.calendar.set(12, minute);
        this.calendar.set(13, second);
        this.calendar.set(14, 0);
        if (!this.calendar.getTime().before(date)) {
            this.calendar.add(5, -1);
        }
    }

    @Override
    public Date next() {
        do {
            this.calendar.add(5, 1);
        } while (Arrays.binarySearch(this.days, this.calendar.get(7)) < 0);
        return this.calendar.getTime();
    }
}

