/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.jess;

import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ProblemEdge;
import edu.cmu.pact.Preferences.PreferencesModel;
import edu.cmu.pact.Utilities.CTAT_Controller;
import edu.cmu.pact.Utilities.EventLogger;
import edu.cmu.pact.Utilities.TextOutput;
import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.jess.GetCustomFieldsFact;
import edu.cmu.pact.jess.HintFact;
import edu.cmu.pact.jess.JessModelTracing;
import edu.cmu.pact.jess.JessParser;
import edu.cmu.pact.jess.MT;
import edu.cmu.pact.jess.ModelTracingUserfunction;
import edu.cmu.pact.jess.StudentValuesRecorder;
import edu.cmu.pact.jess.UIComponentRecorder;
import edu.cmu.pact.jess.Utils;
import edu.cmu.pact.miss.Sai;
import edu.cmu.pact.miss.console.controller.MissController;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.server.UID;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jess.Activation;
import jess.Context;
import jess.Defquery;
import jess.Defrule;
import jess.Deftemplate;
import jess.Fact;
import jess.FactIDValue;
import jess.HasLHS;
import jess.Jesp;
import jess.JessEvent;
import jess.JessException;
import jess.JessListener;
import jess.PrettyPrinter;
import jess.QueryResult;
import jess.RU;
import jess.Rete;
import jess.Strategy;
import jess.Token;
import jess.Userfunction;
import jess.Value;
import jess.ValueVector;
import jess.Visitable;
import jess.WatchConstants;

public class MTRete
extends Rete
implements Serializable,
JessParser,
WatchConstants,
PropertyChangeListener {
    public static final String USE_STUDENT_VALUES_FACT = "UseStudentValuesFact";
    public static final String DEFAULT_IN_ROUTER = "WSTDIN";
    public static final String DEFAULT_IO_ROUTER = "WSTDOUT";
    public static final String DEFAULT_ERR_ROUTER = "WSTDERR";
    public static final String NOT_SPECIFIED = "NotSpecified";
    public static final String SINGLE_PASS_PREFERENCE = "Single Pass Search";
    private static final Pattern fireableBuggyPrefix = Pattern.compile("^([^:][^:]*::)?[fF][iI][rR][eE]?[aA][bB][lL][eE]-?[bB][uU][gG]([gG][yY]|[^a-zA-Z]).*");
    private static final Pattern buggyPrefix = Pattern.compile("^([^:][^:]*::)?[bB][uU][gG]([gG][yY]|[^a-zA-Z]).*");
    private ArrayList factsList = new ArrayList();
    private ArrayList deftemplateList = new ArrayList();
    private static final String USE_SALIENCE = "Use Salience";
    static final String TREE_DEPTH = "Tree Depth";
    static final String SAINAME = "special-tutor-fact";
    static final String CORRECTSAINAME = "special-tutor-fact-correct";
    static final String BUGGYSAINAME = "special-tutor-fact-buggy";
    static final String OLDSAINAME = "selection-action-input";
    static final String SPECIALWME = "special-wme";
    static final String NOT_ON_AGENDA = "not on agenda";
    static final String ACTIVATION_INACTIVE = "inactive";
    static final String ACTIVATION_ACTIVE = "active";
    static boolean displayChain = true;
    static boolean displayFired = false;
    static boolean instantiations = false;
    static boolean breakOnExceptions = true;
    public static final String DONT_CARE = "DONT-CARE";
    private ArrayList firedRuleList = new ArrayList();
    private transient UIComponentRecorder uiComponentRecorder = null;
    private transient Fact studentValuesFact = null;
    public static boolean doLog = true;
    static int DEFAULT_MAX_DEPTH = 5;
    private int maxDepth = DEFAULT_MAX_DEPTH;
    boolean useBackwardChaining = false;
    private transient int watchMask = 0;
    static boolean stopModelTracing = false;
    public static boolean useSalience = true;
    private static final String[] cacheKeys = new String[]{"special-tutor-fact-correct", "special-tutor-fact-buggy", "special-tutor-fact", "selection-action-input", "special-wme"};
    private static final int factCount = cacheKeys.length;
    private static final int EVENT_MASK = -2147477488;
    private static final String DEFAULT_STRATEGY_NAME = new Rete().getStrategy().getName();
    private static final int watchAllMask = 31;
    private static List watchOptions = null;
    private transient int reteChangeCount = 0;
    private transient int rulesFiredCount = 0;
    private transient TextOutput textOutput = TextOutput.getNullOutput();
    protected transient JessModelTracing jmt = null;
    private transient MT mt = null;
    private String lastAuthorChosenStrategyName = "buggy-rules-later";
    private Boolean psAccess = null;
    private transient EventLogger eventLogger;
    private HashMap saveStates = new HashMap();
    private boolean prunePriorActivations = false;
    private Boolean useStudentValuesFact = null;
    private String[] uiComponentMessageTypes = new String[0];
    private transient StudentValuesRecorder studentValuesRecorder = null;
    private static final Pattern spacePattern = Pattern.compile("\\p{Space}");
    private static boolean useInterfaceTemplates = true;
    private static boolean loadInterfacetemplatesFailed = false;

    void setActivationToFire(Activation act) {
        Strategy s = this.getStrategy();
        if (!(s instanceof BuggyRulesNormalSalienceStrategy)) {
            return;
        }
        ((BuggyRulesNormalSalienceStrategy)s).setActToFire(act, this);
        try {
            this.setStrategy(s);
            if (trace.getDebugCode("mt")) {
                trace.out("mt", "setActivationToFire() a[" + MTRete.getActivationIndex(act, this) + "]: " + act);
            }
        }
        catch (JessException je) {
            je.printStackTrace();
        }
    }

    public void watchAll() {
        super.watchAll();
        this.watchMask |= 0x1F;
    }

    public void unwatchAll() {
        super.unwatchAll();
        this.watchMask &= 0xFFFFFFE0;
    }

    public void watch(int which) throws JessException {
        super.watch(which);
        if (which < 0 || 32 <= which) {
            return;
        }
        this.watchMask |= 1 << which;
    }

    public void unwatch(int which) throws JessException {
        super.unwatch(which);
        if (which < 0 || 32 <= which) {
            return;
        }
        this.watchMask &= ~(1 << which);
    }

    public int getWatchMask() {
        return this.watchMask;
    }

    public MTRete() {
        this(null, null, null);
    }

    public MTRete(CTAT_Controller controller) {
        this(controller.getEventLogger(), controller.getPreferencesModel(), controller);
    }

    public MTRete(EventLogger eventLogger, PreferencesModel pm) {
        this(eventLogger, pm, null);
    }

    private MTRete(EventLogger eventLogger, PreferencesModel pm, CTAT_Controller controller) {
        if (trace.getDebugCode("mt")) {
            trace.out("mt", "entered MTRete's constructor");
        }
        if (controller != null) {
            this.setApplet(controller.getApplet());
        }
        this.setUpListener();
        this.init(eventLogger, pm);
        new BuggyRulesLaterStrategy().install(this);
        if (trace.getDebugCode("mt")) {
            trace.out("mt", "no-arg constructor");
        }
    }

    public EventLogger getEventLogger() {
        return this.eventLogger;
    }

    void showActivations(String label) {
        if (!trace.getDebugCode("mt")) {
            return;
        }
        int nActs = 0;
        int nFacts = 0;
        int nRules = 0;
        int nTemplates = 0;
        Iterator it = this.listActivations();
        while (it.hasNext()) {
            it.next();
            ++nActs;
        }
        it = this.listFacts();
        while (it.hasNext()) {
            it.next();
            ++nFacts;
        }
        it = this.listDefrules();
        while (it.hasNext()) {
            it.next();
            ++nRules;
        }
        it = this.listDeftemplates();
        while (it.hasNext()) {
            it.next();
            ++nTemplates;
        }
        if (trace.getDebugCode("mt")) {
            trace.out("mt", label + " nActs=" + nActs + " nFacts=" + nFacts + " nRules=" + nRules + " nTemplates=" + nTemplates + " " + trace.nh(this));
        }
    }

    void setUpListener() {
        if (trace.getDebugCode("mt")) {
            trace.out("mt", "entered setUpListener()");
        }
        this.registerWatchOptions();
        new ReteChangedListener();
    }

    static void setWatchOptions(List watchOptions) {
        MTRete.watchOptions = watchOptions;
    }

    private void registerWatchOptions() {
        if (watchOptions == null) {
            this.unwatchAll();
        } else if (watchOptions.isEmpty()) {
            this.watchAll();
        } else {
            for (Object watchOption : watchOptions) {
                try {
                    if (watchOption instanceof Integer) {
                        int watchInt = (Integer)watchOption;
                        this.watch(watchInt);
                        continue;
                    }
                    if (!(watchOption instanceof String)) continue;
                    Userfunction watchFn = this.findUserfunction("watch");
                    ValueVector vv = new ValueVector(2);
                    vv.add("watch");
                    vv.add((String)watchOption);
                    watchFn.call(vv, this.getGlobalContext());
                }
                catch (Exception e) {
                    trace.err("error setting watchOption " + watchOption + ": " + e);
                }
            }
        }
    }

    private void init(EventLogger eventLogger, PreferencesModel pm) {
        this.eventLogger = eventLogger == null ? new EventLogger(null) : eventLogger;
        if (pm == null) {
            return;
        }
        pm.addPropertyChangeListener(TREE_DEPTH, this);
        pm.addPropertyChangeListener(USE_SALIENCE, this);
        this.getPreferencesFromModel(pm);
    }

    void removeListeners(PreferencesModel pm) {
        if (pm == null) {
            return;
        }
        pm.removePropertyChangeListener(TREE_DEPTH, this);
        pm.removePropertyChangeListener(USE_SALIENCE, this);
    }

    private void getPreferencesFromModel(PreferencesModel model) {
        Boolean booleanValue;
        Integer integerValue = model.getIntegerValue(TREE_DEPTH);
        if (integerValue != null) {
            this.setMaxDepth(integerValue);
        }
        if ((booleanValue = model.getBooleanValue(USE_SALIENCE)) != null) {
            useSalience = booleanValue;
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent arg0) {
        String name = arg0.getPropertyName();
        Object newValue = arg0.getNewValue();
        if (trace.getDebugCode("mps")) {
            trace.out("mps", "Changed " + name + " from " + arg0.getOldValue() + " to " + newValue);
        }
        if (name.equals(TREE_DEPTH)) {
            this.setMaxDepth((Integer)newValue);
        }
        if (name.equals(USE_SALIENCE)) {
            useSalience = (Boolean)newValue;
        }
    }

    public void setTextOutput(TextOutput textOutput) {
        this.textOutput = textOutput;
    }

    public TextOutput getTextOutput() {
        return this.textOutput;
    }

    public void updateChunkValues(String selection, String input) {
    }

    public JessModelTracing getJmt() {
        return this.jmt;
    }

    protected void setJmt(JessModelTracing jmt) {
        this.jmt = jmt;
    }

    public String getLastAuthorChosenStrategyName() {
        return this.lastAuthorChosenStrategyName;
    }

    public String setLastAuthorChosenStrategyName(String strategyName) {
        String result = this.lastAuthorChosenStrategyName;
        this.lastAuthorChosenStrategyName = strategyName;
        return result;
    }

    public Fact modify(Fact arg0, String arg1, Value arg2) throws JessException {
        super.modify(arg0, arg1, arg2);
        return arg0;
    }

    public synchronized void clear() throws JessException {
        super.clear();
        this.uiComponentRecorder = null;
        this.setStrategyByName(this.getLastAuthorChosenStrategyName());
    }

    public boolean setStrategyByName(String strategyName) throws JessException {
        BuggyRulesNormalSalienceStrategy strategyResult;
        boolean result = true;
        if ("buggy-rules-later".equalsIgnoreCase(strategyName)) {
            strategyResult = new BuggyRulesLaterStrategy();
            strategyResult.install(this);
        } else if ("buggy-rules-normal-salience".equalsIgnoreCase(strategyName)) {
            strategyResult = new BuggyRulesNormalSalienceStrategy();
            ((BuggyRulesNormalSalienceStrategy)strategyResult).install(this);
        } else if ("".equals(strategyName) || strategyName == null || DEFAULT_STRATEGY_NAME.equalsIgnoreCase(strategyName)) {
            strategyResult = new Rete().getStrategy();
            this.setStrategy(strategyResult);
        } else {
            trace.err("MTRete.setStrategyByName() unknown strategy name argument " + strategyName);
            strategyResult = null;
            result = false;
        }
        if (trace.getDebugCode("mt")) {
            trace.out("mt", "MTRete.setStrategyByName(" + strategyName + ") returns " + result + "; new strategy name " + (strategyResult == null ? null : strategyResult.getName()));
        }
        return result;
    }

    public void bload(InputStream is) throws IOException, ClassNotFoundException {
        if (trace.getDebugCode("mtt")) {
            trace.out("mtt", "MTRete.bload(" + is + ") before super.bload(is)");
        }
        EventLogger eventLogger = this.eventLogger;
        JessModelTracing jmt = this.jmt;
        MT mt = this.mt;
        super.bload(is);
        this.mt = mt;
        this.jmt = jmt;
        this.eventLogger = eventLogger;
        if (trace.getDebugCode("mtt")) {
            trace.out("mtt", "MTRete.bload(" + is + ") before after.bload(is)");
        }
        this.setUpListener();
    }

    public void bsave(OutputStream os) throws IOException {
        this.dumpAgenda("!!before Rete.bsave()");
        super.bsave(os);
        this.dumpAgenda("!!after Rete.bsave()");
    }

    public static int getActivationIndex(Activation act, Rete rete) {
        if (act == null) {
            return -2;
        }
        int result = 0;
        Iterator it = rete.listActivations();
        while (it.hasNext()) {
            if (act.equals(it.next())) {
                return result;
            }
            ++result;
        }
        return -1;
    }

    public void dumpAgenda(String label) {
        this.dumpAgenda("mt", label, false);
        this.dumpAgenda("agenda", label, true);
    }

    public void dumpAgenda(String debugCode, String label, boolean verbose) {
        if (debugCode == null) {
            return;
        }
        boolean err = "err".equals(debugCode);
        if (!err && !trace.getDebugCode(debugCode)) {
            return;
        }
        StringBuffer sb = new StringBuffer(label == null ? "dumpAgenda()" : label);
        sb.append(":");
        Iterator it = this.listActivations();
        int i = 0;
        while (it.hasNext()) {
            Activation a = (Activation)it.next();
            sb.append("\n ");
            if (i < 10) {
                sb.append(" ");
            }
            sb.append(i).append(".");
            sb.append(a.isInactive() ? "IN " : "AC ");
            if (!verbose) {
                sb.append(a.toString());
            } else {
                sb.append('[').append(a.getRule() == null ? "(null rule)" : a.getRule().getName());
                sb.append(' ').append(a.getToken() == null ? "(null token)" : a.getToken().toString());
                sb.append("; salience ").append(a.getSalience()).append(']');
            }
            ++i;
        }
        sb.append(" <").append(this.getClass().getName()).append(".dumpAgenda>");
        if (err) {
            trace.err(sb.toString());
        } else {
            trace.out(debugCode, sb.toString());
        }
    }

    String findActivation(Activation a) {
        if (a == null) {
            return NOT_ON_AGENDA;
        }
        Iterator it = this.listActivations();
        while (it.hasNext()) {
            Activation aa = (Activation)it.next();
            if (!this.activationsEqual(a, aa)) continue;
            if (aa.isInactive()) {
                return ACTIVATION_INACTIVE;
            }
            return ACTIVATION_ACTIVE;
        }
        return NOT_ON_AGENDA;
    }

    public List getAgendaAsList(Activation stopAct) {
        ArrayList<Activation> result = new ArrayList<Activation>();
        int i = 0;
        Iterator it = this.listActivations();
        while (it.hasNext()) {
            Activation act = (Activation)it.next();
            if (trace.getDebugCode("mt")) {
                trace.out("mt", "agenda[" + i + "]= " + (act.isInactive() ? "IN " : "AC ") + act);
            }
            if (stopAct != null && stopAct == act) break;
            result.add(act);
            ++i;
        }
        return result;
    }

    private boolean activationsEqual(Activation a1, Activation a2) {
        if (a1 == null) {
            return a2 == null;
        }
        if (a2 == null) {
            return false;
        }
        String name1 = a1.getRule().getName();
        String name2 = a2.getRule().getName();
        boolean tokensEq = a1.getToken().dataEquals(a2.getToken());
        if (trace.getDebugCode("mt")) {
            trace.out("mt", "activationsEqual()" + name1 + "?=" + name2 + " && tokensEq" + tokensEq);
        }
        return name1.equals(name2) && tokensEq;
    }

    public void removeAllRules() throws JessException {
        Iterator it = this.listDefrules();
        ArrayList<String> ruleNames = new ArrayList<String>();
        while (it.hasNext()) {
            Object obj = it.next();
            if (!obj.getClass().getName().equalsIgnoreCase("jess.defrule")) continue;
            ruleNames.add(((Defrule)obj).getName());
        }
        it = ruleNames.iterator();
        while (it.hasNext()) {
            this.unDefrule((String)it.next());
        }
        ruleNames.removeAll(ruleNames);
        ruleNames = null;
    }

    public ArrayList getFacts() {
        ArrayList facts = new ArrayList();
        Iterator it = this.listFacts();
        while (it.hasNext()) {
            facts.add(it.next());
        }
        return facts;
    }

    public String[] getUIComponentMessageTypes() {
        return this.uiComponentMessageTypes;
    }

    public void setUIComponentMessageTypes(String[] uiComponentMessageTypes) {
        this.uiComponentMessageTypes = uiComponentMessageTypes == null ? new String[]{} : uiComponentMessageTypes;
    }

    void clearState() {
        this.saveStates.clear();
    }

    Routers saveState(ByteArrayOutputStream baos) throws IOException {
        Routers routers = new Routers(this);
        this.bsave(baos);
        return routers;
    }

    void loadState(ByteArrayInputStream bais, Routers routers) throws IOException, ClassNotFoundException {
        this.bload(bais);
        if (routers != null) {
            routers.setRouters(this);
        }
    }

    void saveState(String filename) {
        File file = null;
        try {
            file = edu.cmu.pact.Utilities.Utils.getFileAsResource(filename, this);
            if (file != null) {
                if (trace.getDebugCode("mt")) {
                    trace.out("mt", "saving state to " + file.getAbsolutePath());
                }
            } else {
                return;
            }
            BufferedOutputStream binOutStrm = new BufferedOutputStream(new FileOutputStream(file));
            this.bsave(binOutStrm);
            ((OutputStream)binOutStrm).close();
        }
        catch (Exception e) {
            if (trace.getDebugCode("mt")) {
                trace.out("mt", "Error saving binary state: " + e);
            }
            try {
                file.delete();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    void saveState(String dirName, String fileName) {
        this.saveState(dirName, fileName, this.saveStates);
    }

    void saveState(String dirName, String fileName, Map statesMap) {
        try {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            this.bsave(stream);
            byte[] buffer = stream.toByteArray();
            statesMap.put(dirName + fileName, buffer);
            if (trace.getDebugCode("mt")) {
                trace.out("mt", "saved state to " + dirName + fileName + "; size=" + buffer.length);
            }
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
    }

    void loadState(String dirName, String fileName) {
        this.loadState(dirName, fileName, this.saveStates);
    }

    void loadState(String dirName, String fileName, Map statesMap) {
        try {
            this.bload(new ByteArrayInputStream((byte[])statesMap.get(dirName + fileName)));
            if (trace.getDebugCode("mt")) {
                trace.out("mt", "loaded state from " + dirName + fileName);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private int loadInterfaceTemplates(List interfaceTemplatesList) {
        int count = 0;
        if (interfaceTemplatesList == null) {
            trace.err("MT.loadInterfaceTemplates(): interfaceTemplatesList is null");
            return 0;
        }
        for (String deftemplateCmd : interfaceTemplatesList) {
            try {
                if (count < 1 && this.textOutput != null) {
                    this.textOutput.append("\nLoading deftemplates from interface definitions.");
                }
                Value val = this.eval(deftemplateCmd);
                if (trace.getDebugCode("mt")) {
                    trace.out("mt", "rete " + this.hashCode() + " deftemplate, result " + val + ", type " + RU.getTypeName((int)val.type()) + ":\n" + deftemplateCmd);
                }
            }
            catch (JessException e1) {
                String errMsg = "Error executing deftemplate command " + (count + 1) + ":\n  " + deftemplateCmd + ":\n  " + (Object)((Object)e1) + (e1.getCause() == null ? "" : ";\n  " + e1.getCause().toString());
                trace.err(errMsg);
                e1.printStackTrace();
                this.textOutput.append("\n" + errMsg + "\n");
            }
            ++count;
        }
        return count;
    }

    public Boolean updateUIComponent(String messageType, Vector selection, Vector action, Vector input) {
        if (this.uiComponentRecorder == null) {
            this.uiComponentRecorder = new UIComponentRecorder(this, this.uiComponentMessageTypes);
        }
        return this.uiComponentRecorder.update(messageType, selection, action, input);
    }

    boolean[] loadJessFiles(String bloadName, String templatesName, String rulesName, String problemFactsName, List interfaceTemplatesList) throws JessException {
        boolean popupError;
        this.resetLoadInterfacetemplatesFailed();
        HintFact.setHintFact(false, this);
        String[] filenames = new String[]{bloadName, templatesName, rulesName, problemFactsName};
        boolean templateFileIndex = true;
        int rulesFileIndex = 2;
        int factsFileIndex = 3;
        Object[] files = this.findFiles(filenames);
        File bloadFile = null;
        boolean[] results = new boolean[files.length];
        boolean doBload = false;
        if (files[0] instanceof File && ((File)files[0]).exists()) {
            bloadFile = (File)files[0];
            long bloadTime = bloadFile.lastModified();
            doBload = true;
            for (int i = 1; doBload && i < files.length; ++i) {
                if (!(files[i] instanceof File)) {
                    doBload = false;
                    continue;
                }
                File fi = (File)files[i];
                if (!fi.exists() || bloadTime <= fi.lastModified()) {
                    doBload = false;
                }
                if (!trace.getDebugCode("mt")) continue;
                trace.out("mt", "doBload " + doBload + ", files[" + i + "] " + fi + ", exists " + fi.exists());
            }
        }
        if (doBload) {
            try {
                BufferedInputStream in = new BufferedInputStream(new FileInputStream(bloadFile));
                String fileLoadMsg = "\nLoading saved start state from binary file " + bloadFile.getAbsolutePath();
                if (trace.getDebugCode("mt")) {
                    trace.out("mt", fileLoadMsg);
                }
                this.textOutput.append(fileLoadMsg);
                this.bload(in);
                in.close();
                results[0] = true;
                this.textOutput.append("\n");
                return results;
            }
            catch (Exception e) {
                trace.err("Error trying to load file " + bloadFile.getAbsolutePath() + ": " + e);
                this.clear();
            }
        }
        if (bloadFile != null && bloadFile.exists()) {
            bloadFile.delete();
        }
        CTAT_Controller ctlr = this.getMT() != null ? this.getMT().getController() : null;
        boolean bl = popupError = ctlr == null || !edu.cmu.pact.Utilities.Utils.isRuntime() && ctlr.getMissController() instanceof MissController && !ctlr.getMissController().isPLEon();
        if (trace.getDebugCode("mt")) {
            trace.outNT("mt", "MTRete.loadJessFiles() popupError " + popupError + ": ctlr " + ctlr + ", Utils.isRuntime() " + edu.cmu.pact.Utilities.Utils.isRuntime() + ", ctlr.getMissController() " + (ctlr == null ? null : ctlr.getMissController()));
        }
        Object errorMessage = null;
        for (int i = 1; i < files.length; ++i) {
            Object rdr = null;
            Object resource = null;
            results[i] = this.parse(files[i], i == 2, popupError, i == 3);
            if (results[i] || i >= 2) continue;
            if (useInterfaceTemplates) {
                this.loadInterfaceTemplates(interfaceTemplatesList);
            } else {
                this.setLoadInterfacetemplatesFailed(true);
            }
            if (this.findDeftemplate("problem") != null) continue;
            String deftemplateStr = "(deftemplate problem (slot name) (multislot interface-elements) (multislot subgoals) (slot done) (slot description))";
            this.eval(deftemplateStr);
        }
        this.textOutput.append("\n");
        return results;
    }

    public static void setUseInterfaceTemplates(boolean b) {
        useInterfaceTemplates = b;
    }

    public static boolean getUseInterfaceTemplates() {
        return useInterfaceTemplates;
    }

    private void setLoadInterfacetemplatesFailed(boolean b) {
        loadInterfacetemplatesFailed = b;
    }

    private void resetLoadInterfacetemplatesFailed() {
        loadInterfacetemplatesFailed = false;
    }

    public static boolean loadInterfacetemplatesFailed() {
        return loadInterfacetemplatesFailed;
    }

    public boolean useProblemSummary(Boolean enable) {
        boolean result = this.getUseProblemSummary();
        this.psAccess = enable;
        return result;
    }

    public boolean getUseProblemSummary() {
        return this.psAccess != null && this.psAccess != false;
    }

    private Object[] findFiles(String[] filenames) {
        Object[] results = new Object[filenames.length];
        for (int i = 0; i < filenames.length; ++i) {
            File f = null;
            if (filenames[i] != null && filenames[i].length() > 0) {
                f = new File(filenames[i]);
            }
            if (f != null && f.exists()) {
                results[i] = f;
                if (!trace.getDebugCode("mt")) continue;
                trace.out("mt", "filenames[" + i + "]=" + filenames[i] + " is absolute file " + f.getAbsolutePath());
                continue;
            }
            URL url = this.tryToReadURL(filenames[i]);
            if (url != null) {
                results[i] = url;
                if (!trace.getDebugCode("mt")) continue;
                trace.out("mt", "filenames[" + i + "]=" + filenames[i] + ": URL " + url);
                continue;
            }
            f = edu.cmu.pact.Utilities.Utils.getFileAsResource(filenames[i], this);
            if (f != null && f.exists()) {
                results[i] = f;
                if (!trace.getDebugCode("mt")) continue;
                trace.out("mt", "filenames[" + i + "]=" + filenames[i] + " is relative: absolute is " + f.getAbsolutePath());
                continue;
            }
            url = this.tryToReadURL(edu.cmu.pact.Utilities.Utils.getURL(filenames[i], this));
            if (url == null) continue;
            results[i] = url;
            if (!trace.getDebugCode("mt")) continue;
            trace.out("mt", "filenames[" + i + "]=" + filenames[i] + ": classpath URL " + url);
        }
        return results;
    }

    private URL tryToReadURL(String path) {
        try {
            return this.tryToReadURL(new URL(path));
        }
        catch (MalformedURLException mue) {
            if (trace.getDebugCode("mt")) {
                trace.outNT("mt", "MTRete.tryToRead() error converting \"" + path + "\" to URL: " + mue);
            }
            return null;
        }
    }

    private URL tryToReadURL(URL url) {
        String err = "";
        if (url != null) {
            try {
                InputStream is = url.openStream();
                is.close();
                return url;
            }
            catch (Exception e) {
                err = e.toString();
            }
        }
        if (trace.getDebugCode("mt")) {
            trace.outNT("mt", "MTRete.tryToReadURL() error opening \"" + url + "\" as URL: " + err);
        }
        return null;
    }

    @Override
    public Value parse(Reader rdr) throws JessException {
        return this.parse(rdr, false);
    }

    private Reader openJessFile(Object file, String[] fullPath, boolean popupError, boolean fileNotFoundOk) {
        InputStreamReader rdr;
        block10: {
            rdr = null;
            try {
                if (file instanceof File) {
                    File f = (File)file;
                    if (fullPath != null) {
                        fullPath[0] = f.getCanonicalPath();
                    }
                    rdr = new FileReader(f);
                    break block10;
                }
                if (file instanceof URL) {
                    URL url = (URL)file;
                    if (fullPath != null) {
                        fullPath[0] = url.toString();
                    }
                    rdr = new InputStreamReader(url.openStream());
                    break block10;
                }
                return null;
            }
            catch (Exception e) {
                String errorMessage = "Error reading file " + fullPath + ":\n  " + e;
                if (trace.getDebugCode("mt")) {
                    trace.errStack(errorMessage, e);
                } else {
                    trace.err(errorMessage);
                }
                if (fileNotFoundOk && e instanceof FileNotFoundException) {
                    return null;
                }
                this.textOutput.append("\n" + errorMessage);
                if (popupError) {
                    edu.cmu.pact.Utilities.Utils.showExceptionOccuredDialog(e, errorMessage, "Jess File Evaluation Error");
                }
                this.getEventLogger().log(true, "BEHAVIOR_RECORDER", "JESS_FILE_EVALUATION_ERROR", errorMessage, "", "");
                return null;
            }
        }
        return rdr;
    }

    private boolean parse(Object file, boolean removeBuggyRules, boolean popupError) {
        return this.parse(file, removeBuggyRules, popupError, false);
    }

    private boolean parse(Object file, boolean removeBuggyRules, boolean popupError, boolean fileNotFoundOk) {
        if (file == null) {
            return false;
        }
        String[] fullPath = new String[1];
        Reader rdr = this.openJessFile(file, fullPath, popupError, fileNotFoundOk);
        if (rdr == null) {
            return false;
        }
        return this.parse(rdr, fullPath[0], removeBuggyRules, popupError);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean parse(Reader rdr, String fullPath, boolean removeBuggyRules, boolean popupError) {
        try {
            String fileParseMsg = "\nReading " + edu.cmu.pact.Utilities.Utils.getBaseName(fullPath, false) + " (" + fullPath + ")";
            if (trace.getDebugCode("mt")) {
                trace.out("mt", fileParseMsg);
            }
            this.textOutput.append(fileParseMsg);
            Value lastV = this.parse(rdr, removeBuggyRules);
            boolean bl = true;
            return bl;
        }
        catch (JessException je) {
            je.printStackTrace();
            String errorMessage = "Error parsing file " + fullPath + " at line " + je.getLineNumber() + ":\n" + (je.getDetail() == null ? "" : je.getDetail() + ". ") + (je.getData() == null ? "" : je.getData());
            if (trace.getDebugCode("mt")) {
                trace.out("mt", errorMessage);
            }
            this.textOutput.append("\nError parsing file " + fullPath + ":\n  " + (Object)((Object)je) + "\n");
            if (popupError) {
                edu.cmu.pact.Utilities.Utils.showExceptionOccuredDialog((Exception)((Object)je), errorMessage, "Jess File Evaluation Error");
            }
            this.getEventLogger().log(true, "BEHAVIOR_RECORDER", "JESS_FILE_EVALUATION_ERROR", errorMessage, "", "");
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            String errorMessage = "Error parsing file " + fullPath + ":\n  " + e;
            if (trace.getDebugCode("mt")) {
                trace.out("mt", errorMessage);
            }
            this.textOutput.append("\n" + errorMessage);
            if (popupError) {
                edu.cmu.pact.Utilities.Utils.showExceptionOccuredDialog(e, errorMessage, "Jess File Evaluation Error");
            }
            this.getEventLogger().log(true, "BEHAVIOR_RECORDER", "JESS_FILE_EVALUATION_ERROR", errorMessage, "", "");
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (rdr != null) {
                    rdr.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public Value parse(Reader rdr, boolean removeBuggyRules) throws JessException {
        UID uid = new UID();
        if (!(rdr instanceof BufferedReader) && !(rdr instanceof StringReader)) {
            rdr = new BufferedReader(rdr);
        }
        Jesp jesp = new Jesp(rdr, (Rete)this);
        Value result = jesp.parse(false, this.getGlobalContext());
        if (removeBuggyRules) {
            this.unloadBuggyRules();
        }
        return result;
    }

    boolean reloadProductionRulesFile(String filename, boolean popupError) {
        if (this.getFacts().size() < 2) {
            return false;
        }
        String[] productionRulesFile = new String[]{filename};
        Object[] file = this.findFiles(productionRulesFile);
        if (file[0] != null) {
            boolean result = this.parse(file[0], true, popupError);
            this.deleteBload();
            if (this.textOutput != null) {
                this.textOutput.append("\n");
            }
            return result;
        }
        String errorMessage = "Could not read production rules file \"" + filename + "\"";
        this.textOutput.append("\n" + errorMessage + "\n");
        if (popupError) {
            edu.cmu.pact.Utilities.Utils.showExceptionOccuredDialog(null, errorMessage, "Load Production Rules file Error");
        }
        return false;
    }

    public boolean reloadProductionRulesFile(File prFile, boolean popupError) {
        boolean result = this.parse(prFile, false, popupError);
        this.deleteBload();
        if (this.textOutput != null) {
            this.textOutput.append("\n");
        }
        return result;
    }

    void deleteBload() {
        if (this.mt == null) {
            return;
        }
        try {
            File bf = new File(this.mt.findCognitiveModelDirectory() + this.mt.getProblemName() + ".bload");
            if (bf.exists()) {
                bf.delete();
            }
        }
        catch (Exception e) {
            trace.err("error deleting bload file on reload production rules: " + e);
        }
    }

    public Iterator<Defrule> allRulesIterator() {
        return this.allRulesMap().values().iterator();
    }

    public Map<String, Defrule> allRulesMap() {
        HashMap<String, Defrule> result = new HashMap<String, Defrule>();
        Iterator it = this.listDefrules();
        while (it.hasNext()) {
            Object obj = it.next();
            if (!(obj instanceof Defrule)) continue;
            Defrule rule = (Defrule)obj;
            result.put(rule.getName(), rule);
        }
        return result;
    }

    int loadBuggyRules(TextOutput ta) throws Exception {
        int count = 0;
        return count;
    }

    static boolean isCorrectRule(Defrule rule) {
        if (rule == null) {
            return false;
        }
        return MTRete.isCorrectRuleName(rule.getName());
    }

    static boolean isCorrectRuleName(String ruleName) {
        if (ruleName == null) {
            return false;
        }
        return !MTRete.isFireableBuggyRuleName(ruleName) && !MTRete.isBuggyRuleName(ruleName);
    }

    static boolean isBuggyRule(Defrule rule) {
        if (rule == null) {
            return false;
        }
        return MTRete.isBuggyRuleName(rule.getName());
    }

    static boolean isBuggyRuleName(String ruleName) {
        if (ruleName == null) {
            return false;
        }
        Matcher m = buggyPrefix.matcher(ruleName);
        return m.matches();
    }

    static boolean isFireableBuggyRule(Defrule rule) {
        if (rule == null) {
            return false;
        }
        return MTRete.isFireableBuggyRuleName(rule.getName());
    }

    static boolean isFireableBuggyRuleName(String ruleName) {
        if (ruleName == null) {
            return false;
        }
        Matcher m = fireableBuggyPrefix.matcher(ruleName);
        return m.matches();
    }

    void unloadBuggyRules() {
        if (trace.getDebugCode("mt")) {
            trace.out("mt", "unloadBuggyRules(): singlePassTrace " + this.useSinglePassTrace());
        }
        if (this.useSinglePassTrace()) {
            return;
        }
    }

    public boolean useSinglePassTrace() {
        return true;
    }

    public void addDeftemplates(ArrayList deftemplates) throws JessException {
        int size = deftemplates.size();
        for (int i = 0; i < size; ++i) {
            this.addDeftemplate((Deftemplate)deftemplates.get(i));
        }
    }

    int getReteChangeCount() {
        return this.reteChangeCount;
    }

    public int run(int maxRules) throws JessException {
        this.reteChangeCount = 0;
        this.rulesFiredCount = 0;
        try {
            return super.run(maxRules);
        }
        catch (HaltReteException hre) {
            if (trace.getDebugCode("mt")) {
                trace.out("mt", hre.toString());
            }
            return this.rulesFiredCount;
        }
    }

    void haltRete(String routine) throws JessException {
        throw new HaltReteException(routine, "change count " + this.getReteChangeCount());
    }

    public ArrayList getWMEEditorDeftemplateList() {
        return this.deftemplateList;
    }

    public ArrayList getWMEEditorFactsList() {
        return this.factsList;
    }

    public void setWMEEditorDeftemplateList(ArrayList deftemplateList) {
        this.deftemplateList = deftemplateList;
    }

    public String getDeftemplateString(Deftemplate dt) {
        String deftemplateString = "\n(deftemplate";
        deftemplateString = deftemplateString + " " + dt.getBaseName() + " ";
        if (dt.getParent() != null && dt.getParent().getBaseName().charAt(0) != '_') {
            deftemplateString = deftemplateString + "extends " + dt.getParent().getBaseName() + " ";
        }
        for (int i = 0; i < dt.getNSlots(); ++i) {
            try {
                String typeStr = RU.getTypeName((int)dt.getSlotType(i));
                typeStr = typeStr.toLowerCase();
                deftemplateString = deftemplateString + " (" + typeStr + " " + dt.getSlotName(i);
                if (!typeStr.equalsIgnoreCase("multislot")) {
                    deftemplateString = deftemplateString + " (default " + dt.getSlotDefault(i) + ")";
                    String dataType = RU.getTypeName((int)dt.getSlotDataType(i));
                    if (dataType != null && !dataType.equalsIgnoreCase("null")) {
                        deftemplateString = deftemplateString + " (type " + dataType + "))";
                        continue;
                    }
                    deftemplateString = deftemplateString + ")";
                    continue;
                }
                deftemplateString = deftemplateString + ")";
                continue;
            }
            catch (JessException e) {
                e.printStackTrace();
                return "";
            }
        }
        deftemplateString = deftemplateString + ")";
        return deftemplateString;
    }

    public void addWMEEditorFact(Fact fact) {
        Integer id;
        Fact f;
        HashMap<Integer, Fact> map = new HashMap<Integer, Fact>();
        for (int i = 0; i < this.factsList.size(); ++i) {
            f = (Fact)this.factsList.get(i);
            id = new Integer(f.getFactId());
            map.put(id, f);
        }
        this.factsList.add(MTRete.cloneFact(fact, map));
        map.clear();
        map = null;
        f = null;
        id = null;
    }

    public void removeWMEEditorFact(Fact fact) {
        this.factsList.remove(fact);
    }

    public void addWMEEditorDeftemplate(Deftemplate dt) {
        this.deftemplateList.add(dt);
    }

    public void removeWMEEditorDeftemplate(Deftemplate dt) {
        this.deftemplateList.remove(dt);
    }

    static boolean isSAIUnspecified(List sai) {
        if (sai == null || sai.size() < 3) {
            return false;
        }
        return MTRete.isSAIUnspecified((String)sai.get(0), (String)sai.get(1), (String)sai.get(2));
    }

    static boolean isSAIUnspecified(String selection, String action, String input) {
        return NOT_SPECIFIED.equals(selection) && NOT_SPECIFIED.equals(action) && NOT_SPECIFIED.equals(input);
    }

    protected void aboutToFire(Activation act) {
        this.firedRuleList.add(act.getRule().getName());
    }

    public void clearFiredRuleList() {
        this.firedRuleList.removeAll(this.firedRuleList);
    }

    public ArrayList getFiredRuleList() {
        return this.firedRuleList;
    }

    static Fact cloneFact(Fact fact, Map map) {
        fact = (Fact)fact.clone();
        Deftemplate dt = fact.getDeftemplate();
        int nSlots = dt.getNSlots();
        for (int j = 0; j < nSlots; ++j) {
            try {
                Value v = fact.getSlotValue(dt.getSlotName(j));
                if (v.type() != 16) continue;
                Fact slotFact = v.factValue(null);
                Integer i2 = new Integer(slotFact.getFactId());
                if (map.get(i2) == null) {
                    map.put(i2, MTRete.cloneFact(slotFact, map));
                }
                fact.setSlotValue(dt.getSlotName(j), (Value)new FactIDValue((Fact)map.get(i2)));
                continue;
            }
            catch (JessException e) {
                e.printStackTrace();
            }
        }
        return fact;
    }

    public boolean compareTokens(Token t1, Token t2) {
        if (t1.size() != t2.size()) {
            return false;
        }
        boolean returnValue = true;
        for (int i = 0; i < t1.size(); ++i) {
            int factId2;
            int factId1 = t1.fact(i).getFactId();
            if (factId1 == (factId2 = t2.fact(i).getFactId())) continue;
            returnValue = false;
            break;
        }
        return returnValue;
    }

    public void setMaxDepth(int maxDepth) {
        PropertyChangeEvent pce = new PropertyChangeEvent(this, TREE_DEPTH, this.maxDepth, maxDepth);
        this.maxDepth = maxDepth;
        if (trace.getDebugCode("mt")) {
            trace.out("mt", "MTRete.setMaxDepth() sending " + pce + " to jmt " + this.getJmt() + ".tree " + (this.getJmt() == null ? null : this.getJmt().getRuleActivationTree()));
        }
        if (this.getJmt() != null && this.getJmt().getRuleActivationTree() != null) {
            this.getJmt().getRuleActivationTree().propertyChange(pce);
        }
    }

    public int getMaxDepth() {
        return this.maxDepth;
    }

    public boolean isUseBackwardChaining() {
        return this.useBackwardChaining;
    }

    public void setUseBackwardChaining(boolean useBackwardChaining) {
        this.useBackwardChaining = useBackwardChaining;
    }

    public void setGlobalSAI(String selection, String action, String input) {
        this.jmt.setupForNewRequest(!JessModelTracing.isSAIToBeModelTraced(selection, action));
        Fact cff = GetCustomFieldsFact.clear(this);
        HintFact.setHintFact(JessModelTracing.isHintRequest(selection, action), this);
        this.setGlobalSAI(selection, action, input, this.getUseStudentValuesFact());
    }

    private void setGlobalSAI(String selection, String action, String input, Boolean assertStudentValuesFact) {
        try {
            this.eval("(defglobal ?*sSelection* = " + Utils.escapeString(selection, true) + ")");
            this.eval("(defglobal ?*sAction* = " + Utils.escapeString(action, true) + ")");
            this.eval("(defglobal ?*sInput* = " + Utils.escapeString(input, true) + ")");
            this.eval("(printout t crlf crlf \"?*sSelection*: \" ?*sSelection* \", \"\"?*sAction*: \" ?*sAction* \", \"\"?*sInput*: \" ?*sInput* \";\" crlf)");
            this.updateStudentValues(selection, action, input);
        }
        catch (JessException e1) {
            e1.printStackTrace();
        }
    }

    private void updateStudentValues(String selection, String action, String input) {
        if (this.studentValuesRecorder == null) {
            this.studentValuesRecorder = new StudentValuesRecorder(this.getUseStudentValuesFact(), this);
        }
        this.studentValuesRecorder.update(selection, action, input);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Fact getStudentValuesFact() throws JessException {
        for (int trial = 0; trial < 2; ++trial) {
            try {
                QueryResult qr = this.runQueryStar("get-studentValues", new ValueVector(0));
                if (!qr.next()) {
                    return null;
                }
                Value sv = qr.get("?sv");
                Fact result = sv.factValue(this.getGlobalContext());
                if (trace.getDebugCode("sv")) {
                    trace.out("sv", "query found student values fact " + result);
                }
                return result;
            }
            catch (JessException je) {
                if (trial > 0) {
                    trace.err("Error running defquery get-studentValues: " + (Object)((Object)je) + "; cause " + je.getCause() + ".\n  " + je.getProgramText() + "\n  " + je.getDetail());
                    continue;
                }
                MTRete mTRete = this;
                synchronized (mTRete) {
                    HasLHS q = this.findDefrule("get-studentValues");
                    if (!(q instanceof Defquery)) {
                        this.eval("(defquery get-studentValues \"Retrieve the fact holding the student SAI.\"?sv <- (studentValues))");
                    }
                    continue;
                }
            }
        }
        return null;
    }

    public Fact getFactByName(String name) {
        if (name == null || name.length() < 1) {
            return null;
        }
        Iterator it = this.listFacts();
        int i = 0;
        if (trace.getDebugCode("boots15")) {
            trace.out("boots15", "searching for fact named " + name);
        }
        while (it.hasNext()) {
            int si;
            if (trace.getDebugCode("boots15")) {
                trace.out("boots15", "iterator loop: i = " + i);
            }
            ++i;
            Fact fact = (Fact)it.next();
            Deftemplate dt = fact.getDeftemplate();
            if (dt == null || (si = dt.getSlotIndex("name")) < 0) continue;
            try {
                Value nv = fact.getSlotValue("name");
                String nvs = nv.stringValue(this.getGlobalContext());
                if (trace.getDebugCode("boots15")) {
                    trace.out("boots15", "iterator loop:                nvs = " + nvs);
                }
                if (!name.equalsIgnoreCase(nvs)) continue;
                if (trace.getDebugCode("boots15")) {
                    trace.out("boots15", "iterator loop: returning fact named " + nvs);
                }
                return fact;
            }
            catch (JessException je) {
                String errMsg = "Error getting fact by name \"" + name + "\": " + (Object)((Object)je);
                trace.err(errMsg);
                return null;
            }
        }
        return null;
    }

    public boolean setSAIDirectly(ProblemEdge brdEdge) {
        Sai sai = brdEdge.getSai();
        String selection = sai.getS();
        String action = sai.getA();
        String input = sai.getI();
        if (trace.getDebugCode("gusmiss")) {
            trace.out("gusmiss", "calling setSaiDirectly with s=" + selection + ", a=" + action + ", i=" + input);
        }
        boolean b = this.setSAIDirectly(selection, action, input);
        return b;
    }

    public boolean setSAIDirectly(String selection, String action, String input) {
        if (trace.getDebugCode("missInput")) {
            trace.out("missInput", "entered setSAIDirectly(" + selection + "," + action + "," + input + ")");
        }
        Fact f = this.getFactByName(selection);
        trace.out("modifying directly : " + selection + input);
        if (f == null) {
            if (trace.getDebugCode("missInput")) {
                trace.out("missInput", "getFactByName(" + selection + ") returned null");
            }
            return false;
        }
        try {
            f.getSlotValue("value");
        }
        catch (JessException je) {
            return false;
        }
        try {
            Value iv = MTRete.stringToValue(input);
            if (trace.getDebugCode("missInput")) {
                trace.out("missInput", "iv = " + iv);
            }
            if (trace.getDebugCode("missInput")) {
                trace.out("missInput", "before, f.value = " + f.getSlotValue("value"));
            }
            this.modify(f, "value", iv);
            if (trace.getDebugCode("missInput")) {
                trace.out("missInput", "after, f.value = " + f.getSlotValue("value"));
            }
            if (trace.getDebugCode("missInput")) {
                trace.out("missInput", "f.hashCode() = " + f.hashCode());
            }
            if (trace.getDebugCode("missInput")) {
                trace.out("missInput", "Here is the list of facts");
            }
            ArrayList factsCurrent = this.getFacts();
            for (int i = 0; i < factsCurrent.size(); ++i) {
                if (!trace.getDebugCode("missInput")) continue;
                trace.out("missInput", "Fact value at " + i + "is" + factsCurrent.get(i));
            }
            return true;
        }
        catch (JessException je) {
            String errMsg = "Error setting value slot in fact with name \"" + selection + "\": " + (Object)((Object)je);
            trace.err(errMsg);
            je.printStackTrace();
            return false;
        }
    }

    public static Value stringToValue(String s) throws JessException {
        return MTRete.stringToValue(s, false);
    }

    public static Value stringToValue(String s, boolean coerceSymbolsToStrings) throws JessException {
        Value iv = null;
        if (s == null) {
            iv = new Value("nil", 1);
        } else {
            Value[] returnValue = new Value[1];
            Utils.getJessType(s, returnValue, coerceSymbolsToStrings);
            iv = returnValue[0];
        }
        return iv;
    }

    public boolean statePending(String dirName, String fileName) {
        return this.saveStates.get(dirName + fileName) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean logTemplates(File f) {
        FileWriter w;
        try {
            w = new FileWriter(f);
        }
        catch (IOException e1) {
            e1.printStackTrace();
            return false;
        }
        Pattern slotTypePattern = Pattern.compile("(\\p{Space}*\\(slot )(.*)(\\(type\\p{Space}+)([1-9][0-9]*)\\)(\\)+)\\p{Space}*$");
        BufferedWriter out = null;
        try {
            out = w instanceof BufferedWriter ? (BufferedWriter)((Object)w) : new BufferedWriter(w);
            Iterator it = this.listDeftemplates();
            while (it.hasNext()) {
                Deftemplate dt = (Deftemplate)it.next();
                if (dt.getBaseName().startsWith("_") || dt.getBaseName().equalsIgnoreCase("initial-fact")) continue;
                StringBuffer sb = new StringBuffer();
                String template = new PrettyPrinter((Visitable)dt).toString();
                StringTokenizer tkzr = new StringTokenizer(template, "\n");
                while (tkzr.hasMoreTokens()) {
                    String line = tkzr.nextToken();
                    Matcher m = slotTypePattern.matcher(line);
                    if (m.matches()) {
                        sb.replace(0, sb.length(), m.group(1));
                        sb.append(m.group(2));
                        int typeNum = -1;
                        try {
                            typeNum = Integer.parseInt(m.group(4));
                            String type = RU.getTypeName((int)typeNum);
                            if (type == null) {
                                trace.out(5, this, "bad slot type number " + typeNum);
                            } else {
                                sb.append(m.group(3));
                                sb.append(RU.getTypeName((int)typeNum));
                                sb.append(')');
                            }
                        }
                        catch (NumberFormatException nfe) {
                            trace.out(5, this, "regex should prevent this " + typeNum);
                        }
                        sb.append(m.group(5));
                        line = sb.toString();
                    }
                    out.write(line);
                    out.newLine();
                }
                if (dt.getBackwardChaining()) {
                    out.write("(do-backward-chaining " + dt.getBaseName() + ")");
                    out.newLine();
                }
                out.flush();
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean logFacts(File file) {
        FileWriter w;
        try {
            w = new FileWriter(file);
        }
        catch (IOException e1) {
            e1.printStackTrace();
            return false;
        }
        Iterator factsIt = this.listFacts();
        try (PrintWriter out = null;){
            out = w instanceof PrintWriter ? (PrintWriter)((Object)w) : new PrintWriter(w);
            Context context = this.getGlobalContext();
            class FactVar {
                Fact f;
                String v;

                FactVar(Fact f, int i) {
                    this.f = f;
                    this.v = "?var" + i;
                }
            }
            LinkedHashMap<Integer, FactVar> map = new LinkedHashMap<Integer, FactVar>();
            if (factsIt == null) {
                factsIt = this.listFacts();
            }
            int i = 1;
            while (factsIt.hasNext()) {
                Fact f = (Fact)factsIt.next();
                map.put(new Integer(f.getFactId()), new FactVar(f, i));
                ++i;
            }
            out.println(";;;; Fact assertions: slot assignments are below.");
            out.println("");
            for (FactVar fv : map.values()) {
                String nameAssgnmt = "";
                int n = fv.f.getDeftemplate().getSlotIndex("name");
                if (n >= 0) {
                    Value nameVal = fv.f.getSlotValue("name");
                    nameAssgnmt = " (name " + nameVal.resolveValue(context) + ")";
                }
                out.println("(bind " + fv.v + " (assert(" + fv.f.getName() + nameAssgnmt + ")))");
            }
            out.println();
            out.println(";;;; Slot assignments");
            out.println();
            for (FactVar fv : map.values()) {
                Deftemplate dt = fv.f.getDeftemplate();
                int nSlots = dt.getNSlots();
                if (nSlots < 1) continue;
                out.println("; " + fv.f.getName());
                out.println("(modify " + fv.v);
                for (int i2 = 0; i2 < nSlots; ++i2) {
                    String slotName = dt.getSlotName(i2);
                    Value val = fv.f.getSlotValue(slotName).resolveValue(context);
                    out.print("    (" + slotName);
                    switch (val.type()) {
                        case 16: {
                            Fact valFact = val.factValue(context);
                            FactVar valFV = (FactVar)map.get(new Integer(valFact.getFactId()));
                            out.print(" " + valFV.v);
                            break;
                        }
                        case 512: {
                            ValueVector vv = val.listValue(context);
                            for (int j = 0; j < vv.size(); ++j) {
                                Value listVal = vv.get(j).resolveValue(context);
                                if (listVal.type() == 16) {
                                    Fact valFact = listVal.factValue(context);
                                    FactVar valFV = (FactVar)map.get(new Integer(valFact.getFactId()));
                                    out.print(" " + valFV.v);
                                    continue;
                                }
                                out.print(" " + listVal.toString());
                            }
                            break;
                        }
                        case 2048: {
                            boolean bl = false;
                            return bl;
                        }
                        default: {
                            out.print(" " + val.toString());
                        }
                    }
                    out.println(")");
                }
                out.println(")");
            }
            boolean bl = true;
            return bl;
        }
    }

    public boolean getPrunePriorActivations() {
        return this.prunePriorActivations;
    }

    public void setPrunePriorActivations(boolean prunePriorActivations) {
        this.prunePriorActivations = prunePriorActivations;
    }

    public MT getMT() {
        return this.mt;
    }

    void setMT(MT mt) {
        this.mt = mt;
    }

    public boolean addStartStateHookCall(ModelTracingUserfunction function) {
        return this.getMT().addStartStateHookCall(function);
    }

    boolean removeStartStateHook(ModelTracingUserfunction function) {
        return this.getMT().removeStartStateHook(function);
    }

    public boolean addHookCall(ModelTracingUserfunction function) {
        return this.getJmt().addHookCall(function);
    }

    public boolean removeHookCall(ModelTracingUserfunction function) {
        return this.getJmt().removeHookCall(function);
    }

    public static int findUserfuction(Userfunction f, List list) {
        ListIterator iter = list.listIterator();
        int pos = 0;
        while (iter.hasNext()) {
            Userfunction curFunction = (Userfunction)iter.next();
            if (curFunction.getClass().equals(f.getClass())) {
                return pos;
            }
            ++pos;
        }
        return -1;
    }

    public boolean clearJessWmeFact(String commName) {
        return this.setSAIDirectly(commName, null, "nil");
    }

    public Boolean setUseStudentValuesFact(Boolean b) {
        Boolean oldValue = this.useStudentValuesFact;
        this.useStudentValuesFact = b;
        return oldValue;
    }

    public Boolean getUseStudentValuesFact() {
        Boolean result = this.useStudentValuesFact;
        try {
            String prop = System.getProperty(USE_STUDENT_VALUES_FACT);
            if (null != prop && prop.length() > 0) {
                result = Boolean.valueOf(prop);
            }
        }
        catch (Exception e) {
            trace.err("Error from System.getProperty(\"UseStudentValuesFact\"): " + e + "; returning " + result);
        }
        return result;
    }

    public void setSkipWhyNotSaves(boolean skipWhyNotSaves) {
        if (this.getJmt() != null) {
            this.getJmt().setSkipWhyNotSaves(skipWhyNotSaves);
        }
    }

    private class ReteChangedListener
    implements JessListener {
        public static final int EVENT_MASK = 1073745942;

        ReteChangedListener() {
            MTRete.this.addJessListener(this);
            MTRete.this.setEventMask(MTRete.this.getEventMask() | 0x40001016);
        }

        public void eventHappened(JessEvent je) {
            if (je.getType() == 2) {
                ++MTRete.this.rulesFiredCount;
            } else {
                ++MTRete.this.reteChangeCount;
            }
        }
    }

    static class BuggyRulesLaterStrategy
    extends BuggyRulesNormalSalienceStrategy {
        private static final long serialVersionUID = 201309141315L;
        public static final String NAME = "buggy-rules-later";

        BuggyRulesLaterStrategy() {
        }

        @Override
        public String getName() {
            return NAME;
        }

        @Override
        public int compare(Activation a0, Activation a1) {
            Defrule r0 = a0.getRule();
            Defrule r1 = a1.getRule();
            int result = this.testCachedActs(a0, a1);
            if (result == 0) {
                result = MTRete.isCorrectRule(r0) && !MTRete.isCorrectRule(r1) ? -1 : (!MTRete.isCorrectRule(r0) && MTRete.isCorrectRule(r1) ? 1 : (!MTRete.isBuggyRule(r0) && MTRete.isBuggyRule(r1) ? -1 : (MTRete.isBuggyRule(r0) && !MTRete.isBuggyRule(r1) ? 1 : this.getOriginalStrategy().compare(a0, a1))));
            }
            if (trace.getDebugCode("strat")) {
                trace.out("strat", this.getName() + ".compare(" + r0.getName() + "," + r1.getName() + ")->" + result + ", cacheUse " + this.cacheUse);
            }
            return result;
        }
    }

    static class BuggyRulesNormalSalienceStrategy
    implements Strategy,
    Serializable {
        private static final long serialVersionUID = 201309131040L;
        public static final String NAME = "buggy-rules-normal-salience";
        private Activation actToFire = null;
        private Activation cachedActToFire = null;
        protected int cacheUse = 0;
        protected final Strategy originalStrategy = new Rete().getStrategy();

        BuggyRulesNormalSalienceStrategy() {
        }

        void setActToFire(Activation act, Rete rete) {
            if (trace.getDebugCode("mtt")) {
                trace.out("mtt", "setActToFire() old, new[" + MTRete.getActivationIndex(act, rete) + "]:\n " + this.actToFire + "\n " + act);
            }
            this.actToFire = act;
            this.cachedActToFire = null;
            this.cacheUse = 0;
        }

        protected Strategy install(Rete r) {
            Strategy oldStrategy = null;
            try {
                oldStrategy = r.getStrategy();
                r.setStrategy((Strategy)this);
                return oldStrategy;
            }
            catch (JessException je) {
                je.printStackTrace();
                return oldStrategy;
            }
        }

        public String getName() {
            return NAME;
        }

        public int compare(Activation a0, Activation a1) {
            int result = this.testCachedActs(a0, a1);
            if (result == 0) {
                result = this.getOriginalStrategy().compare(a0, a1);
            }
            if (trace.getDebugCode("strat")) {
                Defrule r0 = a0.getRule();
                Defrule r1 = a1.getRule();
                trace.out("strat", this.getName() + ".compare(" + r0.getName() + "," + r1.getName() + ")->" + result + ", cacheUse " + this.cacheUse);
            }
            return result;
        }

        protected Strategy getOriginalStrategy() {
            return this.originalStrategy;
        }

        protected int testCachedActs(Activation a0, Activation a1) {
            int result = 0;
            if (this.cachedActToFire != null) {
                ++this.cacheUse;
                if (a0 == this.cachedActToFire) {
                    result = -1;
                }
                if (a1 == this.cachedActToFire) {
                    result = 1;
                }
            } else if (this.actToFire != null) {
                if (a0.equals((Object)this.actToFire)) {
                    result = -1;
                    this.cachedActToFire = a0;
                }
                if (a1.equals((Object)this.actToFire)) {
                    result = 1;
                    this.cachedActToFire = a1;
                }
            }
            return result;
        }
    }

    public static class Routers {
        private final Reader tReader;
        private final boolean tConsoleLike;
        private final Writer tWriter;
        private final Reader stdinReader;
        private final boolean stdinConsoleLike;
        private final Writer stdoutWriter;
        private final Writer stderrWriter;
        private final int rWatchMask;

        Routers(Rete rete) {
            this.tReader = rete.getInputRouter("t");
            this.tConsoleLike = rete.getInputMode("t");
            this.tWriter = rete.getOutputRouter("t");
            this.stdinReader = rete.getInputRouter(MTRete.DEFAULT_IN_ROUTER);
            this.stdinConsoleLike = rete.getInputMode(MTRete.DEFAULT_IN_ROUTER);
            this.stdoutWriter = rete.getOutputRouter(MTRete.DEFAULT_IO_ROUTER);
            this.stderrWriter = rete.getOutputRouter(MTRete.DEFAULT_ERR_ROUTER);
            this.rWatchMask = rete instanceof MTRete ? ((MTRete)rete).getWatchMask() : 0;
        }

        void setRouters(Rete rete) {
            rete.addInputRouter("t", this.tReader, this.tConsoleLike);
            rete.addInputRouter(MTRete.DEFAULT_IN_ROUTER, this.stdinReader, this.stdinConsoleLike);
            rete.addOutputRouter("t", this.tWriter);
            rete.addOutputRouter(MTRete.DEFAULT_IO_ROUTER, this.stdoutWriter);
            rete.addOutputRouter(MTRete.DEFAULT_ERR_ROUTER, this.stderrWriter);
            if (rete instanceof MTRete) {
                int b = 0;
                int m = this.rWatchMask;
                while ((b = Integer.lowestOneBit(m)) != 0) {
                    int w = 0;
                    while ((b >>> w & 1) == 0) {
                        ++w;
                    }
                    try {
                        rete.watch(w);
                    }
                    catch (JessException je) {
                        trace.errStack("setRouters() error from Rete.watch(" + w + ") rWatchMask " + this.rWatchMask, je);
                    }
                    m &= ~b;
                }
            }
            Routers.dumpRouters(String.format("setRouters() rWatchMask 0x%02X", this.rWatchMask), rete);
        }

        static void dumpRouters(String label, Rete rete) {
            if (!trace.getDebugCode("routers")) {
                return;
            }
            trace.out("routers", (label == null ? "(null)" : label) + " in dumpRouters; rete " + rete.hashCode() + ", context rete " + rete.getGlobalContext().getEngine().hashCode());
            trace.out("routers", "t input router=" + rete.getInputRouter("t"));
            trace.out("routers", "WSTDIN input router=" + rete.getInputRouter(MTRete.DEFAULT_IN_ROUTER));
            trace.out("routers", "t output router=" + rete.getOutputRouter("t"));
            trace.out("routers", "WSTDOUT output router=" + rete.getOutputRouter(MTRete.DEFAULT_IO_ROUTER));
            trace.out("routers", "WSTDERR output router=" + rete.getOutputRouter(MTRete.DEFAULT_ERR_ROUTER));
        }
    }

    public static class HaltReteException
    extends JessException {
        public HaltReteException(String routine, String message) {
            super(routine, "Rete interrupted", message);
        }
    }
}

