/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.jess;

import edu.cmu.pact.BehaviorRecorder.Controller.BR_Controller;
import edu.cmu.pact.BehaviorRecorder.Controller.CTAT_Launcher;
import edu.cmu.pact.BehaviorRecorder.View.JUndo;
import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.jess.JessConsole;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.text.DefaultCaret;
import javax.swing.text.Document;

public class JessConsolePanel
extends JPanel
implements TextListener,
ActionListener,
KeyListener {
    private static final long serialVersionUID = -5766160217867156983L;
    private static final String CLEAR_WINDOW = "Clear Window";
    public static final String PROMPT = "\n\nJess> ";
    private final int BACKWARD = 0;
    private final int FORWARD = 1;
    private JTextField m_tf;
    private JTextArea textArea;
    private int caretPosition;
    private CTAT_Launcher server;
    private boolean doEcho = false;
    private commandQueue JessCommandQueue = new commandQueue();

    public JessConsolePanel(CTAT_Launcher server, boolean doEcho) {
        this.server = server;
        this.doEcho = doEcho;
        this.setName("Jess Console");
        this.setSize(500, 300);
        this.setLayout(new BorderLayout());
        this.textArea = new JTextArea(10, 40);
        this.textArea.setName("Jess Console Output");
        this.textArea.setOpaque(false);
        this.textArea.setFont(new Font("SansSerif", 0, 12));
        DefaultCaret caret = (DefaultCaret)this.textArea.getCaret();
        caret.setUpdatePolicy(2);
        JScrollPane scrollPane = new JScrollPane(this.textArea);
        this.m_tf = new JTextField(40);
        JUndo.makeTextUndoable(this.m_tf);
        this.m_tf.setName("Jess Console Input");
        this.textArea.setEditable(false);
        this.m_tf.addKeyListener(this);
        JButton bClear = new JButton(CLEAR_WINDOW);
        bClear.setActionCommand("CLEAR");
        JPanel p = new JPanel();
        p.setLayout(new BorderLayout());
        JPanel left = new JPanel();
        this.setLayout(new BorderLayout());
        this.add("Center", scrollPane);
        p.add((Component)this.m_tf, "Center");
        p.add((Component)left, "East");
        p.setBorder(new EmptyBorder(4, 2, 2, 2));
        left.add(bClear);
        this.add("South", p);
        this.m_tf.addActionListener(this);
        bClear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                JessConsolePanel.this.m_tf.setText("");
                JessConsolePanel.this.textArea.setText("");
                JessConsolePanel.this.caretPosition = 0;
            }
        });
        this.validate();
        this.repaint();
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        String cmd = this.m_tf.getText();
        JessConsole jessConsole = this.server.getFocusedController().getModelTracer().getConsole();
        if (this.doEcho) {
            jessConsole.doEcho(cmd);
        }
        this.JessCommandQueue.saveCommand(cmd);
        jessConsole.executeCommand(cmd);
        this.m_tf.setText("");
        this.scrollToBottom();
        this.textArea.repaint();
    }

    public final void setFocus() {
        this.m_tf.requestFocus();
    }

    @Override
    public void textValueChanged(TextEvent arg0) {
        trace.out("mps", "event = " + arg0);
        this.update();
    }

    void clearOutputArea() {
        this.m_tf.setText("");
        this.textArea.setText("");
        this.caretPosition = 0;
    }

    public void update() {
        int newCaretPosition = this.textArea.getText().length();
        if (newCaretPosition <= this.caretPosition) {
            return;
        }
        trace.out("mps", "old pos = " + this.caretPosition + " new pos = " + newCaretPosition);
        this.textArea.setSelectionStart(this.caretPosition);
        this.textArea.setSelectionEnd(newCaretPosition);
        this.caretPosition = newCaretPosition;
    }

    void submitCommand(String cmd) {
        this.m_tf.setText(cmd);
        this.actionPerformed(new ActionEvent(this.m_tf, 1, "submitCommand()"));
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 40 || e.getKeyCode() == 225) {
            this.m_tf.setText(this.JessCommandQueue.getCommand(1));
        } else if (e.getKeyCode() == 38 || e.getKeyCode() == 224) {
            this.m_tf.setText(this.JessCommandQueue.getCommand(0));
        }
    }

    public void refresh() {
        BR_Controller controller = this.server.getFocusedController();
        Document doc = controller.getModelTracer().getConsole().getTextOutput().getDocument();
        this.textArea.setDocument(doc);
        this.scrollToBottom();
        this.textArea.validate();
        this.textArea.repaint();
    }

    public void scrollToBottom() {
        this.textArea.setCaretPosition(this.textArea.getText().length());
    }

    private class commandQueue {
        private int queueLength = 50;
        private int pick;
        private int save = 0;
        private String[] historyQueue;

        public commandQueue() {
            this.historyQueue = new String[this.queueLength];
        }

        public commandQueue(int queueLength) {
            this.queueLength = queueLength;
            this.historyQueue = new String[queueLength];
        }

        public String getCommand(int direction) {
            if (direction == 0 && this.pick > 0) {
                --this.pick;
            } else if (direction == 1 && this.pick < this.save) {
                ++this.pick;
            }
            if (this.pick == this.save) {
                return "";
            }
            return this.historyQueue[this.pick % this.queueLength];
        }

        public void saveCommand(String newCommand) {
            this.historyQueue[this.save % this.queueLength] = newCommand;
            ++this.save;
            this.pick = this.save;
        }
    }
}

