/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.client;

import edu.cmu.pact.BehaviorRecorder.View.HintWindow.HintWindowInterface;
import edu.cmu.pact.Utilities.LoggingSupport;
import edu.cmu.pact.Utilities.MessageEvent;
import edu.cmu.pact.Utilities.MessageEventListener;
import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.client.HintMessagesManager;
import edu.cmu.pact.ctat.MessageObject;
import edu.cmu.pact.ctat.MsgType;
import edu.cmu.pact.ctat.TutorController;
import edu.cmu.pact.miss.SimSt;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.border.Border;
import pact.CommWidgets.JCommTable;
import pact.CommWidgets.JCommWidget;
import pact.CommWidgets.StudentInterfaceWrapper;

public class HintMessagesManagerForClient
implements MessageEventListener,
HintMessagesManager {
    public static final Border defaultBorder = BorderFactory.createLineBorder(Color.blue, 4);
    protected String type;
    protected MessageObject hintsMessageObject;
    private Vector messages;
    private String currentMessage;
    private int maxMessageIndex;
    private int currentMessageIndex;
    protected boolean highlightFlag = true;
    protected Vector highlightWidgetNames = new Vector();
    protected HighlightWidget highlightWidgetPair;
    protected String selectionName;
    private String transactionId;
    protected Vector currentHighlightNames = new Vector();
    private Vector currentHighlightWidgets = new Vector();
    private int mouseClickedNum = 0;
    private TutorController controller;
    private StudentInterfaceWrapper studentInterfaceWrapper;
    private HintWindowInterface hintInterface;
    private String stepID;
    private static final String HIGHLIGHT_MESSAGE = "HighlightMsg";
    private LinkedHashMap<MouseEvent, Integer> mouseEvents = new LinkedHashMap();
    private static final String WrongUserMessage = "Your answer might be right. However, this is not your task. Please work on your part.";

    public HintMessagesManagerForClient(TutorController controller) {
        this.controller = controller;
        this.reset();
    }

    @Override
    public void reset() {
        this.highlightFlag = true;
        this.maxMessageIndex = -1;
        this.currentMessageIndex = -1;
        this.type = "";
        this.hintsMessageObject = null;
        this.messages = new Vector();
        this.currentMessage = "";
        this.highlightWidgetNames = new Vector();
        this.currentHighlightNames = new Vector();
        this.currentHighlightWidgets = new Vector();
    }

    @Override
    public void setMessageObject(MessageObject o) {
        this.reset();
        this.hintsMessageObject = o;
        this.parseMessages();
        this.mouseClickedNum = 0;
    }

    @Override
    public boolean hasPreviousMessage() {
        return this.currentMessageIndex > 0;
    }

    @Override
    public boolean hasNextMessage() {
        return this.currentMessageIndex < this.maxMessageIndex;
    }

    void oliLog(MessageObject mo, boolean tutorToTool) {
        if (this.controller == null) {
            return;
        }
        LoggingSupport loggingSupport = this.controller.getLoggingSupport();
        if (loggingSupport != null) {
            loggingSupport.oliLog(mo, tutorToTool);
        }
    }

    @Override
    public String getPreviousMessage() {
        if (this.hasPreviousMessage()) {
            MessageObject mo = this.getNextHintRequest(false);
            this.oliLog(mo, false);
            --this.currentMessageIndex;
            this.currentMessage = (String)this.messages.elementAt(this.currentMessageIndex);
            mo = this.getNextHintResponse(false);
            this.oliLog(mo, true);
            return this.currentMessage;
        }
        return null;
    }

    @Override
    public String getFirstMessage() {
        if (this.maxMessageIndex >= 0) {
            this.currentMessageIndex = 0;
            this.currentMessage = (String)this.messages.elementAt(this.currentMessageIndex);
            return this.currentMessage;
        }
        return null;
    }

    @Override
    public String getNextMessage() {
        if (this.hasNextMessage()) {
            MessageObject mo = this.getNextHintRequest(true);
            this.oliLog(mo, false);
            ++this.currentMessageIndex;
            this.currentMessage = (String)this.messages.elementAt(this.currentMessageIndex);
            mo = this.getNextHintResponse(true);
            this.oliLog(mo, true);
            return this.currentMessage;
        }
        return null;
    }

    private Vector getHighlightedWidgets(Vector action) {
        Vector<String> result = new Vector<String>();
        for (int i = 0; i < this.currentHighlightNames.size(); ++i) {
            HighlightWidget v = (HighlightWidget)this.currentHighlightNames.get(i);
            result.add(v.getSelection());
            if (v.getAction() == null || action == null) continue;
            action.add(v.getAction());
        }
        return result;
    }

    @Override
    public MessageObject getNextHintRequest(boolean next) {
        MessageObject mo = MessageObject.create("InterfaceAction", "NotePropertySet");
        Vector<String> selection = new Vector<String>();
        Vector<String> action = new Vector<String>();
        Vector<String> input = new Vector<String>();
        Vector hw = this.getHighlightedWidgets(null);
        selection.addElement(next ? "NextHintButton" : "PreviousHintButton");
        action.addElement("ButtonPressed");
        input.addElement("-1");
        if (hw != null && hw.size() > 0 && hw.get(0) != null) {
            selection.addElement(hw.get(0).toString());
            action.addElement("PreviousFocus");
        }
        mo.setSelection(selection);
        mo.setAction(action);
        mo.setInput("-1");
        mo.setTransactionId(mo.makeTransactionId());
        this.setTransactionId(mo.getTransactionId());
        return mo;
    }

    @Override
    public MessageObject getNextHintResponse(boolean next) {
        Vector skills;
        Vector input;
        Vector action;
        String msgType = next ? "NextHintMessage" : "PreviousHintMessage";
        MessageObject mo = MessageObject.create(msgType, "SendNoteProperty");
        mo.setProperty("CurrentHintNumber", this.currentMessageIndex + 1);
        mo.setProperty("TotalHintsAvailable", this.maxMessageIndex + 1);
        Vector selection = this.getHighlightedWidgets(null);
        if (selection == null || selection.size() < 1) {
            selection = this.getHintMessageSelection();
        }
        if (selection != null && selection.size() > 0) {
            mo.setProperty("Selection", selection);
        }
        if ((action = this.getHintMessageAction()) != null && action.size() > 0) {
            mo.setProperty("Action", action);
        }
        if ((input = (Vector)this.getHintMessageProperty("Input")) != null && input.size() > 0) {
            mo.setProperty("Input", input);
        }
        if ((skills = (Vector)this.getHintMessageProperty("Rules")) != null && skills.size() > 0) {
            mo.setProperty("Rules", skills);
        }
        if (this.stepID != null) {
            mo.setProperty("StepID", this.stepID);
        }
        mo.setProperty("HintsMessage", this.currentMessage);
        if (this.getTransactionId() != null) {
            mo.setTransactionId(this.getTransactionId());
        }
        return mo;
    }

    @Override
    public String getMessageType() {
        return this.type;
    }

    @Override
    public void resetHighlightWidgets() {
        trace.out("mps", "resetHighlightWidgets(): highlightFlag = " + this.highlightFlag + " type = " + this.type);
        if (!this.highlightFlag) {
            return;
        }
        if (this.type.equalsIgnoreCase("ShowHintsMessageFromLisp")) {
            if (this.currentHighlightWidgets.size() > 0) {
                this.removeCurrentHighlights();
            }
            this.currentHighlightNames = (Vector)this.highlightWidgetNames.elementAt(this.currentMessageIndex);
        }
        this.setCurrentHighlights();
    }

    void removeCurrentHighlights() {
        if (trace.getDebugCode("inter")) {
            trace.printStack("inter", "HMMFC.removeCurrentHighlights() currentHighlightWidgets " + this.currentHighlightWidgets);
        }
        for (int i = 0; i < this.currentHighlightWidgets.size(); ++i) {
            JCommWidget d = (JCommWidget)this.currentHighlightWidgets.elementAt(i);
            this.highlightWidgetPair = (HighlightWidget)this.currentHighlightNames.elementAt(i);
            this.selectionName = this.highlightWidgetPair.getSelection();
            d.removeHighlight(this.selectionName);
        }
        this.currentHighlightWidgets = new Vector();
    }

    protected Border getHighlightBorder(String colorString) {
        Color color = Color.blue;
        if (colorString.equalsIgnoreCase("Blue")) {
            color = Color.blue;
        } else if (colorString.equalsIgnoreCase("Red")) {
            color = Color.red;
        } else if (colorString.equalsIgnoreCase("Yellow")) {
            color = Color.yellow;
        } else if (colorString.equalsIgnoreCase("Green")) {
            color = Color.green;
        } else if (colorString.equalsIgnoreCase("Black")) {
            color = Color.black;
        } else if (colorString.equalsIgnoreCase("DarkGray")) {
            color = Color.darkGray;
        } else if (colorString.equalsIgnoreCase("Cyan")) {
            color = Color.cyan;
        } else if (colorString.equalsIgnoreCase("Magenta")) {
            color = Color.magenta;
        } else if (colorString.equalsIgnoreCase("Orange")) {
            color = Color.orange;
        } else if (colorString.equalsIgnoreCase("Gray")) {
            color = Color.gray;
        } else if (colorString.equalsIgnoreCase("Pink")) {
            color = Color.pink;
        } else if (colorString.equalsIgnoreCase("LightGray")) {
            color = Color.lightGray;
        } else {
            trace.out(5, this, "Not recognizied color String: " + colorString);
        }
        Border border = BorderFactory.createLineBorder(color, 4);
        return border;
    }

    protected JCommWidget selectedWidget() {
        return this.controller == null ? null : this.controller.getCommWidget(this.selectionName);
    }

    private void setCurrentHighlights() {
        if (trace.getDebugCode("mps")) {
            trace.out("mps", "HMMFC.setCurrentHighlights() currentHighlightWidgets " + this.currentHighlightWidgets + ", currentHighlightNames " + this.currentHighlightNames);
        }
        if (this.currentHighlightWidgets.size() > 0) {
            return;
        }
        this.currentHighlightWidgets = new Vector();
        for (int i = 0; i < this.currentHighlightNames.size(); ++i) {
            this.highlightWidgetPair = (HighlightWidget)this.currentHighlightNames.elementAt(i);
            this.selectionName = this.highlightWidgetPair.getSelection();
            JCommWidget selectedWidget = this.selectedWidget();
            if (trace.getDebugCode("mps")) {
                trace.out("mps", "highlight widget name: selectionName=" + this.selectionName + ", selectedWidget " + selectedWidget);
            }
            if (selectedWidget != null) {
                selectedWidget.highlight(this.selectionName, this.highlightWidgetPair.getBorder());
                if (!this.type.equalsIgnoreCase("SuccessMessage") && !this.type.equalsIgnoreCase("BuggyMessage")) {
                    selectedWidget.setFocus(this.selectionName);
                }
                this.currentHighlightWidgets.addElement(selectedWidget);
                continue;
            }
            this.currentHighlightNames.removeElementAt(i);
        }
    }

    @Override
    public void cleanUpHintOnChange() {
        this.removeWidgetsHighlight();
        if (this.controller != null && this.controller.getStudentInterface() != null && this.controller.getStudentInterface().getHintInterface() != null) {
            this.controller.getStudentInterface().getHintInterface().reset();
        }
    }

    public void tutorWindowClicked(MouseEvent me) {
        Integer count = this.mouseEvents.get(me);
        count = count == null ? new Integer(1) : new Integer(count + 1);
        this.mouseEvents.put(me, count);
        if (this.mouseEvents.size() > 100) {
            MouseEvent oldest = this.mouseEvents.keySet().iterator().next();
            this.mouseEvents.remove(oldest);
        }
        if (trace.getDebugCode("inter")) {
            trace.outNT("inter", "HMMFC.tutorWindowClicked() mouseClickedNum " + this.mouseClickedNum + ", count " + count);
        }
        ++this.mouseClickedNum;
        if (me.getClickCount() == 2 && this.controller != null && this.controller.isSimStudentMode()) {
            SimSt simSt = this.controller.getMissController().getSimSt();
            if (simSt.isSsFoaClickDisabled() && simSt.isFoaGetterDefined()) {
                return;
            }
            Component c = me.getComponent();
            Class<?> cc = c.getClass();
            if (cc.equals(JCommTable.TableExpressionCell.class)) {
                c = ((JCommTable.TableExpressionCell)c).getTable();
                ((JCommWidget)c).mouseDoubleClickedWhenMissActive(me);
                c = null;
            }
            while (c != null) {
                if (c instanceof JCommWidget) {
                    ((JCommWidget)c).mouseDoubleClickedWhenMissActive(new MouseEvent(c, me.getID(), me.getWhen(), me.getModifiers(), me.getX(), me.getY(), me.getClickCount(), me.isPopupTrigger()));
                    c = null;
                    continue;
                }
                c = c.getParent();
            }
        } else if (count < 2 && this.mouseClickedNum > 1) {
            this.removeWidgetsHighlight();
        }
    }

    @Override
    public void removeWidgetsHighlight() {
        if (trace.getDebugCode("inter")) {
            trace.out("inter", "HMMFC.removeWidgetsHighlight() type " + this.type + ", currentHighlightWidgets " + this.currentHighlightWidgets);
        }
        JCommWidget selectedWidget = null;
        String widgetName = "";
        if (this.type.equalsIgnoreCase("BuggyMessage")) {
            String CommButtonClassName = "pact.CommWidgets.JCommButton";
            for (int i = 0; i < this.currentHighlightWidgets.size(); ++i) {
                selectedWidget = (JCommWidget)this.currentHighlightWidgets.elementAt(i);
                String className = selectedWidget.getClass().getName();
                if (!className.equalsIgnoreCase(CommButtonClassName)) continue;
                selectedWidget.removeHighlight("");
                selectedWidget.moveFocus();
            }
        }
        for (int i = 0; i < this.currentHighlightWidgets.size(); ++i) {
            selectedWidget = (JCommWidget)this.currentHighlightWidgets.elementAt(i);
            this.highlightWidgetPair = (HighlightWidget)this.currentHighlightNames.elementAt(i);
            widgetName = this.highlightWidgetPair.getSelection();
            selectedWidget.removeHighlight(widgetName);
        }
        if (this.type.equalsIgnoreCase("ShowHintsMessage") && this.messages.size() == 1 && widgetName.equalsIgnoreCase("Done")) {
            boolean flagSpecialMsg = false;
            String hintMessage = (String)this.messages.elementAt(0);
            if (hintMessage.equalsIgnoreCase("I'm sorry, but you are not done yet. Please continue working.") || hintMessage.equalsIgnoreCase("You can not get Done Hints now.") || hintMessage.equalsIgnoreCase("No hint message is currently available.")) {
                flagSpecialMsg = true;
            }
            if (flagSpecialMsg && selectedWidget != null) {
                selectedWidget.moveFocus();
            }
        }
        this.currentHighlightWidgets = new Vector();
    }

    @Override
    public void setWidgetFocus() {
        if (this.currentHighlightWidgets.size() > 0) {
            JCommWidget selectedWidget = (JCommWidget)this.currentHighlightWidgets.elementAt(0);
            this.highlightWidgetPair = (HighlightWidget)this.currentHighlightNames.elementAt(0);
            String widgetName = this.highlightWidgetPair.getSelection();
            selectedWidget.setFocus(widgetName);
            String hintMessage = (String)this.messages.elementAt(0);
            if (hintMessage.equalsIgnoreCase("I'm sorry, but you are not done yet. Please continue working.") || hintMessage.equalsIgnoreCase("You can not get Done Hints now.") || hintMessage.equalsIgnoreCase("No hint message is currently available.")) {
                selectedWidget.moveFocus();
            }
        }
    }

    @Override
    public Vector getHighlightedWidgetsVector() {
        return this.currentHighlightWidgets;
    }

    @Override
    public void dialogCloseCleanup() {
        if (this.currentHighlightWidgets.size() > 0) {
            this.removeWidgetsHighlight();
            this.setWidgetFocus();
        }
        this.reset();
    }

    protected Object getHintMessageProperty(String propertyName) {
        return this.hintsMessageObject.getProperty(propertyName);
    }

    protected Vector getHintMessageVector(String propertyName) {
        Object result = this.getHintMessageProperty(propertyName);
        Vector<String> vResult = new Vector<String>();
        if (result == null) {
            vResult.add("null");
            return vResult;
        }
        if (result instanceof Vector) {
            return (Vector)result;
        }
        vResult.add(result.toString());
        return vResult;
    }

    protected Vector getHintMessageSelection() {
        return this.getHintMessageVector("Selection");
    }

    protected Vector getHintMessageAction() {
        return this.getHintMessageVector("Action");
    }

    protected boolean parseMessages() {
        this.type = this.hintsMessageObject.getMessageType();
        trace.out("inter", "hint message = " + this.hintsMessageObject);
        if (this.type.equalsIgnoreCase(HIGHLIGHT_MESSAGE)) {
            this.processHighlightMessage();
            return true;
        }
        if (this.type.equalsIgnoreCase("SuccessMessage")) {
            this.processSuccessMessage();
            return true;
        }
        if (this.type.equalsIgnoreCase("BuggyMessage")) {
            this.processBuggyMessage();
            return true;
        }
        if (this.type.equalsIgnoreCase("NoHintMessage")) {
            this.processNoHintMessage();
            return true;
        }
        if (this.type.equalsIgnoreCase("WrongUserMessage")) {
            this.processWrongUserMessage();
            return true;
        }
        if (this.type.equalsIgnoreCase("CorrectAction")) {
            this.processCorrectOrIncorrectMessage(true);
            return true;
        }
        if (this.type.equalsIgnoreCase("IncorrectAction")) {
            this.processCorrectOrIncorrectMessage(false);
            return true;
        }
        if (this.type.equalsIgnoreCase("AssociatedRules")) {
            this.processAssociatedRulesMessage();
            return true;
        }
        Vector v = this.getHintMessageVector("HintsMessage");
        if (v == null) {
            this.messages.addElement("No hint message is currently available.");
        } else {
            trace.out("inter", "HintsMessage vector = " + v);
            this.messages = new Vector();
            for (String hint : v) {
                this.messages.addElement(this.cleanedUpHint(hint));
            }
        }
        this.maxMessageIndex = this.messages.size() - 1;
        if (this.type.equalsIgnoreCase("ShowHintsMessage")) {
            this.processShowHintsMessage();
            return true;
        }
        return false;
    }

    private void processAssociatedRulesMessage() {
        this.stepID = (String)this.getHintMessageProperty("StepID");
    }

    private void processShowHintsMessage() {
        this.stepID = (String)this.getHintMessageProperty("StepID");
        Vector selectionNamesVector = this.getHintMessageSelection();
        Vector actionVector = this.getHintMessageAction();
        if (selectionNamesVector == null) {
            this.highlightFlag = false;
            return;
        }
        trace.out(5, this, "selectionPart.size() = " + selectionNamesVector.size());
        if (selectionNamesVector.size() == 0) {
            this.highlightFlag = false;
            return;
        }
        if (selectionNamesVector.get(0) == "") {
            this.highlightFlag = false;
            return;
        }
        for (int i = 0; i < selectionNamesVector.size(); ++i) {
            this.selectionName = (String)selectionNamesVector.elementAt(i);
            if (this.selectedWidget() == null) continue;
            this.currentHighlightNames.addElement(new HighlightWidget(this.selectionName, defaultBorder, actionVector, i));
        }
    }

    private void processNoHintMessage() {
        this.messages.addElement("No hint message is currently available.");
        this.maxMessageIndex = this.messages.size() - 1;
        this.highlightFlag = false;
    }

    private void processCorrectOrIncorrectMessage(boolean correct) {
        this.maxMessageIndex = this.messages.size() - 1;
        this.highlightFlag = false;
    }

    private String composeMessageFromEvaluation(boolean correct) {
        StringBuffer msg = new StringBuffer();
        Vector selection = this.getHintMessageSelection();
        if (correct && selection != null && selection.size() > 0) {
            msg.append(" in component ").append(selection.get(0));
        }
        return msg.toString();
    }

    private void processWrongUserMessage() {
        this.messages.addElement(this.cleanedUpHint(WrongUserMessage));
        this.maxMessageIndex = this.messages.size() - 1;
        this.highlightFlag = false;
    }

    private void processBuggyMessage() {
        this.messages.addElement(this.cleanedUpHint((String)this.getHintMessageProperty("BuggyMsg")));
        this.maxMessageIndex = this.messages.size() - 1;
        Vector selectionPart = this.getHintMessageSelection();
        Vector actionPart = this.getHintMessageAction();
        if (selectionPart != null) {
            for (int i = 0; i < selectionPart.size(); ++i) {
                this.selectionName = (String)selectionPart.elementAt(i);
                if (this.selectedWidget() == null) continue;
                this.currentHighlightNames.addElement(new HighlightWidget(this.selectionName, defaultBorder, actionPart, i));
            }
        } else {
            this.highlightFlag = false;
        }
    }

    private void addActionToHighlightWidgetPair(Vector highlightWidgetPair, Vector actionPart, int i) {
        if (highlightWidgetPair == null) {
            return;
        }
        if (actionPart == null || actionPart.size() <= i) {
            return;
        }
        String action = (String)actionPart.get(i);
        if (action.length() < 1) {
            return;
        }
        highlightWidgetPair.add(action);
    }

    private void processSuccessMessage() {
        this.highlightFlag = false;
        String msgText = (String)this.getHintMessageProperty("SuccessMsg");
        if (msgText == null || msgText.trim().length() < 1) {
            msgText = this.composeMessageFromEvaluation(true);
        }
        this.messages.addElement(this.cleanedUpHint(msgText));
        this.maxMessageIndex = this.messages.size() - 1;
    }

    private void processHighlightMessage() {
        if (!this.highlightSelection()) {
            return;
        }
        String highlightMsgText = (String)this.getHintMessageProperty("HighlightMsgText");
        if (highlightMsgText == null) {
            return;
        }
        if (highlightMsgText == "") {
            return;
        }
        this.messages.addElement(highlightMsgText);
        this.maxMessageIndex = this.messages.size() - 1;
    }

    private boolean highlightSelection() {
        Vector selection = this.getHintMessageVector("selection");
        Vector action = this.getHintMessageVector("action");
        if (selection == null || action == null) {
            return false;
        }
        this.currentHighlightNames = new Vector();
        for (int i = 0; i < selection.size(); ++i) {
            String actionString;
            JCommWidget selectedWidget;
            this.selectionName = (String)selection.elementAt(i);
            if (this.selectionName == null || (selectedWidget = this.selectedWidget()) == null || (actionString = (String)action.elementAt(i)) == null || actionString.equalsIgnoreCase("ButtonPressed") || actionString.equalsIgnoreCase("UpdateCheckBox")) continue;
            selectedWidget.setFocus(this.selectionName);
            this.highlightWidgetPair = new HighlightWidget(this.selectionName, defaultBorder, actionString);
            this.currentHighlightNames.addElement(this.highlightWidgetPair);
        }
        return this.currentHighlightNames.size() > 0;
    }

    @Override
    public void setMessages(Vector messageVector) {
        this.messages = messageVector;
        this.maxMessageIndex = this.messages.size() - 1;
        this.currentMessageIndex = -1;
        this.highlightFlag = false;
        this.currentHighlightWidgets = new Vector();
        this.currentHighlightNames = new Vector();
    }

    @Override
    public void setMessageType(String mType) {
        this.type = mType;
    }

    private String cleanedUpHint(String hintStr) {
        String cleanedUp = this.replaceImg(hintStr);
        return cleanedUp.replaceAll("\n", "<BR>");
    }

    private String replaceImg(String message) {
        StringBuffer messageBuffer = new StringBuffer(message);
        Pattern pattern = Pattern.compile("<\\s*img.*src\\s*=[^>]*");
        Matcher matcher = pattern.matcher(message);
        if (matcher.find()) {
            String imgPath = message.substring(matcher.start(), matcher.end());
            int start = matcher.start();
            pattern = Pattern.compile("\".*\"");
            matcher = pattern.matcher(imgPath);
            if (matcher.find()) {
                int imgStart = start + matcher.start();
                int end = imgStart + matcher.end();
                String tempStr = matcher.group();
                tempStr = tempStr.replaceAll("\"", "");
                URL url = this.getClass().getResource(tempStr);
                if (url != null) {
                    messageBuffer.replace(imgStart, end, url.toString());
                }
            } else {
                URL url;
                int imgStart = -1;
                int imgEnd = -1;
                StringTokenizer st = new StringTokenizer(imgPath, " ");
                while (st.hasMoreTokens()) {
                    int tempIndex;
                    String nextToken = st.nextToken();
                    if (!nextToken.startsWith("src") && !nextToken.startsWith("SRC") && !nextToken.startsWith("Src")) continue;
                    if (nextToken.endsWith("=")) {
                        if (!st.hasMoreTokens()) continue;
                        imgStart = message.indexOf("src=") + 5;
                        imgPath = st.nextToken();
                        imgEnd = imgStart + imgPath.length();
                        break;
                    }
                    int index = nextToken.indexOf("=");
                    if (index != -1) {
                        tempIndex = message.indexOf(nextToken);
                        imgStart = tempIndex + index + 1;
                        imgPath = nextToken.substring(index + 1, nextToken.length());
                        imgEnd = imgStart + imgPath.length();
                        break;
                    }
                    tempIndex = message.indexOf(nextToken);
                    nextToken = st.nextToken();
                    if (!nextToken.equals("=") || !st.hasMoreTokens()) continue;
                    imgStart = tempIndex + imgPath.indexOf(nextToken, tempIndex) + 2;
                    imgPath = st.nextToken();
                    imgEnd = imgStart + imgPath.length();
                    break;
                }
                if ((url = this.getClass().getResource(imgPath)) != null && imgStart > -1 && imgEnd > -1) {
                    messageBuffer.replace(imgStart, imgEnd, url.toString());
                }
            }
        }
        return messageBuffer.toString();
    }

    Object getValue(Vector propertyNames, Vector propertyValues, String propertyName) {
        int pos = this.fieldPosition(propertyNames, propertyName);
        if (pos != -1) {
            return propertyValues.elementAt(pos);
        }
        return null;
    }

    @Override
    public int fieldPosition(Vector from, String fieldName) {
        int toret = -1;
        int s = from.size();
        for (int i = 0; i < s; ++i) {
            if (!((String)from.elementAt(i)).equalsIgnoreCase(fieldName)) continue;
            return i;
        }
        return toret;
    }

    private String getTransactionId() {
        return this.transactionId;
    }

    private void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    @Override
    public void messageEventOccurred(MessageEvent msgEvt) {
        try {
            if (msgEvt.isQuitMsg()) {
                return;
            }
            MessageObject mo = (MessageObject)msgEvt.getMessage();
            if (mo.isMessageType(StudentInterfaceWrapper.cleanUpMessages)) {
                this.cleanUpHintOnChange();
            }
            if (MsgType.hasTextFeedback(mo) || mo.isMessageType(StudentInterfaceWrapper.tutorEvaluationMessages)) {
                this.setMessageObject(mo);
                String message = this.getFirstMessage();
                if (trace.getDebugCode("msg")) {
                    trace.out("msg", "Printing: " + message + " for type: " + mo.getMessageType());
                }
                this.getHintInterface().showMessage(message);
            }
        }
        catch (Exception e) {
            trace.err("Error on " + msgEvt + ": " + e + (e.getCause() == null ? "" : "; cause " + e.getCause()));
            e.printStackTrace();
        }
    }

    @Override
    public HintWindowInterface getHintInterface() {
        return this.hintInterface;
    }

    private StudentInterfaceWrapper getStudentInterfaceWrapper() {
        if (this.studentInterfaceWrapper == null) {
            this.setStudentInterfaceWrapper(this.controller.getStudentInterface());
        }
        return this.studentInterfaceWrapper;
    }

    @Override
    public void setStudentInterfaceWrapper(StudentInterfaceWrapper studentInterfaceWrapper) {
        this.studentInterfaceWrapper = studentInterfaceWrapper;
    }

    @Override
    public void setHintInterface(HintWindowInterface hintInterface) {
        this.hintInterface = hintInterface;
    }

    @Override
    public void requestHint() {
        this.getStudentInterfaceWrapper().requestHint();
    }

    @Override
    public void requestDone() {
        this.getStudentInterfaceWrapper().requestDone();
    }

    protected class HighlightWidget {
        private final String selection;
        private final Border border;
        private final String action;

        public HighlightWidget(String selection, Border border, String action) {
            this.selection = selection;
            this.border = border;
            this.action = action;
        }

        public HighlightWidget(String selection, Border border, Vector actionV, int i) {
            String action;
            this.selection = selection;
            this.border = border;
            this.action = actionV == null || actionV.size() <= i ? null : ((action = (String)actionV.get(i)).length() < 1 ? null : action);
        }

        String getAction() {
            return this.action;
        }

        Border getBorder() {
            return this.border;
        }

        public String getSelection() {
            return this.selection;
        }
    }
}

