/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.TutoringService;

import edu.cmu.pact.Log.LogFormatUtils;
import edu.cmu.pact.Utilities.trace;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Iterator;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

class TSLTCorrectnessChecker {
    private static final String Usage = "Usage: Please enter .comp and .test file to compare\n";
    private static String[] badMessageTypes = new String[]{"VersionInfo", "ProblemSummaryRequest"};
    private LogFormatUtils utils = new LogFormatUtils();

    private boolean sequentialCompareLogs(String comp, String test) {
        Document compXML = null;
        Document testXML = null;
        SAXBuilder builder = new SAXBuilder();
        try {
            compXML = builder.build((Reader)new StringReader(comp));
            testXML = builder.build((Reader)new StringReader(test));
        }
        catch (JDOMException e) {
            trace.out("tslt", "Test Failed: jdom exception building doc");
            System.out.println("Test Failed: jdom exception building doc");
            e.printStackTrace();
        }
        catch (IOException e) {
            trace.out("tslt", "Test Failed: ioexception building doc");
            System.out.println("Test Failed: ioexception building doc");
            e.printStackTrace();
        }
        Element compRoot = compXML.getRootElement();
        Element testRoot = testXML.getRootElement();
        Iterator<Element> compIt = compRoot.getChildren().iterator();
        Iterator<Element> testIt = testRoot.getChildren().iterator();
        int i = 0;
        while (testIt.hasNext()) {
            Element compMessage;
            ++i;
            Element testMessage = this.getNextMessage(testIt);
            if (testMessage == null != ((compMessage = this.getNextMessage(compIt)) == null)) {
                return false;
            }
            if (testMessage == null && compMessage == null) {
                return true;
            }
            if (this.testProperties(compMessage, testMessage)) continue;
            return false;
        }
        return true;
    }

    private boolean testProperties(Element comp, Element test) {
        Element compProperties = comp.getChild("properties");
        Element testProperties = comp.getChild("properties");
        String msgType = compProperties.getChildText("MessageType");
        if (!msgType.equals(testProperties.getChildText("MessageType"))) {
            return false;
        }
        if (msgType.equals("InterfaceAction")) {
            if (compProperties.getChild("transaction_id") != null && !compProperties.getChildText("transaction_id").equals(testProperties.getChildText("transaction_id"))) {
                return false;
            }
            if (!compProperties.getChild("Selection").getValue().equals(testProperties.getChild("Selection").getValue())) {
                return false;
            }
            if (!compProperties.getChild("Action").getValue().equals(testProperties.getChild("Action").getValue())) {
                return false;
            }
            if (!compProperties.getChild("Input").getValue().equals(testProperties.getChild("Input").getValue())) {
                return false;
            }
        }
        if (msgType.equals("CorrectAction") || msgType.equals("InCorrectAction")) {
            if (compProperties.getChild("transaction_id") != null && !compProperties.getChildText("transaction_id").equals(testProperties.getChildText("transaction_id"))) {
                return false;
            }
            if (!compProperties.getChild("Selection").getValue().equals(testProperties.getChild("Selection").getValue())) {
                return false;
            }
            if (!compProperties.getChild("Action").getValue().equals(testProperties.getChild("Action").getValue())) {
                return false;
            }
            if (!compProperties.getChild("Input").getValue().equals(testProperties.getChild("Input").getValue())) {
                return false;
            }
        }
        if (msgType.equals("AssociatedRules")) {
            if (compProperties.getChild("transaction_id") != null && !compProperties.getChildText("transaction_id").equals(testProperties.getChildText("transaction_id"))) {
                return false;
            }
            if (!compProperties.getChild("Selection").getValue().equals(testProperties.getChild("Selection").getValue())) {
                return false;
            }
            if (!compProperties.getChild("Action").getValue().equals(testProperties.getChild("Action").getValue())) {
                return false;
            }
            if (!compProperties.getChild("Input").getValue().equals(testProperties.getChild("Input").getValue())) {
                return false;
            }
        }
        if (msgType.equals("ShowHintsMessage")) {
            if (!this.compUnescapedValues(compProperties.getChild("HintsMessage"), testProperties.getChild("HintsMessage"))) {
                return false;
            }
            if (!compProperties.getChild("Selection").getValue().equals(testProperties.getChild("Selection").getValue())) {
                return false;
            }
            if (!compProperties.getChild("Action").getValue().equals(testProperties.getChild("Action").getValue())) {
                return false;
            }
            if (!compProperties.getChild("Input").getValue().equals(testProperties.getChild("Input").getValue())) {
                return false;
            }
        }
        return !msgType.equals("ProblemSummaryResponse") || compProperties.getChildText("ProblemSummary").equals(testProperties.getChildText("ProblemSummary"));
    }

    private boolean compUnescapedValues(Element a, Element b) {
        String aString = a.getValue();
        String bString = b.getValue();
        aString = LogFormatUtils.unescapeString(aString);
        bString = LogFormatUtils.unescapeString(bString);
        return aString.equals(bString);
    }

    private Element getNextMessage(Iterator<Element> it) {
        int i = 0;
        while (it.hasNext()) {
            boolean goodMessageType = true;
            Element message = it.next();
            Element messageType = message.getChild("properties").getChild("MessageType");
            String text = messageType.getText();
            for (i = 0; i < badMessageTypes.length; ++i) {
                if (!text.equals(badMessageTypes[i])) continue;
                goodMessageType = false;
            }
            if (!goodMessageType) continue;
            return message;
        }
        return null;
    }

    public static void main(String[] args) {
        TSLTCorrectnessChecker TSLTCC = new TSLTCorrectnessChecker();
        String compFilePath = "";
        String testFilePath = "";
        if (args.length != 2) {
            trace.out("tslt", "Test Failed: improper usage");
            System.out.println("Test Failed: improper usage");
            System.out.println("Usage: TSLTCorrectnessChecker testFilePath [origFilePath]");
            return;
        }
        compFilePath = args[0];
        testFilePath = args[1];
        trace.out("tslt", "TSLTCorrectnessChecking " + compFilePath + " vs " + testFilePath);
        String testXML = "<?xml version=\"1.0\" standalone=\"yes\"?>\n<messages>\n";
        String compXML = "";
        try {
            BufferedReader br = new BufferedReader(new FileReader(new File(testFilePath)));
            while (br.ready()) {
                testXML = testXML + br.readLine() + '\n';
            }
            br.close();
            testXML = testXML + "</messages>";
            br = new BufferedReader(new FileReader(new File(compFilePath)));
            while (br.ready()) {
                compXML = compXML + br.readLine() + '\n';
            }
            br.close();
        }
        catch (Exception e) {
            System.out.println(Usage);
            System.out.println("File reading exception of some sorts, test failed");
            trace.out("tslt", "File reading exception of some sorts, test failed");
            return;
        }
        if (TSLTCC.sequentialCompareLogs(compXML, testXML)) {
            trace.out("tslt", "Test log matches the original log");
            System.out.println("Test log matches the original log");
        } else {
            trace.out("tslt", "Test Failed: log DOESN NOT MATCH original log");
            System.out.println("Test Failed: log DOESN NOT MATCH original log");
        }
    }
}

