/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.TutoringService;

import edu.cmu.pact.TutoringService.Collaborators;
import edu.cmu.pact.TutoringService.LauncherServer;
import edu.cmu.pact.TutoringService.TSLauncherServer;
import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.ctat.MessageObject;
import java.util.LinkedList;
import java.util.List;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class CollaboratorsTest
extends TestCase {
    private static final String schoolName = "My School Name";
    private static final String[] setPrefsMsgs = new String[]{"<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<message>\n  <verb>NotePropertySet</verb>\n  <properties>\n    <MessageType>SetPreferences</MessageType>\n    <class_name>CollaboratorsTest0(fred, mary, hank)</class_name>\n    <school_name>My School Name</school_name>\n    <user_guid>replace with user</user_guid>\n  </properties>\n</message>", "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<message>\n  <verb>NotePropertySet</verb>\n  <properties>\n    <MessageType>SetPreferences</MessageType>\n    <class_name>CollaboratorsTest1(FRED , Mary, jane)</class_name>\n    <school_name>My School Name</school_name>\n    <user_guid>replace with user</user_guid>\n  </properties>\n</message>"};
    private static int guids = 0;

    public static Test suite() {
        TestSuite suite = new TestSuite(CollaboratorsTest.class);
        return suite;
    }

    protected void setUp() throws Exception {
        super.setUp();
        trace.addDebugCodes("collab");
    }

    protected void tearDown() throws Exception {
        trace.removeDebugCode("collab");
        super.tearDown();
    }

    public void testGetUserids() {
        int[] position = new int[1];
        Object[] objectArray = new Object[1];
        String className = "Collaborators(fred,mary,hank, Luke Skywalker)";
        objectArray[0] = "Collaborators(fred,mary,hank, Luke Skywalker)";
        System.out.printf("ClassName: %s\n", objectArray);
        String[] userids = new String[]{"fred", "mary", " Hank", "Luke Skywalker ", "not there", "luke "};
        Integer[] resultLengths = new Integer[]{4, 4, 4, 4, null, null};
        this.runTestGetUserids(null, className, userids, position, resultLengths);
        Object[] objectArray2 = new Object[1];
        className = "Collaborators at Westinghouse(fred,mary,hank, Luke Skywalker)";
        objectArray2[0] = "Collaborators at Westinghouse(fred,mary,hank, Luke Skywalker)";
        System.out.printf("ClassName: %s\n", objectArray2);
        userids = new String[]{"fred", "mary", " Hank", "Luke Skywalker ", "not there", "luke "};
        resultLengths = new Integer[]{4, 4, 4, 4, null, null};
        this.runTestGetUserids(null, className, userids, position, resultLengths);
        Object[] objectArray3 = new Object[1];
        className = "Collaborators( fred, mary,hank, Luke Skywalker )";
        objectArray3[0] = "Collaborators( fred, mary,hank, Luke Skywalker )";
        System.out.printf("ClassName: %s\n", objectArray3);
        userids = new String[]{"fred", "mary", " Hank", "Luke Skywalker ", "not there", "luke "};
        resultLengths = new Integer[]{4, 4, 4, 4, null, null};
        this.runTestGetUserids(null, className, userids, position, resultLengths);
        Object[] objectArray4 = new Object[1];
        className = "Collaborators(fred,mary,hank, Luke Skywalker";
        objectArray4[0] = "Collaborators(fred,mary,hank, Luke Skywalker";
        System.out.printf("ClassName: %s\n", objectArray4);
        userids = new String[]{"fred", "not there"};
        resultLengths = new Integer[]{null, null};
        this.runTestGetUserids(null, className, userids, position, resultLengths);
        Object[] objectArray5 = new Object[1];
        className = "Collaborators:fred,mary,hank, Luke Skywalker";
        objectArray5[0] = "Collaborators:fred,mary,hank, Luke Skywalker";
        System.out.printf("ClassName: %s\n", objectArray5);
        userids = new String[]{"fred", "not there"};
        resultLengths = new Integer[]{null, null};
        this.runTestGetUserids(null, className, userids, position, resultLengths);
        Object[] objectArray6 = new Object[1];
        className = "Collaborators (fred)";
        objectArray6[0] = "Collaborators (fred)";
        System.out.printf("ClassName: %s\n", objectArray6);
        userids = new String[]{"fred", "not there"};
        resultLengths = new Integer[]{1, null};
        this.runTestGetUserids(null, className, userids, position, resultLengths);
        Object[] objectArray7 = new Object[1];
        className = "Collaborators ( )";
        objectArray7[0] = "Collaborators ( )";
        System.out.printf("ClassName: %s\n", objectArray7);
        userids = new String[]{" ", "not there"};
        resultLengths = new Integer[]{null, null};
        this.runTestGetUserids(null, className, userids, position, resultLengths);
        Object[] objectArray8 = new Object[1];
        String team = "fred , mary,hank, Luke Skywalker";
        objectArray8[0] = "fred , mary,hank, Luke Skywalker";
        System.out.printf("Team: %s\n", objectArray8);
        userids = new String[]{"fred", "mary", " Hank", "Luke Skywalker ", "not there", "luke "};
        resultLengths = new Integer[]{4, 4, 4, 4, null, null};
        this.runTestGetUserids(team, null, userids, position, resultLengths);
        Object[] objectArray9 = new Object[1];
        team = "fred, mary, hank , Luke Skywalker";
        objectArray9[0] = "fred, mary, hank , Luke Skywalker";
        System.out.printf("Team: %s\n", objectArray9);
        userids = new String[]{"fred", "mary", " Hank", "Luke Skywalker ", "not there", "luke "};
        resultLengths = new Integer[]{4, 4, 4, 4, null, null};
        this.runTestGetUserids(team, null, userids, position, resultLengths);
        Object[] objectArray10 = new Object[1];
        team = "fred, mary,hank, Luke Skywalker";
        objectArray10[0] = "fred, mary,hank, Luke Skywalker";
        System.out.printf("Team: %s\n", objectArray10);
        userids = new String[]{"fred", "mary", " Hank", "Luke Skywalker ", "not there", "luke "};
        resultLengths = new Integer[]{4, 4, 4, 4, null, null};
        this.runTestGetUserids(team, null, userids, position, resultLengths);
        Object[] objectArray11 = new Object[1];
        team = " , fred,mary,hank, Luke Skywalker";
        objectArray11[0] = " , fred,mary,hank, Luke Skywalker";
        System.out.printf("Team: %s\n", objectArray11);
        userids = new String[]{"fred", "MARY ", " hank", "not there"};
        resultLengths = new Integer[]{4, 4, 4, null};
        this.runTestGetUserids(team, null, userids, position, resultLengths);
        Object[] objectArray12 = new Object[1];
        team = "fred,mary,hank, Luke Skywalker ,";
        objectArray12[0] = "fred,mary,hank, Luke Skywalker ,";
        System.out.printf("Team: %s\n", objectArray12);
        userids = new String[]{"fred", "not there"};
        resultLengths = new Integer[]{4, null};
        this.runTestGetUserids(team, null, userids, position, resultLengths);
        Object[] objectArray13 = new Object[1];
        team = "fred";
        objectArray13[0] = "fred";
        System.out.printf("Team: %s\n", objectArray13);
        userids = new String[]{"fred", "not there"};
        resultLengths = new Integer[]{1, null};
        this.runTestGetUserids(team, null, userids, position, resultLengths);
        Object[] objectArray14 = new Object[1];
        team = ",fred";
        objectArray14[0] = ",fred";
        System.out.printf("Team: %s\n", objectArray14);
        userids = new String[]{"fred", "not there"};
        resultLengths = new Integer[]{1, null};
        this.runTestGetUserids(team, null, userids, position, resultLengths);
        Object[] objectArray15 = new Object[1];
        team = "fred ,";
        objectArray15[0] = "fred ,";
        System.out.printf("Team: %s\n", objectArray15);
        userids = new String[]{"fred", "not there"};
        resultLengths = new Integer[]{1, null};
        this.runTestGetUserids(team, null, userids, position, resultLengths);
        Object[] objectArray16 = new Object[1];
        team = "";
        objectArray16[0] = "";
        System.out.printf("Team: %s\n", objectArray16);
        userids = new String[]{" ", "not there"};
        resultLengths = new Integer[]{null, null};
        this.runTestGetUserids(team, null, userids, position, resultLengths);
    }

    private void runTestGetUserids(String team, String className, String[] userids, int[] position, Integer[] resultLengths) {
        for (int i = 0; i < userids.length; ++i) {
            List<String> result = null;
            MessageObject setPrefs = MessageObject.parse(setPrefsMsgs[0]);
            setPrefs.setProperty("user_guid", userids[i]);
            String label = null;
            if (team != null) {
                setPrefs.setProperty("study_condition_type" + i, "Collaborators");
                setPrefs.setProperty("study_condition_name" + i, team);
                label = "\"" + team + "\"";
            }
            if (className != null) {
                setPrefs.setProperty("class_name", className);
                if (label == null) {
                    label = "\"" + className + "\"";
                }
            }
            result = Collaborators.getUserids(setPrefs, position);
            System.out.printf("  %-10s: %s %2d;\n", userids[i], result, position[0]);
            if (resultLengths[i] == null) {
                CollaboratorsTest.assertTrue((String)(label + ", user \"" + userids[i] + "\" position < 0"), (position[0] < 0 ? 1 : 0) != 0);
                continue;
            }
            CollaboratorsTest.assertEquals((String)(label + ", user \"" + userids[i] + "\" bad length"), (int)resultLengths[i], (int)result.size());
            CollaboratorsTest.assertEquals((String)(label + ", user \"" + userids[i] + "\" bad position"), (int)(i + 1), (int)position[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCreate() {
        final LauncherServer ls = new LauncherServer();
        String[][] userids = new String[][]{{"fred", "mary", "hank"}, {"Mary", "FRED ", "jane"}};
        LinkedList<Thread> threads = new LinkedList<Thread>();
        for (int i = 0; i < setPrefsMsgs.length; ++i) {
            for (String string : userids[i]) {
                class Create
                implements Runnable {
                    private final MessageObject setPrefs;
                    private final String userid;
                    private final int problemCount;

                    Create(String setPrefs, String userid, int nProblems) {
                        this.setPrefs = MessageObject.parse(setPrefs);
                        this.setPrefs.setProperty("user_guid", userid);
                        this.userid = userid;
                        this.problemCount = nProblems;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public synchronized void run() {
                        LauncherServer launcherServer = ls;
                        launcherServer.getClass();
                        TSLauncherServer.Session session = new TSLauncherServer.Session(launcherServer, Integer.toString(++guids), this.userid);
                        session.setTeam(Collaborators.getUserids(this.setPrefs, null).toString());
                        session.setSchoolName(CollaboratorsTest.schoolName);
                        this.setPrefs.setProperty("user_guid", this.userid);
                        for (int p = 0; p < this.problemCount; ++p) {
                            try {
                                Collaborators.create(session, this.setPrefs);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                Assert.fail((String)("exception from create-" + this.userid + ": " + e));
                            }
                            finally {
                                this.notify();
                            }
                            System.out.printf("... Now running problem %d in Thread %s: session %s\n", p, Thread.currentThread().toString(), session.toString());
                            CollaboratorsTest collaboratorsTest = CollaboratorsTest.this;
                            synchronized (collaboratorsTest) {
                                try {
                                    ((Object)((Object)CollaboratorsTest.this)).wait();
                                }
                                catch (InterruptedException ie) {
                                    trace.err("exception during wait() for main thread");
                                }
                            }
                            if (trace.getDebugCode("collab")) {
                                trace.out("collab", "About to call Collaborators.remove(" + session + ")");
                            }
                            Collaborators.remove(session);
                        }
                    }
                }
                Thread t = new Thread((Runnable)new Create(setPrefsMsgs[i], string, i + 1), "create-" + i + "-" + string);
                threads.add(t);
                t.start();
            }
        }
        Collaborators.All allCollabs = ls.getAllCollaborators();
        for (int p = 0; p < setPrefsMsgs.length; ++p) {
            for (Thread t : threads) {
                if (!t.isAlive()) continue;
                Thread thread = t;
                synchronized (thread) {
                    try {
                        t.wait(2000L);
                    }
                    catch (InterruptedException ie) {
                        trace.err("exception during wait() for thread " + t);
                    }
                }
            }
            if (trace.getDebugCode("collab")) {
                trace.out("collab", "allCollabs:\n  " + allCollabs + "\n");
            }
            CollaboratorsTest.assertEquals((String)"wrong number of collaboration lists", (int)(setPrefsMsgs.length - p), (int)allCollabs.size());
            for (int i = p; i < setPrefsMsgs.length; ++i) {
                List<String> userNames = Collaborators.getUserids(MessageObject.parse(setPrefsMsgs[i]), null);
                String string = Collaborators.makeKeyWithNamespace(schoolName, userNames.toString());
                List collabsList = (List)allCollabs.get(string);
                CollaboratorsTest.assertNotNull((String)("could not find list for " + string), (Object)collabsList);
                CollaboratorsTest.assertEquals((String)("wrong size for listKey " + string), (int)1, (int)collabsList.size());
                Collaborators collabs = (Collaborators)collabsList.get(0);
                if (trace.getDebugCode("collab")) {
                    trace.out("collab", "Instance for " + string + "[0]:\n  " + collabs + "\n");
                }
                CollaboratorsTest.assertEquals((String)("wrong state for " + string + "[0]"), (Object)((Object)Collaborators.State.Running), (Object)((Object)collabs.getState()));
                for (int j = 0; j < userids[i].length; ++j) {
                    String userid = userids[i][j].trim().toLowerCase();
                    Collaborators.Collaborator collab = collabs.getCollaborator(userid);
                    CollaboratorsTest.assertNotNull((String)("no Collaborator for team (" + userNames + "), userid " + userid), (Object)collab);
                    CollaboratorsTest.assertEquals((String)("bad userid in Collaborator for team " + userNames + ", userid " + userid), (String)userid, (String)collab.getUserid());
                }
            }
            CollaboratorsTest i = this;
            synchronized (i) {
                ((Object)((Object)this)).notifyAll();
                continue;
            }
        }
        for (Thread t : threads) {
            try {
                t.join(2000L);
            }
            catch (InterruptedException ie) {
                trace.err("exception during join() for thread " + t);
            }
        }
        CollaboratorsTest.assertEquals((String)"allCollabs not empty", (int)0, (int)allCollabs.size());
    }
}

