/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.BehaviorRecorder.ProblemModel.Matcher;

import edu.cmu.pact.BehaviorRecorder.ProblemModel.Matcher.RegexMatcher;

public class WildcardMatcher
extends RegexMatcher {
    private String simpleActionPattern;
    private String simpleSelectionPattern;
    private String simpleInputPattern;
    private String simpleSinglePattern;

    public WildcardMatcher(boolean concat2, int vector, String value) {
        super(concat2, vector, value);
        this.simpleSinglePattern = value;
    }

    public WildcardMatcher() {
    }

    @Override
    public Object clone() {
        WildcardMatcher m = new WildcardMatcher(this.concat, this.vector, this.simpleSinglePattern);
        m.copyFrom(this);
        m.simpleSelectionPattern = this.simpleSelectionPattern;
        m.simpleActionPattern = this.simpleActionPattern;
        m.simpleInputPattern = this.simpleInputPattern;
        return m;
    }

    @Override
    public void setSelectionPattern(String selectionPattern) {
        this.simpleSelectionPattern = selectionPattern;
        super.setSelectionPattern(WildcardMatcher.convertToFullRegex(selectionPattern));
        this.selectionElement.removeContent();
        this.selectionElement.addContent(this.simpleSelectionPattern);
    }

    @Override
    public void setActionPattern(String actionPattern) {
        this.simpleActionPattern = actionPattern;
        super.setActionPattern(WildcardMatcher.convertToFullRegex(actionPattern));
        this.actionElement.removeContent();
        this.actionElement.addContent(this.simpleActionPattern);
    }

    @Override
    public void setInputPattern(String inputPattern) {
        this.simpleInputPattern = inputPattern;
        super.setInputPattern(WildcardMatcher.convertToFullRegex(inputPattern));
        this.inputElement.removeContent();
        this.inputElement.addContent(this.simpleInputPattern);
    }

    @Override
    public void setSinglePattern(String inputPattern) {
        this.simpleSinglePattern = inputPattern;
        super.setSinglePattern(WildcardMatcher.convertToFullRegex(inputPattern));
    }

    @Override
    public Object getParameter(int index) {
        if (this.single) {
            if (index == 0) {
                return this.getSinglePattern();
            }
            return null;
        }
        if (index == 0) {
            return this.getSimpleSelectionPattern();
        }
        if (index == 1) {
            return this.getSimpleActionPattern();
        }
        if (index == 2) {
            return this.getSimpleInputPattern();
        }
        if (index == 3) {
            return this.getActorPattern();
        }
        return null;
    }

    public static String convertToFullRegex(String inputPattern) {
        if (inputPattern == null) {
            return null;
        }
        inputPattern = inputPattern.replaceAll("\\.", "\\.");
        inputPattern = inputPattern.replaceAll("\\*", "\\.\\*");
        inputPattern = inputPattern.replaceAll("\\.\\.\\*", "\\.\\*");
        return inputPattern;
    }

    @Override
    public String getMatcherType() {
        return "Wildcard Match";
    }

    @Override
    public String getMatcherTypeText() {
        return "Wildcard";
    }

    @Override
    public String getMatcherClassType() {
        return "WildcardMatcher";
    }

    public String getSimpleActionPattern() {
        return this.simpleActionPattern;
    }

    public String getSimpleSelectionPattern() {
        return this.simpleSelectionPattern;
    }

    public String getSimpleInputPattern() {
        return this.simpleInputPattern;
    }

    @Override
    public String toString() {
        if (this.single) {
            return this.simpleSinglePattern;
        }
        return super.toString();
    }

    @Override
    public String[] getValuesVector() {
        return this.simpleSinglePattern.split("\n", -1);
    }

    @Override
    public String getSelectionLabelText() {
        return this.getSimpleSelectionPattern();
    }

    @Override
    public String getActionLabelText() {
        return this.getSimpleActionPattern();
    }

    @Override
    public String getInputLabelText() {
        return this.getSimpleInputPattern();
    }

    @Override
    public String getSingleLabelText() {
        return this.simpleSinglePattern;
    }
}

