/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.BehaviorRecorder.ProblemModel.Matcher;

import edu.cmu.pact.BehaviorRecorder.ProblemModel.Matcher.AnyMatcher;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Matcher.CTATFunctions;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Matcher.ExactMatcher;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Matcher.ExpressionMatcher;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Matcher.RangeMatcher;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Matcher.RegexMatcher;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Matcher.VectorMatcher;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Matcher.WildcardMatcher;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.ProblemModel;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.VariableTable;
import edu.cmu.pact.Utilities.trace;
import fri.patterns.interpreter.parsergenerator.Parser;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.jdom.Content;
import org.jdom.Element;

public abstract class Matcher
implements Cloneable,
Serializable {
    public static final int NON_SINGLE = -1;
    public static final int SELECTION = 0;
    public static final int ACTION = 1;
    public static final int INPUT = 2;
    public static final int VECTOR = 3;
    public static final int SHORT_TEXT_TRUNCATION_CHARS = 18;
    public static final int LONG_TEXT_TRUNCATION_CHARS = 23;
    protected Object lastResult;
    protected final int vector;
    public static final String MATCHER_PARAMETER_BRD_VERSION = "2.1";
    private static final double matcherParameterStdBrdVersion = Double.parseDouble("2.1");
    public static final String ACTOR = "Actor";
    public static final String DEFAULT_STUDENT_ACTOR = "Student";
    public static final String DEFAULT_TOOL_ACTOR = "Tutor";
    public static final String UNGRADED_TOOL_ACTOR = "Tutor (unevaluated)";
    public static final String ANY_ACTOR = "Any";
    public static final String DEFAULT_ACTOR = "Student";
    public static final String DEFAULT_STUDENT_ACTOR_TOOLTIP = "Only the student can perform this step.";
    public static final String DEFAULT_TOOL_ACTOR_TOOLTIP = "Tutor will perform and evaluate this step.";
    public static final String UNGRADED_TOOL_ACTOR_TOOLTIP = "Tutor will perform this step but leave it unevaluated.";
    public static final String ANY_ACTOR_TOOLTIP = "The student or the tutor may perform this step.";
    public static final String WILDCARD_MATCHER = "Wildcard Match";
    public static final String REGULAR_EXPRESSION_MATCHER = "Regular Expression Match";
    public static final String RANGE_MATCHER = "Range Match";
    public static final String ANY_MATCHER = "Any Match";
    public static final String EXACT_MATCHER = "Exact Match";
    public static final String EXPRESSION_MATCHER = "Formula Match";
    public static final String SOLVER_MATCHER = "Equation Solver";
    public static final String MULTIPLE_VECTORS_MATCHER = "Multiple Vectors Match";
    public static final String[] MATCHER_NAMES = new String[]{"Wildcard Match", "Regular Expression Match", "Range Match", "Any Match", "Exact Match", "Formula Match"};
    private String defaultSelection = "";
    private String defaultAction = "";
    private String defaultInput = "";
    private Vector<String> defaultSelectionVector = new Vector();
    private Vector<String> defaultActionVector = new Vector();
    private Vector<String> defaultInputVector = new Vector();
    final boolean single;
    final boolean concat;
    private String defaultActor = "Student";
    private boolean caseInsensitive;
    private boolean useAlgebraicEquivalence;
    protected static final int SHORT_DISPLAY_LENGTH = 8;
    protected static final int SELECTION_INDEX = 0;
    protected static final int ACTION_INDEX = 1;
    protected static final int INPUT_INDEX = 2;
    protected static final int ACTOR_INDEX = 3;
    private int selectionIndex = 0;
    private int actionIndex = 1;
    private int inputIndex = 2;
    public static final String NOT_SPECIFIED = "NotSpecified";
    public static final String DONT_CARE = "DONT-CARE";
    protected String singleValue;
    private List paramNotSpecifiedList = null;
    private transient Map<String, Object> sessionStorage = null;
    private boolean linkTriggered = false;
    private String replacementFormula;
    static final Class[] matcherPrecedenceOrder = new Class[]{ExactMatcher.class, RangeMatcher.class, ExpressionMatcher.class, WildcardMatcher.class, RegexMatcher.class, AnyMatcher.class};
    public static final String TRIGGER_ATTR = "linkTriggered";

    public Matcher(boolean concat2, int vector) {
        this.single = true;
        this.concat = concat2;
        this.vector = vector;
    }

    public Matcher() {
        this.single = false;
        this.concat = false;
        this.vector = -1;
    }

    public abstract Object clone();

    protected void copyFrom(Matcher m) {
        this.selectionIndex = m.selectionIndex;
        this.actionIndex = m.actionIndex;
        this.inputIndex = m.inputIndex;
        this.caseInsensitive = m.caseInsensitive;
        this.defaultSelection = m.defaultSelection;
        this.defaultAction = m.defaultAction;
        this.defaultInput = m.defaultInput;
        this.defaultActor = m.defaultActor;
        this.lastResult = null;
        this.linkTriggered = m.linkTriggered;
        this.paramNotSpecifiedList = m.paramNotSpecifiedList == null ? null : new ArrayList(m.paramNotSpecifiedList);
        this.replacementFormula = m.replacementFormula;
        this.sessionStorage = m.sessionStorage;
        this.singleValue = m.singleValue;
        this.useAlgebraicEquivalence = m.useAlgebraicEquivalence;
    }

    protected static boolean versionIsBeforeMatcherParameterStd(Element matcherParamElt) {
        return Matcher.versionIsBeforeMatcherParameterStd(matcherParamElt.getAttributeValue("version"));
    }

    public final boolean isConcat() {
        return this.concat;
    }

    public static boolean versionIsBeforeMatcherParameterStd(String version) {
        if (version == null || version.length() < 1) {
            return true;
        }
        try {
            double v = Double.parseDouble(version);
            return v < matcherParameterStdBrdVersion;
        }
        catch (NumberFormatException nfe) {
            if (trace.getDebugCode("br")) {
                trace.out("br", "non-numeric BRD version \"" + version + "\": " + nfe);
            }
            return true;
        }
    }

    public abstract String toXML();

    public abstract String toXML(String var1);

    public abstract boolean match(Vector var1, Vector var2, Vector var3);

    public boolean match(Vector selection, Vector action, Vector input, String actor) {
        return this.match(selection, action, input);
    }

    public boolean match(Vector selection, Vector action, Vector input, String actor, VariableTable vt) {
        return this.match(selection, action, input);
    }

    public abstract boolean matchForHint(Vector var1, Vector var2, String var3, VariableTable var4);

    protected boolean matchActor(String actor) {
        String myActor = this.getActor();
        if (ANY_ACTOR.equalsIgnoreCase(myActor)) {
            return true;
        }
        if (ANY_ACTOR.equalsIgnoreCase(actor)) {
            return true;
        }
        if (myActor == null) {
            myActor = this.getDefaultActor();
        }
        if (myActor == null) {
            return actor == null;
        }
        if (UNGRADED_TOOL_ACTOR.equalsIgnoreCase(myActor)) {
            if (DEFAULT_TOOL_ACTOR.equalsIgnoreCase(actor)) {
                return true;
            }
        }
        if (UNGRADED_TOOL_ACTOR.equalsIgnoreCase(actor)) {
            if (DEFAULT_TOOL_ACTOR.equalsIgnoreCase(myActor)) {
                return true;
            }
        }
        return myActor.equalsIgnoreCase(actor);
    }

    public boolean match(int i, Vector v) {
        if (i == this.getSelectionIndex()) {
            return this.matchSelection(v);
        }
        if (i == this.getActionIndex()) {
            return this.matchAction(v);
        }
        if (i == this.getInputIndex()) {
            return this.matchInput(v);
        }
        if (i == this.getActorIndex()) {
            return this.matchActor(v == null || v.size() < 1 ? null : (String)v.get(0));
        }
        trace.err("Matcher.match(" + v + ") parameter index undefined: " + i);
        return false;
    }

    protected boolean matchSelection(Vector v) {
        String actualSelection = v == null || v.size() < 1 ? "" : v.elementAt(0).toString();
        String expectedSelection = this.getSelection().toString();
        boolean comparisonValue = false;
        comparisonValue = this.getCaseInsensitive() ? expectedSelection.equalsIgnoreCase(actualSelection) : expectedSelection.equals(actualSelection);
        return comparisonValue;
    }

    protected String getSingle() {
        return this.singleValue;
    }

    public void setSingle(String text) {
        this.singleValue = text;
    }

    public boolean matchConcatenation(Vector v) {
        return this.matchSingle(Matcher.vector2ConcatString(v));
    }

    boolean matchSingle(String s) {
        return this.getCaseInsensitive() ? s.equalsIgnoreCase(this.singleValue) : s.equals(this.singleValue);
    }

    protected boolean matchAction(Vector v) {
        String actualAction = v == null || v.size() < 1 ? "" : v.elementAt(0).toString();
        String expectedAction = this.getAction().toString();
        boolean comparisonValue = false;
        comparisonValue = this.getCaseInsensitive() ? expectedAction.equalsIgnoreCase(actualAction) : expectedAction.equals(actualAction);
        return comparisonValue;
    }

    protected boolean matchInput(Vector v) {
        String actualInput = v == null || v.size() < 1 ? "" : v.elementAt(0).toString();
        String expectedInput = this.getInput().toString();
        boolean comparisonValue = false;
        comparisonValue = this.getCaseInsensitive() ? expectedInput.equalsIgnoreCase(actualInput) : expectedInput.equals(actualInput);
        return comparisonValue;
    }

    public void setParameter(Element element2, int index) {
        String name = element2.getAttributeValue("name");
        if (name == null || name.length() == 0) {
            this.setParameterInternal(element2, index);
        } else if (name.equalsIgnoreCase("selection")) {
            this.setDefaultSelection(element2.getText());
        } else if (name.equalsIgnoreCase("action")) {
            this.setDefaultAction(element2.getText());
        } else if (name.equalsIgnoreCase("input")) {
            this.setDefaultInput(element2.getText());
        } else if (name.equalsIgnoreCase("actor")) {
            this.setDefaultActor(element2.getText());
        } else if (name.equalsIgnoreCase("single")) {
            this.setSingle(element2.getText());
        } else {
            this.setParameterInternal(element2, index);
        }
    }

    protected abstract void setParameterInternal(Element var1, int var2);

    public abstract void setParameterByIndex(String var1, int var2);

    public MatcherParameter getMatcherParameter(int index) {
        switch (index) {
            case 0: {
                return new MatcherParameter("selection", this.getParameter(index));
            }
            case 1: {
                return new MatcherParameter("action", this.getParameter(index));
            }
            case 2: {
                return new MatcherParameter("input", this.getParameter(index));
            }
            case 3: {
                return new MatcherParameter("actor", this.getParameter(index));
            }
        }
        return null;
    }

    public abstract Object getParameter(int var1);

    public abstract int getParameterCount();

    public String getSelection() {
        return this.getDefaultSelection();
    }

    public Vector<String> getSelectionVector() {
        return this.defaultSelectionVector;
    }

    public String getAction() {
        return this.getDefaultAction();
    }

    public String getInput() {
        return this.getDefaultInput();
    }

    public String getEvaluatedInput() {
        return this.getInput();
    }

    public String getActor() {
        return this.getDefaultActor();
    }

    public String getActionLabelText(int view) {
        return this.truncateText(this.getSelectionLabelText(), 18) + ", " + this.truncateText(this.getInputLabelText(), 18);
    }

    public abstract String getMatcherTypeText();

    public abstract String getSelectionLabelText();

    public abstract String getActionLabelText();

    public abstract String getInputLabelText();

    public abstract String getSingleLabelText();

    public String getToolTipText() {
        return this.getSingleLabelText();
    }

    public String getSelectionToolTipText() {
        return this.getSelectionLabelText();
    }

    public String getActionToolTipText() {
        return this.getActionLabelText();
    }

    public String getInputToolTipText() {
        return this.getInputLabelText();
    }

    public String truncateText(String s, int maxChars) {
        if (s.length() > maxChars) {
            return s.substring(0, maxChars - 3) + "...";
        }
        return s;
    }

    public abstract String getMatcherType();

    public abstract String getMatcherClassType();

    public void setDefaultSelection(String defaultSelection) {
        this.defaultSelection = defaultSelection;
        this.defaultSelectionVector.clear();
        this.defaultSelectionVector.add(defaultSelection);
    }

    public void setDefaultSelectionVector(Vector selection) {
        this.setDefaultSelection((String)selection.get(0));
        this.defaultSelectionVector = selection;
    }

    public String getDefaultSelection() {
        return this.defaultSelection;
    }

    public void setDefaultActionVector(Vector action) {
        this.setDefaultAction((String)action.get(0));
        this.defaultActionVector = action;
    }

    public void setDefaultAction(String defaultAction) {
        this.defaultAction = defaultAction;
        this.defaultActionVector.clear();
        this.defaultActionVector.add(defaultAction);
    }

    public String getDefaultAction() {
        return this.defaultAction;
    }

    public void setDefaultInputVector(Vector input) {
        this.setDefaultInput((String)input.get(0));
        this.defaultInputVector = input;
    }

    public void setDefaultInput(String defaultInput) {
        this.defaultInput = defaultInput;
        this.defaultInputVector.clear();
        this.defaultInputVector.add(defaultInput);
    }

    public String getDefaultInput() {
        return this.defaultInput;
    }

    public void setDefaultActor(String defaultActor) {
        if (trace.getDebugCode("actor")) {
            trace.out("actor", "Matcher.setDefaultActor(" + defaultActor + ")");
        }
        if (defaultActor.equals("Tool")) {
            defaultActor = DEFAULT_TOOL_ACTOR;
        }
        this.defaultActor = defaultActor;
    }

    public String getDefaultActor() {
        return this.defaultActor;
    }

    public Vector getDefaultActionVector() {
        if (this.defaultActionVector.size() == 0) {
            Vector<String> v = new Vector<String>();
            v.add(this.defaultAction);
            return v;
        }
        return this.defaultActionVector;
    }

    public Vector getDefaultInputVector() {
        if (this.defaultInputVector.size() == 0) {
            Vector<String> v = new Vector<String>();
            v.add(this.defaultInput);
            return v;
        }
        return this.defaultInputVector;
    }

    public Vector getDefaultSelectionVector() {
        if (this.defaultSelectionVector.size() == 0) {
            Vector<String> v = new Vector<String>();
            v.add(this.defaultSelection);
            return v;
        }
        return this.defaultSelectionVector;
    }

    public Vector getDefaultActorVector() {
        Vector<String> v = new Vector<String>();
        v.add(this.defaultActor);
        return v;
    }

    public void setCaseInsensitive(boolean caseInsensitive) {
        this.caseInsensitive = caseInsensitive;
    }

    public boolean getCaseInsensitive() {
        return this.caseInsensitive;
    }

    public boolean getUseAlgebraicEquivalence() {
        return this.useAlgebraicEquivalence;
    }

    public void setUseAlgebraicEquivalence(boolean useAlgebraicEquivalence) {
        this.useAlgebraicEquivalence = useAlgebraicEquivalence;
    }

    public void setParamNotSpecified(int i, String spec) {
        if (this.paramNotSpecifiedList == null) {
            this.paramNotSpecifiedList = new ArrayList();
        }
        if (this.paramNotSpecifiedList.size() > i) {
            this.paramNotSpecifiedList.set(i, spec);
        } else {
            for (int j = this.paramNotSpecifiedList.size(); j < i; ++j) {
                this.paramNotSpecifiedList.add("");
            }
            this.paramNotSpecifiedList.add(spec);
        }
    }

    public boolean isParamNotSpecified(int i) {
        if (this.paramNotSpecifiedList == null) {
            return false;
        }
        if (this.paramNotSpecifiedList.size() <= i) {
            return false;
        }
        return NOT_SPECIFIED.equals((String)this.paramNotSpecifiedList.get(i));
    }

    public boolean isParamDontCare(int i) {
        if (this.paramNotSpecifiedList == null) {
            return false;
        }
        if (this.paramNotSpecifiedList.size() <= i) {
            return false;
        }
        return DONT_CARE.equals((String)this.paramNotSpecifiedList.get(i));
    }

    public int getSelectionIndex() {
        return this.selectionIndex;
    }

    public int getActionIndex() {
        return this.actionIndex;
    }

    public int getInputIndex() {
        return this.inputIndex;
    }

    public int getActorIndex() {
        return 3;
    }

    public void setExternalResources(VariableTable variableTable, ProblemModel problemModel, Parser parser) {
    }

    public Object evaluate() {
        return this.evaluate(null, null, null);
    }

    public Object evaluate(String selection, String action, String input) {
        return this.getDefaultInput();
    }

    public boolean checkExpression() {
        return true;
    }

    public String error() {
        return null;
    }

    public static int compare(Matcher m1, Matcher m2) {
        int top = Matcher.compare(m1.getClass(), m2.getClass());
        if (top != 0) {
            return top;
        }
        if (m1.getClass() != VectorMatcher.class || m2.getClass() != VectorMatcher.class) {
            return top;
        }
        VectorMatcher v1 = (VectorMatcher)m1;
        VectorMatcher v2 = (VectorMatcher)m2;
        int input = Matcher.compare(v1.getSingleMatcher("input").getClass(), v2.getSingleMatcher("input").getClass());
        if (input != 0) {
            return input;
        }
        int selection = Matcher.compare(v1.getSingleMatcher("selection").getClass(), v2.getSingleMatcher("selection").getClass());
        if (selection != 0) {
            return selection;
        }
        return Matcher.compare(v1.getSingleMatcher("action").getClass(), v2.getSingleMatcher("action").getClass());
    }

    private static int compare(Class class1, Class class2) {
        int j;
        int i;
        for (i = 0; i < 5; ++i) {
            try {
                if (class1.asSubclass(matcherPrecedenceOrder[i]) == null) continue;
                break;
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        for (j = 0; j < 5; ++j) {
            try {
                if (class2.asSubclass(matcherPrecedenceOrder[j]) == null) continue;
                break;
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        if (i < j) {
            return 1;
        }
        if (i > j) {
            return -1;
        }
        return 0;
    }

    protected String shortString(String s) {
        return s.substring(0, Math.min(8, s.length()));
    }

    public static String vector2ConcatString(Vector v) {
        String concat2 = "";
        for (Object o : v) {
            concat2 = concat2 + o.toString() + "\n";
        }
        return concat2.substring(0, concat2.length() > 0 ? concat2.length() - 1 : 0);
    }

    public String[] getValuesVector() {
        return new String[]{""};
    }

    public abstract String getSelectionMatcherType();

    public abstract String getActionMatcherType();

    public abstract String getInputMatcherType();

    public String getLastResult() {
        return this.lastResult == null ? "" : this.lastResult.toString();
    }

    public void setSessionStorage(Map<String, Object> sessionStorage) {
        this.sessionStorage = sessionStorage;
    }

    protected Map<String, Object> getSessionStorage() {
        return this.sessionStorage;
    }

    public boolean isLinkTriggered() {
        return this.linkTriggered;
    }

    public void setLinkTriggered(boolean linkTriggered) {
        this.linkTriggered = linkTriggered;
    }

    public void reset() {
    }

    public boolean replaceInput() {
        return this.getReplacementFormula() != null;
    }

    public String getReplacementFormula() {
        return this.replacementFormula;
    }

    public void setReplacementFormula(String replacementFormula) {
        this.replacementFormula = replacementFormula;
    }

    public Vector evaluateReplacement(Vector selection, Vector action, Vector input, VariableTable vt, ProblemModel pm) {
        if (this.getReplacementFormula() == null || vt == null) {
            return input;
        }
        CTATFunctions tempfunc = new CTATFunctions(vt, pm, pm.getFormulaParser());
        String s = selection != null && selection.size() > 0 ? selection.get(0).toString() : null;
        String a = action != null && action.size() > 0 ? action.get(0).toString() : null;
        String i = input != null && input.size() > 0 ? input.get(0).toString() : null;
        try {
            Object result;
            if (trace.getDebugCode("functions")) {
                trace.outln("functions", "evaluating " + this.getReplacementFormula() + " with s=" + s + ", a=" + a + ", i=" + i);
            }
            if ((result = tempfunc.evaluate(this.getReplacementFormula(), s, a, i)) == null) {
                trace.err("Null result from " + this.getReplacementFormula() + " with s=" + s + ", a=" + a + ", i=" + i);
                return input;
            }
            Vector<String> resultV = new Vector<String>();
            resultV.add(result.toString());
            return resultV;
        }
        catch (Exception e) {
            trace.errStack(" Error from " + this.getReplacementFormula() + " with s=" + s + ", a=" + a + ", i=" + i + ": ", e);
            return input;
        }
    }

    public int getTraversalIncrement() {
        return 1;
    }

    public Element toElement() {
        Element elt = new Element("matcher");
        if (this.getReplacementFormula() != null) {
            elt.setAttribute("replacementFormula", this.getReplacementFormula());
        }
        elt.addContent((Content)new Element("matcherType").setText(this.getMatcherClassType()));
        for (int p = 0; p < this.getParameterCount(); ++p) {
            MatcherParameter mp = this.getMatcherParameter(p);
            Element mpElt = new Element("matcherParameter");
            mpElt.setAttribute("name", mp.getName());
            mpElt.setText(mp.getValue().toString());
            elt.addContent((Content)mpElt);
        }
        return elt;
    }

    public static boolean isTutorActor(String actor, boolean acceptAny) {
        if (DEFAULT_TOOL_ACTOR.equalsIgnoreCase(actor)) {
            return true;
        }
        if (UNGRADED_TOOL_ACTOR.equalsIgnoreCase(actor)) {
            return true;
        }
        return acceptAny && ANY_ACTOR.equalsIgnoreCase(actor);
    }

    public static class MatcherParameter {
        private final String name;
        private final Object value;

        public MatcherParameter(String name, Object value) {
            this.name = name == null ? "" : name;
            this.value = value == null ? "" : value;
        }

        public String getName() {
            return this.name;
        }

        public Object getValue() {
            return this.value;
        }
    }
}

