/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.BehaviorRecorder.Controller;

import edu.cmu.pact.BehaviorRecorder.Controller.BR_Controller;
import edu.cmu.pact.BehaviorRecorder.Controller.PseudoTutorMessageBuilder;
import edu.cmu.pact.BehaviorRecorder.Controller.SingleSessionLauncher;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.FeedbackEnum;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ExampleTracerEvent;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ExampleTracerSAI;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.ProblemModel;
import edu.cmu.pact.SocketProxy.HTTPToolProxy;
import edu.cmu.pact.TutoringService.Collaborators;
import edu.cmu.pact.Utilities.Utils;
import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.ctat.HTTPMessageObject;
import edu.cmu.pact.ctat.MessageObject;
import edu.cmu.pact.ctat.MsgType;
import edu.cmu.pact.ctat.model.ProblemSummary;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import org.jdom.Content;
import org.jdom.Element;

public class MessageTank {
    public static final String END_OF_TRANSACTION = "end_of_transaction";
    private BR_Controller controller;
    private LinkedHashMap<MessageObject, ExampleTracerEvent> messageTank;
    private String transaction_id = null;
    private Vector<String> lastStudentSelection;
    private Vector<String> lastStudentAction;
    private volatile boolean tankEmpty = true;
    private Boolean suppressLogging = null;
    private HashMap<String, MessageObject> delayedFeedback = null;
    private MessageObject requestMessage;
    private String bundleName = null;

    public MessageTank(BR_Controller controller) {
        this.controller = controller;
        this.messageTank = new LinkedHashMap();
        this.tankEmpty = true;
    }

    public void consolidateMessageTank(ProblemSummary ps) {
        List<MessageObject> respondMsgs = this.getMessageTank();
        if (trace.getDebugCode("br")) {
            trace.out("br", "consolidateMessageTank() nMsgs " + respondMsgs.size());
        }
        if (trace.getDebugCode("br")) {
            trace.out("br", "============================================");
        }
        MessageObject associatedSkillsMsg = null;
        String success = "";
        String buggy = "";
        for (MessageObject msg : respondMsgs) {
            if (trace.getDebugCode("br")) {
                trace.out("br", "respond message == " + msg.toString());
            }
            if (msg.getMessageType().equals("AssociatedRules")) {
                associatedSkillsMsg = msg;
                continue;
            }
            if (msg.getMessageType().equals("SuccessMessage")) {
                success = (String)msg.getProperty("SuccessMsg");
                continue;
            }
            if (msg.getMessageType().equals("BuggyMessage")) {
                buggy = (String)msg.getProperty("BuggyMsg");
            }
            if (msg.getMessageType().equals("HighlightMsg")) {
                buggy = (String)msg.getProperty("HighlightMsgText");
            }
            if (!msg.getMessageType().equals("NotDoneMessage")) continue;
            buggy = (String)msg.getProperty("Message");
        }
        if (associatedSkillsMsg != null) {
            if (!success.equals("")) {
                associatedSkillsMsg.setProperty("TutorAdvice", success);
            } else if (!buggy.equals("")) {
                associatedSkillsMsg.setProperty("TutorAdvice", buggy);
            }
            associatedSkillsMsg.setProperty("LogAsResult", Boolean.toString(true));
            if (trace.getDebugCode("br")) {
                trace.out("br", "* associatedSkillsMsg == " + associatedSkillsMsg.toString());
            }
            this.updateProblemSummary(ps, associatedSkillsMsg);
            this.addCollaborators(associatedSkillsMsg);
        }
        if (trace.getDebugCode("br")) {
            trace.out("br", "============================================");
        }
    }

    private void addCollaborators(MessageObject msg) {
        Collaborators collabs = null;
        if (this.controller == null || this.controller.getLauncher() == null || (collabs = this.controller.getLauncher().getCollaborators()) == null) {
            return;
        }
        List<String> sessionList = collabs.getSessionIds();
        if (sessionList.size() < 2) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < sessionList.size() - 1) {
            sb.append(sessionList.get(i++)).append(',');
        }
        sb.append(sessionList.get(i));
        Element sessionsElt = new Element("custom_field");
        sessionsElt.addContent((Content)new Element("name").addContent("collaborating_sessions"));
        sessionsElt.addContent((Content)new Element("value").addContent(sb.toString()));
        ArrayList<Element> newCustomFields = new ArrayList<Element>();
        Object priorCustomFields = msg.getProperty("custom_fields");
        if (priorCustomFields instanceof List) {
            newCustomFields.addAll((List)priorCustomFields);
        }
        newCustomFields.add(sessionsElt);
        msg.setProperty("custom_fields", newCustomFields, true);
    }

    public synchronized void flushMessageTank(ProblemSummary ps, boolean endOfTransaction) {
        if (this.tankEmpty) {
            this.ensureFlushed(endOfTransaction);
            return;
        }
        this.consolidateMessageTank(ps);
        List<MessageObject> respondMsgs = this.getMessageTank();
        Collections.sort(respondMsgs, new MessageTankComparator());
        ProblemModel pm = this.controller == null ? null : this.controller.getProblemModel();
        FeedbackEnum suppress = pm == null ? FeedbackEnum.SHOW_ALL_FEEDBACK : this.controller.getProblemModel().getSuppressStudentFeedback();
        ListIterator<MessageObject> it = respondMsgs.listIterator();
        block5: while (it.hasNext()) {
            MessageObject msg = it.next();
            FeedbackEnum dispose = MsgType.suppressFeedback(msg, suppress);
            switch (dispose) {
                case SHOW_ALL_FEEDBACK: {
                    continue block5;
                }
                case DELAY_FEEDBACK: {
                    this.addToDelayedFeedbackTank(msg);
                    it.remove();
                    if (!trace.getDebugCode("br")) continue block5;
                    trace.out("br", "MessageTank hid " + msg.getMessageType());
                    continue block5;
                }
                case HIDE_ALL_FEEDBACK: 
                case HIDE_BUT_COMPLETE: {
                    it.remove();
                    if (!trace.getDebugCode("br")) continue block5;
                    trace.out("br", "MessageTank discarded " + msg.getMessageType());
                    continue block5;
                }
            }
        }
        for (int i = 0; i < respondMsgs.size(); ++i) {
            MessageObject msg = respondMsgs.get(i);
            if (this.transaction_id != null) {
                msg.setTransactionId(this.transaction_id);
            }
            boolean setEndOfTx = endOfTransaction || i >= respondMsgs.size() - 1;
            msg.setProperty(END_OF_TRANSACTION, Boolean.toString(setEndOfTx));
            this.updateSessionInfo(msg, setEndOfTx);
            if (trace.getDebugCode("br")) {
                trace.out("br", "transaction_id " + this.transaction_id + ", respond message\n " + msg.toString());
            }
            this.processInterfaceVariables(msg);
            this.sendMessage(msg);
        }
        this.ensureFlushed(endOfTransaction);
        this.transaction_id = null;
        this.tankEmpty = true;
        if (trace.getDebugCode("tank")) {
            trace.out("tank", "From flushMessageTank");
        }
        this.controller.getWidgetSynchronizedLock().releaseLock();
    }

    private void ensureFlushed(boolean endOfTransaction) {
        trace.printStack("tank", "ensureFlush(" + endOfTransaction + "), requestMessage " + trace.nh(this.requestMessage));
        if (!endOfTransaction) {
            return;
        }
        HTTPToolProxy htp = null;
        if (this.requestMessage instanceof HTTPMessageObject && null != (htp = ((HTTPMessageObject)this.requestMessage).getHttpToolProxy())) {
            htp.flushResponses(this.bundleName);
        } else if (this.controller.getUniversalToolProxy() instanceof HTTPToolProxy && null != (htp = (HTTPToolProxy)this.controller.getUniversalToolProxy())) {
            htp.flushResponses(this.bundleName);
        }
    }

    private void updateSessionInfo(MessageObject msg, boolean endOfTx) {
        if (!endOfTx || !this.controller.inTutoringServiceMode()) {
            return;
        }
        SingleSessionLauncher launcher = this.controller.getLauncher();
        if (launcher == null || launcher.getLauncherServer() == null) {
            if (Utils.isRuntime()) {
                trace.err("SingleSessionLauncher " + launcher + " or LauncherServer " + launcher.getLauncherServer() + " in tutoring service");
            }
            return;
        }
        boolean[] correct = new boolean[1];
        boolean isDoneStep = PseudoTutorMessageBuilder.isDoneStep(msg, correct);
        if (isDoneStep && correct[0]) {
            launcher.getLauncherServer().updateTransactionInfo(launcher.getSessionId(), Boolean.TRUE);
            launcher.endCollaboration();
        }
    }

    private void addToDelayedFeedbackTank(MessageObject msg) {
        Vector<String> selection = msg.getSelection();
        if (selection == null) {
            return;
        }
        if (this.delayedFeedback == null) {
            this.delayedFeedback = new LinkedHashMap<String, MessageObject>();
        }
        this.delayedFeedback.put(selection.toString(), msg);
    }

    private void processInterfaceVariables(MessageObject msg) {
        String msgType = msg.getMessageType();
        if (msgType == null) {
            return;
        }
        if ((msgType = msgType.toLowerCase()).startsWith("correct") || msgType.startsWith("interfaceaction")) {
            this.controller.processInterfaceVariables(msg);
        }
    }

    private void updateProblemSummary(ProblemSummary ps, MessageObject assocRulesResp) {
        if (trace.getDebugCode("ps")) {
            trace.outNT("ps", "MessageTank.updateProblemSummary() " + assocRulesResp);
        }
        if (ps == null || assocRulesResp == null) {
            return;
        }
        ProblemModel pm = this.controller == null ? null : this.controller.getProblemModel();
        FeedbackEnum ssfb = pm == null ? FeedbackEnum.SHOW_ALL_FEEDBACK : pm.getSuppressStudentFeedback();
        ExampleTracerEvent evt = this.messageTank.get(assocRulesResp);
        Object stepIDobj = assocRulesResp.getProperty("StepID");
        if (stepIDobj == null) {
            return;
        }
        String stepID = stepIDobj.toString();
        Object indicatorObj = assocRulesResp.getProperty("Indicator");
        if (evt != null && evt.isSolverResult()) {
            stepID = evt.getSolverStepID(stepID);
            indicatorObj = evt.getResult();
        }
        ProblemSummary.CompletionValue cv = ProblemSummary.CompletionValue.incomplete;
        ps.setCompletionStatus(cv, pm.getEffectiveConfirmDone());
        boolean[] correct = new boolean[1];
        boolean doneStep = PseudoTutorMessageBuilder.isDoneStep(assocRulesResp, correct);
        if (doneStep) {
            ProblemSummary.CompletionValue completionValue = cv = correct[0] ? ProblemSummary.CompletionValue.complete : ProblemSummary.CompletionValue.incomplete;
            if (ssfb.exitOnIncorrectDone()) {
                cv = ProblemSummary.CompletionValue.complete;
            }
            if (trace.getDebugCode("ps")) {
                trace.out("ps", "stepID " + stepID + " doneStep, correct=" + correct[0] + ", suppressFeedback=" + (Object)((Object)ssfb) + ", completion=" + (Object)((Object)cv));
            }
            ps.setCompletionStatus(cv, true);
        }
        if (cv == ProblemSummary.CompletionValue.complete) {
            ps.stopTimer();
        } else {
            ps.restartTimer();
        }
        Object actor = assocRulesResp.getProperty("Actor");
        if (actor != null && actor.toString().toLowerCase().startsWith("t")) {
            return;
        }
        if (PseudoTutorMessageBuilder.isHint(indicatorObj)) {
            ps.addHint(stepID);
        } else if (!PseudoTutorMessageBuilder.isCorrect(indicatorObj)) {
            ps.addError(stepID);
        } else if (indicatorObj != null) {
            ps.addCorrect(stepID);
        }
        if (trace.getDebugCode("ps")) {
            trace.out("ps", "stepID " + stepID + ", indicator " + indicatorObj + ", ps:\n  " + ps.toXML());
        }
        if (this.controller != null) {
            this.controller.updateSkillsConsole(assocRulesResp);
        }
    }

    private void sendMessage(MessageObject newMessage) {
        if (this.controller.isRestoringProblemState(newMessage.getTransactionId(), false)) {
            newMessage.suppressLogging(true);
        } else if (this.suppressLogging != null) {
            newMessage.suppressLogging(this.suppressLogging);
        }
        if (trace.getDebugCode("tank")) {
            trace.out("tank", "MessageTank.sendMessage() requestMessage type " + (this.requestMessage == null ? "(null)" : this.requestMessage.getClass().getSimpleName()));
        }
        if (!this.sendMessageHTTP(newMessage, false)) {
            if (this.bundleName == null) {
                this.controller.handleMessageUTP(newMessage);
            } else {
                this.controller.getUniversalToolProxy().bundleMessage(newMessage, this.bundleName, "ProblemRestoreEnd");
            }
        }
    }

    boolean sendMessageHTTP(MessageObject newMessage, boolean flush) {
        HTTPToolProxy htp = null;
        if (this.requestMessage instanceof HTTPMessageObject && (htp = ((HTTPMessageObject)this.requestMessage).getHttpToolProxy()) instanceof HTTPToolProxy) {
            htp.bundleResponse(newMessage, this.bundleName, flush);
        } else if (this.controller.getUniversalToolProxy() instanceof HTTPToolProxy) {
            htp = (HTTPToolProxy)this.controller.getUniversalToolProxy();
            htp.bundleResponse(newMessage, this.bundleName, flush);
        }
        if (trace.getDebugCode("http")) {
            trace.out("http", "MTank.sendMessageHTTP(" + newMessage.getMessageType() + ", " + flush + "): requestMessage " + trace.nh(this.requestMessage) + ", htp " + trace.nh(htp));
        }
        return htp != null;
    }

    public Boolean getSuppressLogging() {
        return this.suppressLogging;
    }

    void setSuppressLogging(Boolean suppressLogging) {
        this.suppressLogging = suppressLogging;
    }

    private List<MessageObject> getMessageTank() {
        if (trace.getDebugCode("tank")) {
            trace.out("tank", "getMessageTank(): messageTank.size() " + this.messageTank.size());
        }
        return new ArrayList<MessageObject>(this.messageTank.keySet());
    }

    public void addToMessageTank(MessageObject newMessage) {
        this.addToMessageTank(newMessage, null);
    }

    public void addToMessageTank(List<MessageObject> newMessages) {
        for (MessageObject mo : newMessages) {
            this.addToMessageTank(mo, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToMessageTank(MessageObject newMessage, ExampleTracerEvent evt) {
        if (trace.getDebugCode("tank")) {
            trace.printStack("tank", "addToMessageTank(" + this.messageTank.size() + "): " + newMessage + (evt == null ? "" : "\n event: " + evt + ". MessageTank@" + Integer.toHexString(this.hashCode())));
        }
        if (newMessage == null) {
            return;
        }
        MessageTank messageTank = this;
        synchronized (messageTank) {
            if (this.tankEmpty) {
                this.messageTank = new LinkedHashMap();
            }
            this.messageTank.put(newMessage, evt);
            this.tankEmpty = false;
        }
    }

    public synchronized void resetMessageTank() {
        if (trace.getDebugCode("tank")) {
            trace.printStack("tank", "resetMessageTank()");
        }
        this.tankEmpty = true;
        this.messageTank = new LinkedHashMap();
    }

    public String getTransaction_id() {
        return this.transaction_id;
    }

    void setTransaction_id(String transaction_id) {
        this.transaction_id = transaction_id;
    }

    public String enqueueMessageToStudent(String messageType, String selection, String action, String input, String subtype) {
        Vector<String> s = PseudoTutorMessageBuilder.s2v(selection);
        Vector<String> a = PseudoTutorMessageBuilder.s2v(action);
        Vector<String> i = PseudoTutorMessageBuilder.s2v(input);
        return this.enqueueMessageToStudent(messageType, s, a, i, subtype);
    }

    public String enqueueToolActionToStudent(Vector selection, Vector action, Vector input, String subtype) {
        return this.enqueueMessageToStudent("InterfaceAction", selection, action, input, subtype);
    }

    String enqueueMessageToStudent(String messageType, Vector selection, Vector action, Vector input, String subtype) {
        MessageObject mo = MessageObject.create(messageType, "NotePropertySet");
        mo.setSelection(selection);
        mo.setAction(action);
        mo.setInput(input);
        mo.setProperty("trigger", "DATA");
        mo.setProperty("subtype", subtype == null || subtype.length() < 1 ? "tutor-performed" : subtype);
        mo.lockTransactionId(MessageObject.makeTransactionId());
        ExampleTracerEvent evt = new ExampleTracerEvent(this, new ExampleTracerSAI(selection, action, input, "Tutor"));
        evt.setFeedback(this.controller.getProblemModel().getSuppressStudentFeedback());
        this.addToMessageTank(mo, evt);
        return mo.getTransactionId();
    }

    public boolean editSelectionAndAction(String messageType, Vector selection, Vector action) {
        int i;
        Vector<String> lastSelection = this.lastStudentSelection;
        this.lastStudentSelection = selection;
        Vector<String> lastAction = this.lastStudentAction;
        this.lastStudentAction = action;
        if (!MessageTank.isHintSelection(selection)) {
            return false;
        }
        if (!"InterfaceAction".equalsIgnoreCase(messageType)) {
            return false;
        }
        if (lastSelection == null || lastSelection.size() < 1 || lastSelection.get(0).length() < 1) {
            return this.maybeBlankPreviousFocus(selection, action);
        }
        if (MessageTank.isHintSelection(lastSelection)) {
            return this.maybeBlankPreviousFocus(selection, action);
        }
        if (!this.lastTransactionAffectsHint()) {
            return this.maybeBlankPreviousFocus(selection, action);
        }
        if (!this.controller.getProblemModel().areHintsBiasedByCurrentSelection() && !this.controller.getProblemModel().areHintsBiasedByPriorError()) {
            return this.maybeBlankPreviousFocus(selection, action);
        }
        if (!this.controller.getProblemModel().areHintsBiasedByPriorError()) {
            return this.maybeBlankPreviousFocus(selection, action);
        }
        for (i = 1; i <= lastSelection.size(); ++i) {
            if (i < selection.size()) {
                selection.set(i, lastSelection.get(i - 1));
                continue;
            }
            selection.add(lastSelection.get(i - 1));
        }
        if (action != null) {
            if (action.size() > 1) {
                action.set(1, "PreviousFocus");
            } else {
                action.add("PreviousFocus");
            }
            for (i = 0; i < lastAction.size(); ++i) {
                action.add(lastAction.get(i));
            }
        }
        if (trace.getDebugCode("ett")) {
            trace.out("ett", "[edit selection] s: " + selection + ", a: " + action);
        }
        return true;
    }

    private boolean maybeBlankPreviousFocus(Vector selection, Vector action) {
        int i;
        if (this.controller.getProblemModel().areHintsBiasedByCurrentSelection()) {
            return true;
        }
        for (i = 1; i < selection.size(); ++i) {
            selection.set(i, "");
        }
        for (i = 1; i < action.size(); ++i) {
            action.set(i, "");
        }
        return false;
    }

    private boolean lastTransactionAffectsHint() {
        List<MessageObject> tankContents = this.getMessageTank();
        boolean foundIncorrect = false;
        boolean isOutOfOrder = false;
        for (int i = 0; !isOutOfOrder && i < tankContents.size(); ++i) {
            MessageObject mo = tankContents.get(i);
            if (trace.getDebugCode("tank")) {
                trace.out("tank", "lastTransactionAffectsHint() tankContents[" + i + "] " + mo.getMessageType());
            }
            if (!foundIncorrect) {
                foundIncorrect = "IncorrectAction".equalsIgnoreCase(mo.getMessageType());
            }
            if (isOutOfOrder) continue;
            isOutOfOrder = "HighlightMsg".equalsIgnoreCase(mo.getMessageType());
        }
        return foundIncorrect && !isOutOfOrder;
    }

    private static boolean isHintSelection(Vector selection) {
        if (selection == null || selection.size() < 1) {
            return false;
        }
        String firstSelection = (String)selection.get(0);
        return "Help".equalsIgnoreCase(firstSelection) || "Hint".equalsIgnoreCase(firstSelection);
    }

    public void flushDelayedFeedback() {
        if (trace.getDebugCode("msg")) {
            trace.out("msg", "flushDelayedFeedback() no. to send " + (this.delayedFeedback == null ? "null" : Integer.toString(this.delayedFeedback.size())));
        }
        if (this.delayedFeedback == null) {
            return;
        }
        for (MessageObject mo : this.delayedFeedback.values()) {
            this.processInterfaceVariables(mo);
            this.sendMessage(mo);
        }
        this.delayedFeedback.clear();
    }

    public void clear() {
        if (trace.getDebugCode("tank")) {
            trace.printStack("tank", "MessageTank.clear()");
        }
        if (this.messageTank != null) {
            this.messageTank.clear();
        }
        this.bundleName = null;
        this.tankEmpty = true;
        this.lastStudentSelection = null;
        this.lastStudentAction = null;
        if (this.delayedFeedback != null) {
            this.delayedFeedback.clear();
        }
        this.setTransaction_id(null);
        this.requestMessage = null;
        this.suppressLogging = null;
    }

    public void setRequestMessage(MessageObject mo) {
        this.requestMessage = mo;
    }

    public void setBundleName(String bundleName) {
        this.bundleName = bundleName;
    }

    public boolean isEmpty() {
        return !this.tankEmpty;
    }

    private static class MessageTankComparator
    implements Comparator<MessageObject> {
        private static HashSet<String> msgTypesToDefer = new HashSet<String>(Arrays.asList("SuccessMessage", "BuggyMessage", "HighlightMsg", "NotDoneMessage"));

        private MessageTankComparator() {
        }

        @Override
        public int compare(MessageObject o1, MessageObject o2) {
            String m1 = o1.getMessageType();
            String m2 = o2.getMessageType();
            if (msgTypesToDefer.contains(m1)) {
                return msgTypesToDefer.contains(m2) ? 0 : 1;
            }
            if (msgTypesToDefer.contains(m2)) {
                return msgTypesToDefer.contains(m1) ? 0 : -1;
            }
            return 0;
        }
    }
}

