/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.BehaviorRecorder.Controller;

import edu.cmu.pact.BehaviorRecorder.Controller.BR_Controller;
import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.ctat.MessageObject;
import edu.cmu.pact.ctat.model.Skills;
import java.net.URL;
import java.util.Arrays;
import javax.xml.bind.DatatypeConverter;

public class ClientRetrievedURL {
    public static final String CLIENT_SCHEME = "client:";
    private final String problemName;
    private final Skills skills;
    private final MessageObject setPrefsMsg;
    private final URL problemFileURL;

    public ClientRetrievedURL(String clientSchemeURL, String problemName, Skills skills, MessageObject setPrefsMsg) throws IllegalArgumentException {
        if (clientSchemeURL == null || !clientSchemeURL.startsWith(CLIENT_SCHEME) || clientSchemeURL.length() <= CLIENT_SCHEME.length()) {
            throw new IllegalArgumentException("ClientRetrievedURL: invalid initial URL: \"" + clientSchemeURL + "\"; must begin with \"" + CLIENT_SCHEME + "\"");
        }
        URL url = null;
        String urlStr = null;
        for (int i = 0; url == null && i < 2; ++i) {
            urlStr = i < 1 ? clientSchemeURL.substring(CLIENT_SCHEME.length()) : "http:" + urlStr;
            try {
                url = new URL(urlStr);
                continue;
            }
            catch (Exception e) {
                trace.err("ClientRetrievedURL: invalid URL: \"" + urlStr + "\"; error " + e + ", cause " + e.getCause());
                if (i < 1) {
                    url = null;
                    continue;
                }
                throw new IllegalArgumentException("ClientRetrievedURL: invalid initial URL: \"" + clientSchemeURL + "\"; error " + e + ", cause " + e.getCause());
            }
        }
        this.problemFileURL = url;
        this.problemName = problemName;
        this.skills = skills;
        this.setPrefsMsg = setPrefsMsg;
    }

    MessageObject createGetURLMsg() {
        MessageObject msg = MessageObject.create("GetURL");
        msg.setProperty("URL", this.getActualURL());
        msg.suppressLogging(true);
        if (trace.getDebugCode("url")) {
            trace.out("url", "GetURL msg:\n " + msg.toXML());
        }
        return msg;
    }

    private String getActualURL() {
        return this.problemFileURL.toString();
    }

    boolean openBR(MessageObject getURLMsg, BR_Controller controller) {
        byte[] brdImage;
        block7: {
            String content = getURLMsg.getProperty("content").toString();
            if (trace.getDebugCode("url")) {
                trace.out("url", String.format("URL msg content len %d, begins\n  %.130s", content.length(), content));
            }
            brdImage = null;
            try {
                if (content == null || content.length() < 1) {
                    throw new IllegalArgumentException("Empty or null GetURLResponse.content " + content + "; URL " + this.problemFileURL);
                }
                brdImage = DatatypeConverter.parseBase64Binary((String)content);
                if (trace.getDebugCode("url")) {
                    try {
                        trace.out("url", String.format("URL msg brdImage len %d, begins\n  %.130s", brdImage.length, new String(Arrays.copyOf(brdImage, 130), "UTF-8")));
                    }
                    catch (Exception e) {
                        trace.errStack("Programming error: UTF-8 gives error " + e, e);
                    }
                }
            }
            catch (Exception e) {
                trace.errStack("Error base64-decoding brd content: " + e + "; brdImage.length " + (brdImage == null ? -1 : brdImage.length), e);
                if (brdImage != null && brdImage.length >= 1) break block7;
                return false;
            }
        }
        return controller.openBR(this.problemFileURL, brdImage, this.getActualURL(), this.problemName, this.skills, this.setPrefsMsg);
    }
}

