/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.ctat;

import edu.cmu.pact.Utilities.trace;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Random;

public class CTATRandom {
    private static Random gen = new Random(System.currentTimeMillis());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSeed(long newSeed) {
        Random random = gen;
        synchronized (random) {
            gen.setSeed(newSeed);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] randomOrder(int n) {
        int[] result = new int[n];
        LinkedList<Integer> indices = new LinkedList<Integer>();
        for (int i = 0; i < n; ++i) {
            indices.add(new Integer(i));
        }
        Random random = gen;
        synchronized (random) {
            int i = 0;
            while (n > 0) {
                double r = gen.nextDouble();
                result[i] = (Integer)indices.remove((int)(r * (double)n));
                if (trace.getDebugCode("random")) {
                    trace.out("random", "r " + r + ", (int) (r*n) " + (int)(r * (double)n) + ", result[" + i + "]=" + result[i]);
                }
                ++i;
                --n;
            }
        }
        return result;
    }

    public int[] randomIndices(int n, double fraction) {
        int[] randIndices = this.randomOrder(n);
        int resultLength = (int)Math.floor((double)n * fraction);
        if (resultLength < 1) {
            return new int[0];
        }
        return Arrays.copyOf(randIndices, resultLength);
    }
}

