/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.ctat;

import edu.cmu.hcii.ctat.CTATAssetManager;
import edu.cmu.hcii.ctat.CTATBase;
import edu.cmu.hcii.ctat.CTATCourseAssignment;
import edu.cmu.hcii.ctat.CTATCourseProbset;
import edu.cmu.hcii.ctat.CTATLink;
import edu.cmu.hcii.ctat.CTATProblem;
import edu.cmu.hcii.ctat.CTATProblemSet;
import edu.cmu.hcii.ctat.CTATURLFetch;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class CTATCurriculum
extends CTATBase {
    private static final String INSTRUCTOR_NAME = "instructor_name";
    private static final String TEACHER_NAME = "teacher_name";
    public String problemSetsPath = CTATLink.htdocs + "/remoteBRDs/tutors/problem_sets/";
    public String relativePathPrefix = "/tutors/problem_sets/";
    private String assignedClass = "";
    private Hashtable<String, CTATCourseAssignment> assignments = new Hashtable();
    private String instructorName = null;
    private String schoolName = null;
    private Set<String> usernames = new HashSet<String>();

    public CTATCurriculum() {
        this.setClassName("CTATCurriculum");
        this.debug("CTATCurriculum (String)");
    }

    public CTATCurriculum(String curriculumXML) throws SAXException, IOException, ParserConfigurationException, FactoryConfigurationError {
        this.setClassName("CTATCurriculum");
        this.debug("CTATCurriculum (): curriculumXML is\n" + curriculumXML + "\n");
        Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new InputSource(new ByteArrayInputStream(curriculumXML.getBytes("utf-8"))));
        this.parse(doc);
    }

    public CTATCurriculum(File curriculumXML) throws SAXException, IOException, ParserConfigurationException, FactoryConfigurationError {
        this.setClassName("CTATCurriculum");
        this.debug("CTATCurriculum (File)");
        Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(curriculumXML);
        this.parse(doc);
    }

    public String getAssignedClass() {
        return this.assignedClass;
    }

    public void setAssignedClass(String assignedClass) {
        this.assignedClass = assignedClass;
    }

    public void parse(Document doc) throws IOException {
        this.debug("parse ()");
        Element root = doc.getDocumentElement();
        if (root.getNodeName().equalsIgnoreCase("curriculum")) {
            this.debug("Detected old format curriculum");
            this.parseTheOldWay(doc);
            return;
        }
        this.debug("Parsing new format curriculum");
        this.instructorName = root.getAttribute(INSTRUCTOR_NAME);
        if (this.instructorName == null || this.instructorName.length() < 1) {
            this.instructorName = root.getAttribute(TEACHER_NAME);
        }
        this.schoolName = root.getAttribute("school_name");
        NodeList docChildren = root.getChildNodes();
        int numDocChildren = docChildren.getLength();
        for (int i = 0; i < numDocChildren; ++i) {
            Node docChild = docChildren.item(i);
            if (docChild.getNodeType() == 1 && docChild.getNodeName().equalsIgnoreCase("Assignments")) {
                this.debug("Processing 'Assignments' node ...");
                NodeList assignmentNodes = docChild.getChildNodes();
                int numAssignmentNodes = assignmentNodes.getLength();
                for (int j = 0; j < numAssignmentNodes; ++j) {
                    Node assignmentNode = assignmentNodes.item(j);
                    if (assignmentNode.getNodeType() != 1 || !assignmentNode.getNodeName().equalsIgnoreCase("Assignment")) continue;
                    this.debug("Processing 'Assignment' node ...");
                    Element assignmentElement = (Element)assignmentNode;
                    String assignmentName = assignmentElement.getAttribute("name");
                    String assignmentStatus = assignmentElement.getAttribute("status");
                    String assignmentPosition = assignmentElement.getAttribute("position");
                    String assignmentAssignType = assignmentElement.getAttribute("assign_type");
                    this.debug("Assignment name " + assignmentName + ", status " + assignmentStatus + ", position " + assignmentPosition);
                    if (assignmentName.length() <= 0) continue;
                    CTATCourseAssignment thisAssignment = new CTATCourseAssignment();
                    thisAssignment.name = assignmentName;
                    thisAssignment.status = assignmentStatus;
                    try {
                        thisAssignment.position = Integer.valueOf(assignmentPosition);
                    }
                    catch (NumberFormatException e) {
                        thisAssignment.position = -1;
                    }
                    thisAssignment.assign_type = assignmentAssignType;
                    CTATCourseAssignment prev = this.assignments.put(assignmentName, thisAssignment);
                    if (prev != null) {
                        throw new IOException("invalid XML -- duplicate assingment names");
                    }
                    NodeList assignmentChildren = assignmentNode.getChildNodes();
                    int numAssignmentChildren = assignmentChildren.getLength();
                    this.debug("Assignment name " + thisAssignment.name + ", numAssignmentChildren " + numAssignmentChildren);
                    for (int k = 0; k < numAssignmentChildren; ++k) {
                        Node assignmentChild = assignmentChildren.item(k);
                        if (assignmentChild.getNodeType() != 1 || !assignmentChild.getNodeName().equalsIgnoreCase("ProblemSets")) continue;
                        NodeList problemSetNodes = assignmentChild.getChildNodes();
                        int numProblemSetNodes = problemSetNodes.getLength();
                        this.debug("Assignment name " + thisAssignment.name + ", nProblemSetNodes " + numProblemSetNodes);
                        for (int m = 0; m < numProblemSetNodes; ++m) {
                            Node problemSetNode = problemSetNodes.item(m);
                            if (problemSetNode.getNodeType() != 1 || !problemSetNode.getNodeName().equalsIgnoreCase("ProblemSet")) continue;
                            Element problemSetElement = (Element)problemSetNode;
                            String probsetName = problemSetElement.getAttribute("name");
                            String probsetPosition = problemSetElement.getAttribute("position");
                            String probsetSubdirectory = problemSetElement.getAttribute("subdirectory");
                            String probsetActivationStatus = problemSetElement.getAttribute("activation_status");
                            if (probsetName.length() <= 0) continue;
                            CTATCourseProbset thisProbset = new CTATCourseProbset();
                            thisProbset.name = probsetName;
                            try {
                                thisProbset.position = Integer.valueOf(probsetPosition);
                            }
                            catch (NumberFormatException e) {
                                thisProbset.position = -1;
                            }
                            thisProbset.subdirectory = probsetSubdirectory;
                            thisProbset.activation_status = probsetActivationStatus;
                            thisAssignment.addProbset(thisProbset);
                        }
                    }
                }
            }
            if (docChild.getNodeType() != 1 || !docChild.getNodeName().equalsIgnoreCase("Students")) continue;
            NodeList studentNodes = docChild.getChildNodes();
            int numStudentNodes = studentNodes.getLength();
            for (int m = 0; m < numStudentNodes; ++m) {
                Node studentNode = studentNodes.item(m);
                if (studentNode.getNodeType() != 1 || !studentNode.getNodeName().equalsIgnoreCase("Student")) continue;
                Element studentElement = (Element)studentNode;
                String username = studentElement.getAttribute("username");
                this.usernames.add(username);
            }
        }
    }

    public boolean isUserRegistered(String username) {
        return this.usernames.contains(username);
    }

    private void parseTheOldWay(Document doc) throws IOException {
        Element root = doc.getDocumentElement();
        NodeList assignmentNodes = root.getChildNodes();
        int numAssignmentNodes = assignmentNodes.getLength();
        HashSet<String> probsetNames = new HashSet<String>();
        for (int i = 0; i < numAssignmentNodes; ++i) {
            Node assignmentNode = assignmentNodes.item(i);
            if (assignmentNode.getNodeType() != 1 || !assignmentNode.getNodeName().equalsIgnoreCase("assignment")) continue;
            Element assignmentElement = (Element)assignmentNode;
            String assignmentID = assignmentElement.getAttribute("id");
            String assignmentName = assignmentElement.getAttribute("name");
            String assignmentStatus = assignmentElement.getAttribute("status");
            if (assignmentID.length() <= 0 || assignmentName.length() <= 0) continue;
            CTATCourseAssignment thisAssignment = new CTATCourseAssignment();
            thisAssignment.name = assignmentName;
            thisAssignment.status = assignmentStatus;
            CTATCourseAssignment prev = this.assignments.put(assignmentID, thisAssignment);
            if (prev != null) {
                throw new IOException("Curriculum XML invalid -- duplicate assignment IDs \"" + assignmentID + "\"");
            }
            NodeList probsetNodes = assignmentElement.getChildNodes();
            int numProbsetNodes = probsetNodes.getLength();
            for (int j = 0; j < numProbsetNodes; ++j) {
                Node probsetNode = probsetNodes.item(j);
                if (probsetNode.getNodeType() != 1 || !probsetNode.getNodeName().equals("problemset")) continue;
                Element probsetElement = (Element)probsetNode;
                String probsetID = probsetElement.getAttribute("id");
                String probsetName = probsetElement.getAttribute("name");
                boolean noDuplicate = probsetNames.add(probsetName);
                if (!noDuplicate) {
                    throw new IOException("Curriculum XML invalid -- duplicate problem set names \"" + probsetName + "\"");
                }
                if (probsetName.length() <= 0) continue;
                CTATCourseProbset thisProbset = new CTATCourseProbset();
                thisProbset.activation_status = probsetID;
                thisProbset.name = probsetName;
                thisAssignment.addProbset(thisProbset);
            }
        }
    }

    public String getFirstAssignment() {
        this.debug("getFirstAssignment ()");
        if (this.assignments.size() == 0) {
            this.debug("Error: no assignments yet");
            return "";
        }
        CTATCourseAssignment ass = this.assignments.entrySet().iterator().next().getValue();
        if (ass == null) {
            this.debug("Error getting first assignment");
            return "";
        }
        return ass.name;
    }

    public String getFirstProblemSet(String assignmentID) {
        CTATCourseAssignment assignment;
        this.debug("getFirstProblemSet (" + assignmentID + ")");
        this.debug("assignments.size (): " + this.assignments.size());
        String firstProblemSet = null;
        if (assignmentID != null && (assignment = this.assignments.get(assignmentID)) != null && assignment.numProbsets() > 0) {
            firstProblemSet = assignment.getProbsets().get((int)0).name;
        }
        return firstProblemSet;
    }

    public CTATCourseProbset getFirstProblemSetInstance(String assignmentID) {
        CTATCourseAssignment assignment;
        this.debug("getFirstProblemSetInstance (" + assignmentID + ")");
        if (assignmentID != null && (assignment = this.assignments.get(assignmentID)) != null && assignment.numProbsets() > 0) {
            return assignment.getProbsets().get(0);
        }
        return null;
    }

    public ArrayList<CTATProblemSet> getProblemSets(String assignmentID) {
        this.debug("getProblemSets (" + assignmentID + ")");
        if (!assignmentID.isEmpty()) {
            CTATCourseAssignment assignment = this.assignments.get(assignmentID);
            if (assignment != null) {
                this.debug("We have an assignment object");
                ArrayList<CTATProblemSet> pSets = new ArrayList<CTATProblemSet>();
                if (assignment.getProbsets() != null) {
                    for (int i = 0; i < assignment.numProbsets(); ++i) {
                        CTATCourseProbset testSet = assignment.getProbsets().get(i);
                        if (testSet != null) {
                            if (testSet.ctatProblemSet != null) {
                                pSets.add(testSet.ctatProblemSet);
                                continue;
                            }
                            this.debug("Oops, problem set not loaded yet!");
                            continue;
                        }
                        this.debug("Error getting problem set " + i);
                    }
                } else {
                    this.debug("Error: assignment.probsets==null");
                }
                return pSets;
            }
            this.debug("Error: unable to get assignment object for id: " + assignmentID);
            return null;
        }
        return null;
    }

    public String getProblemSetActivationStatus(String problemSetName) {
        this.debug("getProblemSetActivationStatus (" + problemSetName + ")");
        String problemSetActivationStatus = null;
        Collection<CTATCourseAssignment> collection = this.assignments.values();
        block0: for (CTATCourseAssignment assignment : collection) {
            for (CTATCourseProbset probset : assignment.getProbsets()) {
                if (!problemSetName.equals(probset.name)) continue;
                problemSetActivationStatus = probset.activation_status;
                continue block0;
            }
        }
        return problemSetActivationStatus;
    }

    public String getAssignment(String studentAssignmentName) {
        CTATCourseAssignment answer = this.getAssignmentInternal(studentAssignmentName);
        return answer == null ? null : answer.name;
    }

    public String getNextStudentAssignment(String currentStudentAssignment) {
        this.debug("getNextStudentAssignment (" + currentStudentAssignment + ")");
        String answer = null;
        CTATCourseAssignment assignment = this.getAssignmentInternal(currentStudentAssignment);
        if (assignment != null) {
            List<CTATCourseProbset> probsets = assignment.getProbsets();
            Iterator<CTATCourseProbset> iter = probsets.iterator();
            while (iter.hasNext()) {
                CTATCourseProbset thisProbset = iter.next();
                if (!currentStudentAssignment.equals(thisProbset.name)) continue;
                if (!iter.hasNext()) break;
                answer = iter.next().name;
                break;
            }
        }
        return answer;
    }

    public int getNumberOfProblemsInProbset(String studentAssignmentName) {
        this.debug("getNumberOfProblemsInProbset (" + studentAssignmentName + ")");
        CTATProblemSet ctatProblemSet = this.getProblemSet(studentAssignmentName);
        if (ctatProblemSet != null) {
            return ctatProblemSet.getNumProblems();
        }
        return 0;
    }

    public CTATProblemSet getProblemSet(String problemSetName) {
        this.debug("getProblemSet (" + problemSetName + ")");
        CTATProblemSet answer = null;
        CTATCourseAssignment assignment = this.getAssignmentInternal(problemSetName);
        if (assignment != null) {
            List<CTATCourseProbset> probsets = assignment.getProbsets();
            for (CTATCourseProbset probset : probsets) {
                if (!problemSetName.equals(probset.name)) continue;
                if (probset.ctatProblemSet == null) {
                    this.loadProblemSet(probset);
                }
                answer = probset.ctatProblemSet;
                break;
            }
        }
        return answer;
    }

    public String getAssignmentStatus(String assignmentName) {
        CTATCourseAssignment assignment;
        this.debug("getAssignmentStatus (" + assignmentName + ")");
        String status = null;
        if (assignmentName != null && (assignment = this.assignments.get(assignmentName)) != null) {
            status = assignment.status == null ? "" : assignment.status;
        }
        return status;
    }

    public String getProblemSetStatus(String problemSetName) {
        this.debug("getProblemSetStatus (" + problemSetName + ")");
        String status = null;
        CTATCourseAssignment assignment = this.getAssignmentInternal(problemSetName);
        if (assignment != null) {
            List<CTATCourseProbset> probsets = assignment.getProbsets();
            for (CTATCourseProbset probset : probsets) {
                if (!problemSetName.equals(probset.name)) continue;
                status = probset.status == null ? "" : probset.status;
                break;
            }
        }
        return status;
    }

    public boolean setAssignmentStatus(String assignmentName, String status) {
        CTATCourseAssignment assignment;
        this.debug("setAssignmentStatus (" + assignmentName + "," + status + ")");
        boolean success = false;
        if (assignmentName != null && (assignment = this.assignments.get(assignmentName)) != null) {
            assignment.status = status == null ? "" : status;
            success = true;
        }
        return success;
    }

    public boolean setProblemSetStatus(String problemSetName, String status) {
        this.debug("setProblemSetStatus (" + problemSetName + "," + status + ")");
        boolean success = false;
        CTATCourseAssignment assignment = this.getAssignmentInternal(problemSetName);
        if (assignment != null) {
            List<CTATCourseProbset> probsets = assignment.getProbsets();
            for (CTATCourseProbset probset : probsets) {
                if (!problemSetName.equals(probset.name)) continue;
                probset.status = status == null ? "" : status;
                success = true;
                break;
            }
        }
        return success;
    }

    private CTATCourseAssignment getAssignmentInternal(String studentAssignmentName) {
        this.debug("getAssignmentInternal (" + studentAssignmentName + ")");
        CTATCourseAssignment answer = null;
        Collection<CTATCourseAssignment> collection = this.assignments.values();
        block0: for (CTATCourseAssignment thisAssignment : collection) {
            for (CTATCourseProbset probset : thisAssignment.getProbsets()) {
                if (!studentAssignmentName.equals(probset.name)) continue;
                answer = thisAssignment;
                break block0;
            }
        }
        return answer;
    }

    private void loadProblemSet(CTATCourseProbset probset) {
        boolean success;
        File f;
        this.debug("loadProblemSet (Probset)");
        CTATProblemSet ctatProblemSet = new CTATProblemSet();
        this.debug("problemSetsPath: " + this.problemSetsPath + ", probset.activation_status: " + probset.activation_status + ", probset.name: " + probset.name);
        String path = this.problemSetsPath + probset.activation_status + "/" + probset.subdirectory + "/problem_set.xml";
        this.debug("Attempting to load file: " + path);
        if (CTATLink.allowWriting && !(f = new File(path)).exists()) {
            try {
                f.getParentFile().mkdirs();
                f.createNewFile();
                String xml = new CTATURLFetch().fetchURL("http://" + CTATLink.remoteHost + "/tutors/problem_sets/" + probset.activation_status + "/" + probset.subdirectory + "/problem_set.xml");
                CTATLink.fManager.setContents(path, xml);
            }
            catch (Exception e) {
                return;
            }
        }
        if (success = ctatProblemSet.loadProblemSet(path)) {
            probset.ctatProblemSet = ctatProblemSet;
        }
        if (success && CTATLink.allowWriting) {
            List<CTATProblem> problems = ctatProblemSet.getAllProblems();
            for (CTATProblem problem : problems) {
                if (problem == null) continue;
                String brdName = problem.problem_file;
                String brdPath = this.problemSetsPath + probset.activation_status + "/" + probset.subdirectory + "/FinalBRDs/" + brdName;
                File brdFile = new File(brdPath);
                if (brdFile.exists()) continue;
                try {
                    brdFile.getParentFile().mkdirs();
                    brdFile.createNewFile();
                    String brdContents = new CTATURLFetch().fetchURL("http://" + CTATLink.remoteHost + "/tutors/problem_sets/" + probset.activation_status + "/" + probset.subdirectory + "/FinalBRDs/" + brdName);
                    CTATLink.fManager.setContents(brdPath, brdContents);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("<curriculum>");
        Collection<CTATCourseAssignment> collection = this.assignments.values();
        for (CTATCourseAssignment assignment : collection) {
            sb.append("<assignment");
            if (assignment.name != null) {
                sb.append(" name=\"" + assignment.name + "\"");
            }
            if (assignment.status != null) {
                sb.append(" status=\"" + assignment.status + "\"");
            }
            sb.append(">");
            for (CTATCourseProbset probset : assignment.getProbsets()) {
                sb.append("<problemset");
                if (probset.name != null) {
                    sb.append(" name=\"" + probset.name + "\"");
                }
                if (probset.status != null) {
                    sb.append(" status=\"" + probset.status + "\"");
                }
                sb.append(" />");
            }
            sb.append("</assignment>");
        }
        sb.append("</curriculum>");
        return sb.toString();
    }

    public Collection<String> getRequiredProblemSets() {
        this.debug("getRequiredProblemSets ()");
        HashSet<String> result = new HashSet<String>();
        Collection<CTATCourseAssignment> assignmentCollection = this.assignments.values();
        this.debug("Found " + assignmentCollection.size() + " eligible course assignments");
        for (CTATCourseAssignment assignment : assignmentCollection) {
            List<CTATCourseProbset> probsetCollection = assignment.getProbsets();
            this.debug("Processing assignment " + assignment.name + " with " + probsetCollection.size() + " problem sets...");
            for (CTATCourseProbset probset : probsetCollection) {
                result.add(this.relativePathPrefix + probset.activation_status + "/" + probset.subdirectory + "/problem_set.xml");
            }
        }
        return result;
    }

    public Collection<String> getRequiredAssets(String server) {
        this.debug("getRequiredAssets ()");
        HashSet<String> result = new HashSet<String>();
        Collection<CTATCourseProbset> probsets = this.loadAllProblemSets();
        for (CTATCourseProbset probset : probsets) {
            if (probset.ctatProblemSet != null) {
                int num = probset.ctatProblemSet.getNumProblems();
                for (int i = 0; i < num; ++i) {
                    probset.ctatProblemSet.setCurrentIndex(i);
                    String pathSearch = this.relativePathPrefix + probset.activation_status + "/" + probset.subdirectory + "/Flash/Assets.xml";
                    CTATAssetManager assetManager = new CTATAssetManager();
                    ArrayList<String> assetList = assetManager.downloadAssets(pathSearch, server);
                    for (int t = 0; t < assetList.size(); ++t) {
                        result.add(assetList.get(t));
                    }
                }
                continue;
            }
            this.debug("Internal error: ctatProblemSet attribute in problem set container is null");
        }
        return result;
    }

    public Collection<String> getRequiredBRDs() {
        this.debug("getRequiredBRDs ()");
        HashSet<String> result = new HashSet<String>();
        Collection<CTATCourseProbset> probsets = this.loadAllProblemSets();
        for (CTATCourseProbset probset : probsets) {
            if (probset.ctatProblemSet != null) {
                int num = probset.ctatProblemSet.getNumProblems();
                for (int i = 0; i < num; ++i) {
                    probset.ctatProblemSet.setCurrentIndex(i);
                    CTATProblem ctatProblem = probset.ctatProblemSet.getNextProblem();
                    result.add(this.relativePathPrefix + probset.activation_status + "/" + probset.subdirectory + "/FinalBRDs/" + ctatProblem.problem_file);
                }
                continue;
            }
            this.debug("Internal error: ctatProblemSet attribute in problem set container is null");
        }
        return result;
    }

    public Collection<String> getRequiredSWFs() {
        this.debug("getRequiredSWFs ()");
        HashSet<String> result = new HashSet<String>();
        Collection<CTATCourseProbset> probsets = this.loadAllProblemSets();
        for (CTATCourseProbset probset : probsets) {
            if (probset.ctatProblemSet != null) {
                int num = probset.ctatProblemSet.getNumProblems();
                for (int i = 0; i < num; ++i) {
                    probset.ctatProblemSet.setCurrentIndex(i);
                    CTATProblem ctatProblem = probset.ctatProblemSet.getNextProblem();
                    result.add(this.relativePathPrefix + probset.activation_status + "/" + probset.subdirectory + "/Flash/" + ctatProblem.student_interface);
                }
                continue;
            }
            this.debug("Internal error: ctatProblemSet attribute in problem set container is null");
        }
        return result;
    }

    public Collection<CTATCourseProbset> loadAllProblemSets() {
        this.debug("loadAllProblemSets ()");
        HashSet<CTATCourseProbset> result = new HashSet<CTATCourseProbset>();
        Collection<CTATCourseAssignment> collection = this.assignments.values();
        for (CTATCourseAssignment assignment : collection) {
            List<CTATCourseProbset> probsets = assignment.getProbsets();
            for (CTATCourseProbset probset : probsets) {
                if (probset.ctatProblemSet == null) {
                    this.loadProblemSet(probset);
                }
                result.add(probset);
            }
        }
        return result;
    }

    public String getInstructorName() {
        return this.instructorName == null ? "" : this.instructorName;
    }

    public String getSchoolName() {
        return this.schoolName;
    }

    public String getConditionName(String problemSetName) {
        if (problemSetName == null) {
            return "";
        }
        CTATCourseAssignment assignment = this.getAssignmentInternal(problemSetName);
        if (assignment == null) {
            return "";
        }
        return assignment.getConditionName();
    }
}

