/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.ctat;

import edu.cmu.hcii.ctat.CTATBase;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;

public class CTATCryptoUtils
extends CTATBase {
    public static final String AES = "AES";

    public String encrypt(String value, String keyString) throws GeneralSecurityException {
        this.debug("encrypt ()");
        SecretKeySpec sks = this.getSecretKeySpec(keyString);
        Cipher cipher = Cipher.getInstance(AES);
        cipher.init(1, (Key)sks, cipher.getParameters());
        byte[] encrypted = cipher.doFinal(value.getBytes());
        return this.byteArrayToHexString(encrypted);
    }

    public String decrypt(String message, String keyString) throws GeneralSecurityException {
        this.debug("decrypt ()");
        SecretKeySpec sks = this.getSecretKeySpec(keyString);
        Cipher cipher = Cipher.getInstance(AES);
        cipher.init(2, sks);
        byte[] decrypted = cipher.doFinal(this.hexStringToByteArray(message));
        return new String(decrypted);
    }

    private SecretKeySpec getSecretKeySpec(String keyString) throws NoSuchAlgorithmException {
        this.debug("getSecretKeySpec ()");
        byte[] key = this.hexStringToByteArray(keyString);
        SecretKeySpec sks = new SecretKeySpec(key, AES);
        return sks;
    }

    private String byteArrayToHexString(byte[] b) {
        this.debug("byteArrayToHexString ()");
        StringBuffer sb = new StringBuffer(b.length * 2);
        for (int i = 0; i < b.length; ++i) {
            int v = b[i] & 0xFF;
            if (v < 16) {
                sb.append('0');
            }
            sb.append(Integer.toHexString(v));
        }
        return sb.toString().toUpperCase();
    }

    private byte[] hexStringToByteArray(String s) {
        this.debug("hexStringToByteArray ()");
        byte[] b = new byte[s.length() / 2];
        for (int i = 0; i < b.length; ++i) {
            int index = i * 2;
            int v = Integer.parseInt(s.substring(index, index + 2), 16);
            b[i] = (byte)v;
        }
        return b;
    }
}

