/*
 * Decompiled with CFR 0.152.
 */
package pact.CommWidgets;

import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.ctat.MessageObject;
import edu.cmu.pact.ctat.TutorController;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.text.Highlighter;
import pact.CommWidgets.ComboboxComponent;
import pact.CommWidgets.JCommQuestion;
import pact.CommWidgets.event.IncorrectActionEvent;
import pact.CommWidgets.event.IncorrectActionListener;
import pact.CommWidgets.event.StudentActionEvent;
import pact.CommWidgets.event.StudentActionListener;

public class JCommQuestionComboBox
extends JCommQuestion
implements ActionListener,
ItemListener {
    private ArrayList componentList = new ArrayList();
    private String choicesText = "[choice1, choice2]";
    private int nComponents = 1;
    private int questionLayout = 1;
    private static int counter = 0;
    JButton submitBtn;
    private boolean alreadyDone = false;
    private boolean sameSize = false;
    String previousValue = "";
    protected Highlighter defaultHighlighter;
    protected String resetValue = "";
    protected String values = "";
    protected Vector comboBoxStrings;
    protected Vector comboBoxStringColors;
    protected int sizeOfComboBoxStrings;
    protected JPanel container;
    protected boolean actionFromBR;
    protected boolean locked;
    protected boolean setValuesDone = true;
    private JPanel buttonPanel = new JPanel();
    private JLabel endLabel = new JLabel();

    public JCommQuestionComboBox() {
        this.setActionName("UpdateQuestionComboBox");
        this.locked = false;
        this.questionText = this.questionText + ", question part-2";
        this.actionFromBR = false;
        this.createQuestionPanel();
    }

    private void createQuestionPanel() {
        int i;
        this.removeAll();
        if (this.questionLayout == 1) {
            this.setLayout(new FlowLayout());
        } else {
            this.setLayout(new GridLayout(0, 1));
        }
        for (i = 0; i < this.nComponents; ++i) {
            ComboboxComponent component;
            if (this.componentList.size() <= i || this.componentList.get(i) == null) {
                component = new ComboboxComponent();
                component.addActionListener(this);
                this.componentList.add(component);
            } else {
                component = (ComboboxComponent)this.componentList.get(i);
            }
            this.add(component);
        }
        this.endLabel.setFocusable(false);
        this.add(this.endLabel);
        if (this.nComponents > 1) {
            if (this.submitBtn == null) {
                this.submitBtn = new JButton("Submit");
                this.submitBtn.addActionListener(this);
            }
            this.buttonPanel.add(this.submitBtn);
        } else if (this.submitBtn != null) {
            this.buttonPanel.remove(this.submitBtn);
        }
        this.separateQuestionList();
        this.separateTextList();
        for (i = this.nComponents; i < this.componentList.size(); ++i) {
            this.componentList.remove(i);
        }
        this.add(this.buttonPanel);
        this.validate();
        this.repaint();
    }

    private void separateQuestionList() {
        StringTokenizer st = new StringTokenizer(this.questionText, ",");
        int i = 0;
        while (st.hasMoreTokens() && i < this.nComponents) {
            ((ComboboxComponent)this.componentList.get(i++)).setLabelTxt(st.nextToken());
        }
        while (i < this.nComponents) {
            ((ComboboxComponent)this.componentList.get(i++)).setLabelTxt("");
        }
        if (st.hasMoreTokens()) {
            this.endLabel.setText(st.nextToken());
        } else {
            this.endLabel.setText("");
        }
        this.validate();
    }

    private void separateTextList() {
        StringBuffer sb = new StringBuffer(this.choicesText);
        int startIndex = 0;
        int i = 0;
        do {
            if ((startIndex = sb.indexOf("[", startIndex)) == -1) continue;
            int endIndex = sb.indexOf("]", startIndex);
            ((ComboboxComponent)this.componentList.get(i++)).addTextToCombobox(sb.substring(startIndex + 1, endIndex));
            startIndex = endIndex + 1;
        } while (startIndex > 0 && startIndex < sb.length() && i < this.nComponents);
    }

    @Override
    protected boolean initialize() {
        this.alreadyDone = false;
        if (!super.initialize()) {
            return false;
        }
        this.addStudentActionListener((StudentActionListener)((Object)this.getController().getStudentInterface().getHintInterface()));
        this.addIncorrectActionListener((IncorrectActionListener)((Object)this.getController().getStudentInterface().getHintInterface()));
        this.addCommWidgetName(this.commName);
        this.addCommListener();
        if (this.getController().isShowWidgetInfo()) {
            this.setToolTipWidgetInfo();
        }
        return true;
    }

    @Override
    public Object getValue() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.nComponents; ++i) {
            String obj = ((ComboboxComponent)this.componentList.get(i)).getValue();
            if (obj == null) continue;
            sb.append(obj);
            if (i + 1 >= this.nComponents) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    @Override
    public void doCorrectAction(String selection, String action, String input) {
        if ("SetVisible".equalsIgnoreCase(action)) {
            if (trace.getDebugCode("inter")) {
                trace.out("inter", "SetVisible: " + input);
            }
            this.setVisible(input);
        } else {
            this.actionFromBR = true;
            this.setSelectedValues(input, this.correctColor);
            if (this.getUniversalToolProxy().lockWidget()) {
                this.locked = true;
            }
            if (!this.alreadyDone) {
                this.fireStudentAction(new StudentActionEvent(this));
                this.alreadyDone = true;
            }
            this.dirty = false;
            this.actionFromBR = false;
        }
    }

    @Override
    public void doLISPCheckAction(String selection, String input) {
        this.actionFromBR = true;
        this.setSelectedValues(input, this.LISPCheckColor);
        if (this.getUniversalToolProxy().lockWidget()) {
            this.locked = true;
        }
        this.actionFromBR = false;
    }

    @Override
    public void doIncorrectAction(String selection, String input) {
        this.actionFromBR = true;
        this.setSelectedValues(input, this.incorrectColor);
        this.locked = false;
        this.alreadyDone = false;
        this.fireIncorrectAction(new IncorrectActionEvent(this));
        this.actionFromBR = false;
    }

    @Override
    public void doInterfaceAction(String selection, String action, String input) {
        this.actionFromBR = true;
        this.locked = false;
        this.setSelectedValues(input, this.startColor);
        if (action.equalsIgnoreCase("UpdateInVisible")) {
            if (trace.getDebugCode("inter")) {
                trace.out("inter", "Set InVisible: " + input);
            }
            if (input.equalsIgnoreCase("true")) {
                this.setInvisible(true);
            } else {
                this.setInvisible(false);
            }
            this.setVisible(!this.isInvisible());
            return;
        }
        if ("SetVisible".equalsIgnoreCase(action)) {
            if (trace.getDebugCode("inter")) {
                trace.out("inter", "SetVisible: " + input);
            }
            this.setVisible(input);
            return;
        }
        if (this.getController().isStartStateInterface()) {
            this.locked = true;
        }
        this.actionFromBR = false;
    }

    public void setSelectedValues(String input, Color color) {
        StringTokenizer st = new StringTokenizer(input, ",");
        int i = 0;
        while (st.hasMoreTokens()) {
            if (i >= this.componentList.size()) continue;
            ComboboxComponent combo = (ComboboxComponent)this.componentList.get(i++);
            combo.setColor(color);
            combo.setValue(st.nextToken());
            combo.repaint();
        }
    }

    @Override
    public MessageObject getDescriptionMessage() {
        MessageObject mo = MessageObject.create("InterfaceDescription");
        mo.setVerb("SendNoteProperty");
        if (!this.initialize()) {
            trace.out(5, this, "ERROR!: Can't create Comm message because can't initialize.  Returning empty comm message");
            return null;
        }
        mo.setProperty("WidgetType", "CommQuestionCombobox");
        mo.setProperty("CommName", this.commName);
        mo.setProperty("UpdateEachCycle", new Boolean(this.updateEachCycle));
        Vector deftemplates = this.createJessDeftemplates();
        Vector instances = this.createJessInstances();
        if (deftemplates != null) {
            mo.setProperty("jessDeftemplates", deftemplates);
        }
        if (instances != null) {
            mo.setProperty("jessInstances", instances);
        }
        this.serializeGraphicalProperties(mo);
        return mo;
    }

    @Override
    public boolean isChangedFromResetState() {
        for (int i = 0; i < this.nComponents; ++i) {
            ComboboxComponent combo = (ComboboxComponent)this.componentList.get(i);
            if (!combo.getValue().equals("")) continue;
            return false;
        }
        return true;
    }

    @Override
    public void reset(TutorController controller) {
        this.alreadyDone = false;
        this.initialize();
        this.locked = false;
        this.actionFromBR = false;
        this.setEnabled(true);
        for (int i = 0; i < this.nComponents; ++i) {
            ComboboxComponent combo = (ComboboxComponent)this.componentList.get(i);
            combo.setValue("");
            combo.setForeground(this.startColor);
        }
    }

    @Override
    public void setSize(Dimension d) {
        super.setSize(d);
    }

    @Override
    public Vector createJessDeftemplates() {
        Vector<String> deftemplates = new Vector<String>();
        String choiceTemplate = "(deftemplate questionCombobox (slot name) (slot value) (slot question))";
        deftemplates.add(choiceTemplate);
        return deftemplates;
    }

    @Override
    public Vector createJessInstances() {
        Vector<String> instances = new Vector<String>();
        String str = "(bind ?" + this.getCommName() + " (assert (questionCombobox (name " + this.getCommName() + "))))";
        instances.add(str);
        return instances;
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        JCommQuestionComboBox qcb = new JCommQuestionComboBox();
        frame.getContentPane().setLayout(new FlowLayout());
        frame.getContentPane().add(qcb);
        frame.pack();
        frame.show();
        qcb.setNPairs(2);
        qcb.setQuestionLayout(1);
        qcb.setQuestionText("Question1, Question2, Question3");
        qcb.setChoicesText("[x, y, z][a, ][p, q, r]");
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        this.removeHighlight(this.commName);
        Object source = ae.getSource();
        String selectedValue = this.getValue().toString();
        if (this.actionFromBR) {
            return;
        }
        if (!this.locked && this.initialized && !selectedValue.equals("")) {
            if (this.submitBtn != null && source.equals(this.submitBtn)) {
                this.previousValue = this.getValue().toString();
                this.dirty = true;
                this.sendValue();
                return;
            }
            if (source.getClass().equals(JComboBox.class) && !selectedValue.equals("")) {
                if (this.nComponents == 1) {
                    this.previousValue = selectedValue;
                    this.dirty = true;
                    this.sendValue();
                } else {
                    ((JComboBox)source).setForeground(this.startColor);
                }
            }
        } else if (this.locked && !this.previousValue.equals("") && !this.previousValue.equals(this.getValue())) {
            this.setSelectedValues(this.previousValue, this.correctColor);
        }
    }

    @Override
    public void highlight(String subElement, Border highlightBorder) {
        this.setBorder(highlightBorder);
    }

    @Override
    public void removeHighlight(String subElement) {
        this.setBorder(this.originalBorder);
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
    }

    public synchronized String getChoicesText() {
        return this.choicesText;
    }

    public synchronized void setChoicesText(String choicesText) {
        this.choicesText = choicesText;
        this.separateTextList();
        this.validate();
    }

    public synchronized int getNPairs() {
        return this.nComponents;
    }

    public synchronized void setNPairs(int pairs) {
        this.nComponents = pairs;
        this.createQuestionPanel();
        this.validate();
    }

    public synchronized int getQuestionLayout() {
        return this.questionLayout;
    }

    public synchronized void setQuestionLayout(int pairLayout) {
        this.questionLayout = pairLayout;
        this.createQuestionPanel();
        this.validate();
    }

    @Override
    public void setQuestionText(String text) {
        this.questionText = text;
        this.separateQuestionList();
        this.validate();
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
    }

    @Override
    public String getCommNameToSend() {
        String s = this.commName;
        return s;
    }
}

