/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.miss.console.view;

import edu.cmu.pact.BehaviorRecorder.Controller.BR_Controller;
import edu.cmu.pact.miss.console.controller.MissController;
import edu.cmu.pact.miss.console.controller.MissMouseHandler;
import java.awt.Color;
import java.awt.Dimension;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;

public class MissConsole
extends JRootPane {
    private final String toolName = "Simulated Student Console";
    private final String version = "Ver. 1.00";
    private final int WIDTH = 550;
    private final int HEIGHT = 400;
    private final double MARGIN_RATE = 0.95;
    private final double MA_RATE = 0.2;
    private final int MA_WIDTH = 522;
    private final int MA_HEIGHT = 76;
    private final int MA_TOP_MARGIN = 20;
    private final int TP_WIDTH = 522;
    private final int TP_HEIGHT = 307;
    private final int PROBLEM_WIDTH = 261;
    private final int PROBLEM_HEIGHT = 307;
    private final int BK_WIDTH = 261;
    private final int BK_HEIGHT = 307;
    private JTabbedPane taskPane;
    private final String PROBLEM_TP_NAME = "Problems";
    private final String CURRENT_DEMO_NAME = "Current Demo.";
    private final String BK_TP_NAME = "Background Knowledge";
    private JList problemList = new JList();
    private Vector problemListVector = new Vector();
    private JList skillNameList = new JList();
    private final String WME_TYPE_FILE_LABEL = "File name for WME Types:";
    private final String INIT_WME_FILE_LABEL = "File name for initial WMEs:";
    private final String NOT_GIVEN = "Not given";
    private JLabel wmeTypeFileLabel = new JLabel();
    private JLabel initWmeFileLabel = new JLabel();
    private JList featureList = new JList();
    private JList operatorList = new JList();
    private JLabel currentProblemName = new JLabel("N/A");
    private JLabel numStepsDemonstrated = new JLabel("N/A");
    private JLabel numProductionRules = new JLabel("N/A");
    private JLabel percentStepsModelTraced = new JLabel("N/A");
    private JTextArea messageArea = new JTextArea();
    private MissController missController;
    private JMenuItem missHibernationMenu = new JMenuItem("Hibernate Sim.St");

    String getToolName() {
        return "Simulated Student Console";
    }

    String getVersion() {
        return "Ver. 1.00";
    }

    JTabbedPane getTaskPane() {
        return this.taskPane;
    }

    void setTaskPane(JTabbedPane taskPane) {
        this.taskPane = taskPane;
    }

    private JList getProblemList() {
        return this.problemList;
    }

    public void addProblemList(String problem) {
        this.problemListVector.add(problem);
        this.problemList.setListData(this.problemListVector);
    }

    private JList getSkillNameList() {
        return this.skillNameList;
    }

    public void updateSkillNameList(Vector skillNames) {
        this.skillNameList.setListData(skillNames);
    }

    private JLabel getWmeTypeFileLabel() {
        return this.wmeTypeFileLabel;
    }

    public void setWmeTypeFileLabel(String text) {
        this.wmeTypeFileLabel.setText(text);
    }

    private JLabel getInitWmeFileLabel() {
        return this.initWmeFileLabel;
    }

    public void setInitWmeFileLabel(String text) {
        this.initWmeFileLabel.setText(text);
    }

    private JList getFeatureList() {
        return this.featureList;
    }

    private JList getOperatorList() {
        return this.operatorList;
    }

    private JLabel getCurrentProblemName() {
        return this.currentProblemName;
    }

    public void setCurrentProblemName(String name) {
        this.currentProblemName.setText(name);
    }

    public JLabel getNumStepsDemonstrated() {
        return this.numStepsDemonstrated;
    }

    public void setNumStepsDemonstrated(int n) {
        this.numStepsDemonstrated.setText("" + n);
    }

    public JLabel getNumProductionRules() {
        return this.numProductionRules;
    }

    public void setNumProductionRules(int n) {
        this.numProductionRules.setText("" + n);
    }

    private JLabel getPercentStepsModelTraced() {
        return this.percentStepsModelTraced;
    }

    private void setPercentStepsModelTraced(double n) {
        this.percentStepsModelTraced.setText("" + n);
    }

    JTextArea getMessageArea() {
        return this.messageArea;
    }

    void setMessageArea(JTextArea messageArea) {
        this.messageArea = messageArea;
    }

    private MissController getMissController() {
        return this.missController;
    }

    private void setMissController(MissController missController) {
        this.missController = missController;
    }

    public MissConsole(MissController missController, BR_Controller brController) {
        this.setMissController(missController);
        this.setNativeLookAndFeel();
        this.setName(this.getToolName());
        this.initComponents();
        if (this.getMissController().getSimStInitStateFile() != null) {
            this.setInitWmeFileLabel(this.getMissController().getSimStInitStateFile());
        }
        if (this.getMissController().getSimStWmeTypeFile() != null) {
            this.setWmeTypeFileLabel(this.getMissController().getSimStWmeTypeFile());
        }
    }

    private void setNativeLookAndFeel() {
        String nativeLF = UIManager.getSystemLookAndFeelClassName();
        try {
            UIManager.setLookAndFeel(nativeLF);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.getMissController().getLogger().simStLogException(e);
        }
    }

    private void initComponents() {
        this.setContentPane(new JPanel());
        BoxLayout layout = new BoxLayout(this.getContentPane(), 1);
        this.getContentPane().setLayout(layout);
        this.setSize(550, 400);
        this.setGuiComponents();
    }

    public JMenuItem getMissHibernationMenu() {
        return this.missHibernationMenu;
    }

    private void setupMenu() {
        MissController missController = this.getMissController();
        MissMouseHandler mouseListener = new MissMouseHandler(missController);
        JMenuBar menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu("File");
        fileMenu.addMouseListener(mouseListener);
        menuBar.add(fileMenu);
        String[] menuItems = new String[]{"New Problem", null, "Save Instructions", "Load Instructions", null, "Load WME Types", "Initialize WMEs", "Load Feature Predicates", "Load Operators"};
        String[] toolTipText = new String[]{"This doesn't do anything currently.", null, "Save results of current demonstrations.", "Load results of previous demonstrations.", null, "Load WME types from specific file.", "Load initial WME definitions from file.", "Load predicate symbols from file.", "Load operator symbols from file."};
        this.setupMenuItems(fileMenu, menuItems, toolTipText, mouseListener);
        JMenu prodSysemMenu = new JMenu("Prod.System");
        prodSysemMenu.addMouseListener(mouseListener);
        menuBar.add(prodSysemMenu);
        String[] prodSysMenuItems = new String[]{"Test Current Model on..."};
        this.setupMenuItems(prodSysemMenu, prodSysMenuItems, null, mouseListener);
        JMenu debugMenu = new JMenu("Debugging...");
        menuBar.add(debugMenu);
        this.getMissHibernationMenu().addActionListener(mouseListener);
        debugMenu.add(this.getMissHibernationMenu());
        this.setJMenuBar(menuBar);
    }

    private void setupMenuItems(JMenu jMenu, String[] menuItems, String[] toolTips, MissMouseHandler mouseListener) {
        for (int i = 0; i < menuItems.length; ++i) {
            if (menuItems[i] != null) {
                JMenuItem menuItem = new JMenuItem(menuItems[i]);
                if (toolTips != null) {
                    menuItem.setToolTipText(toolTips[i]);
                }
                menuItem.addActionListener(mouseListener);
                jMenu.add(menuItem);
                continue;
            }
            jMenu.addSeparator();
        }
    }

    private void setGuiComponents() {
        this.setTaskPane(new JTabbedPane());
        JComponent problemTaskPane = this.makeProblemTaskPane();
        this.getTaskPane().addTab("Problems", problemTaskPane);
        JComponent currentDemoPane = this.makeCurrentDemonstrationPane();
        this.getTaskPane().addTab("Current Demo.", currentDemoPane);
        JComponent bkTaskPane = this.makeBkTaskPane();
        this.getTaskPane().addTab("Background Knowledge", bkTaskPane);
        this.getContentPane().add(this.getTaskPane());
        Dimension size = new Dimension(522, 76);
        this.getMessageArea().setPreferredSize(size);
        this.getMessageArea().setEditable(false);
        this.getContentPane().add(this.getMessageArea());
    }

    private JComponent makeProblemTaskPane() {
        JPanel problemTaskPane = new JPanel();
        Dimension problemListSize = new Dimension(261, 307);
        JPanel problemListPanel = new JPanel();
        BoxLayout layout = new BoxLayout(problemListPanel, 1);
        problemListPanel.setLayout(layout);
        problemListPanel.setPreferredSize(problemListSize);
        problemListPanel.add(new JLabel("List of Problems"));
        this.makeProblemList();
        problemListPanel.add(new JScrollPane(this.getProblemList()));
        problemTaskPane.add(problemListPanel);
        JPanel snPane = new JPanel();
        Dimension skillListSize = new Dimension(261, 307);
        snPane.setLayout(new BoxLayout(snPane, 1));
        snPane.add(new JLabel("Skill Names:"));
        JScrollPane jsp = new JScrollPane(this.getSkillNameList());
        snPane.add(jsp);
        snPane.setPreferredSize(skillListSize);
        problemTaskPane.add(snPane);
        return problemTaskPane;
    }

    private void makeProblemList() {
    }

    private void makeSkillNameList() {
    }

    private JComponent makeCurrentDemonstrationPane() {
        JPanel currentDemoPane = new JPanel();
        Color bColor = new Color(151, 224, 228);
        JPanel statPane = new JPanel();
        statPane.setBackground(bColor);
        statPane.setLayout(new BoxLayout(statPane, 1));
        JPanel cpPane = new JPanel();
        cpPane.add(new JLabel("Currrent Problem: "));
        cpPane.add(this.getCurrentProblemName());
        statPane.add(cpPane);
        JPanel sdPane = new JPanel();
        sdPane.add(new JLabel("Num steps demonstrated: "));
        sdPane.add(this.getNumStepsDemonstrated());
        statPane.add(sdPane);
        JPanel prPane = new JPanel();
        prPane.add(new JLabel("Num production rules: "));
        prPane.add(this.getNumProductionRules());
        statPane.add(prPane);
        JPanel mtPane = new JPanel();
        mtPane.add(new JLabel("% steps model traced: "));
        mtPane.add(this.getPercentStepsModelTraced());
        statPane.add(mtPane);
        currentDemoPane.add(statPane);
        return currentDemoPane;
    }

    private JComponent makeBkTaskPane() {
        int listWidth = 165;
        int listHeight = 260;
        JPanel bkTaskPane = new JPanel();
        bkTaskPane.setBackground(Color.cyan);
        BoxLayout bkLayout = new BoxLayout(bkTaskPane, 1);
        bkTaskPane.setLayout(bkLayout);
        JPanel wmeFilePane = new JPanel();
        BoxLayout wfLayout = new BoxLayout(wmeFilePane, 1);
        wmeFilePane.setLayout(wfLayout);
        JPanel wmeTypeLabelPane = new JPanel();
        JLabel wmeTypeLabel = new JLabel("File name for WME Types:");
        wmeTypeLabelPane.add(wmeTypeLabel);
        this.setWmeTypeFileLabel("Not given");
        wmeTypeLabelPane.add(this.getWmeTypeFileLabel());
        wmeFilePane.add(wmeTypeLabelPane);
        JPanel initWmeLabelPane = new JPanel();
        JLabel initWmeLabel = new JLabel("File name for initial WMEs:");
        initWmeLabelPane.add(initWmeLabel);
        this.setInitWmeFileLabel("Not given");
        initWmeLabelPane.add(this.getInitWmeFileLabel());
        wmeFilePane.add(initWmeLabelPane);
        JPanel symbolPane = new JPanel();
        Dimension bkListSize = new Dimension(261, 307);
        JPanel featureListPane = new JPanel();
        featureListPane.setBackground(Color.red);
        BoxLayout flLayout = new BoxLayout(featureListPane, 1);
        featureListPane.setLayout(flLayout);
        featureListPane.add(new JLabel("Features:"));
        int lsm = 2;
        this.getFeatureList().setSelectionMode(lsm);
        MissMouseHandler ml = new MissMouseHandler(this.getMissController());
        this.getFeatureList().addListSelectionListener(ml);
        JScrollPane jsp1 = new JScrollPane(this.getFeatureList());
        jsp1.setPreferredSize(bkListSize);
        featureListPane.add(jsp1);
        JPanel opListPane = new JPanel();
        opListPane.setBackground(Color.pink);
        BoxLayout olLayout = new BoxLayout(opListPane, 1);
        opListPane.setLayout(olLayout);
        opListPane.add(new JLabel("Operators:"));
        this.getOperatorList().setSelectionMode(lsm);
        this.getOperatorList().addListSelectionListener(ml);
        JScrollPane jsp2 = new JScrollPane(this.getOperatorList());
        jsp2.setPreferredSize(bkListSize);
        opListPane.add(jsp2);
        symbolPane.add(featureListPane);
        symbolPane.add(opListPane);
        bkTaskPane.add(wmeFilePane);
        bkTaskPane.add(symbolPane);
        return bkTaskPane;
    }

    public void message(String text) {
        this.messageArea.setText(text);
    }

    public void clearMessage() {
        this.messageArea.setText("");
    }

    public void displayPredicates(Vector predicates) {
        this.getFeatureList().setListData(predicates);
    }

    public void displayOperators(Vector operators) {
        this.getOperatorList().setListData(operators);
    }

    public void switchMissHibernationMenu(boolean status) {
        this.getMissHibernationMenu().setText(status ? "Wakeup Sim.St" : "Hibernate Sim.St");
    }
}

