/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.jess;

import edu.cmu.pact.BehaviorRecorder.Controller.BR_Controller;
import edu.cmu.pact.BehaviorRecorder.Controller.CTAT_Launcher;
import edu.cmu.pact.BehaviorRecorder.View.JUndo;
import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.ctat.view.AbstractCtatWindow;
import edu.cmu.pact.ctatview.JHorizontalTable;
import edu.cmu.pact.jess.MT;
import edu.cmu.pact.jess.MTRete;
import edu.cmu.pact.jess.WMEEditor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import jess.Deftemplate;
import jess.Fact;
import jess.FactIDValue;
import jess.JessException;
import jess.Rete;
import jess.Value;
import jess.ValueVector;

public class WMEEditorPanel
extends JRootPane
implements ActionListener,
KeyListener,
MouseListener,
MouseMotionListener,
DocumentListener {
    private static final long serialVersionUID = -8607450228214776058L;
    private static final String cmFolderPrefix = "Cognitive Model Folder: ";
    private static final String NO_TEMPLATE_TEXT = "No template selected";
    private static final String NO_FACT_TEXT = "No fact selected";
    private MT mt;
    private CTAT_Launcher server;
    private BR_Controller controller;
    private JLabel cmFolderLabel;
    private final boolean inWhyNot;
    private WMEEditor wmeEditor;
    private AbstractCtatWindow parentFrame;
    JTextField filter;
    JTextField findFactByID;
    JLabel templateLabel;
    JLabel factLabel;
    JTextField templateField;
    JCheckBox reactive;
    JMenuItem deleteMenu;
    JMenuItem newFactMenu;
    JMenuItem newSlotMenu;
    JPopupMenu wmeTreePopup;
    JPopupMenu slotPopup;
    JSplitPane splitPane;
    Box top_pane;
    String lastProblem;
    String lastMode;

    public WMEEditorPanel(CTAT_Launcher server, WMEEditor editor, boolean doSetSize, boolean whyNot) {
        if (trace.getDebugCode("wme")) {
            trace.out("wme", String.format("WMEEditorPanel(%s, %s, %b, %b)", server, editor, doSetSize, whyNot));
        }
        this.server = server;
        this.parentFrame = this.server.getActiveWindow();
        this.inWhyNot = whyNot;
        this.lastProblem = "";
        this.lastMode = "";
        if (editor != null) {
            this.wmeEditor = editor;
            this.controller = this.server.getFocusedController();
        } else {
            this.wmeEditor = this.server.getFocusedController().getModelTracer().getWmeEditor();
        }
        this.mt = this.wmeEditor.getRete().getMT();
        this.setName("WM Editor Window");
        this.cmFolderLabel = new JLabel();
        this.cmFolderLabel.setName("WME Folder Label");
        this.cmFolderLabel.setAlignmentX(0.5f);
        if (this.server.isDoneIntializing()) {
            this.displayCognitiveModelFolder();
        }
        this.top_pane = new Box(0);
        JRadioButton PreButton = new JRadioButton("Show Pre");
        JRadioButton PostButton = new JRadioButton("Show Post");
        if (this.getPostRete() == null) {
            PreButton.setVisible(false);
            PostButton.setVisible(false);
        } else {
            PreButton.setVisible(true);
            PostButton.setVisible(true);
        }
        ButtonGroup ShowWMEButtonGroup = new ButtonGroup();
        PreButton.addActionListener(this);
        PostButton.addActionListener(this);
        PreButton.setActionCommand("ShowPre");
        PostButton.setActionCommand("ShowPost");
        ShowWMEButtonGroup.add(PreButton);
        ShowWMEButtonGroup.add(PostButton);
        PreButton.setSelected(true);
        this.top_pane.add(PreButton);
        this.top_pane.add(PostButton);
        this.filter = new JTextField(25);
        JUndo.makeTextUndoable(this.filter);
        this.filter.setName("WME Filter");
        this.filter.setMaximumSize(new Dimension(50, 20));
        this.filter.getDocument().addDocumentListener(this);
        this.top_pane.add(Box.createHorizontalGlue());
        this.top_pane.add(new JLabel(" Search by name:"));
        this.top_pane.add(this.filter);
        this.findFactByID = new JTextField(5);
        JUndo.makeTextUndoable(this.findFactByID);
        this.findFactByID.setName("WME Find Fact");
        this.findFactByID.setMaximumSize(new Dimension(5, 20));
        this.findFactByID.setActionCommand("findFactByID");
        this.findFactByID.addActionListener(this);
        this.top_pane.add(new JLabel(" Search by fact ID:"));
        this.top_pane.add(this.findFactByID);
        JTree wmeTree = this.wmeEditor.getWMETree();
        wmeTree.addMouseListener(this);
        wmeTree.addMouseMotionListener(this);
        wmeTree.addKeyListener(this);
        JScrollPane treeScroll = new JScrollPane(wmeTree);
        treeScroll.setPreferredSize(new Dimension(500, 600));
        treeScroll.setHorizontalScrollBarPolicy(30);
        JPanel panel4 = new JPanel();
        panel4.setLayout(new BoxLayout(panel4, 1));
        panel4.add(this.cmFolderLabel);
        panel4.add(treeScroll);
        panel4.setMinimumSize(new Dimension(600, 100));
        panel4.setPreferredSize(new Dimension(600, 300));
        JPanel panel7 = new JPanel();
        panel7.setLayout(new BoxLayout(panel7, 1));
        JScrollPane slotTableScroll = new JScrollPane(this.wmeEditor.getSlotTable());
        slotTableScroll.setAlignmentX(0.0f);
        slotTableScroll.setMinimumSize(new Dimension(400, 150));
        slotTableScroll.setPreferredSize(new Dimension(600, 250));
        slotTableScroll.setHorizontalScrollBarPolicy(30);
        Box templateBox = new Box(0);
        templateBox.setAlignmentX(0.0f);
        this.templateLabel = new JLabel(NO_TEMPLATE_TEXT);
        this.templateLabel.setName("WME Template Label");
        this.templateLabel.setAlignmentX(0.0f);
        this.templateField = new JTextField(20);
        JUndo.makeTextUndoable(this.templateField);
        this.templateField.setName("WME Template Name");
        this.templateField.setMaximumSize(new Dimension(150, 20));
        this.templateField.setVisible(false);
        this.templateField.addActionListener(this);
        this.templateField.setActionCommand("rename");
        this.reactive = new JCheckBox("Backwards Reactive");
        this.reactive.setName("WME Reactive");
        this.reactive.setEnabled(false);
        this.reactive.setAlignmentX(1.0f);
        this.reactive.setActionCommand("reactive");
        this.reactive.addActionListener(this);
        templateBox.add(this.templateLabel);
        templateBox.add(this.templateField);
        templateBox.add(Box.createRigidArea(new Dimension(10, 0)));
        templateBox.add(this.reactive);
        templateBox.setMaximumSize(new Dimension(500, 20));
        templateBox.add(Box.createHorizontalGlue());
        this.factLabel = new JLabel(NO_FACT_TEXT);
        this.factLabel.setName("WME Fact Label");
        this.factLabel.setAlignmentX(0.0f);
        panel7.add(templateBox);
        panel7.add(this.factLabel);
        panel7.add(slotTableScroll);
        panel7.setMinimumSize(new Dimension(600, 100));
        panel7.setPreferredSize(new Dimension(600, 200));
        this.splitPane = new JSplitPane(0, panel4, panel7);
        this.setLayout(new BorderLayout());
        this.add(this.splitPane);
        this.add((Component)this.top_pane, "North");
        this.constructTreePopupMenu();
        int width = 600;
        int height = 500;
        if (doSetSize) {
            this.setSize(width, height);
        }
    }

    private void refreshPanel(boolean newProblem) {
        if (trace.getDebugCode("wme")) {
            trace.out("wme", "WMEEditorPanel.refreshPanel(" + newProblem + ")");
        }
        if (newProblem) {
            this.splitPane.removeAll();
            this.getContentPane().removeAll();
            this.removeAll();
            if (!this.isInWhyNot()) {
                this.wmeEditor = this.controller.getModelTracer().getWmeEditor();
            }
            JTree wmeTree = this.wmeEditor.getWMETree();
            wmeTree.removeKeyListener(this);
            wmeTree.removeMouseListener(this);
            wmeTree.removeMouseMotionListener(this);
            wmeTree.addMouseListener(this);
            wmeTree.addMouseMotionListener(this);
            wmeTree.addKeyListener(this);
            JScrollPane treeScroll = new JScrollPane(wmeTree);
            treeScroll.setPreferredSize(new Dimension(500, 600));
            JPanel panel4 = new JPanel();
            panel4.setLayout(new BoxLayout(panel4, 1));
            panel4.add(this.cmFolderLabel);
            panel4.add(treeScroll);
            panel4.setMinimumSize(new Dimension(600, 100));
            panel4.setPreferredSize(new Dimension(600, 300));
            JPanel panel7 = new JPanel();
            panel7.setLayout(new BoxLayout(panel7, 1));
            JHorizontalTable slotTable = this.wmeEditor.getSlotTable();
            JScrollPane slotTableScroll = new JScrollPane(slotTable);
            slotTableScroll.setAlignmentX(0.0f);
            if (slotTable.getPreferredScrollableViewportSize().getWidth() > ((JViewport)slotTable.getParent()).getPreferredSize().getWidth()) {
                slotTable.setAutoResizeMode(3);
                slotTable.doLayout();
            }
            Box templateBox = new Box(0);
            templateBox.setAlignmentX(0.0f);
            this.templateLabel = new JLabel(NO_TEMPLATE_TEXT);
            this.templateLabel.setName("WME Template Label");
            this.templateLabel.setAlignmentX(0.0f);
            this.templateField = new JTextField(20);
            JUndo.makeTextUndoable(this.templateField);
            this.templateField.setName("WME Template Name");
            this.templateField.setMaximumSize(new Dimension(150, 20));
            this.templateField.removeActionListener(this);
            this.templateField.addActionListener(this);
            this.templateField.setActionCommand("rename");
            templateBox.add(this.templateLabel);
            templateBox.add(this.templateField);
            templateBox.add(Box.createRigidArea(new Dimension(10, 0)));
            templateBox.add(this.reactive);
            templateBox.setMaximumSize(new Dimension(500, 20));
            templateBox.add(Box.createHorizontalGlue());
            panel7.add(templateBox);
            panel7.add(this.factLabel);
            panel7.add(slotTableScroll);
            panel7.setMinimumSize(new Dimension(600, 100));
            panel7.setPreferredSize(new Dimension(600, 200));
            this.splitPane.removeAll();
            this.splitPane = new JSplitPane(0, panel4, panel7);
            this.getContentPane().add((Component)this.top_pane, "North");
            this.getContentPane().add(this.splitPane);
            this.add(this.getContentPane());
        }
        this.constructTreePopupMenu();
        this.splitPane.revalidate();
        this.splitPane.repaint();
        this.revalidate();
        this.repaint();
    }

    private Boolean refreshController() {
        BR_Controller newController;
        BR_Controller bR_Controller = newController = this.server == null ? null : this.server.getFocusedController();
        if (trace.getDebugCode("wme")) {
            trace.out("wme", "WMEEditorPanel.refreshController() old ctlr@" + (this.controller == null ? -1 : this.controller.hashCode()) + ", new ctlr@" + (this.server == null ? -2 : (newController == null ? -1 : newController.hashCode())));
        }
        if (newController == null) {
            return null;
        }
        if (this.isInWhyNot()) {
            return Boolean.FALSE;
        }
        BR_Controller oldController = this.controller;
        this.controller = newController;
        if (oldController != this.controller) {
            this.lastProblem = this.controller.getProblemFullName();
            this.lastMode = this.controller.getCtatModeModel().getCurrentMode();
            return Boolean.TRUE;
        }
        String oldMode = this.lastMode;
        this.lastMode = this.controller.getCtatModeModel().getCurrentMode();
        if (!this.lastMode.equals(oldMode)) {
            this.lastProblem = this.controller.getProblemFullName();
            return Boolean.TRUE;
        }
        String oldProblem = this.lastProblem;
        this.lastProblem = this.controller.getProblemFullName();
        return !this.lastProblem.equals(oldProblem);
    }

    public boolean isInWhyNot() {
        if (trace.getDebugCode("wme")) {
            trace.out("wme", "isInWhyNot() returns " + this.inWhyNot);
        }
        return this.inWhyNot;
    }

    public void displayCognitiveModelFolder() {
        String folderName;
        this.refreshController();
        this.mt = this.controller.getModelTracer();
        String cmDir = this.mt.findCognitiveModelDirectory();
        if (cmDir == null || cmDir.length() < 1) {
            String folderName2 = "none";
            this.cmFolderLabel.setText(cmFolderPrefix + folderName2);
            this.cmFolderLabel.setToolTipText("No folder is set for the location of cognitive model files");
            return;
        }
        File f = new File(cmDir);
        String path = f.getAbsolutePath();
        if (path.endsWith(".") && !path.substring(0, path.length() - 1).endsWith(".")) {
            path = path.substring(0, path.length() - 1);
            f = new File(path);
            path = f.getAbsolutePath();
        }
        if ((folderName = f.getName()).length() < 1) {
            folderName = folderName + "none";
        }
        if (trace.getDebugCode("eep")) {
            trace.out("eep", "f file path:" + f.getAbsolutePath());
        }
        this.cmFolderLabel.setText(cmFolderPrefix + folderName);
        this.cmFolderLabel.setToolTipText(path);
    }

    public void updateCognitiveModelFolder(String folderName, String path) {
        this.cmFolderLabel.setText(cmFolderPrefix + folderName);
        this.cmFolderLabel.setToolTipText(path);
    }

    public synchronized void refresh() {
        Deftemplate dt;
        if (trace.getDebugCode("wme")) {
            trace.out("wme", "WMEEditorPanel.refresh() ");
        }
        if (!this.isInWhyNot()) {
            Boolean chgdCtlr = this.refreshController();
            if (chgdCtlr == null) {
                return;
            }
            if (chgdCtlr.booleanValue()) {
                this.refreshPanel(true);
                return;
            }
            this.wmeEditor = this.controller.getModelTracer().getWmeEditor();
        }
        JTree wmeTree = this.wmeEditor.getWMETree();
        JHorizontalTable slotTable = this.wmeEditor.getSlotTable();
        slotTable.removeMouseListener(this);
        slotTable.addMouseListener(this);
        if (this.getMainRete() == null) {
            return;
        }
        this.wmeEditor.checkDirtyTypes();
        this.wmeEditor.checkDirtyInstances();
        Fact lastSelectedFact = this.wmeEditor.getSelectedFact();
        Deftemplate lastSelectedTemplate = this.wmeEditor.getSelectedTemplate();
        DefaultTreeModel wmeTreeModel = (DefaultTreeModel)wmeTree.getModel();
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)wmeTreeModel.getRoot();
        ArrayList<String> expanded = new ArrayList<String>();
        Enumeration<TreeNode> templates = root.children();
        while (templates.hasMoreElements()) {
            DefaultMutableTreeNode template = (DefaultMutableTreeNode)templates.nextElement();
            if (!wmeTree.isExpanded(new TreePath(wmeTreeModel.getPathToRoot(template)))) continue;
            expanded.add(template.toString());
        }
        int[] indices = new int[root.getChildCount()];
        Object[] children = new Object[root.getChildCount()];
        for (int i = 0; i < root.getChildCount(); ++i) {
            indices[i] = i;
            children[i] = root.getChildAt(i);
        }
        root.removeAllChildren();
        wmeTreeModel.nodesWereRemoved(root, indices, children);
        Iterator it = this.getMainRete().listDeftemplates();
        while (it.hasNext()) {
            dt = (Deftemplate)it.next();
            if (dt.getBaseName().startsWith("_") || dt.getBaseName().equals("test") || dt.getBaseName().equals("initial-fact")) continue;
            wmeTreeModel.insertNodeInto(new DefaultMutableTreeNode(dt.getBaseName()), root, root.getChildCount());
        }
        wmeTree.expandPath(new TreePath(root));
        root = (DefaultMutableTreeNode)wmeTreeModel.getRoot();
        templates = root.children();
        while (templates.hasMoreElements()) {
            DefaultMutableTreeNode template = (DefaultMutableTreeNode)templates.nextElement();
            if (template.getChildCount() == 0) continue;
            indices = new int[template.getChildCount()];
            children = new Object[template.getChildCount()];
            for (int i = 0; i < template.getChildCount(); ++i) {
                indices[i] = i;
                children[i] = template.getChildAt(i);
            }
            template.removeAllChildren();
            wmeTreeModel.nodesWereRemoved(template, indices, children);
        }
        it = this.getMainRete().listFacts();
        try {
            while (it.hasNext()) {
                String factName;
                Fact fact = (Fact)it.next();
                dt = fact.getDeftemplate();
                if (dt == null || this.filter.getText().length() > 0 && (dt.getSlotIndex("name") == -1 || (factName = fact.getSlotValue("name").toString().toLowerCase()) == null || factName.indexOf(this.filter.getText().toLowerCase()) == -1)) continue;
                if (this.findFactByID.getText().length() > 0) {
                    if (fact.getFactId() != Integer.parseInt(this.findFactByID.getText())) continue;
                    expanded.add(fact.getDeftemplate().getBaseName());
                    lastSelectedFact = fact;
                    lastSelectedTemplate = dt;
                }
                templates = root.children();
                DefaultMutableTreeNode template = null;
                while (templates.hasMoreElements() && template == null) {
                    template = (DefaultMutableTreeNode)templates.nextElement();
                    if (template.toString().equals(dt.getBaseName())) continue;
                    template = null;
                }
                if (template == null) continue;
                if (dt.getNSlots() > 0 && dt.getSlotIndex("name") != -1) {
                    wmeTreeModel.insertNodeInto(new DefaultMutableTreeNode(fact.getSlotValue("name") + " " + new FactIDValue(fact)), template, template.getChildCount());
                    continue;
                }
                wmeTreeModel.insertNodeInto(new DefaultMutableTreeNode(new FactIDValue(fact)), template, template.getChildCount());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        root = (DefaultMutableTreeNode)wmeTreeModel.getRoot();
        templates = root.children();
        while (templates.hasMoreElements()) {
            DefaultMutableTreeNode template = (DefaultMutableTreeNode)templates.nextElement();
            String templateName = template.toString();
            if (!expanded.contains(templateName)) continue;
            wmeTree.expandPath(new TreePath(wmeTreeModel.getPathToRoot(template)));
            expanded.remove(templateName);
        }
        this.wmeEditor.setSelection(lastSelectedFact, lastSelectedTemplate);
        this.refreshPanel(false);
    }

    private void constructTreePopupMenu() {
        int keyMask = System.getProperty("os.name").toUpperCase().startsWith("MAC") ? 4 : 2;
        this.wmeTreePopup = new JPopupMenu();
        JMenuItem goToProblemMenu = new JMenuItem("Go To Problem Fact");
        goToProblemMenu.setActionCommand("goToProblem");
        goToProblemMenu.setAccelerator(KeyStroke.getKeyStroke(80, keyMask));
        this.wmeTreePopup.add(goToProblemMenu);
        goToProblemMenu.addActionListener(this);
        JMenuItem backMenu = new JMenuItem("Back");
        backMenu.setActionCommand("back");
        backMenu.setAccelerator(KeyStroke.getKeyStroke(91, keyMask));
        this.wmeTreePopup.add(backMenu);
        backMenu.addActionListener(this);
        JMenuItem forwardMenu = new JMenuItem("Forward");
        forwardMenu.setActionCommand("forward");
        forwardMenu.setAccelerator(KeyStroke.getKeyStroke(93, keyMask));
        this.wmeTreePopup.add(forwardMenu);
        forwardMenu.addActionListener(this);
        this.wmeTreePopup.addSeparator();
        JMenuItem refreshMenu = new JMenuItem("Refresh");
        refreshMenu.setActionCommand("refresh");
        refreshMenu.setAccelerator(KeyStroke.getKeyStroke(82, keyMask));
        this.wmeTreePopup.add(refreshMenu);
        refreshMenu.addActionListener(this);
        JMenuItem expandAllMenu = new JMenuItem("Expand All");
        expandAllMenu.setActionCommand("expand");
        this.wmeTreePopup.add(expandAllMenu);
        expandAllMenu.addActionListener(this);
        JMenuItem collapseAllMenu = new JMenuItem("Collapse All");
        collapseAllMenu.setActionCommand("collapse");
        this.wmeTreePopup.add(collapseAllMenu);
        collapseAllMenu.addActionListener(this);
        this.wmeTreePopup.addSeparator();
        JMenuItem newTemplateMenu = new JMenuItem("New Template");
        newTemplateMenu.setActionCommand("newTemplate");
        this.wmeTreePopup.add(newTemplateMenu);
        newTemplateMenu.addActionListener(this);
        this.newFactMenu = new JMenuItem("New Fact");
        this.newFactMenu.setActionCommand("newFact");
        this.wmeTreePopup.add(this.newFactMenu);
        this.newFactMenu.removeActionListener(this);
        this.newFactMenu.addActionListener(this);
        this.newFactMenu.setEnabled(false);
        this.newSlotMenu = new JMenuItem("New Slot");
        this.newSlotMenu.setActionCommand("addSlot");
        this.wmeTreePopup.add(this.newSlotMenu);
        this.newSlotMenu.removeActionListener(this);
        this.newSlotMenu.addActionListener(this);
        this.newSlotMenu.setEnabled(false);
        this.deleteMenu = new JMenuItem("Delete");
        this.deleteMenu.setActionCommand("delete");
        this.deleteMenu.setAccelerator(KeyStroke.getKeyStroke(127, 0));
        this.wmeTreePopup.add(this.deleteMenu);
        this.deleteMenu.removeActionListener(this);
        this.deleteMenu.addActionListener(this);
        this.deleteMenu.setEnabled(false);
    }

    private void evaluatePopup(MouseEvent e) {
        JTree wmeTree = this.wmeEditor.getWMETree();
        if (e == null) {
            return;
        }
        if (e.getSource() == wmeTree && wmeTree.getRowCount() > 0 && e.isPopupTrigger()) {
            this.wmeTreePopup.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        String actionCommand = ae.getActionCommand();
        if (actionCommand.equals("findFactByID")) {
            this.doFindFactByID();
        } else if (actionCommand.equalsIgnoreCase("refresh")) {
            this.doRefresh();
        } else if (actionCommand.equals("expand")) {
            this.doExpand();
        } else if (actionCommand.equals("collapse")) {
            this.doCollapse();
        } else if (actionCommand.equals("back")) {
            this.doBack();
        } else if (actionCommand.equals("forward")) {
            this.doForward();
        } else if (actionCommand.equals("newFact")) {
            this.doNewFact();
        } else if (actionCommand.equals("newTemplate")) {
            this.doNewTemplate();
        } else if (actionCommand.equals("goToProblem")) {
            this.doGoToProblemFact();
        } else if (actionCommand.equals("delete")) {
            this.doDeleteFactOrTemplate();
        } else if (actionCommand.equals("addSlot")) {
            this.doAddSlot();
        } else if (actionCommand.equals("deleteSlot")) {
            this.doDeleteSlot();
        } else if (actionCommand.equals("reactive")) {
            this.doReactive();
        } else if (actionCommand.equals("rename")) {
            this.doRename();
        } else if (actionCommand.equals("ShowPre")) {
            this.setRete(this.getPreRete());
            this.refresh();
        } else if (actionCommand.equals("ShowPost")) {
            this.setRete(this.getPostRete());
            this.refresh();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        JHorizontalTable slotTable = this.wmeEditor.getSlotTable();
        WMEEditor.SlotTableModel slotTableModel = (WMEEditor.SlotTableModel)this.wmeEditor.getSlotTable().getModel();
        JTree wmeTree = this.wmeEditor.getWMETree();
        DefaultTreeModel wmeTreeModel = (DefaultTreeModel)wmeTree.getModel();
        if (e != null && e.getSource() == slotTable) {
            return;
        }
        this.evaluatePopup(e);
        DefaultMutableTreeNode selection = (DefaultMutableTreeNode)wmeTree.getLastSelectedPathComponent();
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)wmeTreeModel.getRoot();
        if (selection != null) {
            if (selection.getParent() == root) {
                slotTableModel.clear();
                try {
                    Deftemplate dt = this.getMainRete().findDeftemplate(selection.toString());
                    slotTableModel.loadTemplate(dt);
                    this.reactive.setSelected(dt.getBackwardChaining());
                    this.reactive.setEnabled(false);
                    this.newFactMenu.setEnabled(true);
                    this.newSlotMenu.setEnabled(true);
                    this.deleteMenu.setEnabled(true);
                    this.templateLabel.setText("Template: ");
                    this.templateField.setText(selection.toString());
                    this.templateField.setVisible(true);
                    this.factLabel.setText(NO_FACT_TEXT);
                    this.wmeEditor.setSelectedTemplate(dt);
                    this.wmeEditor.setSelectedFact(null);
                }
                catch (JessException je) {
                    trace.errStack("mouseReleased(" + e + ")", je);
                }
            } else {
                slotTableModel.clear();
                Iterator it = this.getMainRete().listFacts();
                String template = selection.getParent().toString();
                String factID = selection.toString().substring(selection.toString().indexOf(60));
                try {
                    while (it.hasNext()) {
                        Fact fact = (Fact)it.next();
                        Deftemplate dt = fact.getDeftemplate();
                        if (dt == null || !dt.getBaseName().equals(template) || !factID.equals(new FactIDValue(fact).toString())) continue;
                        slotTableModel.loadFact(fact);
                        this.reactive.setSelected(dt.getBackwardChaining());
                        this.reactive.setEnabled(false);
                        this.wmeEditor.setSelectedTemplate(dt);
                        this.wmeEditor.setSelectedFact(fact);
                        break;
                    }
                    this.newFactMenu.setEnabled(true);
                    this.newSlotMenu.setEnabled(true);
                    this.deleteMenu.setEnabled(true);
                    this.templateLabel.setText("Template: ");
                    this.templateField.setText(selection.getParent().toString());
                    this.templateField.setVisible(true);
                    this.factLabel.setText("Fact: " + selection.toString());
                }
                catch (JessException je) {
                    trace.errStack("mouseReleased(" + e + ")", je);
                }
            }
            int numRows = slotTable.getRowCount();
            int finalColNumber = slotTable.getColumnCount() - 1;
            int maxWidth = 200;
            for (int row = 0; row < numRows; ++row) {
                TableCellRenderer renderer = slotTable.getCellRenderer(row, finalColNumber);
                Component comp = slotTable.prepareRenderer(renderer, row, finalColNumber);
                maxWidth = Math.max(comp.getPreferredSize().width, maxWidth);
            }
            slotTable.getColumnModel().getColumn(finalColNumber).setPreferredWidth(maxWidth + 5);
            slotTable.setMinimumSize(((JComponent)slotTable).getPreferredSize());
        } else {
            this.newFactMenu.setEnabled(false);
            this.newSlotMenu.setEnabled(false);
            this.deleteMenu.setEnabled(false);
            slotTableModel.clear();
            this.wmeEditor.setSelectedTemplate(null);
            this.wmeEditor.setSelectedFact(null);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        Fact selectedFact = this.wmeEditor.getSelectedFact();
        Deftemplate selectedTemplate = this.wmeEditor.getSelectedTemplate();
        JHorizontalTable slotTable = this.wmeEditor.getSlotTable();
        WMEEditor.SlotTableModel slotTableModel = (WMEEditor.SlotTableModel)slotTable.getModel();
        JTree wmeTree = this.wmeEditor.getWMETree();
        String selection = null;
        if (e.getClickCount() == 2 && e.getSource() == wmeTree) {
            selection = selectedFact == null ? selectedTemplate.toString() : selectedFact.toString();
            JFrame singleView = new JFrame(selection);
            singleView.getContentPane().setLayout(new BoxLayout(singleView.getContentPane(), 1));
            JLabel newTemplateLabel = new JLabel("Template: " + selectedTemplate.getBaseName());
            newTemplateLabel.setAlignmentX(0.0f);
            singleView.getContentPane().add(newTemplateLabel);
            if (selectedFact != null) {
                JLabel newFactLabel = new JLabel("Fact: " + ((DefaultMutableTreeNode)wmeTree.getLastSelectedPathComponent()).toString());
                newFactLabel.setAlignmentX(0.0f);
                singleView.getContentPane().add(newFactLabel);
            }
            String[] columnNames = new String[]{"Slot", "Type", "Slot Value"};
            WMEEditor.SlotTableModel newSlotTableModel = this.wmeEditor.getNewTableModel(columnNames, 5);
            JTable newSlotTable = new JTable(newSlotTableModel);
            for (int i = 0; i < 3; ++i) {
                TableColumn column = newSlotTable.getColumnModel().getColumn(i);
                if (i == 0) {
                    column.setMinWidth(100);
                }
                if (i == 1) {
                    column.setMinWidth(50);
                }
                if (i != 2) continue;
                column.setMinWidth(200);
            }
            if (selectedFact != null) {
                newSlotTableModel.loadFact(selectedFact);
            } else {
                newSlotTableModel.loadTemplate(selectedTemplate);
            }
            newSlotTable.setAlignmentX(0.0f);
            singleView.getContentPane().add(newSlotTable);
            singleView.pack();
            singleView.setVisible(true);
            this.mt.getRete().getEventLogger().log(true, "WORKING_MEMORY_EDITOR", "INSPECT_FACT", selectedFact.toString(), "", "");
        } else if ((e.getButton() == 3 || e.isControlDown()) && e.getSource() == slotTable) {
            int row = slotTable.rowAtPoint(new Point(e.getX(), e.getY()));
            int col = slotTable.columnAtPoint(new Point(e.getX(), e.getY()));
            if (col == slotTableModel.SLOTVALUE_COL && selectedFact != null) {
                try {
                    Value val = (Value)slotTableModel.getValueAt(row, col);
                    if (val instanceof FactIDValue) {
                        Fact f = val.factValue(null);
                        Deftemplate dt = f.getDeftemplate();
                        this.wmeEditor.setSelection(f, dt);
                    } else if (val.type() == 512) {
                        int i;
                        ValueVector vv = val.listValue(null);
                        String valString = val.toString();
                        Rectangle cellRect = slotTable.getCellRect(row, col, false);
                        int offset = e.getX() - (int)cellRect.getMinX();
                        StringBuffer partial = new StringBuffer();
                        int pos = 0;
                        for (i = 1; i <= vv.size(); ++i) {
                            if (!(vv.get(i - 1) instanceof FactIDValue)) continue;
                            partial.append(valString.substring(pos, valString.indexOf(62, pos) + 1));
                            pos = valString.indexOf(62, pos) + 1;
                            int partialWidth = slotTable.getFontMetrics(slotTable.getFont()).stringWidth(partial.toString());
                            if (partialWidth >= offset) break;
                        }
                        if (i <= vv.size()) {
                            FactIDValue factVal = (FactIDValue)vv.get(i - 1);
                            Fact f = factVal.factValue(null);
                            Deftemplate dt = f.getDeftemplate();
                            this.wmeEditor.setSelection(f, dt);
                        }
                    }
                }
                catch (JessException je) {
                    trace.errStack("mouseClicked() in row " + row + ", col " + col, je);
                }
            } else if (col == slotTableModel.SLOTNAME_COL && this.slotPopup != null) {
                this.slotPopup.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.evaluatePopup(e);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        int row;
        JTree wmeTree = this.wmeEditor.getWMETree();
        if (e.getSource() == wmeTree && (row = wmeTree.getRowForLocation(e.getX(), e.getY())) != wmeTree.getMinSelectionRow()) {
            wmeTree.getTransferHandler().exportAsDrag(wmeTree, e, 1);
        }
    }

    private void displayAssociatedFact(KeyEvent e) {
        JHorizontalTable slotTable = this.wmeEditor.getSlotTable();
        JTree wmeTree = this.wmeEditor.getWMETree();
        DefaultTreeModel wmeTreeModel = (DefaultTreeModel)wmeTree.getModel();
        if (e != null && e.getSource() == slotTable) {
            return;
        }
        WMEEditor.SlotTableModel slotTableModel = (WMEEditor.SlotTableModel)this.wmeEditor.getSlotTable().getModel();
        DefaultMutableTreeNode selection = (DefaultMutableTreeNode)wmeTree.getLastSelectedPathComponent();
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)wmeTreeModel.getRoot();
        if (selection != null && selection.getParent() == root) {
            slotTableModel.clear();
            try {
                Deftemplate dt = this.getMainRete().findDeftemplate(selection.toString());
                slotTableModel.loadTemplate(dt);
                this.reactive.setSelected(dt.getBackwardChaining());
                this.reactive.setEnabled(false);
                this.newFactMenu.setEnabled(true);
                this.newSlotMenu.setEnabled(true);
                this.deleteMenu.setEnabled(true);
                this.templateLabel.setText("Template: ");
                this.templateField.setText(selection.toString());
                this.templateField.setVisible(true);
                this.factLabel.setText(NO_FACT_TEXT);
                this.wmeEditor.setSelectedTemplate(dt);
                this.wmeEditor.setSelectedFact(null);
            }
            catch (JessException je) {
                trace.errStack("displayAssociatedFact(" + e + ")", je);
            }
        } else if (selection != null) {
            slotTableModel.clear();
            Iterator it = this.getMainRete().listFacts();
            String template = selection.getParent().toString();
            String factID = selection.toString().substring(selection.toString().indexOf(60));
            try {
                while (it.hasNext()) {
                    Fact fact = (Fact)it.next();
                    Deftemplate dt = fact.getDeftemplate();
                    if (dt == null || !dt.getBaseName().equals(template) || !factID.equals(new FactIDValue(fact).toString())) continue;
                    slotTableModel.loadFact(fact);
                    this.reactive.setSelected(dt.getBackwardChaining());
                    this.reactive.setEnabled(false);
                    this.wmeEditor.setSelectedTemplate(dt);
                    this.wmeEditor.setSelectedFact(fact);
                    break;
                }
                this.newFactMenu.setEnabled(true);
                this.newSlotMenu.setEnabled(true);
                this.deleteMenu.setEnabled(true);
                this.templateLabel.setText("Template: ");
                this.templateField.setText(selection.getParent().toString());
                this.templateField.setVisible(true);
                this.factLabel.setText("Fact: " + selection.toString());
            }
            catch (JessException je) {
                trace.errStack("displayAssociatedFact(" + e + ")", je);
            }
        } else {
            this.newFactMenu.setEnabled(false);
            this.newSlotMenu.setEnabled(false);
            this.deleteMenu.setEnabled(false);
            slotTableModel.clear();
            this.wmeEditor.setSelectedTemplate(null);
            this.wmeEditor.setSelectedFact(null);
        }
    }

    private void setRete(MTRete rete) {
        this.wmeEditor.setRete(rete);
    }

    private void doAddSlot() {
        block2: {
            MTRete r = this.getMainRete();
            Deftemplate selectedTemplate = this.wmeEditor.getSelectedTemplate();
            this.mt.getRete().getEventLogger().log(true, "WORKING_MEMORY_EDITOR", "ADD_SLOT", selectedTemplate.getName(), "", "");
            StringWriter swt = new StringWriter();
            StringWriter swf = new StringWriter();
            this.wmeEditor.saveTemplatesAddSlot(selectedTemplate, swt);
            this.wmeEditor.saveFactsAsJessCode(r.listFacts(), swf);
            try {
                r.clear();
                r.parse(new BufferedReader(new StringReader(swt.toString())));
                r.parse(new BufferedReader(new StringReader(swf.toString())));
            }
            catch (JessException je) {
                if (!trace.getDebugCode("wme")) break block2;
                trace.out("wme", je.toString());
            }
        }
        this.refresh();
    }

    private void doBack() {
        WMEEditor.SlotTableModel slotTableModel = (WMEEditor.SlotTableModel)this.wmeEditor.getSlotTable().getModel();
        slotTableModel.goBackInHistory();
    }

    private void doCollapse() {
        JTree wmeTree = this.wmeEditor.getWMETree();
        DefaultTreeModel wmeTreeModel = (DefaultTreeModel)wmeTree.getModel();
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)wmeTreeModel.getRoot();
        Enumeration<TreeNode> templates = root.children();
        while (templates.hasMoreElements()) {
            DefaultMutableTreeNode template = (DefaultMutableTreeNode)templates.nextElement();
            wmeTree.collapsePath(new TreePath(wmeTreeModel.getPathToRoot(template)));
        }
        this.mt.getRete().getEventLogger().log(true, "WORKING_MEMORY_EDITOR", "COLLAPSE_ALL", "", "", "");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doDeleteFactOrTemplate() {
        JTree wmeTree;
        block7: {
            MTRete r = this.getMainRete();
            wmeTree = this.wmeEditor.getWMETree();
            Fact selectedFact = this.wmeEditor.getSelectedFact();
            Deftemplate selectedTemplate = this.wmeEditor.getSelectedTemplate();
            if (selectedTemplate != null && selectedFact == null) {
                this.mt.getRete().getEventLogger().log(true, "WORKING_MEMORY_EDITOR", "DELETE_TEMPLATE", selectedTemplate.getBaseName(), "", "");
                DefaultMutableTreeNode selection = (DefaultMutableTreeNode)wmeTree.getLastSelectedPathComponent();
                if (selection.getChildCount() != 0 && JOptionPane.showConfirmDialog(this.parentFrame, "All of the facts defined under this template will be deleted.  Are you sure you want to delete this template?", "Delete template", 0) != 0) {
                    this.mt.getRete().getEventLogger().log(true, "WORKING_MEMORY_EDITOR", "CANCEL_DELETE_TEMPLATE", selectedTemplate.getBaseName(), "", "");
                    return;
                }
                this.wmeEditor.removeTemplate(selectedTemplate);
            } else {
                if (selectedFact != null) {
                    this.mt.getRete().getEventLogger().log(true, "WORKING_MEMORY_EDITOR", "DELETE_FACT", selectedFact.getDeftemplate().getBaseName(), "", "");
                    try {
                        r.retract(selectedFact);
                        r.removeWMEEditorFact(selectedFact);
                    }
                    catch (JessException je) {
                        if (trace.getDebugCode("wme")) {
                            trace.out("wme", je.toString());
                        }
                        break block7;
                    }
                }
                this.deleteMenu.setEnabled(false);
            }
        }
        this.refresh();
        wmeTree.setSelectionPath(null);
        WMEEditor.SlotTableModel slotTableModel = (WMEEditor.SlotTableModel)this.wmeEditor.getSlotTable().getModel();
        slotTableModel.clear();
        this.templateLabel.setText(NO_TEMPLATE_TEXT);
        this.templateField.setVisible(false);
        this.factLabel.setText(NO_FACT_TEXT);
        this.reactive.setEnabled(false);
    }

    private void doDeleteSlot() {
        block2: {
            MTRete r = this.getMainRete();
            Deftemplate selectedTemplate = this.wmeEditor.getSelectedTemplate();
            WMEEditor.SlotTableModel slotTableModel = (WMEEditor.SlotTableModel)this.wmeEditor.getSlotTable().getModel();
            this.mt.getRete().getEventLogger().log(true, "WORKING_MEMORY_EDITOR", "DELETE_SLOT", selectedTemplate.getName(), "", "");
            StringWriter swt = new StringWriter();
            StringWriter swf = new StringWriter();
            String slotName = slotTableModel.getValueAt(this.wmeEditor.getSelectedSlotNumber(), slotTableModel.SLOTNAME_COL).toString();
            this.wmeEditor.saveTemplatesDeleteSlot(selectedTemplate, slotName, swt);
            this.wmeEditor.saveFactsAsJessCodeDeleteSlot(selectedTemplate, slotName, r.listFacts(), swf);
            try {
                r.clear();
                r.parse(new BufferedReader(new StringReader(swt.toString())));
                r.parse(new BufferedReader(new StringReader(swf.toString())));
            }
            catch (JessException je) {
                if (!trace.getDebugCode("wme")) break block2;
                trace.out("wme", je.toString());
            }
        }
        this.refresh();
    }

    private void doExpand() {
        JTree wmeTree = this.wmeEditor.getWMETree();
        DefaultTreeModel wmeTreeModel = (DefaultTreeModel)wmeTree.getModel();
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)wmeTreeModel.getRoot();
        Enumeration<TreeNode> templates = root.children();
        while (templates.hasMoreElements()) {
            DefaultMutableTreeNode template = (DefaultMutableTreeNode)templates.nextElement();
            wmeTree.expandPath(new TreePath(wmeTreeModel.getPathToRoot(template)));
        }
        this.mt.getRete().getEventLogger().log(true, "WORKING_MEMORY_EDITOR", "EXPAND_ALL", "", "", "");
    }

    private void doFindFactByID() {
        if (trace.getDebugCode("wme")) {
            trace.out("wme", "WMEEditorPanel.doFindFactByID() mainRete " + this.getMainRete() + ", findFactByID " + (this.findFactByID == null ? null : this.findFactByID.getClass()) + ", mt " + this.mt);
        }
        Iterator facts = this.getMainRete().listFacts();
        while (facts.hasNext()) {
            Fact fact = (Fact)facts.next();
            if (fact.getFactId() != Integer.parseInt(this.findFactByID.getText())) continue;
            this.wmeEditor.setSelectedFact(fact);
            this.wmeEditor.setSelectedTemplate(fact.getDeftemplate());
        }
        this.mt.authorActionLog("WORKING_MEMORY_EDITOR", "Find Fact by ID", this.findFactByID.getText(), "", "");
        this.findFactByID.setText("");
        this.refresh();
    }

    private void doForward() {
        WMEEditor.SlotTableModel slotTableModel = (WMEEditor.SlotTableModel)this.wmeEditor.getSlotTable().getModel();
        slotTableModel.goForwardInHistory();
    }

    private void doGoToProblemFact() {
        Iterator facts = this.getMainRete().listFacts();
        while (facts.hasNext()) {
            Fact fact = (Fact)facts.next();
            if (!fact.getDeftemplate().getBaseName().equals("problem")) continue;
            this.wmeEditor.setSelectedFact(fact);
            this.wmeEditor.setSelectedTemplate(fact.getDeftemplate());
            break;
        }
        this.refresh();
    }

    private void doReactive() {
        if (this.wmeEditor.getSelectedTemplate() != null && this.reactive.isSelected()) {
            trace.err("NOT IMPLEMENTED: backward chaining not yet functional");
        }
    }

    private void doRefresh() {
        this.mt.authorActionLog("WORKING_MEMORY_EDITOR", "refresh", "", "", "");
        this.refresh();
        this.mt.getRete().getEventLogger().log(true, "WORKING_MEMORY_EDITOR", "REFRESH", "", "", "");
    }

    private void doRename() {
        MTRete r = this.getMainRete();
        Deftemplate selectedTemplate = this.wmeEditor.getSelectedTemplate();
        this.mt.getRete().getEventLogger().log(true, "WORKING_MEMORY_EDITOR", "RENAME_TEMPLATE", selectedTemplate.getName(), "", "");
        StringWriter swt = new StringWriter();
        StringWriter swf = new StringWriter();
        this.wmeEditor.saveTemplatesRename(selectedTemplate, this.templateField.getText().replace(' ', '_'), swt);
        this.wmeEditor.saveFactsAsJessCodeRename(selectedTemplate, this.templateField.getText().replace(' ', '_'), r.listFacts(), swf);
        try {
            r.clear();
            r.parse(new BufferedReader(new StringReader(swt.toString())));
            r.parse(new BufferedReader(new StringReader(swf.toString())));
        }
        catch (JessException je) {
            trace.errStack("Error renaming deftemplate", je);
        }
        this.refresh();
    }

    private void doNewFact() {
        Deftemplate selectedTemplate = this.wmeEditor.getSelectedTemplate();
        this.mt.getRete().getEventLogger().log(true, "WORKING_MEMORY_EDITOR", "ADD_FACT", selectedTemplate.getBaseName(), "", "");
        if (selectedTemplate == null) {
            this.newFactMenu.setEnabled(false);
            this.newSlotMenu.setEnabled(false);
            return;
        }
        try {
            Fact newFact = new Fact(selectedTemplate);
            int i = -1;
            if (trace.getDebugCode("wme")) {
                trace.out("wme", "assertFact() called");
            }
            this.getMainRete().assertFact(newFact);
            while (newFact.getFactId() == -1) {
                if (i == -1) {
                    newFact.setSlotValue("name", new Value(newFact.getSlotValue("name").toString() + "1", 1));
                    i = 1;
                } else {
                    newFact.setSlotValue("name", new Value(newFact.getSlotValue("name").toString().substring(0, newFact.getSlotValue("name").toString().length() - 1) + i, 1));
                }
                if (++i > 10) {
                    i -= 10;
                }
                if (trace.getDebugCode("wme")) {
                    trace.out("wme", "assertFact() called");
                }
                this.getMainRete().assertFact(newFact);
            }
            this.getMainRete().addWMEEditorFact(newFact);
            Deftemplate prevSelected = selectedTemplate;
            this.refresh();
            this.wmeEditor.setSelection(newFact, prevSelected);
        }
        catch (JessException je) {
            trace.errStack("doNewFact()", je);
            return;
        }
    }

    private void doNewTemplate() {
        MTRete r = this.getMainRete();
        try {
            String name = "NewTemplate";
            int i = -1;
            while (r.findDeftemplate(name) != null) {
                if (i == -1) {
                    name = name + " 1";
                    i = 1;
                } else {
                    name = name.substring(0, name.length() - 1) + i;
                }
                if (++i <= 10) continue;
                i -= 10;
            }
            Deftemplate dt = new Deftemplate(name, null, (Rete)r);
            dt.addSlot("name", new Value("nil", 1), "ANY");
            this.mt.getRete().getEventLogger().log(true, "WORKING_MEMORY_EDITOR", "ADD_TEMPLATE", name, "", "");
            r.addDeftemplate(dt);
            r.addWMEEditorDeftemplate(dt);
            this.refresh();
            this.wmeEditor.setSelection(null, dt);
        }
        catch (JessException je) {
            trace.errStack("doNewTemplate()", je);
        }
    }

    private MTRete getMainRete() {
        return this.wmeEditor.getRete();
    }

    private MTRete getPreRete() {
        return this.wmeEditor.getPreRete();
    }

    private MTRete getPostRete() {
        return this.wmeEditor.getPostRete();
    }

    void constructSlotPopupMenu(boolean isDeleteEnabled) {
        this.slotPopup = new JPopupMenu();
        JMenuItem addSlotMenu = new JMenuItem("Add Slot");
        addSlotMenu.setActionCommand("addSlot");
        this.slotPopup.add(addSlotMenu);
        addSlotMenu.addActionListener(this);
        JMenuItem deleteSlotMenu = new JMenuItem("Delete Slot");
        deleteSlotMenu.setActionCommand("deleteSlot");
        deleteSlotMenu.setEnabled(isDeleteEnabled);
        this.slotPopup.add(deleteSlotMenu);
        deleteSlotMenu.addActionListener(this);
    }

    public void keyAction(KeyEvent e) {
    }

    public void keyActionRelease(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        int keyMask = System.getProperty("os.name").toUpperCase().startsWith("MAC") ? 4 : 2;
        if (e.getKeyCode() == 38 || e.getKeyCode() == 40) {
            this.displayAssociatedFact(e);
        }
        if (e.getKeyCode() == 127) {
            this.doDeleteFactOrTemplate();
        }
        if (e.getModifiers() == keyMask) {
            if (e.getKeyCode() == 80) {
                this.doGoToProblemFact();
            }
            if (e.getKeyCode() == 82) {
                this.doRefresh();
            }
            if (e.getKeyCode() == 91) {
                this.doBack();
            }
            if (e.getKeyCode() == 93) {
                this.doForward();
            }
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.refresh();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.refresh();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.refresh();
    }
}

