/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.BehaviorRecorder.StartStateEditor;

import edu.cmu.hcii.ctat.CTATDesktopFileManager;
import edu.cmu.hcii.ctat.CTATHTTPServer;
import edu.cmu.pact.BehaviorRecorder.Controller.BR_Controller;
import edu.cmu.pact.BehaviorRecorder.Dialogs.DialogUtilities;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.ProblemModel;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.ProblemModelEvent;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.ProblemModelListener;
import edu.cmu.pact.BehaviorRecorder.StartStateEditor.CTATComponent;
import edu.cmu.pact.BehaviorRecorder.StartStateEditor.CTATComponentPanel;
import edu.cmu.pact.BehaviorRecorder.StartStateEditor.CTATFileManager;
import edu.cmu.pact.BehaviorRecorder.StartStateEditor.CTATJPanel;
import edu.cmu.pact.BehaviorRecorder.StartStateEditor.CTATPreviewHandler;
import edu.cmu.pact.BehaviorRecorder.StartStateEditor.CTATSAI;
import edu.cmu.pact.BehaviorRecorder.StartStateEditor.CTATSAITable;
import edu.cmu.pact.BehaviorRecorder.StartStateEditor.CTATSAITreeNode;
import edu.cmu.pact.BehaviorRecorder.StartStateEditor.CTATSSELink;
import edu.cmu.pact.BehaviorRecorder.StartStateEditor.CTATSerializableTableEntry;
import edu.cmu.pact.BehaviorRecorder.StartStateEditor.CTATSheetCellEditor;
import edu.cmu.pact.BehaviorRecorder.StartStateEditor.CTATStartStateEvent;
import edu.cmu.pact.BehaviorRecorder.StartStateEditor.CTATTutorPreview;
import edu.cmu.pact.BehaviorRecorder.StartStateEditor.CTATXMLViewer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTree;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import org.jdom.Element;

public class CTATStartStateEditor
extends CTATJPanel
implements ActionListener,
ProblemModelListener,
TreeSelectionListener,
ListSelectionListener,
MouseListener,
ComponentListener {
    private static final long serialVersionUID = 1L;
    public static CTATSSELink link = null;
    private CTATFileManager fManager = null;
    private JButton saveButton = null;
    private JButton saveAsButton = null;
    private JButton loadButton = null;
    private JButton xmlButton = null;
    private JButton addButton = null;
    private JButton removeButton = null;
    private JButton executeButton = null;
    private JButton upButton = null;
    private JButton downButton = null;
    private JButton zoomInButton = null;
    private JButton zoomOutButton = null;
    private JLabel infoLabel = null;
    private Box componentBox = null;
    private StringBuffer loader = null;
    private JTree SAITree = null;
    private JTree SAIByActionTree = null;
    private DefaultMutableTreeNode SAIRoot = null;
    private DefaultMutableTreeNode SAIRootByAction = null;
    private DefaultTreeModel SAIActionModel = null;
    private DefaultTreeModel SAIActionByActionModel = null;
    private CTATXMLViewer outp = null;
    private JTabbedPane tabbedPane = null;
    private CTATTutorPreview preview = null;
    private CTATComponent componentSelection = null;
    private CTATSAI actionSelection = null;
    private CTATSAITable actionTable = null;
    private JCheckBox showPreviewCheck = null;
    Icon up = null;
    Icon down = null;
    Icon in = null;
    Icon out = null;
    String[] columnNames = new String[]{"Instance/Selection", "Action", "Input"};
    BR_Controller controller = null;
    ProblemModel pm = null;

    public CTATStartStateEditor() {
        this.debug("CTATStartStateEditor ()");
        link = new CTATSSELink(new CTATDesktopFileManager());
        if (CTATSSELink.components == null) {
            CTATSSELink.components = new ArrayList();
        }
        this.up = new ImageIcon(this.getClass().getClassLoader().getResource("pact/CommWidgets/close.png"));
        this.down = new ImageIcon(this.getClass().getClassLoader().getResource("pact/CommWidgets/open.png"));
        this.in = new ImageIcon(this.getClass().getClassLoader().getResource("pact/CommWidgets/zoom-icon-in.png"));
        this.out = new ImageIcon(this.getClass().getClassLoader().getResource("pact/CommWidgets/zoom-icon-out.png"));
        this.loader = new StringBuffer();
        this.fManager = new CTATFileManager();
        BorderLayout frameBox = new BorderLayout();
        this.setLayout(frameBox);
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.setFont(new Font("Dialog", 1, 10));
        JPanel editor = new JPanel();
        editor.setLayout(new BoxLayout(editor, 0));
        editor.setMinimumSize(new Dimension(20, 20));
        editor.setMaximumSize(new Dimension(5000, 2000));
        editor.setBorder(BorderFactory.createMatteBorder(3, 3, 3, 3, new Color(180, 180, 180)));
        editor.setBackground(new Color(180, 180, 180));
        editor.setFont(new Font("Dialog", 1, 10));
        Box mainBox = new Box(1);
        mainBox.setMinimumSize(new Dimension(20, 20));
        mainBox.setMaximumSize(new Dimension(5000, 5000));
        editor.add(mainBox);
        JScrollPane contentScrollList = new JScrollPane(editor);
        contentScrollList.setMinimumSize(new Dimension(20, 20));
        contentScrollList.setMaximumSize(new Dimension(5000, 2000));
        contentScrollList.setHorizontalScrollBarPolicy(31);
        contentScrollList.setVerticalScrollBarPolicy(22);
        this.tabbedPane.addTab("Configuration", null, contentScrollList, "tbd");
        Box previewBox = new Box(1);
        previewBox.setMinimumSize(new Dimension(20, 20));
        previewBox.setMaximumSize(new Dimension(5000, 200));
        this.preview = new CTATTutorPreview();
        this.preview.setMinimumSize(new Dimension(20, 200));
        this.preview.setPreferredSize(new Dimension(this.getWidth(), 200));
        this.preview.setMaximumSize(new Dimension(5000, 200));
        this.preview.setBorder(BorderFactory.createLineBorder(Color.black));
        this.preview.setBackground(new Color(220, 220, 200));
        JScrollPane previewScrollPane = new JScrollPane(this.preview);
        previewBox.add(previewScrollPane);
        Box buttonBox = new Box(0);
        buttonBox.setMinimumSize(new Dimension(20, 20));
        buttonBox.setMaximumSize(new Dimension(5000, 20));
        this.infoLabel = new JLabel();
        this.infoLabel.setMaximumSize(new Dimension(5000, 20));
        this.infoLabel.setText(" Tutor: ");
        this.infoLabel.setOpaque(true);
        this.infoLabel.setBackground(new Color(220, 220, 200));
        this.infoLabel.setBorder(BorderFactory.createLineBorder(Color.black));
        buttonBox.add(this.infoLabel);
        this.showPreviewCheck = new JCheckBox();
        this.showPreviewCheck.setMaximumSize(new Dimension(150, 20));
        this.showPreviewCheck.setText("Live Preview");
        this.showPreviewCheck.setSelected(true);
        buttonBox.add(this.showPreviewCheck);
        this.zoomInButton = new JButton();
        this.zoomInButton.setFont(new Font("Dialog", 1, 10));
        this.zoomInButton.setMinimumSize(new Dimension(30, 20));
        this.zoomInButton.setPreferredSize(new Dimension(30, 20));
        this.zoomInButton.setMaximumSize(new Dimension(30, 20));
        this.zoomInButton.setIcon(this.in);
        this.zoomInButton.setEnabled(false);
        buttonBox.add(this.zoomInButton);
        this.zoomOutButton = new JButton();
        this.zoomOutButton.setFont(new Font("Dialog", 1, 10));
        this.zoomOutButton.setMinimumSize(new Dimension(30, 20));
        this.zoomOutButton.setPreferredSize(new Dimension(30, 20));
        this.zoomOutButton.setMaximumSize(new Dimension(30, 20));
        this.zoomOutButton.setIcon(this.out);
        this.zoomOutButton.setEnabled(false);
        buttonBox.add(this.zoomOutButton);
        this.saveButton = new JButton();
        this.saveButton.setFont(new Font("Dialog", 1, 10));
        this.saveButton.setMaximumSize(new Dimension(5000, 20));
        this.saveButton.setText("Save");
        this.saveAsButton = new JButton();
        this.saveAsButton.setFont(new Font("Dialog", 1, 10));
        this.saveAsButton.setMaximumSize(new Dimension(5000, 20));
        this.saveAsButton.setText("SaveAs");
        this.loadButton = new JButton();
        this.loadButton.setFont(new Font("Dialog", 1, 10));
        this.loadButton.setMaximumSize(new Dimension(5000, 20));
        this.loadButton.setText("Load");
        this.xmlButton = new JButton();
        this.xmlButton.setFont(new Font("Dialog", 1, 10));
        this.xmlButton.setMinimumSize(new Dimension(75, 20));
        this.xmlButton.setPreferredSize(new Dimension(75, 20));
        this.xmlButton.setMaximumSize(new Dimension(75, 20));
        this.xmlButton.setText("To XML");
        buttonBox.add(this.xmlButton);
        previewBox.add(buttonBox);
        this.showPreviewCheck.addActionListener(this);
        this.zoomInButton.addActionListener(this);
        this.zoomOutButton.addActionListener(this);
        this.xmlButton.addActionListener(this);
        this.componentBox = new Box(1);
        this.componentBox.setMinimumSize(new Dimension(20, 20));
        this.componentBox.setMaximumSize(new Dimension(5000, 5000));
        mainBox.add(this.componentBox);
        JPanel SAIEditor = new JPanel();
        this.tabbedPane.addTab("InterfaceActions", null, SAIEditor, "tbd");
        SAIEditor.setBorder(BorderFactory.createMatteBorder(3, 3, 3, 3, new Color(180, 180, 180)));
        SAIEditor.setLayout(new BoxLayout(SAIEditor, 0));
        Box SAISubBox = new Box(1);
        SAIEditor.add(SAISubBox);
        JTabbedPane tabbedSAIPane = new JTabbedPane();
        tabbedSAIPane.setFont(new Font("Dialog", 1, 10));
        SAISubBox.add(tabbedSAIPane);
        this.SAIRoot = new DefaultMutableTreeNode("Available Instances");
        this.SAIActionModel = new DefaultTreeModel(this.SAIRoot);
        this.SAITree = new JTree(this.SAIActionModel);
        this.SAITree.setFont(new Font("Dialog", 1, 10));
        this.SAITree.setBorder(BorderFactory.createLineBorder(Color.black));
        this.SAITree.setMinimumSize(new Dimension(20, 20));
        this.SAITree.setMaximumSize(new Dimension(5000, 200));
        this.SAITree.getSelectionModel().setSelectionMode(1);
        this.SAITree.addTreeSelectionListener(this);
        this.SAITree.addMouseListener(this);
        this.SAITree.setEditable(false);
        JScrollPane SAITreeScrollList = new JScrollPane(this.SAITree);
        SAITreeScrollList.setVerticalScrollBarPolicy(22);
        tabbedSAIPane.addTab("By Instance", null, SAITreeScrollList, "tbd");
        this.SAIRootByAction = new DefaultMutableTreeNode("Available Actions");
        this.SAIActionByActionModel = new DefaultTreeModel(this.SAIRootByAction);
        this.SAIByActionTree = new JTree(this.SAIActionByActionModel);
        this.SAIByActionTree.setFont(new Font("Dialog", 1, 10));
        this.SAIByActionTree.setBorder(BorderFactory.createLineBorder(Color.black));
        this.SAIByActionTree.setMinimumSize(new Dimension(20, 20));
        this.SAIByActionTree.setMaximumSize(new Dimension(5000, 200));
        this.SAIByActionTree.addMouseListener(this);
        this.SAIByActionTree.setEditable(false);
        JScrollPane SAITreeScrollListByAction = new JScrollPane(this.SAIByActionTree);
        SAITreeScrollListByAction.setVerticalScrollBarPolicy(22);
        tabbedSAIPane.addTab("By Action", null, SAITreeScrollListByAction, "tbd");
        Box SAIControlBox = new Box(0);
        this.addButton = new JButton();
        this.addButton.setFont(new Font("Dialog", 1, 10));
        this.addButton.setMaximumSize(new Dimension(5000, 20));
        this.addButton.setText("Add");
        SAIControlBox.add(this.addButton);
        this.removeButton = new JButton();
        this.removeButton.setFont(new Font("Dialog", 1, 10));
        this.removeButton.setMaximumSize(new Dimension(5000, 20));
        this.removeButton.setText("Remove");
        SAIControlBox.add(this.removeButton);
        this.executeButton = new JButton();
        this.executeButton.setFont(new Font("Dialog", 1, 10));
        this.executeButton.setMaximumSize(new Dimension(5000, 20));
        this.executeButton.setText("Execute");
        SAIControlBox.add(this.executeButton);
        this.upButton = new JButton();
        this.upButton.setFont(new Font("Dialog", 1, 10));
        this.upButton.setMaximumSize(new Dimension(5000, 20));
        this.upButton.setIcon(this.up);
        SAIControlBox.add(this.upButton);
        this.downButton = new JButton();
        this.downButton.setFont(new Font("Dialog", 1, 10));
        this.downButton.setMaximumSize(new Dimension(5000, 20));
        this.downButton.setIcon(this.down);
        SAIControlBox.add(this.downButton);
        this.addButton.addActionListener(this);
        this.removeButton.addActionListener(this);
        this.executeButton.addActionListener(this);
        this.upButton.addActionListener(this);
        this.downButton.addActionListener(this);
        SAISubBox.add(SAIControlBox);
        this.actionTable = new CTATSAITable();
        this.actionTable.setBorder(BorderFactory.createLineBorder(Color.black));
        this.actionTable.setMinimumSize(new Dimension(10, 10));
        this.actionTable.setMaximumSize(new Dimension(5000, 5000));
        ListSelectionModel listSelectionModel = this.actionTable.getSelectionModel();
        listSelectionModel.addListSelectionListener(this);
        listSelectionModel.setSelectionMode(0);
        JScrollPane SAIScrollList = new JScrollPane(this.actionTable);
        SAIScrollList.setVerticalScrollBarPolicy(22);
        SAIScrollList.setMinimumSize(new Dimension(10, 10));
        SAIScrollList.setMaximumSize(new Dimension(5000, 5000));
        SAISubBox.add(SAIScrollList);
        CTATSSELink.SAIModel = new DefaultTableModel((Object[][])null, this.columnNames);
        this.actionTable.setModel(CTATSSELink.SAIModel);
        CTATSSELink.SAIModel.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent arg0) {
                CTATStartStateEditor.this.debug("Table changed: " + arg0.getFirstRow() + "," + arg0.getType());
                if (arg0.getType() == 0) {
                    CTATStartStateEditor.this.debug("Propagating SAI settings back into CTAT object ...");
                    CTATSerializableTableEntry entry = (CTATSerializableTableEntry)CTATStartStateEditor.this.actionTable.getValueAt(arg0.getFirstRow(), 0);
                    CTATSAI sai = entry.getSAI();
                    if (sai == null) {
                        CTATStartStateEditor.this.debug("Error, table model doesn't contain an SAI object");
                    }
                }
            }
        });
        JPanel console = new JPanel();
        console.setLayout(new BoxLayout(console, 0));
        console.setMinimumSize(new Dimension(20, 20));
        console.setMaximumSize(new Dimension(5000, 2000));
        console.setBorder(BorderFactory.createMatteBorder(3, 3, 3, 3, new Color(180, 180, 180)));
        console.setBackground(new Color(180, 180, 180));
        console.setFont(new Font("Dialog", 1, 10));
        this.outp = new CTATXMLViewer();
        this.outp.setFont(new Font("Dialog", 1, 10));
        console.add(this.outp);
        this.tabbedPane.addTab("Console", null, console, "tbd");
        JSplitPane splitPane = null;
        splitPane = new JSplitPane(0, previewBox, this.tabbedPane);
        splitPane.setDividerSize(5);
        splitPane.setContinuousLayout(true);
        this.add(splitPane);
        previewBox.setMinimumSize(new Dimension(200, 300));
        this.addComponentListener(this);
        this.buildDisplayList();
        if (CTATSSELink.wServer == null) {
            this.debug("Starting local webserver for incoming image preview materials ...");
            try {
                CTATHTTPServer srv = new CTATHTTPServer(1504, "./", "/logs", new CTATPreviewHandler(this.preview));
                CTATSSELink.wServer = srv;
            }
            catch (Exception e) {
                this.debug("Weirdness just happened!");
                e.printStackTrace();
            }
            this.debug("Server now running");
        } else {
            this.debug("We already have a local webserver running, no need to start another one");
        }
        this.debug("Initialization of the Start State Editor completed.");
    }

    public void setController(BR_Controller aController) {
        this.debug("setController ()");
        this.controller = aController;
        if (this.controller != null) {
            this.pm = this.controller.getProblemModel();
            this.preview.setController(aController);
        }
        this.pm.addProblemModelListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        File file;
        this.debug("actionPerformed ()");
        if (e.getSource() == this.showPreviewCheck) {
            if (this.showPreviewCheck.isSelected()) {
                CTATSSELink.showPreview = true;
                this.preview.updatePreview();
            } else {
                CTATSSELink.showPreview = false;
                this.preview.updatePreview();
            }
        }
        if (e.getSource() == this.xmlButton) {
            this.tabbedPane.setSelectedIndex(2);
            StringBuffer buffer = new StringBuffer();
            buffer.append("<StartState>");
            for (int i = 0; i < CTATSSELink.components.size(); ++i) {
                CTATComponent component = CTATSSELink.components.get(i);
                buffer.append(component.toString());
            }
            buffer.append("</StartState>");
            String result = buffer.toString();
            this.outp.setXML(result);
        }
        if (e.getSource() == this.loadButton) {
            file = DialogUtilities.chooseFile(null, null, null, "Load", "Open", this);
            if (file != null) {
                boolean n = false;
                if (!n) {
                    this.debug("Loading: " + file.getName());
                    this.fromXML(this.fManager.loadContentsXML(file.getAbsolutePath()));
                }
            } else {
                this.debug("Open command cancelled by user.");
            }
        }
        if (e.getSource() == this.saveButton) {
            file = DialogUtilities.chooseFile(null, null, null, "Save", "Save", this);
            if (file != null) {
                this.debug("Saving: " + file.getName());
                this.toXML();
                this.fManager.saveContents(file.getAbsolutePath(), this.loader.toString());
            } else {
                this.debug("Save command cancelled by user");
            }
        }
        if (e.getSource() == this.saveAsButton) {
            file = DialogUtilities.chooseFile(null, null, null, "Save As", "Save", this);
            if (file != null) {
                this.debug("Saving: " + file.getName());
                this.toXML();
                this.fManager.saveContents(file.getAbsolutePath(), this.loader.toString());
            } else {
                this.debug("Save command cancelled by user");
            }
        }
        if (e.getSource() == this.addButton) {
            this.addSAI();
        }
        if (e.getSource() == this.removeButton) {
            this.debug("Removing row ...");
            int sel = this.actionTable.getSelectedRow();
            if (sel == -1) {
                this.debug("Nothing selected!");
                return;
            }
            this.debug("Removing " + sel + " ...");
            CTATSSELink.SAIModel.removeRow(sel);
        }
        if (e.getSource() == this.executeButton) {
            int sel = this.actionTable.getSelectedRow();
            if (sel == -1) {
                this.debug("Nothing selected!");
                return;
            }
            int index = sel;
            CTATSerializableTableEntry entry = (CTATSerializableTableEntry)this.actionTable.getValueAt(index, 0);
            CTATComponent component = entry.getComponent();
            CTATSAI SAI = entry.getSAI();
            this.debug("Selected row is: " + index + " instance: " + component.getInstanceName());
            if (this.controller != null) {
                this.controller.sendInterfaceActionMsg(this.s2v(component.getInstanceName()), this.s2v(SAI.getInput()), this.s2v(SAI.getAction()));
            } else {
                this.debug("Error: no controller available to send interface action action");
            }
        }
        if (e.getSource() == this.upButton) {
            int sel = this.actionTable.getSelectedRow();
            if (sel == -1) {
                this.debug("Nothing selected!");
                return;
            }
            CTATSSELink.SAIModel.moveRow(sel, sel, sel - 1);
        }
        if (e.getSource() == this.downButton) {
            int sel = this.actionTable.getSelectedRow();
            if (sel == -1) {
                this.debug("Nothing selected!");
                return;
            }
            CTATSSELink.SAIModel.moveRow(sel, sel, sel + 1);
        }
        if (e.getSource() == this.zoomInButton) {
            this.preview.zoomIn();
        }
        if (e.getSource() == this.zoomOutButton) {
            this.preview.zoomOut();
        }
    }

    public String toXML() {
        this.debug("toXML ()");
        StringBuffer formatter = new StringBuffer();
        return formatter.toString();
    }

    @Override
    public void fromXML(Element root) {
        this.debug("fromXML ()");
        if (root.getName().equals("StartState")) {
            this.debug("Found start state element");
            for (Element elem : root.getChildren()) {
                if (elem.getName().equals("InterfaceActions")) continue;
                CTATComponent newComponent = new CTATComponent();
                newComponent.fromXML(elem);
                CTATSSELink.components.add(newComponent);
            }
        } else {
            this.debug("Error: no start state element found");
        }
        this.buildDisplayList();
    }

    private CTATComponentPanel findComponentPanel(CTATComponent comp) {
        this.debug("findComponentPanel ()");
        int count = this.componentBox.getComponentCount();
        for (int i = 0; i < count; ++i) {
            CTATComponentPanel componentPanel;
            Component obj = this.componentBox.getComponent(i);
            if (!(obj instanceof CTATComponentPanel) || !(componentPanel = (CTATComponentPanel)obj).getComponent().getInstanceName().equals(comp.getInstanceName())) continue;
            return componentPanel;
        }
        return null;
    }

    public void reset() {
        this.debug("reset ()");
        this.infoLabel.setText(" Tutor: ");
        CTATSSELink.components = new ArrayList();
        this.componentBox.removeAll();
        this.SAITree.removeAll();
        this.SAIByActionTree.removeAll();
        this.revalidate();
    }

    public void buildDisplayList() {
        this.debug("buildDisplayList ()");
        for (int i = 0; i < CTATSSELink.components.size(); ++i) {
            CTATSAITreeNode SAIInstance;
            StringBuffer interfaceFormat;
            CTATSAI interfaceAction;
            int j;
            CTATComponent component = CTATSSELink.components.get(i);
            if (component.getClassType().equals("CTATCommShell")) {
                this.debug("Processing tutor info (CommShell)...");
                this.preview.setTutorWidth((int)component.getWidth());
                this.preview.setTutorHeight((int)component.getHeight());
                this.zoomInButton.setEnabled(true);
                this.zoomOutButton.setEnabled(true);
                this.infoLabel.setText(" Tutor: " + component.getWidth() + "x" + component.getHeight());
                continue;
            }
            this.debug("Processing regular component: " + component.getClassType() + " ...");
            CTATComponentPanel componentPanel = null;
            componentPanel = this.findComponentPanel(component);
            if (componentPanel != null) continue;
            componentPanel = new CTATComponentPanel();
            componentPanel.setMinimumSize(new Dimension(20, 26));
            componentPanel.setPreferredSize(new Dimension(this.componentBox.getWidth(), componentPanel.getFixedHeight()));
            componentPanel.setMaximumSize(new Dimension(5000, componentPanel.getFixedHeight()));
            componentPanel.setComponent(component);
            componentPanel.setController(this.controller);
            componentPanel.setPreview(this.preview);
            this.componentBox.add(componentPanel);
            componentPanel.foldIn();
            this.debug("Fill the SAI panel(s) ...");
            DefaultMutableTreeNode compInstance = new DefaultMutableTreeNode(component.getInstanceName() + " (" + component.getClassType() + ")");
            ArrayList<CTATSAI> SAIs = component.getSAIs();
            for (j = 0; j < SAIs.size(); ++j) {
                interfaceAction = SAIs.get(j);
                interfaceFormat = new StringBuffer();
                if (interfaceAction.getArgumentSize() > 1) {
                    interfaceFormat.append(interfaceAction.getAction() + " (" + interfaceAction.toArgumentString() + ")");
                } else {
                    interfaceFormat.append(interfaceAction.getAction() + " (" + interfaceAction.getType() + ")");
                }
                this.debug("Adding: " + interfaceFormat.toString());
                SAIInstance = new CTATSAITreeNode(interfaceFormat.toString());
                SAIInstance.setSAI(interfaceAction);
                SAIInstance.setComponent(component);
                compInstance.add(SAIInstance);
            }
            this.SAIRoot.add(compInstance);
            for (j = 0; j < SAIs.size(); ++j) {
                interfaceAction = SAIs.get(j);
                interfaceFormat = new StringBuffer();
                if (interfaceAction.getArgumentSize() > 1) {
                    interfaceFormat.append(interfaceAction.getAction() + " (" + interfaceAction.toArgumentString() + ")");
                } else {
                    interfaceFormat.append(interfaceAction.getAction() + " (" + interfaceAction.getType() + ")");
                }
                this.debug("Adding: " + interfaceFormat.toString());
                SAIInstance = new CTATSAITreeNode(interfaceFormat.toString());
                SAIInstance.setSAI(interfaceAction);
                SAIInstance.setComponent(component);
                this.SAIRootByAction.add(SAIInstance);
            }
            this.SAITree.updateUI();
            for (int k = 0; k < this.SAITree.getRowCount(); ++k) {
                this.SAITree.expandRow(k);
            }
            for (int l = 0; l < this.SAITree.getRowCount(); ++l) {
                this.SAIByActionTree.expandRow(l);
            }
        }
        this.revalidate();
        this.preview.repaint();
    }

    @Override
    public void problemModelEventOccurred(ProblemModelEvent e) {
        this.debug("problemModelEventOccurred ()");
        if (e instanceof CTATStartStateEvent) {
            CTATStartStateEvent event = (CTATStartStateEvent)e;
            if (event.getState().equals("InterfaceAction")) {
                this.processStartStateSAI((CTATSAI)event.getTarget());
                return;
            }
            if (event.getState().equals("InterfaceDescription")) {
                this.buildDisplayList();
                return;
            }
            if (event.getState().equals("NewGraph")) {
                this.reset();
                return;
            }
            if (event.getState().equals("InterfaceConnected")) {
                this.preview.setIsConnected(true);
                this.reset();
                return;
            }
            if (event.getState().equals("InterfaceDisconnected")) {
                this.infoLabel.setText(" Tutor: ");
                this.zoomInButton.setEnabled(false);
                this.zoomOutButton.setEnabled(false);
                this.preview.setIsConnected(false);
                return;
            }
        }
    }

    private void processStartStateSAI(CTATSAI anSAI) {
        this.debug("processStartStateSAI ()");
        this.debug("Adding: " + anSAI.getClassName());
        if (CTATSSELink.SAIModel == null) {
            CTATSSELink.SAIModel = new DefaultTableModel((Object[][])null, this.columnNames);
            this.actionTable.setModel(CTATSSELink.SAIModel);
        }
        CTATComponent incomingSelection = CTATSSELink.getComponent(anSAI.getName());
        CTATSerializableTableEntry selectionEntry = new CTATSerializableTableEntry(anSAI.getName());
        selectionEntry.setSAI(anSAI);
        selectionEntry.setComponent(incomingSelection);
        CTATSerializableTableEntry actionEntry = new CTATSerializableTableEntry(anSAI.getAction());
        actionEntry.setSAI(anSAI);
        actionEntry.setComponent(incomingSelection);
        CTATSerializableTableEntry valueEntry = new CTATSerializableTableEntry(anSAI.getInput());
        valueEntry.setSAI(anSAI);
        valueEntry.setComponent(incomingSelection);
        Object[] parameterData = new CTATSerializableTableEntry[]{selectionEntry, actionEntry, valueEntry};
        CTATSSELink.SAIModel.addRow(parameterData);
        this.actionTable.setModel(CTATSSELink.SAIModel);
        TableColumn colS = this.actionTable.getColumnModel().getColumn(2);
        colS.setCellEditor(new CTATSheetCellEditor());
    }

    private void addSAI() {
        this.debug("addSAI ()");
        if (this.actionSelection == null || this.componentSelection == null) {
            this.debug("Info: nothing selected!");
        } else {
            this.debug("Adding: " + this.actionSelection.getClassName());
            CTATSerializableTableEntry selectionEntry = new CTATSerializableTableEntry(this.componentSelection.getInstanceName());
            selectionEntry.setSAI(this.actionSelection);
            selectionEntry.setComponent(this.componentSelection);
            CTATSerializableTableEntry actionEntry = new CTATSerializableTableEntry(this.actionSelection.getAction());
            actionEntry.setSAI(this.actionSelection);
            actionEntry.setComponent(this.componentSelection);
            CTATSerializableTableEntry valueEntry = new CTATSerializableTableEntry(this.actionSelection.getInput());
            valueEntry.setSAI(this.actionSelection);
            valueEntry.setComponent(this.componentSelection);
            Object[] parameterData = new CTATSerializableTableEntry[]{selectionEntry, actionEntry, valueEntry};
            CTATSSELink.SAIModel.addRow(parameterData);
            this.actionTable.setModel(CTATSSELink.SAIModel);
        }
        TableColumn colS = this.actionTable.getColumnModel().getColumn(2);
        colS.setCellEditor(new CTATSheetCellEditor());
    }

    @Override
    public void valueChanged(TreeSelectionEvent event) {
        this.debug("SAITree: valueChanged ()");
    }

    @Override
    public void valueChanged(ListSelectionEvent event) {
        this.debug("SAITable: valueChanged ()");
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.debug("mouseClicked ()");
        if (e.getClickCount() == 1) {
            this.debug("single click ...");
            if (e.getSource() == this.SAITree) {
                this.actionSelection = null;
                this.componentSelection = null;
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.SAITree.getLastSelectedPathComponent();
                if (node == null) {
                    return;
                }
                if (node instanceof CTATSAITreeNode) {
                    CTATSAITreeNode tNode = (CTATSAITreeNode)node;
                    this.actionSelection = tNode.getSAI();
                    this.componentSelection = tNode.getComponent();
                    this.debug("Selected SAI: " + this.actionSelection.getClassName());
                }
            }
        }
        if (e.getClickCount() == 2) {
            this.debug("double click ...");
            if (e.getSource() == this.SAITree) {
                this.addSAI();
            }
            if (e.getSource() == this.SAIByActionTree) {
                // empty if block
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent arg0) {
    }

    @Override
    public void mouseExited(MouseEvent arg0) {
    }

    @Override
    public void mousePressed(MouseEvent arg0) {
    }

    @Override
    public void mouseReleased(MouseEvent arg0) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
    }

    @Override
    public void componentHidden(ComponentEvent arg0) {
        this.debug("componentHidden ()");
    }

    @Override
    public void componentShown(ComponentEvent e) {
        this.debug("componentShown ()");
    }
}

