/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.BehaviorRecorder.Dialogs;

import edu.cmu.pact.BehaviorRecorder.Controller.BR_Controller;
import edu.cmu.pact.BehaviorRecorder.Dialogs.DialogUtilities;
import edu.cmu.pact.BehaviorRecorder.Dialogs.LoadFileDialog;
import edu.cmu.pact.BehaviorRecorder.Dialogs.SaveFileDialog;
import edu.cmu.pact.BehaviorRecorder.Tab.CTATTab;
import edu.cmu.pact.BehaviorRecorder.View.JUndo;
import edu.cmu.pact.Utilities.Utils;
import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.ctat.WebServerLauncher;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.UUID;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class LaunchInterfaceAsListenerDialog
extends JDialog {
    private static final long serialVersionUID = 201706302001L;
    private final String discInstructions = "<html>The launch button on this dialogue will display the specified HTML file (student interface or other .html) in your browser. If a problem file (Behavior Recorder .brd file or problem-specific .nools file) is given, the student interface will load that file also. Here, the tutor will <b>not</b> use the example tracer or rules-based model tracer in the authoring tools, nor communicate with the Behavior Recorder at all. Instead, the interface is expected to have its own tutoring engine.</html>";
    private final String tabInstructions = "<html>The launch button on this dialogue will display an HTML student interface in your browser and connect it to the foreground Behavior Recorder graph. Here, the tutor will <i>not</i> use the example tracer or rules-based tracer in the authoring tools. Instead, the interface is expected to have its own tutoring engine, initialized by the problem file given below. The behavior graph in this case only records actions and evaluations in the tutor for visualization and replay. It will not grade student actions or provide hints.</html>";
    private JLabel htmlFileLabel = new JLabel("Select the student interface (.html) to launch.");
    private JTextField htmlFileTextField = new JTextField("");
    private JButton htmlFileBrowseButton;
    private JLabel problemFileLabel;
    private JTextField problemFileTextField;
    private JButton problemFileBrowseButton;
    protected BR_Controller controller;
    protected File problemFile;
    protected File htmlFile;
    private CTATTab tab;
    private String tabQuestionFile;
    private static String prevHtmlFileName = "";
    private static String prevProblemFileName = "";
    private static final Pattern hasNoolsExt = Pattern.compile(".*[.]nools *$", 2);

    public LaunchInterfaceAsListenerDialog(BR_Controller controller) {
        this(controller, null);
    }

    public LaunchInterfaceAsListenerDialog(BR_Controller controller, CTATTab tab) {
        super((Frame)(tab == null || tab.getController() == null ? controller : tab.getController()).getActiveWindow(), true);
        JUndo.JTextUndoPacket jTextUndoPacket = JUndo.makeTextUndoable(this.htmlFileTextField);
        this.htmlFileBrowseButton = new JButton("Browse...");
        this.problemFileLabel = new JLabel("Select the problem file (.brd, e.g.) for the tutor.");
        this.problemFileTextField = new JTextField("");
        jTextUndoPacket = JUndo.makeTextUndoable(this.problemFileTextField);
        this.problemFileBrowseButton = new JButton("Browse...");
        this.problemFile = null;
        this.htmlFile = null;
        this.tab = null;
        this.tabQuestionFile = null;
        this.tab = tab;
        if (this.tab != null) {
            this.controller = this.tab.getController();
            this.tabQuestionFile = this.tab.getProblemModel() != null ? this.tab.getProblemModel().getProblemFullName() : null;
        } else {
            this.controller = controller;
        }
        this.setTitle("Launch HTML Tutor as Server Only");
        if (prevProblemFileName.length() < 1 && this.tabQuestionFile != null && this.tabQuestionFile.length() > 0) {
            prevProblemFileName = this.tabQuestionFile;
        }
        this.htmlFileBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LaunchInterfaceAsListenerDialog.this.htmlFileBrowseButtonClicked();
            }
        });
        this.problemFileBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LaunchInterfaceAsListenerDialog.this.problemFileBrowseButtonClicked();
            }
        });
        this.htmlFileTextField.setText(this.getDefaultHtmlFileName());
        this.problemFileTextField.setText(prevProblemFileName);
        this.initUI();
    }

    protected String getDefaultHtmlFileName() {
        return prevHtmlFileName;
    }

    protected void htmlFileBrowseButtonClicked() {
        File f;
        File textFieldFile;
        String targetDir = SaveFileDialog.getBrdFileOtherLocation(this.controller);
        File file = textFieldFile = this.htmlFileTextField.getText().isEmpty() ? null : new File(this.htmlFileTextField.getText());
        if (textFieldFile != null && textFieldFile.getParentFile() != null) {
            targetDir = textFieldFile.getParentFile().getAbsolutePath();
        }
        if ((f = DialogUtilities.chooseFile(targetDir, null, "Open Student Interface (.htm or .html)", "Open", this.controller)) != null) {
            this.htmlFileTextField.setText(f.getAbsolutePath());
        }
    }

    protected void problemFileBrowseButtonClicked() {
        File f;
        File textFieldFile;
        String targetDir = SaveFileDialog.getBrdFileOtherLocation(this.controller);
        File file = textFieldFile = this.problemFileTextField.getText().isEmpty() ? null : new File(this.problemFileTextField.getText());
        if (textFieldFile != null && textFieldFile.getParentFile() != null) {
            targetDir = textFieldFile.getParentFile().getAbsolutePath();
        }
        if ((f = DialogUtilities.chooseFile(targetDir, null, "Open Problem File (.brd or .nools)", "Open", this.controller)) != null) {
            this.problemFileTextField.setText(f.getAbsolutePath());
        }
    }

    private File checkFileExistence(String fileName, String prompt, boolean mustSpecify) {
        if (mustSpecify && (fileName == null || fileName.trim().equals(""))) {
            if (trace.getDebugCode("fileserver")) {
                trace.printStack("fileserver", "checkFileExistence(" + fileName + ", " + prompt + ", " + mustSpecify + ") needProblemFile " + this.getNeedProblemFile());
            }
            String title = "Filename Missing";
            JOptionPane.showMessageDialog(this, "<html>" + prompt + "</html>", title, 2);
            return null;
        }
        File result = null;
        if (!(mustSpecify || fileName != null && fileName.length() >= 1)) {
            return result;
        }
        result = new File(fileName);
        if (!result.canRead() && result.isFile()) {
            String message = "<html><p>File " + fileName + " could not be found or is not readable</p><p>" + prompt + "</p></html>";
            String title = "File Missing or Unreadable";
            JOptionPane.showMessageDialog(this, message, title, 2);
            return null;
        }
        return result;
    }

    protected boolean getNeedProblemFile() {
        return true;
    }

    protected String getPromptForHtmlFile() {
        return "Please select a student interface (.html) file.";
    }

    protected boolean checkFileEntries() {
        String htmlFileName = this.htmlFileTextField.getText();
        String problemFileName = this.problemFileTextField.getText();
        this.htmlFile = this.checkFileExistence(htmlFileName, this.getPromptForHtmlFile(), true);
        if (null == this.htmlFile) {
            return false;
        }
        this.saveDefaultHtmlFileName(this.htmlFile.getAbsolutePath());
        if (this.getNeedProblemFile()) {
            this.problemFile = this.checkFileExistence(problemFileName, "<html>Please select a problem (.brd or .nools) file.</html>", true);
            if (!(this.tab == null || this.problemFile != null && this.maybeLoadProblemFileIntoTab())) {
                return false;
            }
            prevProblemFileName = this.problemFile == null ? prevProblemFileName : this.problemFile.getAbsolutePath();
        }
        return true;
    }

    protected void saveDefaultHtmlFileName(String path) {
        prevHtmlFileName = path;
    }

    private boolean maybeLoadProblemFileIntoTab() {
        File tabFile;
        if (this.controller == null || this.problemFile == null) {
            return false;
        }
        if (hasNoolsExt.matcher(this.problemFile.getName()).matches()) {
            return true;
        }
        if (this.tabQuestionFile != null && this.tabQuestionFile.length() > 0 && this.problemFile.equals(tabFile = new File(this.tabQuestionFile))) {
            return true;
        }
        int yesNoCancel = JOptionPane.showConfirmDialog(this.controller != null ? this.controller.getActiveWindow() : null, "Display this file in the tab's graph panel?\n\n" + this.problemFile.getAbsolutePath(), "Load chosen file?", 1, 3);
        boolean loaded = false;
        if (yesNoCancel == 0) {
            loaded = LoadFileDialog.doLoadBRDFile(this.controller.getServer(), this.controller, this.problemFile.getName(), this.problemFile.getParent() + File.separator, true);
        }
        if (trace.getDebugCode("html")) {
            trace.out("html", "Reply from Load chosen file " + this.problemFile.getName() + "? " + (yesNoCancel == 2 ? "Cancel" : (yesNoCancel == 1 ? "No" : "Yes")) + ", file actually loaded " + loaded);
        }
        return yesNoCancel != 2;
    }

    private void initUI() {
        JPanel pane = new JPanel();
        pane.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 19;
        JLabel instructionsLabel = new JLabel(this.getInstructionsLabel());
        instructionsLabel.setBorder(BorderFactory.createLineBorder(Color.black));
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 3;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.2;
        c.insets = new Insets(9, 15, 3, 15);
        c.ipadx = 10;
        c.ipady = 5;
        c.fill = 1;
        pane.add((Component)instructionsLabel, c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 2;
        c.gridheight = 1;
        c.weightx = 0.9;
        c.weighty = 0.0;
        c.insets = new Insets(3, 15, 3, 15);
        c.ipadx = 0;
        c.ipady = 0;
        c.fill = 2;
        pane.add((Component)this.htmlFileLabel, c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 2;
        c.gridheight = 1;
        c.weightx = 0.9;
        c.weighty = 0.0;
        c.fill = 1;
        pane.add((Component)this.htmlFileTextField, c);
        c.gridx = 2;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.1;
        c.weighty = 0.0;
        c.fill = 2;
        pane.add((Component)this.htmlFileBrowseButton, c);
        this.addProblemFileElements(pane, c);
        JLabel spacerAbove = new JLabel(" ");
        c.insets = new Insets(0, 15, 0, 15);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 2;
        c.gridheight = 1;
        c.weightx = 0.9;
        c.weighty = 0.0;
        c.fill = 2;
        pane.add((Component)spacerAbove, c);
        JLabel spacerLeft = new JLabel(" ");
        c.insets = new Insets(3, 15, 9, 15);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.8;
        c.weighty = 0.0;
        pane.add((Component)spacerLeft, c);
        c.gridx = 1;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.1;
        c.weighty = 0.0;
        c.anchor = 24;
        JButton launchButton = new JButton("Launch");
        pane.add((Component)launchButton, c);
        launchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (LaunchInterfaceAsListenerDialog.this.checkFileEntries()) {
                    LaunchInterfaceAsListenerDialog.this.launch();
                }
                LaunchInterfaceAsListenerDialog.this.setVisible(false);
                LaunchInterfaceAsListenerDialog.this.dispose();
            }
        });
        c.gridx = 2;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.1;
        c.weighty = 0.0;
        JButton cancelButton = new JButton("Cancel");
        pane.add((Component)cancelButton, c);
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (trace.getDebugCode("html")) {
                    trace.out("html", "cancel button clicked");
                }
                LaunchInterfaceAsListenerDialog.this.setVisible(false);
                LaunchInterfaceAsListenerDialog.this.dispose();
            }
        });
        this.setContentPane(pane);
        this.setDefaultCloseOperation(2);
        if (this.controller != null) {
            this.setLocationRelativeTo(this.controller.getJGraphWindow());
        }
        this.setMinimumSize(new Dimension(500, 350));
        this.setVisible(true);
    }

    protected void addProblemFileElements(JPanel pane, GridBagConstraints c) {
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 2;
        c.gridheight = 1;
        c.weightx = 0.9;
        c.weighty = 0.0;
        c.fill = 2;
        pane.add((Component)this.problemFileLabel, c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 2;
        c.gridheight = 1;
        c.weightx = 0.9;
        c.weighty = 0.0;
        c.fill = 1;
        pane.add((Component)this.problemFileTextField, c);
        c.gridx = 2;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.1;
        c.weighty = 0.0;
        c.fill = 2;
        pane.add((Component)this.problemFileBrowseButton, c);
    }

    protected String getInstructionsLabel() {
        return this.tab == null ? "<html>The launch button on this dialogue will display the specified HTML file (student interface or other .html) in your browser. If a problem file (Behavior Recorder .brd file or problem-specific .nools file) is given, the student interface will load that file also. Here, the tutor will <b>not</b> use the example tracer or rules-based model tracer in the authoring tools, nor communicate with the Behavior Recorder at all. Instead, the interface is expected to have its own tutoring engine.</html>" : "<html>The launch button on this dialogue will display an HTML student interface in your browser and connect it to the foreground Behavior Recorder graph. Here, the tutor will <i>not</i> use the example tracer or rules-based tracer in the authoring tools. Instead, the interface is expected to have its own tutoring engine, initialized by the problem file given below. The behavior graph in this case only records actions and evaluations in the tutor for visualization and replay. It will not grade student actions or provide hints.</html>";
    }

    private void launchHTMLPage(File htmlFile, File problemFile) {
        String errMsg = null;
        try {
            WebServerLauncher wsl = new WebServerLauncher();
            if (trace.getDebugCode("html")) {
                trace.out("html", "LaunchInterfaceAsListenerDialog.launchHTMLPage(" + htmlFile + ", " + problemFile + ")");
            }
            errMsg = wsl.launchServerAndHTMLPage(htmlFile, problemFile, "S" + UUID.randomUUID().toString(), null);
        }
        catch (Exception e) {
            errMsg = "Error launching web browser for file " + htmlFile;
            trace.errStack(errMsg + ", problem_file " + problemFile, e);
            Utils.showExceptionOccuredDialog(e, errMsg, "Error Launching Browser");
            return;
        }
        if (errMsg != null) {
            Utils.showExceptionOccuredDialog(null, errMsg, "Error Launching Browser");
        }
    }

    private void launch() {
        if (trace.getDebugCode("html")) {
            trace.out("html", "launch() html " + this.htmlFile + ", problemFile " + this.problemFile);
        }
        if (this.tab == null) {
            this.launchHTMLPage(this.htmlFile, this.problemFile);
            return;
        }
        this.tab.setTargetHTMLFile(this.htmlFile);
        this.tab.launchHTMLPageAsListener(this.problemFile);
    }

    public static void main(String[] args) {
        trace.addDebugCode("html");
        new LaunchInterfaceAsListenerDialog(null);
    }
}

