"use strict";

/* jshint ignore:start */



/* jshint ignore:end */

define('dashboard/app', ['exports', 'ember', 'dashboard/resolver', 'ember-load-initializers', 'dashboard/config/environment'], function (exports, _ember, _dashboardResolver, _emberLoadInitializers, _dashboardConfigEnvironment) {

  var App = undefined;

  _ember['default'].MODEL_FACTORY_INJECTIONS = true;

  App = _ember['default'].Application.extend({
    modulePrefix: _dashboardConfigEnvironment['default'].modulePrefix,
    podModulePrefix: _dashboardConfigEnvironment['default'].podModulePrefix,
    Resolver: _dashboardResolver['default']
  });

  (0, _emberLoadInitializers['default'])(App, _dashboardConfigEnvironment['default'].modulePrefix);

  exports['default'] = App;
});
define('dashboard/components/app-version', ['exports', 'ember-cli-app-version/components/app-version', 'dashboard/config/environment'], function (exports, _emberCliAppVersionComponentsAppVersion, _dashboardConfigEnvironment) {

  var name = _dashboardConfigEnvironment['default'].APP.name;
  var version = _dashboardConfigEnvironment['default'].APP.version;

  exports['default'] = _emberCliAppVersionComponentsAppVersion['default'].extend({
    version: version,
    name: name
  });
});
define('dashboard/components/bullet-chart/component', ['exports', 'ember'], function (exports, _ember) {
  exports['default'] = _ember['default'].Component.extend({
    didInsertElement: function didInsertElement() {
      this._super.apply(this, arguments);

      var students = this.get('students');
      var skills = this.get('skills');
      var skillMasteries = this.get('skillMasteries');

      var data = [];
      skills.forEach(function (skill) {
        var row = {};
        var skillId = skill.get('id');
        var masteryCount = 0;
        var opportunityCount = 0;
        if (skillMasteries[skillId]) {
          for (var studentId in skillMasteries[skillId]) {
            var ms = skillMasteries[skillId][studentId];
            if (ms.percentage > 0.95) {
              masteryCount += 1;
              opportunityCount += 1;
            } else if (ms.opportunity >= 10) {
              opportunityCount += 1;
            }
          }
        }
        row["title"] = skill.get('name');
        row["ranges"] = [opportunityCount, 9, 9];
        row["measures"] = [masteryCount, opportunityCount];
        row["markers"] = [masteryCount];
        data.push(row);
      });

      // Bullet helpers
      // Chart design based on the recommendations of Stephen Few. Implementation
      // based on the work of Clint Ivy, Jamie Love, and Jason Davies.
      // http://projects.instantcognition.com/protovis/bulletchart/
      d3.bullet = function () {
        var orient = "left",
            // TODO top & bottom
        reverse = false,
            duration = 0,
            ranges = bulletRanges,
            markers = bulletMarkers,
            measures = bulletMeasures,
            width = 380,
            height = 30,
            tickFormat = null;

        // For each small multiple…
        function bullet(g) {
          g.each(function (d, i) {
            var rangez = ranges.call(this, d, i).slice().sort(d3.descending),
                markerz = markers.call(this, d, i).slice().sort(d3.descending),
                measurez = measures.call(this, d, i).slice().sort(d3.descending),
                g = d3.select(this);

            // Compute the new x-scale.
            var x1 = d3.scaleLinear().domain([0, Math.max(rangez[0], markerz[0], measurez[0])]).range(reverse ? [width, 0] : [0, width]);

            // Retrieve the old x-scale, if this is an update.
            var x0 = this.__chart__ || d3.scaleLinear().domain([0, Infinity]).range(x1.range());

            // Stash the new scale.
            this.__chart__ = x1;

            // Derive width-scales from the x-scales.
            var w0 = bulletWidth(x0),
                w1 = bulletWidth(x1);

            // Update the range rects.
            var range = g.selectAll("rect.range").data(rangez);

            range.enter().append("rect").attr("class", function (d, i) {
              return "range s" + i;
            }).attr("width", w0).attr("height", height).attr("x", reverse ? x0 : 0).transition().duration(duration).attr("width", w1).attr("x", reverse ? x1 : 0);

            range.transition().duration(duration).attr("x", reverse ? x1 : 0).attr("width", w1).attr("height", height);

            // Update the measure rects.
            var measure = g.selectAll("rect.measure").data(measurez);

            measure.enter().append("rect").attr("class", function (d, i) {
              return "measure s" + i;
            }).attr("width", w0).attr("height", height / 3).attr("x", reverse ? x0 : 0).attr("y", height / 3).transition().duration(duration).attr("width", w1).attr("x", reverse ? x1 : 0);

            measure.transition().duration(duration).attr("width", w1).attr("height", height / 3).attr("x", reverse ? x1 : 0).attr("y", height / 3);

            // Update the marker lines.
            var marker = g.selectAll("line.marker").data(markerz);

            marker.enter().append("line").attr("class", "marker").attr("x1", x0).attr("x2", x0).attr("y1", height / 6).attr("y2", height * 5 / 6).transition().duration(duration).attr("x1", x1).attr("x2", x1);

            marker.transition().duration(duration).attr("x1", x1).attr("x2", x1).attr("y1", height / 6).attr("y2", height * 5 / 6);

            // Compute the tick format.
            var format = tickFormat || x1.tickFormat(8);

            // Update the tick groups.
            var tick = g.selectAll("g.tick").data(x1.ticks(8), function (d) {
              return this.textContent || format(d);
            });

            // Initialize the ticks with the old scale, x0.
            var tickEnter = tick.enter().append("g").attr("class", "tick").attr("transform", bulletTranslate(x0)).style("opacity", 1e-6);

            tickEnter.append("line").attr("y1", height).attr("y2", height * 7 / 6);

            tickEnter.append("text").attr("text-anchor", "middle").attr("dy", "1em").attr("y", height * 7 / 6).text(format);

            // Transition the entering ticks to the new scale, x1.
            tickEnter.transition().duration(duration).attr("transform", bulletTranslate(x1)).style("opacity", 1);

            // Transition the updating ticks to the new scale, x1.
            var tickUpdate = tick.transition().duration(duration).attr("transform", bulletTranslate(x1)).style("opacity", 1);

            tickUpdate.select("line").attr("y1", height).attr("y2", height * 7 / 6);

            tickUpdate.select("text").attr("y", height * 7 / 6);

            // Transition the exiting ticks to the new scale, x1.
            tick.exit().transition().duration(duration).attr("transform", bulletTranslate(x1)).style("opacity", 1e-6).remove();
          });
          //d3.timer.flush();
        }

        // left, right, top, bottom
        bullet.orient = function (x) {
          if (!arguments.length) {
            return orient;
          }
          orient = x;
          reverse = orient === "right" || orient === "bottom";
          return bullet;
        };

        // ranges (bad, satisfactory, good)
        bullet.ranges = function (x) {
          if (!arguments.length) {
            return ranges;
          }
          ranges = x;
          return bullet;
        };

        // markers (previous, goal)
        bullet.markers = function (x) {
          if (!arguments.length) {
            return markers;
          }
          markers = x;
          return bullet;
        };

        // measures (actual, forecast)
        bullet.measures = function (x) {
          if (!arguments.length) {
            return measures;
          }
          measures = x;
          return bullet;
        };

        bullet.width = function (x) {
          if (!arguments.length) {
            return width;
          }
          width = x;
          return bullet;
        };

        bullet.height = function (x) {
          if (!arguments.length) {
            return height;
          }
          height = x;
          return bullet;
        };

        bullet.tickFormat = function (x) {
          if (!arguments.length) {
            return tickFormat;
          }
          tickFormat = x;
          return bullet;
        };

        bullet.duration = function (x) {
          if (!arguments.length) {
            return duration;
          }
          duration = x;
          return bullet;
        };

        return bullet;
      };

      function bulletRanges(d) {
        return d.ranges;
      }

      function bulletMarkers(d) {
        return d.markers;
      }

      function bulletMeasures(d) {
        return d.measures;
      }

      function bulletTranslate(x) {
        return function (d) {
          return "translate(" + x(d) + ",0)";
        };
      }

      function bulletWidth(x) {
        var x0 = x(0);
        return function (d) {
          return Math.abs(x(d) - x0);
        };
      }

      // Render
      var margin = { top: 5, right: 40, bottom: 20, left: 120 };
      var width = 960 - margin.left - margin.right;
      var height = 50 - margin.top - margin.bottom;

      var chart = d3.bullet().width(width).height(height);

      var svg = d3.select("div.bullet-chart").selectAll("svg").data(data).enter().append("svg").attr("class", "bullet svg-inline").attr("viewBox", "0 0 960 50").attr("preserveAspectRatio", "xMidYMid meet")
      //.attr("width", width + margin.left + margin.right)
      //.attr("height", height + margin.top + margin.bottom)
      .append("g").attr("transform", "translate(" + margin.left + "," + margin.top + ")").call(chart);

      var title = svg.append("g").style("text-anchor", "end").attr("transform", "translate(-6," + height / 2 + ")");

      title.append("text").attr("class", "title").text(function (d) {
        return d.title;
      });
    }
  });
});
define("dashboard/components/bullet-chart/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    return {
      meta: {
        "fragmentReason": {
          "name": "triple-curlies"
        },
        "revision": "Ember@2.5.1",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 2,
            "column": 0
          }
        },
        "moduleName": "dashboard/components/bullet-chart/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createElement("div");
        dom.setAttribute(el1, "class", "bullet-chart");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes() {
        return [];
      },
      statements: [],
      locals: [],
      templates: []
    };
  })());
});
define('dashboard/components/circle-indicator/component', ['exports', 'ember'], function (exports, _ember) {
  exports['default'] = _ember['default'].Component.extend({});
});
define("dashboard/components/circle-indicator/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      return {
        meta: {
          "fragmentReason": {
            "name": "triple-curlies"
          },
          "revision": "Ember@2.5.1",
          "loc": {
            "source": null,
            "start": {
              "line": 1,
              "column": 0
            },
            "end": {
              "line": 3,
              "column": 0
            }
          },
          "moduleName": "dashboard/components/circle-indicator/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("  ");
          dom.appendChild(el0, el1);
          var el1 = dom.createElement("i");
          dom.setAttribute(el1, "class", "green large checkmark icon");
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes() {
          return [];
        },
        statements: [],
        locals: [],
        templates: []
      };
    })();
    var child1 = (function () {
      var child0 = (function () {
        return {
          meta: {
            "fragmentReason": false,
            "revision": "Ember@2.5.1",
            "loc": {
              "source": null,
              "start": {
                "line": 3,
                "column": 0
              },
              "end": {
                "line": 7,
                "column": 0
              }
            },
            "moduleName": "dashboard/components/circle-indicator/template.hbs"
          },
          isEmpty: false,
          arity: 0,
          cachedFragment: null,
          hasRendered: false,
          buildFragment: function buildFragment(dom) {
            var el0 = dom.createDocumentFragment();
            var el1 = dom.createTextNode("  ");
            dom.appendChild(el0, el1);
            dom.setNamespace("http://www.w3.org/2000/svg");
            var el1 = dom.createElement("svg");
            dom.setAttribute(el1, "class", "svg-inline");
            dom.setAttribute(el1, "height", "12");
            dom.setAttribute(el1, "width", "12");
            var el2 = dom.createTextNode("\n    ");
            dom.appendChild(el1, el2);
            var el2 = dom.createElement("circle");
            dom.setAttribute(el2, "cx", "50%");
            dom.setAttribute(el2, "cy", "50%");
            dom.setAttribute(el2, "r", "6");
            dom.setAttribute(el2, "stroke-width", "0");
            dom.setAttribute(el2, "fill", "#FF9500");
            dom.appendChild(el1, el2);
            var el2 = dom.createTextNode("\n  ");
            dom.appendChild(el1, el2);
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            return el0;
          },
          buildRenderNodes: function buildRenderNodes() {
            return [];
          },
          statements: [],
          locals: [],
          templates: []
        };
      })();
      var child1 = (function () {
        var child0 = (function () {
          return {
            meta: {
              "fragmentReason": false,
              "revision": "Ember@2.5.1",
              "loc": {
                "source": null,
                "start": {
                  "line": 7,
                  "column": 0
                },
                "end": {
                  "line": 11,
                  "column": 0
                }
              },
              "moduleName": "dashboard/components/circle-indicator/template.hbs"
            },
            isEmpty: false,
            arity: 0,
            cachedFragment: null,
            hasRendered: false,
            buildFragment: function buildFragment(dom) {
              var el0 = dom.createDocumentFragment();
              var el1 = dom.createTextNode("  ");
              dom.appendChild(el0, el1);
              dom.setNamespace("http://www.w3.org/2000/svg");
              var el1 = dom.createElement("svg");
              dom.setAttribute(el1, "class", "svg-inline");
              dom.setAttribute(el1, "height", "12");
              dom.setAttribute(el1, "width", "12");
              var el2 = dom.createTextNode("\n    ");
              dom.appendChild(el1, el2);
              var el2 = dom.createElement("circle");
              dom.setAttribute(el2, "cx", "50%");
              dom.setAttribute(el2, "cy", "50%");
              dom.setAttribute(el2, "r", "3");
              dom.setAttribute(el2, "stroke-width", "0");
              dom.setAttribute(el2, "fill", "#34AADC");
              dom.appendChild(el1, el2);
              var el2 = dom.createTextNode("\n  ");
              dom.appendChild(el1, el2);
              dom.appendChild(el0, el1);
              var el1 = dom.createTextNode("\n");
              dom.appendChild(el0, el1);
              return el0;
            },
            buildRenderNodes: function buildRenderNodes() {
              return [];
            },
            statements: [],
            locals: [],
            templates: []
          };
        })();
        return {
          meta: {
            "fragmentReason": false,
            "revision": "Ember@2.5.1",
            "loc": {
              "source": null,
              "start": {
                "line": 7,
                "column": 0
              },
              "end": {
                "line": 11,
                "column": 0
              }
            },
            "moduleName": "dashboard/components/circle-indicator/template.hbs"
          },
          isEmpty: false,
          arity: 0,
          cachedFragment: null,
          hasRendered: false,
          buildFragment: function buildFragment(dom) {
            var el0 = dom.createDocumentFragment();
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            return el0;
          },
          buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
            var morphs = new Array(1);
            morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
            dom.insertBoundary(fragment, 0);
            dom.insertBoundary(fragment, null);
            return morphs;
          },
          statements: [["block", "if", [["subexpr", "eq", [["get", "indicatorType", ["loc", [null, [7, 14], [7, 27]]]], "NotEnoughOpportunity"], [], ["loc", [null, [7, 10], [7, 51]]]]], [], 0, null, ["loc", [null, [7, 0], [11, 0]]]]],
          locals: [],
          templates: [child0]
        };
      })();
      return {
        meta: {
          "fragmentReason": false,
          "revision": "Ember@2.5.1",
          "loc": {
            "source": null,
            "start": {
              "line": 3,
              "column": 0
            },
            "end": {
              "line": 11,
              "column": 0
            }
          },
          "moduleName": "dashboard/components/circle-indicator/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
          dom.insertBoundary(fragment, 0);
          dom.insertBoundary(fragment, null);
          return morphs;
        },
        statements: [["block", "if", [["subexpr", "eq", [["get", "indicatorType", ["loc", [null, [3, 14], [3, 27]]]], "skillNotMastered"], [], ["loc", [null, [3, 10], [3, 47]]]]], [], 0, 1, ["loc", [null, [3, 0], [11, 0]]]]],
        locals: [],
        templates: [child0, child1]
      };
    })();
    return {
      meta: {
        "fragmentReason": {
          "name": "missing-wrapper",
          "problems": ["wrong-type"]
        },
        "revision": "Ember@2.5.1",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 12,
            "column": 0
          }
        },
        "moduleName": "dashboard/components/circle-indicator/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var morphs = new Array(1);
        morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
        dom.insertBoundary(fragment, 0);
        dom.insertBoundary(fragment, null);
        return morphs;
      },
      statements: [["block", "if", [["subexpr", "eq", [["get", "indicatorType", ["loc", [null, [1, 10], [1, 23]]]], "skillMastered"], [], ["loc", [null, [1, 6], [1, 40]]]]], [], 0, 1, ["loc", [null, [1, 0], [11, 7]]]]],
      locals: [],
      templates: [child0, child1]
    };
  })());
});
define('dashboard/components/ember-collection', ['exports', 'ember-collection/components/ember-collection'], function (exports, _emberCollectionComponentsEmberCollection) {
  Object.defineProperty(exports, 'default', {
    enumerable: true,
    get: function get() {
      return _emberCollectionComponentsEmberCollection['default'];
    }
  });
});
define('dashboard/components/ember-native-scrollable', ['exports', 'ember-collection/components/ember-native-scrollable'], function (exports, _emberCollectionComponentsEmberNativeScrollable) {
  Object.defineProperty(exports, 'default', {
    enumerable: true,
    get: function get() {
      return _emberCollectionComponentsEmberNativeScrollable['default'];
    }
  });
});
define('dashboard/components/live-number/component', ['exports', 'ember'], function (exports, _ember) {
  exports['default'] = _ember['default'].Component.extend({
    init: function init() {
      this._super.apply(this, arguments);
      this.time = "";
      var self = this;
      if (!!window.EventSource) {
        var source = new EventSource('http://localhost:3000/live');
        source.addEventListener("message", function (e) {
          //console.log(JSON.parse(e.data));
          self.set("time", JSON.parse(e.data).time);
        }, false);
      }
    }
  });
});
define("dashboard/components/live-number/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    return {
      meta: {
        "fragmentReason": {
          "name": "triple-curlies"
        },
        "revision": "Ember@2.5.1",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 10,
            "column": 0
          }
        },
        "moduleName": "dashboard/components/live-number/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createElement("div");
        dom.setAttribute(el1, "class", "ui icon message");
        var el2 = dom.createTextNode("\n  ");
        dom.appendChild(el1, el2);
        var el2 = dom.createElement("i");
        dom.setAttribute(el2, "class", "notched circle loading icon");
        dom.appendChild(el1, el2);
        var el2 = dom.createTextNode("\n  ");
        dom.appendChild(el1, el2);
        var el2 = dom.createElement("div");
        dom.setAttribute(el2, "class", "content");
        var el3 = dom.createTextNode("\n    ");
        dom.appendChild(el2, el3);
        var el3 = dom.createElement("div");
        dom.setAttribute(el3, "class", "header");
        var el4 = dom.createTextNode("\n      ");
        dom.appendChild(el3, el4);
        var el4 = dom.createComment("");
        dom.appendChild(el3, el4);
        var el4 = dom.createTextNode("\n    ");
        dom.appendChild(el3, el4);
        dom.appendChild(el2, el3);
        var el3 = dom.createTextNode("\n    ");
        dom.appendChild(el2, el3);
        var el3 = dom.createElement("p");
        var el4 = dom.createTextNode("We're streaming server time for you.");
        dom.appendChild(el3, el4);
        dom.appendChild(el2, el3);
        var el3 = dom.createTextNode("\n  ");
        dom.appendChild(el2, el3);
        dom.appendChild(el1, el2);
        var el2 = dom.createTextNode("\n");
        dom.appendChild(el1, el2);
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var morphs = new Array(1);
        morphs[0] = dom.createMorphAt(dom.childAt(fragment, [0, 3, 1]), 1, 1);
        return morphs;
      },
      statements: [["inline", "moment-format", [["get", "time", ["loc", [null, [5, 22], [5, 26]]]], "h:mm:ss a"], ["allow-empty", true], ["loc", [null, [5, 6], [5, 57]]]]],
      locals: [],
      templates: []
    };
  })());
});
define('dashboard/components/notification-receiver/component', ['exports', 'ember'], function (exports, _ember) {
  exports['default'] = _ember['default'].Component.extend({
    init: function init() {
      this._super.apply(this, arguments);
      if (Notification.permission !== "granted") {
        Notification.requestPermission();
      }
      var self = this;
      if (!!window.EventSource) {
        var source = new EventSource('http://localhost:3000/live');
        source.addEventListener("notification", function (e) {
          if (self.get("isNotificationOn")) {
            var message = JSON.parse(e.data).message;
            var icon = JSON.parse(e.data).icon;
            var notification = new Notification('New Message', {
              icon: icon,
              body: message
            });
            notification.onclick = function () {};
          }
        }, false);
      }
    },
    actions: {
      toggleNotification: function toggleNotification() {
        this.toggleProperty('isNotificationOn');
      }
    }
  });
});
define("dashboard/components/notification-receiver/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      return {
        meta: {
          "fragmentReason": {
            "name": "modifiers",
            "modifiers": ["action"]
          },
          "revision": "Ember@2.5.1",
          "loc": {
            "source": null,
            "start": {
              "line": 1,
              "column": 0
            },
            "end": {
              "line": 3,
              "column": 0
            }
          },
          "moduleName": "dashboard/components/notification-receiver/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("  ");
          dom.appendChild(el0, el1);
          var el1 = dom.createElement("button");
          dom.setAttribute(el1, "class", "negative ui button");
          var el2 = dom.createTextNode(" Turn Off ");
          dom.appendChild(el1, el2);
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var element1 = dom.childAt(fragment, [1]);
          var morphs = new Array(1);
          morphs[0] = dom.createElementMorph(element1);
          return morphs;
        },
        statements: [["element", "action", ["toggleNotification"], [], ["loc", [null, [2, 37], [2, 68]]]]],
        locals: [],
        templates: []
      };
    })();
    var child1 = (function () {
      return {
        meta: {
          "fragmentReason": false,
          "revision": "Ember@2.5.1",
          "loc": {
            "source": null,
            "start": {
              "line": 3,
              "column": 0
            },
            "end": {
              "line": 5,
              "column": 0
            }
          },
          "moduleName": "dashboard/components/notification-receiver/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("  ");
          dom.appendChild(el0, el1);
          var el1 = dom.createElement("button");
          dom.setAttribute(el1, "class", "positive ui button");
          var el2 = dom.createTextNode(" Turn On ");
          dom.appendChild(el1, el2);
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var element0 = dom.childAt(fragment, [1]);
          var morphs = new Array(1);
          morphs[0] = dom.createElementMorph(element0);
          return morphs;
        },
        statements: [["element", "action", ["toggleNotification"], [], ["loc", [null, [4, 37], [4, 68]]]]],
        locals: [],
        templates: []
      };
    })();
    return {
      meta: {
        "fragmentReason": {
          "name": "missing-wrapper",
          "problems": ["wrong-type"]
        },
        "revision": "Ember@2.5.1",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 6,
            "column": 0
          }
        },
        "moduleName": "dashboard/components/notification-receiver/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var morphs = new Array(1);
        morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
        dom.insertBoundary(fragment, 0);
        dom.insertBoundary(fragment, null);
        return morphs;
      },
      statements: [["block", "if", [["get", "isNotificationOn", ["loc", [null, [1, 6], [1, 22]]]]], [], 0, 1, ["loc", [null, [1, 0], [5, 7]]]]],
      locals: [],
      templates: [child0, child1]
    };
  })());
});
define('dashboard/components/student-detail/component', ['exports', 'ember'], function (exports, _ember) {
  exports['default'] = _ember['default'].Component.extend({
    init: function init() {
      // Call super init
      this._super.apply(this, arguments);
    }
  });
});
define("dashboard/components/student-detail/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      return {
        meta: {
          "fragmentReason": false,
          "revision": "Ember@2.5.1",
          "loc": {
            "source": null,
            "start": {
              "line": 19,
              "column": 6
            },
            "end": {
              "line": 21,
              "column": 6
            }
          },
          "moduleName": "dashboard/components/student-detail/template.hbs"
        },
        isEmpty: false,
        arity: 1,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("        ");
          dom.appendChild(el0, el1);
          var el1 = dom.createElement("th");
          var el2 = dom.createComment("");
          dom.appendChild(el1, el2);
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(dom.childAt(fragment, [1]), 0, 0);
          return morphs;
        },
        statements: [["content", "student.name", ["loc", [null, [20, 12], [20, 28]]]]],
        locals: ["student"],
        templates: []
      };
    })();
    var child1 = (function () {
      var child0 = (function () {
        var child0 = (function () {
          return {
            meta: {
              "fragmentReason": false,
              "revision": "Ember@2.5.1",
              "loc": {
                "source": null,
                "start": {
                  "line": 30,
                  "column": 12
                },
                "end": {
                  "line": 32,
                  "column": 12
                }
              },
              "moduleName": "dashboard/components/student-detail/template.hbs"
            },
            isEmpty: false,
            arity: 0,
            cachedFragment: null,
            hasRendered: false,
            buildFragment: function buildFragment(dom) {
              var el0 = dom.createDocumentFragment();
              var el1 = dom.createTextNode("              ");
              dom.appendChild(el0, el1);
              var el1 = dom.createComment("");
              dom.appendChild(el0, el1);
              var el1 = dom.createTextNode("\n");
              dom.appendChild(el0, el1);
              return el0;
            },
            buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
              var morphs = new Array(1);
              morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
              return morphs;
            },
            statements: [["inline", "circle-indicator", [], ["indicatorType", ["subexpr", "get-skill-mastery", [["get", "skillMasteries", ["loc", [null, [31, 66], [31, 80]]]], ["get", "skill.id", ["loc", [null, [31, 81], [31, 89]]]], ["get", "student.id", ["loc", [null, [31, 90], [31, 100]]]]], [], ["loc", [null, [31, 47], [31, 101]]]]], ["loc", [null, [31, 14], [31, 103]]]]],
            locals: [],
            templates: []
          };
        })();
        return {
          meta: {
            "fragmentReason": false,
            "revision": "Ember@2.5.1",
            "loc": {
              "source": null,
              "start": {
                "line": 28,
                "column": 8
              },
              "end": {
                "line": 37,
                "column": 8
              }
            },
            "moduleName": "dashboard/components/student-detail/template.hbs"
          },
          isEmpty: false,
          arity: 1,
          cachedFragment: null,
          hasRendered: false,
          buildFragment: function buildFragment(dom) {
            var el0 = dom.createDocumentFragment();
            var el1 = dom.createTextNode("          ");
            dom.appendChild(el0, el1);
            var el1 = dom.createElement("td");
            dom.setAttribute(el1, "class", "center aligned");
            var el2 = dom.createTextNode("\n");
            dom.appendChild(el1, el2);
            var el2 = dom.createComment("");
            dom.appendChild(el1, el2);
            var el2 = dom.createTextNode("            ");
            dom.appendChild(el1, el2);
            var el2 = dom.createElement("div");
            dom.setAttribute(el2, "class", "ui popup");
            var el3 = dom.createTextNode("\n              ");
            dom.appendChild(el2, el3);
            var el3 = dom.createComment("");
            dom.appendChild(el2, el3);
            var el3 = dom.createTextNode("\n            ");
            dom.appendChild(el2, el3);
            dom.appendChild(el1, el2);
            var el2 = dom.createTextNode("\n          ");
            dom.appendChild(el1, el2);
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            return el0;
          },
          buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
            var element0 = dom.childAt(fragment, [1]);
            var morphs = new Array(2);
            morphs[0] = dom.createMorphAt(element0, 1, 1);
            morphs[1] = dom.createMorphAt(dom.childAt(element0, [3]), 1, 1);
            return morphs;
          },
          statements: [["block", "ui-popup", [], ["position", "top center", "inline", true], 0, null, ["loc", [null, [30, 12], [32, 25]]]], ["inline", "student-detail-popup", [], ["student", ["subexpr", "@mut", [["get", "student", ["loc", [null, [34, 45], [34, 52]]]]], [], []], "skillMasteries", ["subexpr", "@mut", [["get", "skillMasteries", ["loc", [null, [34, 68], [34, 82]]]]], [], []], "skill", ["subexpr", "@mut", [["get", "skill", ["loc", [null, [34, 89], [34, 94]]]]], [], []]], ["loc", [null, [34, 14], [34, 96]]]]],
          locals: ["student"],
          templates: [child0]
        };
      })();
      return {
        meta: {
          "fragmentReason": false,
          "revision": "Ember@2.5.1",
          "loc": {
            "source": null,
            "start": {
              "line": 25,
              "column": 4
            },
            "end": {
              "line": 39,
              "column": 4
            }
          },
          "moduleName": "dashboard/components/student-detail/template.hbs"
        },
        isEmpty: false,
        arity: 1,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("      ");
          dom.appendChild(el0, el1);
          var el1 = dom.createElement("tr");
          var el2 = dom.createTextNode("\n        ");
          dom.appendChild(el1, el2);
          var el2 = dom.createElement("td");
          dom.setAttribute(el2, "class", "right aligned selectable");
          var el3 = dom.createElement("a");
          dom.setAttribute(el3, "href", "javascript:;");
          var el4 = dom.createComment("");
          dom.appendChild(el3, el4);
          dom.appendChild(el2, el3);
          dom.appendChild(el1, el2);
          var el2 = dom.createTextNode("\n");
          dom.appendChild(el1, el2);
          var el2 = dom.createComment("");
          dom.appendChild(el1, el2);
          var el2 = dom.createTextNode("      ");
          dom.appendChild(el1, el2);
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var element1 = dom.childAt(fragment, [1]);
          var element2 = dom.childAt(element1, [1, 0]);
          var morphs = new Array(4);
          morphs[0] = dom.createAttrMorph(element1, 'class');
          morphs[1] = dom.createElementMorph(element2);
          morphs[2] = dom.createMorphAt(element2, 0, 0);
          morphs[3] = dom.createMorphAt(element1, 3, 3);
          return morphs;
        },
        statements: [["attribute", "class", ["concat", [["subexpr", "if", [["subexpr", "eq", [["get", "skill.id", ["loc", [null, [26, 26], [26, 34]]]], ["get", "skillSelected", ["loc", [null, [26, 35], [26, 48]]]]], [], ["loc", [null, [26, 22], [26, 49]]]], "positive"], [], ["loc", [null, [26, 17], [26, 62]]]]]]], ["element", "action", ["sortBySkill", ["get", "skill.id", ["loc", [null, [27, 91], [27, 99]]]]], [], ["loc", [null, [27, 68], [27, 101]]]], ["content", "skill.name", ["loc", [null, [27, 102], [27, 116]]]], ["block", "each", [["get", "students", ["loc", [null, [28, 16], [28, 24]]]]], [], 0, null, ["loc", [null, [28, 8], [37, 17]]]]],
        locals: ["skill"],
        templates: [child0]
      };
    })();
    return {
      meta: {
        "fragmentReason": {
          "name": "missing-wrapper",
          "problems": ["multiple-nodes"]
        },
        "revision": "Ember@2.5.1",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 42,
            "column": 0
          }
        },
        "moduleName": "dashboard/components/student-detail/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createElement("h3");
        dom.setAttribute(el1, "class", "ui center aligned header");
        var el2 = dom.createTextNode(" What Skills Has Each Student Mastered? ");
        dom.appendChild(el1, el2);
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createElement("div");
        dom.setAttribute(el1, "class", "ui inverted divider");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createElement("div");
        dom.setAttribute(el1, "class", "ui center aligned");
        var el2 = dom.createTextNode("\n  ");
        dom.appendChild(el1, el2);
        var el2 = dom.createElement("i");
        dom.setAttribute(el2, "class", "green large checkmark icon");
        dom.appendChild(el1, el2);
        var el2 = dom.createTextNode("\n  Mastered\n  ");
        dom.appendChild(el1, el2);
        dom.setNamespace("http://www.w3.org/2000/svg");
        var el2 = dom.createElement("svg");
        dom.setAttribute(el2, "class", "svg-inline");
        dom.setAttribute(el2, "height", "20");
        dom.setAttribute(el2, "width", "36");
        var el3 = dom.createTextNode("\n    ");
        dom.appendChild(el2, el3);
        var el3 = dom.createElement("circle");
        dom.setAttribute(el3, "cx", "24");
        dom.setAttribute(el3, "cy", "70%");
        dom.setAttribute(el3, "r", "6");
        dom.setAttribute(el3, "stroke-width", "0");
        dom.setAttribute(el3, "fill", "#34AADC");
        dom.appendChild(el2, el3);
        var el3 = dom.createTextNode("\n  ");
        dom.appendChild(el2, el3);
        dom.appendChild(el1, el2);
        var el2 = dom.createTextNode("\n  Not Given Enough Opportunity\n  ");
        dom.appendChild(el1, el2);
        var el2 = dom.createElement("svg");
        dom.setAttribute(el2, "class", "svg-inline");
        dom.setAttribute(el2, "height", "20");
        dom.setAttribute(el2, "width", "36");
        var el3 = dom.createTextNode("\n    ");
        dom.appendChild(el2, el3);
        var el3 = dom.createElement("circle");
        dom.setAttribute(el3, "cx", "24");
        dom.setAttribute(el3, "cy", "70%");
        dom.setAttribute(el3, "r", "6");
        dom.setAttribute(el3, "stroke-width", "0");
        dom.setAttribute(el3, "fill", "#FF9500");
        dom.appendChild(el2, el3);
        var el3 = dom.createTextNode("\n  ");
        dom.appendChild(el2, el3);
        dom.appendChild(el1, el2);
        var el2 = dom.createTextNode("\n  Not Mastered\n");
        dom.appendChild(el1, el2);
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        dom.setNamespace(null);
        var el1 = dom.createElement("table");
        dom.setAttribute(el1, "class", "ui definition very padded small selectable table");
        var el2 = dom.createTextNode("\n  ");
        dom.appendChild(el1, el2);
        var el2 = dom.createElement("thead");
        var el3 = dom.createTextNode("\n    ");
        dom.appendChild(el2, el3);
        var el3 = dom.createElement("tr");
        dom.setAttribute(el3, "class", "center aligned");
        var el4 = dom.createTextNode("\n      ");
        dom.appendChild(el3, el4);
        var el4 = dom.createElement("th");
        dom.appendChild(el3, el4);
        var el4 = dom.createTextNode("\n");
        dom.appendChild(el3, el4);
        var el4 = dom.createComment("");
        dom.appendChild(el3, el4);
        var el4 = dom.createTextNode("    ");
        dom.appendChild(el3, el4);
        dom.appendChild(el2, el3);
        var el3 = dom.createTextNode("\n  ");
        dom.appendChild(el2, el3);
        dom.appendChild(el1, el2);
        var el2 = dom.createTextNode("\n  ");
        dom.appendChild(el1, el2);
        var el2 = dom.createElement("tbody");
        var el3 = dom.createTextNode("\n");
        dom.appendChild(el2, el3);
        var el3 = dom.createComment("");
        dom.appendChild(el2, el3);
        var el3 = dom.createTextNode("  ");
        dom.appendChild(el2, el3);
        dom.appendChild(el1, el2);
        var el2 = dom.createTextNode("\n");
        dom.appendChild(el1, el2);
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var element3 = dom.childAt(fragment, [6]);
        var morphs = new Array(2);
        morphs[0] = dom.createMorphAt(dom.childAt(element3, [1, 1]), 3, 3);
        morphs[1] = dom.createMorphAt(dom.childAt(element3, [3]), 1, 1);
        return morphs;
      },
      statements: [["block", "each", [["get", "students", ["loc", [null, [19, 14], [19, 22]]]]], [], 0, null, ["loc", [null, [19, 6], [21, 15]]]], ["block", "each", [["get", "skills", ["loc", [null, [25, 12], [25, 18]]]]], [], 1, null, ["loc", [null, [25, 4], [39, 13]]]]],
      locals: [],
      templates: [child0, child1]
    };
  })());
});
define('dashboard/components/student-detail-popup/component', ['exports', 'ember'], function (exports, _ember) {
  exports['default'] = _ember['default'].Component.extend({
    init: function init() {
      this._super.apply(this, arguments);
      var student = this.get('student');
      var skill = this.get('skill');
      var skillMasteries = this.get('skillMasteries');
      if (skillMasteries[skill.id] && skillMasteries[skill.id][student.id]) {
        var studentInfo = skillMasteries[skill.id][student.id];
        this.set('opportunity', studentInfo.opportunity);
        if (studentInfo.percentage > 0.95) {
          this.set('status', 'Mastered');
        } else if (studentInfo.opportunity < 10) {
          this.set('status', 'Not Enough Opportunity');
        } else {
          this.set('status', 'Not Mastered');
        }
      } else {
        this.set('opportunity', 0);
        this.set('status', 'Not Enough Opportunity');
      }
    }
  });
});
define("dashboard/components/student-detail-popup/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    return {
      meta: {
        "fragmentReason": {
          "name": "triple-curlies"
        },
        "revision": "Ember@2.5.1",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 15,
            "column": 0
          }
        },
        "moduleName": "dashboard/components/student-detail-popup/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createElement("div");
        dom.setAttribute(el1, "class", "ui list left aligned");
        var el2 = dom.createTextNode("\n  ");
        dom.appendChild(el1, el2);
        var el2 = dom.createElement("div");
        dom.setAttribute(el2, "class", "item");
        var el3 = dom.createTextNode("\n    ");
        dom.appendChild(el2, el3);
        var el3 = dom.createElement("div");
        dom.setAttribute(el3, "class", "header");
        var el4 = dom.createTextNode("Student Name:");
        dom.appendChild(el3, el4);
        dom.appendChild(el2, el3);
        var el3 = dom.createTextNode("\n    ");
        dom.appendChild(el2, el3);
        var el3 = dom.createComment("");
        dom.appendChild(el2, el3);
        var el3 = dom.createTextNode("\n  ");
        dom.appendChild(el2, el3);
        dom.appendChild(el1, el2);
        var el2 = dom.createTextNode("\n  ");
        dom.appendChild(el1, el2);
        var el2 = dom.createElement("div");
        dom.setAttribute(el2, "class", "item");
        var el3 = dom.createTextNode("\n    ");
        dom.appendChild(el2, el3);
        var el3 = dom.createElement("div");
        dom.setAttribute(el3, "class", "header");
        var el4 = dom.createTextNode("Number of Opportunity:");
        dom.appendChild(el3, el4);
        dom.appendChild(el2, el3);
        var el3 = dom.createTextNode("\n    ");
        dom.appendChild(el2, el3);
        var el3 = dom.createComment("");
        dom.appendChild(el2, el3);
        var el3 = dom.createTextNode("\n  ");
        dom.appendChild(el2, el3);
        dom.appendChild(el1, el2);
        var el2 = dom.createTextNode("\n  ");
        dom.appendChild(el1, el2);
        var el2 = dom.createElement("div");
        dom.setAttribute(el2, "class", "item");
        var el3 = dom.createTextNode("\n    ");
        dom.appendChild(el2, el3);
        var el3 = dom.createElement("div");
        dom.setAttribute(el3, "class", "header");
        var el4 = dom.createTextNode("Mastery Status:");
        dom.appendChild(el3, el4);
        dom.appendChild(el2, el3);
        var el3 = dom.createTextNode("\n    ");
        dom.appendChild(el2, el3);
        var el3 = dom.createComment("");
        dom.appendChild(el2, el3);
        var el3 = dom.createTextNode("\n  ");
        dom.appendChild(el2, el3);
        dom.appendChild(el1, el2);
        var el2 = dom.createTextNode("\n");
        dom.appendChild(el1, el2);
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var element0 = dom.childAt(fragment, [0]);
        var morphs = new Array(3);
        morphs[0] = dom.createMorphAt(dom.childAt(element0, [1]), 3, 3);
        morphs[1] = dom.createMorphAt(dom.childAt(element0, [3]), 3, 3);
        morphs[2] = dom.createMorphAt(dom.childAt(element0, [5]), 3, 3);
        return morphs;
      },
      statements: [["content", "student.name", ["loc", [null, [4, 4], [4, 20]]]], ["content", "opportunity", ["loc", [null, [8, 4], [8, 19]]]], ["content", "status", ["loc", [null, [12, 4], [12, 14]]]]],
      locals: [],
      templates: []
    };
  })());
});
define('dashboard/components/ui-accordion', ['exports', 'semantic-ui-ember/components/ui-accordion'], function (exports, _semanticUiEmberComponentsUiAccordion) {
  Object.defineProperty(exports, 'default', {
    enumerable: true,
    get: function get() {
      return _semanticUiEmberComponentsUiAccordion['default'];
    }
  });
});
define('dashboard/components/ui-checkbox', ['exports', 'semantic-ui-ember/components/ui-checkbox'], function (exports, _semanticUiEmberComponentsUiCheckbox) {
  Object.defineProperty(exports, 'default', {
    enumerable: true,
    get: function get() {
      return _semanticUiEmberComponentsUiCheckbox['default'];
    }
  });
});
define('dashboard/components/ui-dropdown-array', ['exports', 'semantic-ui-ember/components/ui-dropdown-array'], function (exports, _semanticUiEmberComponentsUiDropdownArray) {
  Object.defineProperty(exports, 'default', {
    enumerable: true,
    get: function get() {
      return _semanticUiEmberComponentsUiDropdownArray['default'];
    }
  });
});
define('dashboard/components/ui-dropdown', ['exports', 'semantic-ui-ember/components/ui-dropdown'], function (exports, _semanticUiEmberComponentsUiDropdown) {
  Object.defineProperty(exports, 'default', {
    enumerable: true,
    get: function get() {
      return _semanticUiEmberComponentsUiDropdown['default'];
    }
  });
});
define('dashboard/components/ui-embed', ['exports', 'semantic-ui-ember/components/ui-embed'], function (exports, _semanticUiEmberComponentsUiEmbed) {
  Object.defineProperty(exports, 'default', {
    enumerable: true,
    get: function get() {
      return _semanticUiEmberComponentsUiEmbed['default'];
    }
  });
});
define('dashboard/components/ui-modal', ['exports', 'semantic-ui-ember/components/ui-modal'], function (exports, _semanticUiEmberComponentsUiModal) {
  Object.defineProperty(exports, 'default', {
    enumerable: true,
    get: function get() {
      return _semanticUiEmberComponentsUiModal['default'];
    }
  });
});
define('dashboard/components/ui-nag', ['exports', 'semantic-ui-ember/components/ui-nag'], function (exports, _semanticUiEmberComponentsUiNag) {
  Object.defineProperty(exports, 'default', {
    enumerable: true,
    get: function get() {
      return _semanticUiEmberComponentsUiNag['default'];
    }
  });
});
define('dashboard/components/ui-popup', ['exports', 'semantic-ui-ember/components/ui-popup'], function (exports, _semanticUiEmberComponentsUiPopup) {
  Object.defineProperty(exports, 'default', {
    enumerable: true,
    get: function get() {
      return _semanticUiEmberComponentsUiPopup['default'];
    }
  });
});
define('dashboard/components/ui-progress', ['exports', 'semantic-ui-ember/components/ui-progress'], function (exports, _semanticUiEmberComponentsUiProgress) {
  Object.defineProperty(exports, 'default', {
    enumerable: true,
    get: function get() {
      return _semanticUiEmberComponentsUiProgress['default'];
    }
  });
});
define('dashboard/components/ui-radio', ['exports', 'semantic-ui-ember/components/ui-radio'], function (exports, _semanticUiEmberComponentsUiRadio) {
  Object.defineProperty(exports, 'default', {
    enumerable: true,
    get: function get() {
      return _semanticUiEmberComponentsUiRadio['default'];
    }
  });
});
define('dashboard/components/ui-rating', ['exports', 'semantic-ui-ember/components/ui-rating'], function (exports, _semanticUiEmberComponentsUiRating) {
  Object.defineProperty(exports, 'default', {
    enumerable: true,
    get: function get() {
      return _semanticUiEmberComponentsUiRating['default'];
    }
  });
});
define('dashboard/components/ui-search', ['exports', 'semantic-ui-ember/components/ui-search'], function (exports, _semanticUiEmberComponentsUiSearch) {
  Object.defineProperty(exports, 'default', {
    enumerable: true,
    get: function get() {
      return _semanticUiEmberComponentsUiSearch['default'];
    }
  });
});
define('dashboard/components/ui-shape', ['exports', 'semantic-ui-ember/components/ui-shape'], function (exports, _semanticUiEmberComponentsUiShape) {
  Object.defineProperty(exports, 'default', {
    enumerable: true,
    get: function get() {
      return _semanticUiEmberComponentsUiShape['default'];
    }
  });
});
define('dashboard/components/ui-sidebar', ['exports', 'semantic-ui-ember/components/ui-sidebar'], function (exports, _semanticUiEmberComponentsUiSidebar) {
  Object.defineProperty(exports, 'default', {
    enumerable: true,
    get: function get() {
      return _semanticUiEmberComponentsUiSidebar['default'];
    }
  });
});
define('dashboard/components/ui-sticky', ['exports', 'semantic-ui-ember/components/ui-sticky'], function (exports, _semanticUiEmberComponentsUiSticky) {
  Object.defineProperty(exports, 'default', {
    enumerable: true,
    get: function get() {
      return _semanticUiEmberComponentsUiSticky['default'];
    }
  });
});
define('dashboard/detail/controller', ['exports', 'ember'], function (exports, _ember) {
  exports['default'] = _ember['default'].Controller.extend({
    actions: {
      sortBySkill: function sortBySkill(skillId) {
        /*var skillMasteries = this.get("skillMasteries");
        var model = this.get("model");
        var students = [];
        if (skillMasteries[skillId]) {
          model.students.forEach(function(item) {
            var studentId = item.id;
            if (skillMasteries[skillId][studentId]) {
              students.push(item);
            }
          });
          model.students.forEach(function(item) {
            var studentId = item.id;
            if (!skillMasteries[skillId][studentId]) {
              students.push(item);
            }
          });
          this.set('skillSelected', skillId);
          this.set('students', students);
        } else {
          this.set('skillSelected', null);
          this.set('students', model.students);
        }*/
      }
    }
  });
});
define('dashboard/detail/route', ['exports', 'ember'], function (exports, _ember) {
  exports['default'] = _ember['default'].Route.extend({
    model: function model() {
      return _ember['default'].RSVP.hash({
        skills: this.store.findAll('skill'),
        students: this.store.findAll('student'),
        skillMasteries: this.store.findAll('skill-mastery')
      });
    },
    setupController: function setupController(controller, model) {
      var skillMasteries = {};

      model.skillMasteries.forEach(function (item) {
        var skillId = item.get('skillId');
        var studentId = item.get('studentId');
        var percentage = item.get('percentage');
        var opportunity = item.get('opportunity');
        if (!skillMasteries[skillId]) {
          skillMasteries[skillId] = {};
        }
        skillMasteries[skillId][studentId] = { percentage: percentage, opportunity: opportunity };
      });

      controller.set('model', model);
      controller.set('skills', model.skills);
      controller.set('students', model.students);
      controller.set("skillMasteries", skillMasteries);
    }
  });
});
define("dashboard/detail/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      return {
        meta: {
          "fragmentReason": false,
          "revision": "Ember@2.5.1",
          "loc": {
            "source": null,
            "start": {
              "line": 18,
              "column": 12
            },
            "end": {
              "line": 20,
              "column": 12
            }
          },
          "moduleName": "dashboard/detail/template.hbs"
        },
        isEmpty: false,
        arity: 1,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("              ");
          dom.appendChild(el0, el1);
          var el1 = dom.createElement("th");
          var el2 = dom.createComment("");
          dom.appendChild(el1, el2);
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(dom.childAt(fragment, [1]), 0, 0);
          return morphs;
        },
        statements: [["content", "student.name", ["loc", [null, [19, 18], [19, 34]]]]],
        locals: ["student"],
        templates: []
      };
    })();
    var child1 = (function () {
      var child0 = (function () {
        return {
          meta: {
            "fragmentReason": false,
            "revision": "Ember@2.5.1",
            "loc": {
              "source": null,
              "start": {
                "line": 27,
                "column": 14
              },
              "end": {
                "line": 31,
                "column": 14
              }
            },
            "moduleName": "dashboard/detail/template.hbs"
          },
          isEmpty: false,
          arity: 1,
          cachedFragment: null,
          hasRendered: false,
          buildFragment: function buildFragment(dom) {
            var el0 = dom.createDocumentFragment();
            var el1 = dom.createTextNode("                ");
            dom.appendChild(el0, el1);
            var el1 = dom.createElement("td");
            dom.setAttribute(el1, "class", "center aligned");
            var el2 = dom.createTextNode("\n                  ");
            dom.appendChild(el1, el2);
            var el2 = dom.createComment("");
            dom.appendChild(el1, el2);
            var el2 = dom.createTextNode("\n                ");
            dom.appendChild(el1, el2);
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            return el0;
          },
          buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
            var morphs = new Array(1);
            morphs[0] = dom.createMorphAt(dom.childAt(fragment, [1]), 1, 1);
            return morphs;
          },
          statements: [["inline", "circle-indicator", [], ["indicatorType", ["subexpr", "get-skill-mastery", [["get", "skillMasteries", ["loc", [null, [29, 70], [29, 84]]]], ["get", "skill.id", ["loc", [null, [29, 85], [29, 93]]]], ["get", "student.id", ["loc", [null, [29, 94], [29, 104]]]]], [], ["loc", [null, [29, 51], [29, 105]]]]], ["loc", [null, [29, 18], [29, 107]]]]],
          locals: ["student"],
          templates: []
        };
      })();
      return {
        meta: {
          "fragmentReason": false,
          "revision": "Ember@2.5.1",
          "loc": {
            "source": null,
            "start": {
              "line": 24,
              "column": 10
            },
            "end": {
              "line": 33,
              "column": 10
            }
          },
          "moduleName": "dashboard/detail/template.hbs"
        },
        isEmpty: false,
        arity: 1,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("            ");
          dom.appendChild(el0, el1);
          var el1 = dom.createElement("tr");
          var el2 = dom.createTextNode("\n              ");
          dom.appendChild(el1, el2);
          var el2 = dom.createElement("td");
          dom.setAttribute(el2, "class", "right aligned selectable");
          var el3 = dom.createElement("a");
          dom.setAttribute(el3, "href", "javascript:;");
          var el4 = dom.createComment("");
          dom.appendChild(el3, el4);
          dom.appendChild(el2, el3);
          dom.appendChild(el1, el2);
          var el2 = dom.createTextNode("\n");
          dom.appendChild(el1, el2);
          var el2 = dom.createComment("");
          dom.appendChild(el1, el2);
          var el2 = dom.createTextNode("            ");
          dom.appendChild(el1, el2);
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var element0 = dom.childAt(fragment, [1]);
          var element1 = dom.childAt(element0, [1, 0]);
          var morphs = new Array(4);
          morphs[0] = dom.createAttrMorph(element0, 'class');
          morphs[1] = dom.createElementMorph(element1);
          morphs[2] = dom.createMorphAt(element1, 0, 0);
          morphs[3] = dom.createMorphAt(element0, 3, 3);
          return morphs;
        },
        statements: [["attribute", "class", ["concat", [["subexpr", "if", [["subexpr", "eq", [["get", "skill.id", ["loc", [null, [25, 32], [25, 40]]]], ["get", "skillSelected", ["loc", [null, [25, 41], [25, 54]]]]], [], ["loc", [null, [25, 28], [25, 55]]]], "positive"], [], ["loc", [null, [25, 23], [25, 68]]]]]]], ["element", "action", ["sortBySkill", ["get", "skill.id", ["loc", [null, [26, 97], [26, 105]]]]], [], ["loc", [null, [26, 74], [26, 107]]]], ["content", "skill.name", ["loc", [null, [26, 108], [26, 122]]]], ["block", "each", [["get", "students", ["loc", [null, [27, 22], [27, 30]]]]], [], 0, null, ["loc", [null, [27, 14], [31, 23]]]]],
        locals: ["skill"],
        templates: [child0]
      };
    })();
    return {
      meta: {
        "fragmentReason": {
          "name": "triple-curlies"
        },
        "revision": "Ember@2.5.1",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 39,
            "column": 0
          }
        },
        "moduleName": "dashboard/detail/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createElement("div");
        dom.setAttribute(el1, "class", "ui padded centered grid");
        var el2 = dom.createTextNode("\n  ");
        dom.appendChild(el1, el2);
        var el2 = dom.createElement("div");
        dom.setAttribute(el2, "class", "fifteen wide column");
        var el3 = dom.createTextNode("\n    ");
        dom.appendChild(el2, el3);
        var el3 = dom.createElement("div");
        dom.setAttribute(el3, "class", "ui vertical segment");
        var el4 = dom.createTextNode("\n      ");
        dom.appendChild(el3, el4);
        var el4 = dom.createElement("h2");
        dom.setAttribute(el4, "class", "ui center aligned block header");
        var el5 = dom.createTextNode(" Mr. Gill, Period 6 (9 students), 05/04-05/06/16 ");
        dom.appendChild(el4, el5);
        dom.appendChild(el3, el4);
        var el4 = dom.createTextNode("\n      ");
        dom.appendChild(el3, el4);
        var el4 = dom.createElement("h3");
        dom.setAttribute(el4, "class", "ui center aligned block header");
        var el5 = dom.createTextNode(" What skills has each student mastered? ");
        dom.appendChild(el4, el5);
        dom.appendChild(el3, el4);
        var el4 = dom.createTextNode("\n      ");
        dom.appendChild(el3, el4);
        var el4 = dom.createElement("div");
        dom.setAttribute(el4, "class", "ui center aligned");
        var el5 = dom.createTextNode("\n        ");
        dom.appendChild(el4, el5);
        var el5 = dom.createElement("i");
        dom.setAttribute(el5, "class", "green large checkmark icon");
        dom.appendChild(el4, el5);
        var el5 = dom.createTextNode("\n        Mastered\n        ");
        dom.appendChild(el4, el5);
        dom.setNamespace("http://www.w3.org/2000/svg");
        var el5 = dom.createElement("svg");
        dom.setAttribute(el5, "class", "svg-inline");
        dom.setAttribute(el5, "height", "20");
        dom.setAttribute(el5, "width", "36");
        var el6 = dom.createTextNode("\n          ");
        dom.appendChild(el5, el6);
        var el6 = dom.createElement("circle");
        dom.setAttribute(el6, "cx", "24");
        dom.setAttribute(el6, "cy", "50%");
        dom.setAttribute(el6, "r", "6");
        dom.setAttribute(el6, "stroke-width", "0");
        dom.setAttribute(el6, "fill", "#34AADC");
        dom.appendChild(el5, el6);
        var el6 = dom.createTextNode("\n        ");
        dom.appendChild(el5, el6);
        dom.appendChild(el4, el5);
        var el5 = dom.createTextNode("\n        Not Given Enough Opportunity\n      ");
        dom.appendChild(el4, el5);
        dom.appendChild(el3, el4);
        var el4 = dom.createTextNode("\n      ");
        dom.appendChild(el3, el4);
        dom.setNamespace(null);
        var el4 = dom.createElement("table");
        dom.setAttribute(el4, "class", "ui definition very padded small selectable table");
        var el5 = dom.createTextNode("\n        ");
        dom.appendChild(el4, el5);
        var el5 = dom.createElement("thead");
        var el6 = dom.createTextNode("\n          ");
        dom.appendChild(el5, el6);
        var el6 = dom.createElement("tr");
        dom.setAttribute(el6, "class", "center aligned");
        var el7 = dom.createTextNode("\n            ");
        dom.appendChild(el6, el7);
        var el7 = dom.createElement("th");
        dom.appendChild(el6, el7);
        var el7 = dom.createTextNode("\n");
        dom.appendChild(el6, el7);
        var el7 = dom.createComment("");
        dom.appendChild(el6, el7);
        var el7 = dom.createTextNode("          ");
        dom.appendChild(el6, el7);
        dom.appendChild(el5, el6);
        var el6 = dom.createTextNode("\n        ");
        dom.appendChild(el5, el6);
        dom.appendChild(el4, el5);
        var el5 = dom.createTextNode("\n        ");
        dom.appendChild(el4, el5);
        var el5 = dom.createElement("tbody");
        var el6 = dom.createTextNode("\n");
        dom.appendChild(el5, el6);
        var el6 = dom.createComment("");
        dom.appendChild(el5, el6);
        var el6 = dom.createTextNode("        ");
        dom.appendChild(el5, el6);
        dom.appendChild(el4, el5);
        var el5 = dom.createTextNode("\n      ");
        dom.appendChild(el4, el5);
        dom.appendChild(el3, el4);
        var el4 = dom.createTextNode("\n    ");
        dom.appendChild(el3, el4);
        dom.appendChild(el2, el3);
        var el3 = dom.createTextNode("\n  ");
        dom.appendChild(el2, el3);
        dom.appendChild(el1, el2);
        var el2 = dom.createTextNode("\n");
        dom.appendChild(el1, el2);
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var element2 = dom.childAt(fragment, [0, 1, 1, 7]);
        var morphs = new Array(2);
        morphs[0] = dom.createMorphAt(dom.childAt(element2, [1, 1]), 3, 3);
        morphs[1] = dom.createMorphAt(dom.childAt(element2, [3]), 1, 1);
        return morphs;
      },
      statements: [["block", "each", [["get", "students", ["loc", [null, [18, 20], [18, 28]]]]], [], 0, null, ["loc", [null, [18, 12], [20, 21]]]], ["block", "each", [["get", "skills", ["loc", [null, [24, 18], [24, 24]]]]], [], 1, null, ["loc", [null, [24, 10], [33, 19]]]]],
      locals: [],
      templates: [child0, child1]
    };
  })());
});
define('dashboard/helpers/eq', ['exports', 'ember'], function (exports, _ember) {
  exports.eq = eq;

  function eq(params /*, hash*/) {
    return params[0] === params[1];
  }

  exports['default'] = _ember['default'].Helper.helper(eq);
});
define('dashboard/helpers/fixed-grid-layout', ['exports', 'ember', 'ember-collection/layouts/grid'], function (exports, _ember, _emberCollectionLayoutsGrid) {
  exports['default'] = _ember['default'].Helper.helper(function (params, hash) {
    return new _emberCollectionLayoutsGrid['default'](params[0], params[1]);
  });
});
define("dashboard/helpers/get-skill-mastery", ["exports", "ember"], function (exports, _ember) {
  exports.getSkillMastery = getSkillMastery;

  function getSkillMastery(params /*, hash*/) {
    var skillMasteries = params[0];
    var skillId = params[1];
    var studentId = params[2];
    if (skillMasteries[skillId] && skillMasteries[skillId][studentId]) {
      var studentInfo = skillMasteries[skillId][studentId];
      if (studentInfo.percentage > 0.95) {
        return "skillMastered";
      } else if (studentInfo.opportunity < 10) {
        return "NotEnoughOpportunity";
      } else {
        return "skillNotMastered";
      }
    }
    return "NotEnoughOpportunity";
  }

  exports["default"] = _ember["default"].Helper.helper(getSkillMastery);
});
define('dashboard/helpers/is-after', ['exports', 'ember', 'dashboard/config/environment', 'ember-moment/helpers/is-after'], function (exports, _ember, _dashboardConfigEnvironment, _emberMomentHelpersIsAfter) {
  exports['default'] = _emberMomentHelpersIsAfter['default'].extend({
    globalAllowEmpty: !!_ember['default'].get(_dashboardConfigEnvironment['default'], 'moment.allowEmpty')
  });
});
define('dashboard/helpers/is-before', ['exports', 'ember', 'dashboard/config/environment', 'ember-moment/helpers/is-before'], function (exports, _ember, _dashboardConfigEnvironment, _emberMomentHelpersIsBefore) {
  exports['default'] = _emberMomentHelpersIsBefore['default'].extend({
    globalAllowEmpty: !!_ember['default'].get(_dashboardConfigEnvironment['default'], 'moment.allowEmpty')
  });
});
define('dashboard/helpers/is-between', ['exports', 'ember', 'dashboard/config/environment', 'ember-moment/helpers/is-between'], function (exports, _ember, _dashboardConfigEnvironment, _emberMomentHelpersIsBetween) {
  exports['default'] = _emberMomentHelpersIsBetween['default'].extend({
    globalAllowEmpty: !!_ember['default'].get(_dashboardConfigEnvironment['default'], 'moment.allowEmpty')
  });
});
define('dashboard/helpers/is-same-or-after', ['exports', 'ember', 'dashboard/config/environment', 'ember-moment/helpers/is-same-or-after'], function (exports, _ember, _dashboardConfigEnvironment, _emberMomentHelpersIsSameOrAfter) {
  exports['default'] = _emberMomentHelpersIsSameOrAfter['default'].extend({
    globalAllowEmpty: !!_ember['default'].get(_dashboardConfigEnvironment['default'], 'moment.allowEmpty')
  });
});
define('dashboard/helpers/is-same-or-before', ['exports', 'ember', 'dashboard/config/environment', 'ember-moment/helpers/is-same-or-before'], function (exports, _ember, _dashboardConfigEnvironment, _emberMomentHelpersIsSameOrBefore) {
  exports['default'] = _emberMomentHelpersIsSameOrBefore['default'].extend({
    globalAllowEmpty: !!_ember['default'].get(_dashboardConfigEnvironment['default'], 'moment.allowEmpty')
  });
});
define('dashboard/helpers/is-same', ['exports', 'ember', 'dashboard/config/environment', 'ember-moment/helpers/is-same'], function (exports, _ember, _dashboardConfigEnvironment, _emberMomentHelpersIsSame) {
  exports['default'] = _emberMomentHelpersIsSame['default'].extend({
    globalAllowEmpty: !!_ember['default'].get(_dashboardConfigEnvironment['default'], 'moment.allowEmpty')
  });
});
define('dashboard/helpers/mixed-grid-layout', ['exports', 'ember', 'ember-collection/layouts/mixed-grid'], function (exports, _ember, _emberCollectionLayoutsMixedGrid) {
  exports['default'] = _ember['default'].Helper.helper(function (params, hash) {
    return new _emberCollectionLayoutsMixedGrid['default'](params[0]);
  });
});
define('dashboard/helpers/moment-calendar', ['exports', 'ember', 'dashboard/config/environment', 'ember-moment/helpers/moment-calendar'], function (exports, _ember, _dashboardConfigEnvironment, _emberMomentHelpersMomentCalendar) {
  exports['default'] = _emberMomentHelpersMomentCalendar['default'].extend({
    globalAllowEmpty: !!_ember['default'].get(_dashboardConfigEnvironment['default'], 'moment.allowEmpty')
  });
});
define('dashboard/helpers/moment-duration', ['exports', 'ember-moment/helpers/moment-duration'], function (exports, _emberMomentHelpersMomentDuration) {
  Object.defineProperty(exports, 'default', {
    enumerable: true,
    get: function get() {
      return _emberMomentHelpersMomentDuration['default'];
    }
  });
});
define('dashboard/helpers/moment-format', ['exports', 'ember', 'dashboard/config/environment', 'ember-moment/helpers/moment-format'], function (exports, _ember, _dashboardConfigEnvironment, _emberMomentHelpersMomentFormat) {
  exports['default'] = _emberMomentHelpersMomentFormat['default'].extend({
    globalAllowEmpty: !!_ember['default'].get(_dashboardConfigEnvironment['default'], 'moment.allowEmpty')
  });
});
define('dashboard/helpers/moment-from-now', ['exports', 'ember', 'dashboard/config/environment', 'ember-moment/helpers/moment-from-now'], function (exports, _ember, _dashboardConfigEnvironment, _emberMomentHelpersMomentFromNow) {
  exports['default'] = _emberMomentHelpersMomentFromNow['default'].extend({
    globalAllowEmpty: !!_ember['default'].get(_dashboardConfigEnvironment['default'], 'moment.allowEmpty')
  });
});
define('dashboard/helpers/moment-to-now', ['exports', 'ember', 'dashboard/config/environment', 'ember-moment/helpers/moment-to-now'], function (exports, _ember, _dashboardConfigEnvironment, _emberMomentHelpersMomentToNow) {
  exports['default'] = _emberMomentHelpersMomentToNow['default'].extend({
    globalAllowEmpty: !!_ember['default'].get(_dashboardConfigEnvironment['default'], 'moment.allowEmpty')
  });
});
define('dashboard/helpers/now', ['exports', 'ember-moment/helpers/now'], function (exports, _emberMomentHelpersNow) {
  Object.defineProperty(exports, 'default', {
    enumerable: true,
    get: function get() {
      return _emberMomentHelpersNow['default'];
    }
  });
});
define('dashboard/helpers/pluralize', ['exports', 'ember-inflector/lib/helpers/pluralize'], function (exports, _emberInflectorLibHelpersPluralize) {
  exports['default'] = _emberInflectorLibHelpersPluralize['default'];
});
define('dashboard/helpers/singularize', ['exports', 'ember-inflector/lib/helpers/singularize'], function (exports, _emberInflectorLibHelpersSingularize) {
  exports['default'] = _emberInflectorLibHelpersSingularize['default'];
});
define("dashboard/index/controller", ["exports", "ember"], function (exports, _ember) {
  exports["default"] = _ember["default"].Controller.extend({
    actions: {
      selectMenu: function selectMenu(menuName) {
        this.set("menu", menuName);
      }
    }
  });
});
define('dashboard/index/route', ['exports', 'ember'], function (exports, _ember) {
  exports['default'] = _ember['default'].Route.extend({
    model: function model() {
      return _ember['default'].RSVP.hash({
        skills: this.store.findAll('skill'),
        students: this.store.findAll('student'),
        skillMasteries: this.store.findAll('skill-mastery')
      });
    },
    setupController: function setupController(controller, model) {
      var skillMasteries = {};

      model.skillMasteries.forEach(function (item) {
        var skillId = item.get('skillId');
        var studentId = item.get('studentId');
        var percentage = item.get('percentage');
        var opportunity = item.get('opportunity');
        if (!skillMasteries[skillId]) {
          skillMasteries[skillId] = {};
        }
        skillMasteries[skillId][studentId] = { percentage: percentage, opportunity: opportunity };
      });

      var skillData = [];
      model.skills.forEach(function (item) {
        var label = item.get('name');
        var skillId = item.get('id');
        var value = 0;
        if (skillMasteries[skillId]) {
          for (var studentId in skillMasteries[skillId]) {
            var ms = skillMasteries[skillId][studentId];
            if (ms.percentage > 0.95) {
              value += 1;
            }
          }
        }
        skillData.push({
          label: label,
          value: value,
          id: skillId
        });
      });

      controller.set('model', model);
      controller.set('skills', model.skills);
      controller.set('students', model.students);
      controller.set('skillMasteries', skillMasteries);
      controller.set('skillData', skillData);
      controller.set('menu', "overview");
    }
  });
});
define("dashboard/index/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      return {
        meta: {
          "fragmentReason": false,
          "revision": "Ember@2.5.1",
          "loc": {
            "source": null,
            "start": {
              "line": 27,
              "column": 4
            },
            "end": {
              "line": 31,
              "column": 4
            }
          },
          "moduleName": "dashboard/index/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("      ");
          dom.appendChild(el0, el1);
          var el1 = dom.createElement("div");
          dom.setAttribute(el1, "class", "wide column");
          var el2 = dom.createTextNode("\n        ");
          dom.appendChild(el1, el2);
          var el2 = dom.createComment("");
          dom.appendChild(el1, el2);
          var el2 = dom.createTextNode("\n      ");
          dom.appendChild(el1, el2);
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(dom.childAt(fragment, [1]), 1, 1);
          return morphs;
        },
        statements: [["inline", "student-detail", [], ["skills", ["subexpr", "@mut", [["get", "skills", ["loc", [null, [29, 32], [29, 38]]]]], [], []], "skillMasteries", ["subexpr", "@mut", [["get", "skillMasteries", ["loc", [null, [29, 54], [29, 68]]]]], [], []], "students", ["subexpr", "@mut", [["get", "students", ["loc", [null, [29, 78], [29, 86]]]]], [], []]], ["loc", [null, [29, 8], [29, 88]]]]],
        locals: [],
        templates: []
      };
    })();
    var child1 = (function () {
      var child0 = (function () {
        return {
          meta: {
            "fragmentReason": false,
            "revision": "Ember@2.5.1",
            "loc": {
              "source": null,
              "start": {
                "line": 31,
                "column": 4
              },
              "end": {
                "line": 43,
                "column": 4
              }
            },
            "moduleName": "dashboard/index/template.hbs"
          },
          isEmpty: false,
          arity: 0,
          cachedFragment: null,
          hasRendered: false,
          buildFragment: function buildFragment(dom) {
            var el0 = dom.createDocumentFragment();
            var el1 = dom.createTextNode("      ");
            dom.appendChild(el0, el1);
            var el1 = dom.createElement("div");
            dom.setAttribute(el1, "class", "eight wide column");
            var el2 = dom.createTextNode("\n        ");
            dom.appendChild(el1, el2);
            var el2 = dom.createElement("div");
            dom.setAttribute(el2, "class", "ui vertical segment");
            var el3 = dom.createTextNode("\n          ");
            dom.appendChild(el2, el3);
            var el3 = dom.createElement("h3");
            dom.setAttribute(el3, "class", "ui center aligned block header");
            var el4 = dom.createTextNode(" How many students have mastered the skills? ");
            dom.appendChild(el3, el4);
            dom.appendChild(el2, el3);
            var el3 = dom.createTextNode("\n          ");
            dom.appendChild(el2, el3);
            var el3 = dom.createComment("");
            dom.appendChild(el2, el3);
            var el3 = dom.createTextNode("\n        ");
            dom.appendChild(el2, el3);
            dom.appendChild(el1, el2);
            var el2 = dom.createTextNode("\n      ");
            dom.appendChild(el1, el2);
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n      ");
            dom.appendChild(el0, el1);
            var el1 = dom.createElement("div");
            dom.setAttribute(el1, "class", "eight wide column");
            var el2 = dom.createTextNode("\n        ");
            dom.appendChild(el1, el2);
            var el2 = dom.createElement("div");
            dom.setAttribute(el2, "class", "ui vertical segment");
            var el3 = dom.createTextNode("\n          ");
            dom.appendChild(el2, el3);
            var el3 = dom.createElement("h3");
            dom.setAttribute(el3, "class", "ui center aligned block header");
            var el4 = dom.createTextNode(" How many students have misconceptions? ");
            dom.appendChild(el3, el4);
            dom.appendChild(el2, el3);
            var el3 = dom.createTextNode("\n        ");
            dom.appendChild(el2, el3);
            dom.appendChild(el1, el2);
            var el2 = dom.createTextNode("\n      ");
            dom.appendChild(el1, el2);
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n    ");
            dom.appendChild(el0, el1);
            return el0;
          },
          buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
            var morphs = new Array(1);
            morphs[0] = dom.createMorphAt(dom.childAt(fragment, [1, 1]), 3, 3);
            return morphs;
          },
          statements: [["inline", "bullet-chart", [], ["skills", ["subexpr", "@mut", [["get", "skills", ["loc", [null, [35, 32], [35, 38]]]]], [], []], "students", ["subexpr", "@mut", [["get", "students", ["loc", [null, [35, 48], [35, 56]]]]], [], []], "skillMasteries", ["subexpr", "@mut", [["get", "skillMasteries", ["loc", [null, [35, 72], [35, 86]]]]], [], []]], ["loc", [null, [35, 10], [35, 88]]]]],
          locals: [],
          templates: []
        };
      })();
      return {
        meta: {
          "fragmentReason": false,
          "revision": "Ember@2.5.1",
          "loc": {
            "source": null,
            "start": {
              "line": 31,
              "column": 4
            },
            "end": {
              "line": 43,
              "column": 4
            }
          },
          "moduleName": "dashboard/index/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
          dom.insertBoundary(fragment, 0);
          dom.insertBoundary(fragment, null);
          return morphs;
        },
        statements: [["block", "if", [["subexpr", "eq", [["get", "menu", ["loc", [null, [31, 18], [31, 22]]]], "overview"], [], ["loc", [null, [31, 14], [31, 34]]]]], [], 0, null, ["loc", [null, [31, 4], [43, 4]]]]],
        locals: [],
        templates: [child0]
      };
    })();
    return {
      meta: {
        "fragmentReason": {
          "name": "missing-wrapper",
          "problems": ["multiple-nodes"]
        },
        "revision": "Ember@2.5.1",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 57,
            "column": 0
          }
        },
        "moduleName": "dashboard/index/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createElement("div");
        dom.setAttribute(el1, "class", "ui top fixed blue inverted menu");
        var el2 = dom.createTextNode("\n  ");
        dom.appendChild(el1, el2);
        var el2 = dom.createElement("div");
        dom.setAttribute(el2, "class", "item");
        var el3 = dom.createTextNode(" Mr. Gill");
        dom.appendChild(el2, el3);
        dom.appendChild(el1, el2);
        var el2 = dom.createTextNode("\n  ");
        dom.appendChild(el1, el2);
        var el2 = dom.createElement("div");
        dom.setAttribute(el2, "class", "right menu");
        var el3 = dom.createTextNode("\n    ");
        dom.appendChild(el2, el3);
        var el3 = dom.createElement("a");
        dom.setAttribute(el3, "class", "item");
        var el4 = dom.createTextNode("Set Mastery Percentage");
        dom.appendChild(el3, el4);
        dom.appendChild(el2, el3);
        var el3 = dom.createTextNode("\n    ");
        dom.appendChild(el2, el3);
        var el3 = dom.createElement("div");
        dom.setAttribute(el3, "class", "ui simple dropdown item");
        var el4 = dom.createTextNode("\n      Sort By ");
        dom.appendChild(el3, el4);
        var el4 = dom.createElement("i");
        dom.setAttribute(el4, "class", "dropdown icon");
        dom.appendChild(el3, el4);
        var el4 = dom.createTextNode("\n      ");
        dom.appendChild(el3, el4);
        var el4 = dom.createElement("div");
        dom.setAttribute(el4, "class", "menu");
        var el5 = dom.createTextNode("\n        ");
        dom.appendChild(el4, el5);
        var el5 = dom.createElement("a");
        dom.setAttribute(el5, "class", "item");
        var el6 = dom.createTextNode("Most Mastered");
        dom.appendChild(el5, el6);
        dom.appendChild(el4, el5);
        var el5 = dom.createTextNode("\n        ");
        dom.appendChild(el4, el5);
        var el5 = dom.createElement("a");
        dom.setAttribute(el5, "class", "item");
        var el6 = dom.createTextNode("Most opportunity given");
        dom.appendChild(el5, el6);
        dom.appendChild(el4, el5);
        var el5 = dom.createTextNode("\n        ");
        dom.appendChild(el4, el5);
        var el5 = dom.createElement("a");
        dom.setAttribute(el5, "class", "item");
        var el6 = dom.createTextNode("Most error");
        dom.appendChild(el5, el6);
        dom.appendChild(el4, el5);
        var el5 = dom.createTextNode("\n      ");
        dom.appendChild(el4, el5);
        dom.appendChild(el3, el4);
        var el4 = dom.createTextNode("\n    ");
        dom.appendChild(el3, el4);
        dom.appendChild(el2, el3);
        var el3 = dom.createTextNode("\n  ");
        dom.appendChild(el2, el3);
        dom.appendChild(el1, el2);
        var el2 = dom.createTextNode("\n");
        dom.appendChild(el1, el2);
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createElement("div");
        dom.setAttribute(el1, "class", "ui padded centered grid");
        var el2 = dom.createTextNode("\n  ");
        dom.appendChild(el1, el2);
        var el2 = dom.createElement("div");
        dom.setAttribute(el2, "class", "row");
        var el3 = dom.createTextNode("\n    ");
        dom.appendChild(el2, el3);
        var el3 = dom.createElement("div");
        dom.setAttribute(el3, "class", "wide column");
        var el4 = dom.createTextNode("\n      ");
        dom.appendChild(el3, el4);
        var el4 = dom.createElement("div");
        dom.setAttribute(el4, "class", "ui secondary pointing menu");
        var el5 = dom.createTextNode("\n        ");
        dom.appendChild(el4, el5);
        var el5 = dom.createElement("a");
        var el6 = dom.createTextNode("Class Overview");
        dom.appendChild(el5, el6);
        dom.appendChild(el4, el5);
        var el5 = dom.createTextNode("\n        ");
        dom.appendChild(el4, el5);
        var el5 = dom.createElement("a");
        var el6 = dom.createTextNode("Student Overview");
        dom.appendChild(el5, el6);
        dom.appendChild(el4, el5);
        var el5 = dom.createTextNode("\n        ");
        dom.appendChild(el4, el5);
        var el5 = dom.createElement("a");
        var el6 = dom.createTextNode("Progress in Tutor");
        dom.appendChild(el5, el6);
        dom.appendChild(el4, el5);
        var el5 = dom.createTextNode("\n      ");
        dom.appendChild(el4, el5);
        dom.appendChild(el3, el4);
        var el4 = dom.createTextNode("\n    ");
        dom.appendChild(el3, el4);
        dom.appendChild(el2, el3);
        var el3 = dom.createTextNode("\n  ");
        dom.appendChild(el2, el3);
        dom.appendChild(el1, el2);
        var el2 = dom.createTextNode("\n\n  ");
        dom.appendChild(el1, el2);
        var el2 = dom.createElement("div");
        dom.setAttribute(el2, "class", "row");
        var el3 = dom.createTextNode("\n");
        dom.appendChild(el2, el3);
        var el3 = dom.createComment("");
        dom.appendChild(el2, el3);
        var el3 = dom.createTextNode("  ");
        dom.appendChild(el2, el3);
        dom.appendChild(el1, el2);
        var el2 = dom.createTextNode("\n");
        dom.appendChild(el1, el2);
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var element0 = dom.childAt(fragment, [2]);
        var element1 = dom.childAt(element0, [1, 1, 1]);
        var element2 = dom.childAt(element1, [1]);
        var element3 = dom.childAt(element1, [3]);
        var element4 = dom.childAt(element1, [5]);
        var morphs = new Array(7);
        morphs[0] = dom.createAttrMorph(element2, 'class');
        morphs[1] = dom.createElementMorph(element2);
        morphs[2] = dom.createAttrMorph(element3, 'class');
        morphs[3] = dom.createElementMorph(element3);
        morphs[4] = dom.createAttrMorph(element4, 'class');
        morphs[5] = dom.createElementMorph(element4);
        morphs[6] = dom.createMorphAt(dom.childAt(element0, [3]), 1, 1);
        return morphs;
      },
      statements: [["attribute", "class", ["concat", ["item ", ["subexpr", "if", [["subexpr", "eq", [["get", "menu", ["loc", [null, [19, 32], [19, 36]]]], "overview"], [], ["loc", [null, [19, 28], [19, 48]]]], "active"], [], ["loc", [null, [19, 23], [19, 59]]]]]]], ["element", "action", ["selectMenu", "overview"], [], ["loc", [null, [19, 61], [19, 95]]]], ["attribute", "class", ["concat", ["item ", ["subexpr", "if", [["subexpr", "eq", [["get", "menu", ["loc", [null, [20, 32], [20, 36]]]], "detail"], [], ["loc", [null, [20, 28], [20, 46]]]], "active"], [], ["loc", [null, [20, 23], [20, 57]]]]]]], ["element", "action", ["selectMenu", "detail"], [], ["loc", [null, [20, 59], [20, 91]]]], ["attribute", "class", ["concat", ["item ", ["subexpr", "if", [["subexpr", "eq", [["get", "menu", ["loc", [null, [21, 32], [21, 36]]]], "progress"], [], ["loc", [null, [21, 28], [21, 48]]]], "active"], [], ["loc", [null, [21, 23], [21, 59]]]]]]], ["element", "action", ["selectMenu", "progress"], [], ["loc", [null, [21, 61], [21, 95]]]], ["block", "if", [["subexpr", "eq", [["get", "menu", ["loc", [null, [27, 14], [27, 18]]]], "detail"], [], ["loc", [null, [27, 10], [27, 28]]]]], [], 0, 1, ["loc", [null, [27, 4], [43, 11]]]]],
      locals: [],
      templates: [child0, child1]
    };
  })());
});
define('dashboard/initializers/app-version', ['exports', 'ember-cli-app-version/initializer-factory', 'dashboard/config/environment'], function (exports, _emberCliAppVersionInitializerFactory, _dashboardConfigEnvironment) {
  exports['default'] = {
    name: 'App Version',
    initialize: (0, _emberCliAppVersionInitializerFactory['default'])(_dashboardConfigEnvironment['default'].APP.name, _dashboardConfigEnvironment['default'].APP.version)
  };
});
define('dashboard/initializers/container-debug-adapter', ['exports', 'ember-resolver/container-debug-adapter'], function (exports, _emberResolverContainerDebugAdapter) {
  exports['default'] = {
    name: 'container-debug-adapter',

    initialize: function initialize() {
      var app = arguments[1] || arguments[0];

      app.register('container-debug-adapter:main', _emberResolverContainerDebugAdapter['default']);
      app.inject('container-debug-adapter:main', 'namespace', 'application:main');
    }
  };
});
define('dashboard/initializers/data-adapter', ['exports', 'ember'], function (exports, _ember) {

  /*
    This initializer is here to keep backwards compatibility with code depending
    on the `data-adapter` initializer (before Ember Data was an addon).
  
    Should be removed for Ember Data 3.x
  */

  exports['default'] = {
    name: 'data-adapter',
    before: 'store',
    initialize: _ember['default'].K
  };
});
define('dashboard/initializers/ember-cli-mirage', ['exports', 'ember-cli-mirage/utils/read-modules', 'dashboard/config/environment', 'dashboard/mirage/config', 'ember-cli-mirage/server', 'lodash/object/assign'], function (exports, _emberCliMirageUtilsReadModules, _dashboardConfigEnvironment, _dashboardMirageConfig, _emberCliMirageServer, _lodashObjectAssign) {
  exports.startMirage = startMirage;
  exports['default'] = {
    name: 'ember-cli-mirage',
    initialize: function initialize(application) {
      if (arguments.length > 1) {
        // Ember < 2.1
        var container = arguments[0],
            application = arguments[1];
      }

      if (_shouldUseMirage(_dashboardConfigEnvironment['default'].environment, _dashboardConfigEnvironment['default']['ember-cli-mirage'])) {
        startMirage(_dashboardConfigEnvironment['default']);
      }
    }
  };

  function startMirage() {
    var env = arguments.length <= 0 || arguments[0] === undefined ? _dashboardConfigEnvironment['default'] : arguments[0];

    var environment = env.environment;
    var modules = (0, _emberCliMirageUtilsReadModules['default'])(env.modulePrefix);
    var options = (0, _lodashObjectAssign['default'])(modules, { environment: environment, baseConfig: _dashboardMirageConfig['default'], testConfig: _dashboardMirageConfig.testConfig });

    return new _emberCliMirageServer['default'](options);
  }

  function _shouldUseMirage(env, addonConfig) {
    var userDeclaredEnabled = typeof addonConfig.enabled !== 'undefined';
    var defaultEnabled = _defaultEnabled(env, addonConfig);

    return userDeclaredEnabled ? addonConfig.enabled : defaultEnabled;
  }

  /*
    Returns a boolean specifying the default behavior for whether
    to initialize Mirage.
  */
  function _defaultEnabled(env, addonConfig) {
    var usingInDev = env === 'development' && !addonConfig.usingProxy;
    var usingInTest = env === 'test';

    return usingInDev || usingInTest;
  }
});
define('dashboard/initializers/ember-data', ['exports', 'ember-data/setup-container', 'ember-data/-private/core'], function (exports, _emberDataSetupContainer, _emberDataPrivateCore) {

  /*
  
    This code initializes Ember-Data onto an Ember application.
  
    If an Ember.js developer defines a subclass of DS.Store on their application,
    as `App.StoreService` (or via a module system that resolves to `service:store`)
    this code will automatically instantiate it and make it available on the
    router.
  
    Additionally, after an application's controllers have been injected, they will
    each have the store made available to them.
  
    For example, imagine an Ember.js application with the following classes:
  
    App.StoreService = DS.Store.extend({
      adapter: 'custom'
    });
  
    App.PostsController = Ember.ArrayController.extend({
      // ...
    });
  
    When the application is initialized, `App.ApplicationStore` will automatically be
    instantiated, and the instance of `App.PostsController` will have its `store`
    property set to that instance.
  
    Note that this code will only be run if the `ember-application` package is
    loaded. If Ember Data is being used in an environment other than a
    typical application (e.g., node.js where only `ember-runtime` is available),
    this code will be ignored.
  */

  exports['default'] = {
    name: 'ember-data',
    initialize: _emberDataSetupContainer['default']
  };
});
define('dashboard/initializers/export-application-global', ['exports', 'ember', 'dashboard/config/environment'], function (exports, _ember, _dashboardConfigEnvironment) {
  exports.initialize = initialize;

  function initialize() {
    var application = arguments[1] || arguments[0];
    if (_dashboardConfigEnvironment['default'].exportApplicationGlobal !== false) {
      var value = _dashboardConfigEnvironment['default'].exportApplicationGlobal;
      var globalName;

      if (typeof value === 'string') {
        globalName = value;
      } else {
        globalName = _ember['default'].String.classify(_dashboardConfigEnvironment['default'].modulePrefix);
      }

      if (!window[globalName]) {
        window[globalName] = application;

        application.reopen({
          willDestroy: function willDestroy() {
            this._super.apply(this, arguments);
            delete window[globalName];
          }
        });
      }
    }
  }

  exports['default'] = {
    name: 'export-application-global',

    initialize: initialize
  };
});
define('dashboard/initializers/injectStore', ['exports', 'ember'], function (exports, _ember) {

  /*
    This initializer is here to keep backwards compatibility with code depending
    on the `injectStore` initializer (before Ember Data was an addon).
  
    Should be removed for Ember Data 3.x
  */

  exports['default'] = {
    name: 'injectStore',
    before: 'store',
    initialize: _ember['default'].K
  };
});
define('dashboard/initializers/store', ['exports', 'ember'], function (exports, _ember) {

  /*
    This initializer is here to keep backwards compatibility with code depending
    on the `store` initializer (before Ember Data was an addon).
  
    Should be removed for Ember Data 3.x
  */

  exports['default'] = {
    name: 'store',
    after: 'ember-data',
    initialize: _ember['default'].K
  };
});
define('dashboard/initializers/transforms', ['exports', 'ember'], function (exports, _ember) {

  /*
    This initializer is here to keep backwards compatibility with code depending
    on the `transforms` initializer (before Ember Data was an addon).
  
    Should be removed for Ember Data 3.x
  */

  exports['default'] = {
    name: 'transforms',
    before: 'store',
    initialize: _ember['default'].K
  };
});
define("dashboard/instance-initializers/ember-data", ["exports", "ember-data/-private/instance-initializers/initialize-store-service"], function (exports, _emberDataPrivateInstanceInitializersInitializeStoreService) {
  exports["default"] = {
    name: "ember-data",
    initialize: _emberDataPrivateInstanceInitializersInitializeStoreService["default"]
  };
});
define('dashboard/live/controller', ['exports', 'ember'], function (exports, _ember) {
  exports['default'] = _ember['default'].Controller.extend({
    seconds: 0
  });
});
define('dashboard/live/route', ['exports', 'ember'], function (exports, _ember) {
  exports['default'] = _ember['default'].Route.extend({});
});
define("dashboard/live/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    return {
      meta: {
        "fragmentReason": {
          "name": "triple-curlies"
        },
        "revision": "Ember@2.5.1",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 13,
            "column": 0
          }
        },
        "moduleName": "dashboard/live/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createElement("div");
        dom.setAttribute(el1, "class", "ui padded grid");
        var el2 = dom.createTextNode("\n  ");
        dom.appendChild(el1, el2);
        var el2 = dom.createElement("div");
        dom.setAttribute(el2, "class", "row");
        var el3 = dom.createTextNode("\n    ");
        dom.appendChild(el2, el3);
        var el3 = dom.createElement("div");
        dom.setAttribute(el3, "class", "sixteen wide column");
        var el4 = dom.createTextNode("\n      ");
        dom.appendChild(el3, el4);
        var el4 = dom.createComment("");
        dom.appendChild(el3, el4);
        var el4 = dom.createTextNode("\n    ");
        dom.appendChild(el3, el4);
        dom.appendChild(el2, el3);
        var el3 = dom.createTextNode("\n  ");
        dom.appendChild(el2, el3);
        dom.appendChild(el1, el2);
        var el2 = dom.createTextNode("\n  ");
        dom.appendChild(el1, el2);
        var el2 = dom.createElement("div");
        dom.setAttribute(el2, "class", "row");
        var el3 = dom.createTextNode("\n    ");
        dom.appendChild(el2, el3);
        var el3 = dom.createElement("div");
        dom.setAttribute(el3, "class", "sixteen wide column");
        var el4 = dom.createTextNode("\n      ");
        dom.appendChild(el3, el4);
        var el4 = dom.createComment("");
        dom.appendChild(el3, el4);
        var el4 = dom.createTextNode("\n    ");
        dom.appendChild(el3, el4);
        dom.appendChild(el2, el3);
        var el3 = dom.createTextNode("\n  ");
        dom.appendChild(el2, el3);
        dom.appendChild(el1, el2);
        var el2 = dom.createTextNode("\n");
        dom.appendChild(el1, el2);
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var element0 = dom.childAt(fragment, [0]);
        var morphs = new Array(2);
        morphs[0] = dom.createMorphAt(dom.childAt(element0, [1, 1]), 1, 1);
        morphs[1] = dom.createMorphAt(dom.childAt(element0, [3, 1]), 1, 1);
        return morphs;
      },
      statements: [["content", "live-number", ["loc", [null, [4, 6], [4, 21]]]], ["content", "notification-receiver", ["loc", [null, [9, 6], [9, 31]]]]],
      locals: [],
      templates: []
    };
  })());
});
define('dashboard/mirage/config', ['exports'], function (exports) {
  exports['default'] = function () {

    // These comments are here to help you get started. Feel free to delete them.

    /*
      Config (with defaults).
      Note: these only affect routes defined *after* them!
    */

    // this.urlPrefix = '';    // make this `http://localhost:8080`, for example, if your API is on a different server
    // this.namespace = '';    // make this `api`, for example, if your API is namespaced
    // this.timing = 400;      // delay for each request, automatically set to 0 during testing

    /*
      Shorthand cheatsheet:
      this.get('/posts');
      this.post('/posts');
      this.get('/posts/:id');
      this.put('/posts/:id'); // or this.patch
      this.del('/posts/:id');
      http://www.ember-cli-mirage.com/docs/v0.2.0-beta.7/shorthands/
    */

    this.get('/skills', function () {
      return {
        data: [{
          type: 'skills',
          id: 1,
          attributes: {
            name: "Add/Subtract Constant From Both Sides"
          }
        }, {
          type: 'skills',
          id: 2,
          attributes: {
            name: "Combine Constant Terms"
          }
        }, {
          type: 'skills',
          id: 3,
          attributes: {
            name: "Divide Both Sides By The Variable Coefficient"
          }
        }, {
          type: 'skills',
          id: 4,
          attributes: {
            name: "Compute Quotient For Constant"
          }
        }, {
          type: 'skills',
          id: 5,
          attributes: {
            name: "Compute Quotient For Variable Coefficient"
          }
        }, {
          type: 'skills',
          id: 6,
          attributes: {
            name: "Multiply Simple Terms"
          }
        }, {
          type: 'skills',
          id: 7,
          attributes: {
            name: "Distribute"
          }
        }, {
          type: 'skills',
          id: 8,
          attributes: {
            name: "Combine Variable Terms"
          }
        }, {
          type: 'skills',
          id: 9,
          attributes: {
            name: "Add/Subtract Variable From Both Sides"
          }
        }]
      };
    });

    this.get('/students', function () {
      return {
        data: [{
          type: 'students',
          id: 1,
          attributes: {
            name: "Adeline Sweet"
          }
        }, {
          type: 'students',
          id: 2,
          attributes: {
            name: "Austin Smith"
          }
        }, {
          type: 'students',
          id: 3,
          attributes: {
            name: "Christina Day"
          }
        }, {
          type: 'students',
          id: 4,
          attributes: {
            name: "Faith Aller"
          }
        }, {
          type: 'students',
          id: 5,
          attributes: {
            name: "Gaven Moore"
          }
        }, {
          type: 'students',
          id: 6,
          attributes: {
            name: "Haley Barkovich"
          }
        }, {
          type: 'students',
          id: 7,
          attributes: {
            name: "Kai Swan"
          }
        }, {
          type: 'students',
          id: 8,
          attributes: {
            name: "Landin Pillar"
          }
        }, {
          type: 'students',
          id: 9,
          attributes: {
            name: "Leah Driscoll"
          }
        }]
      };
    });

    this.get('/skill-masteries', function () {
      return {
        data: [{
          type: 'skill-masteries',
          id: 1,
          attributes: {
            "student-id": 1,
            "skill-id": 2,
            percentage: 0.98,
            opportunity: 15
          }
        }, {
          type: 'skill-masteries',
          id: 91,
          attributes: {
            "student-id": 1,
            "skill-id": 3,
            percentage: 0.98,
            opportunity: 15
          }
        }, {
          type: 'skill-masteries',
          id: 92,
          attributes: {
            "student-id": 1,
            "skill-id": 4,
            percentage: 0.98,
            opportunity: 15
          }
        }, {
          type: 'skill-masteries',
          id: 93,
          attributes: {
            "student-id": 1,
            "skill-id": 6,
            percentage: 0.98,
            opportunity: 15
          }
        }, {
          type: 'skill-masteries',
          id: 2,
          attributes: {
            "student-id": 1,
            "skill-id": 3,
            percentage: 0.75,
            opportunity: 15
          }
        }, {
          type: 'skill-masteries',
          id: 3,
          attributes: {
            "student-id": 2,
            "skill-id": 1,
            percentage: 0.40,
            opportunity: 3
          }
        }, {
          type: 'skill-masteries',
          id: 4,
          attributes: {
            "student-id": 2,
            "skill-id": 2,
            percentage: 0.97,
            opportunity: 20
          }
        }, {
          type: 'skill-masteries',
          id: 5,
          attributes: {
            "student-id": 2,
            "skill-id": 3,
            percentage: 0.92,
            opportunity: 10
          }
        }, {
          type: 'skill-masteries',
          id: 6,
          attributes: {
            "student-id": 2,
            "skill-id": 4,
            percentage: 0.98,
            opportunity: 10
          }
        }, {
          type: 'skill-masteries',
          id: 7,
          attributes: {
            "student-id": 3,
            "skill-id": 7,
            percentage: 0.92,
            opportunity: 10
          }
        }, {
          type: 'skill-masteries',
          id: 8,
          attributes: {
            "student-id": 5,
            "skill-id": 8,
            percentage: 0.92,
            opportunity: 10
          }
        }, {
          type: 'skill-masteries',
          id: 9,
          attributes: {
            "student-id": 7,
            "skill-id": 4,
            percentage: 0.98,
            opportunity: 10
          }
        }, {
          type: 'skill-masteries',
          id: 10,
          attributes: {
            "student-id": 2,
            "skill-id": 8,
            percentage: 0.92,
            opportunity: 10
          }
        }, {
          type: 'skill-masteries',
          id: 11,
          attributes: {
            "student-id": 3,
            "skill-id": 2,
            percentage: 0.98,
            opportunity: 10
          }
        }, {
          type: 'skill-masteries',
          id: 12,
          attributes: {
            "student-id": 5,
            "skill-id": 1,
            percentage: 0.92,
            opportunity: 10
          }
        }, {
          type: 'skill-masteries',
          id: 13,
          attributes: {
            "student-id": 7,
            "skill-id": 4,
            percentage: 0.98,
            opportunity: 10
          }
        }, {
          type: 'skill-masteries',
          id: 14,
          attributes: {
            "student-id": 2,
            "skill-id": 4,
            percentage: 0.92,
            opportunity: 10
          }
        }, {
          type: 'skill-masteries',
          id: 15,
          attributes: {
            "student-id": 3,
            "skill-id": 5,
            percentage: 0.92,
            opportunity: 10
          }
        }, {
          type: 'skill-masteries',
          id: 16,
          attributes: {
            "student-id": 6,
            "skill-id": 5,
            percentage: 0.98,
            opportunity: 12
          }
        }, {
          type: 'skill-masteries',
          id: 17,
          attributes: {
            "student-id": 7,
            "skill-id": 2,
            percentage: 0.20,
            opportunity: 3
          }
        }, {
          type: 'skill-masteries',
          id: 19,
          attributes: {
            "student-id": 8,
            "skill-id": 9,
            percentage: 0.98,
            opportunity: 10
          }
        }, {
          type: 'skill-masteries',
          id: 20,
          attributes: {
            "student-id": 8,
            "skill-id": 8,
            percentage: 0.98,
            opportunity: 12
          }
        }, {
          type: 'skill-masteries',
          id: 21,
          attributes: {
            "student-id": 8,
            "skill-id": 7,
            percentage: 0.20,
            opportunity: 13
          }
        }, {
          type: 'skill-masteries',
          id: 55,
          attributes: {
            "student-id": 9,
            "skill-id": 1,
            percentage: 0.98,
            opportunity: 10
          }
        }, {
          type: 'skill-masteries',
          id: 56,
          attributes: {
            "student-id": 9,
            "skill-id": 3,
            percentage: 0.98,
            opportunity: 12
          }
        }, {
          type: 'skill-masteries',
          id: 57,
          attributes: {
            "student-id": 9,
            "skill-id": 7,
            percentage: 0.98,
            opportunity: 30
          }
        }, {
          type: 'skill-masteries',
          id: 65,
          attributes: {
            "student-id": 7,
            "skill-id": 5,
            percentage: 0.98,
            opportunity: 10
          }
        }, {
          type: 'skill-masteries',
          id: 66,
          attributes: {
            "student-id": 8,
            "skill-id": 5,
            percentage: 0.98,
            opportunity: 12
          }
        }, {
          type: 'skill-masteries',
          id: 67,
          attributes: {
            "student-id": 9,
            "skill-id": 5,
            percentage: 0.98,
            opportunity: 3
          }
        }, {
          type: 'skill-masteries',
          id: 68,
          attributes: {
            "student-id": 4,
            "skill-id": 5,
            percentage: 0.98,
            opportunity: 13
          }
        }, {
          type: 'skill-masteries',
          id: 48,
          attributes: {
            "student-id": 6,
            "skill-id": 7,
            percentage: 0.98,
            opportunity: 13
          }
        }]
      };
    });

    this.get('/misconceptions', function () {
      return {
        data: [{
          type: 'misconceptions',
          id: 1,
          attributes: {
            name: "Combine unlike terms to make constant",
            count: 8
          }
        }, {
          type: 'misconceptions',
          id: 2,
          attributes: {
            name: "Combine unlike terms to make variable",
            count: 8
          }
        }, {
          type: 'misconceptions',
          id: 3,
          attributes: {
            name: "Different transformation on both sides",
            count: 2
          }
        }, {
          type: 'misconceptions',
          id: 4,
          attributes: {
            name: "Do transformation on one side only",
            count: 6
          }
        }, {
          type: 'misconceptions',
          id: 5,
          attributes: {
            name: "Substract instead of divide",
            count: 1
          }
        }]
      };
    });
  };
});
define("dashboard/mirage/scenarios/default", ["exports"], function (exports) {
  exports["default"] = function () /* server */{

    /*
      Seed your development database using your factories.
      This data will not be loaded in your tests.
       Make sure to define a factory for each model you want to create.
    */

    // server.createList('post', 10);
  };
});
define('dashboard/mirage/serializers/application', ['exports', 'ember-cli-mirage'], function (exports, _emberCliMirage) {
  exports['default'] = _emberCliMirage.JSONAPISerializer.extend({});
});
define('dashboard/misconception/model', ['exports', 'ember-data/model', 'ember-data/attr'], function (exports, _emberDataModel, _emberDataAttr) {
  exports['default'] = _emberDataModel['default'].extend({
    title: (0, _emberDataAttr['default'])(),
    count: (0, _emberDataAttr['default'])()
  });
});
define('dashboard/resolver', ['exports', 'ember-resolver'], function (exports, _emberResolver) {
  exports['default'] = _emberResolver['default'];
});
define('dashboard/router', ['exports', 'ember', 'dashboard/config/environment'], function (exports, _ember, _dashboardConfigEnvironment) {

  var Router = _ember['default'].Router.extend({
    location: _dashboardConfigEnvironment['default'].locationType
  });

  Router.map(function () {
    this.route('live');
    this.route('detail');
  });

  exports['default'] = Router;
});
define('dashboard/services/ajax', ['exports', 'ember-ajax/services/ajax'], function (exports, _emberAjaxServicesAjax) {
  Object.defineProperty(exports, 'default', {
    enumerable: true,
    get: function get() {
      return _emberAjaxServicesAjax['default'];
    }
  });
});
define('dashboard/services/moment', ['exports', 'ember', 'dashboard/config/environment', 'ember-moment/services/moment'], function (exports, _ember, _dashboardConfigEnvironment, _emberMomentServicesMoment) {
  exports['default'] = _emberMomentServicesMoment['default'].extend({
    defaultFormat: _ember['default'].get(_dashboardConfigEnvironment['default'], 'moment.outputFormat')
  });
});
define('dashboard/skill/model', ['exports', 'ember-data/model', 'ember-data/attr'], function (exports, _emberDataModel, _emberDataAttr) {
  exports['default'] = _emberDataModel['default'].extend({
    name: (0, _emberDataAttr['default'])()
  });
});
define('dashboard/skill-mastery/model', ['exports', 'ember-data/model', 'ember-data/attr'], function (exports, _emberDataModel, _emberDataAttr) {
  // import { belongsTo, hasMany } from 'ember-data/relationships';

  exports['default'] = _emberDataModel['default'].extend({
    studentId: (0, _emberDataAttr['default'])(),
    skillId: (0, _emberDataAttr['default'])(),
    percentage: (0, _emberDataAttr['default'])(),
    opportunity: (0, _emberDataAttr['default'])()
  });
});
define('dashboard/student/model', ['exports', 'ember-data/model', 'ember-data/attr'], function (exports, _emberDataModel, _emberDataAttr) {
  // import { belongsTo, hasMany } from 'ember-data/relationships';

  exports['default'] = _emberDataModel['default'].extend({
    name: (0, _emberDataAttr['default'])()
  });
});
define("dashboard/templates/application", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    return {
      meta: {
        "fragmentReason": {
          "name": "missing-wrapper",
          "problems": ["wrong-type"]
        },
        "revision": "Ember@2.5.1",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 2,
            "column": 0
          }
        },
        "moduleName": "dashboard/templates/application.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var morphs = new Array(1);
        morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
        dom.insertBoundary(fragment, 0);
        return morphs;
      },
      statements: [["content", "outlet", ["loc", [null, [1, 0], [1, 10]]]]],
      locals: [],
      templates: []
    };
  })());
});
define("dashboard/templates/components/ui-checkbox", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    return {
      meta: {
        "fragmentReason": {
          "name": "missing-wrapper",
          "problems": ["multiple-nodes"]
        },
        "revision": "Ember@2.5.1",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 3,
            "column": 0
          }
        },
        "moduleName": "dashboard/templates/components/ui-checkbox.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createElement("input");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createElement("label");
        var el2 = dom.createComment("");
        dom.appendChild(el1, el2);
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var element0 = dom.childAt(fragment, [0]);
        if (this.cachedFragment) {
          dom.repairClonedNode(element0, [], true);
        }
        var morphs = new Array(5);
        morphs[0] = dom.createAttrMorph(element0, 'type');
        morphs[1] = dom.createAttrMorph(element0, 'name');
        morphs[2] = dom.createAttrMorph(element0, 'checked');
        morphs[3] = dom.createAttrMorph(element0, 'data-id');
        morphs[4] = dom.createMorphAt(dom.childAt(fragment, [2]), 0, 0);
        return morphs;
      },
      statements: [["attribute", "type", ["get", "type", ["loc", [null, [1, 14], [1, 18]]]]], ["attribute", "name", ["get", "name", ["loc", [null, [1, 28], [1, 32]]]]], ["attribute", "checked", ["get", "checked", ["loc", [null, [1, 45], [1, 52]]]]], ["attribute", "data-id", ["get", "data-id", ["loc", [null, [1, 65], [1, 72]]]]], ["content", "label", ["loc", [null, [2, 7], [2, 16]]]]],
      locals: [],
      templates: []
    };
  })());
});
define("dashboard/templates/components/ui-radio", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    return {
      meta: {
        "fragmentReason": {
          "name": "missing-wrapper",
          "problems": ["multiple-nodes"]
        },
        "revision": "Ember@2.5.1",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 3,
            "column": 0
          }
        },
        "moduleName": "dashboard/templates/components/ui-radio.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createElement("input");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createElement("label");
        var el2 = dom.createComment("");
        dom.appendChild(el1, el2);
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var element0 = dom.childAt(fragment, [0]);
        if (this.cachedFragment) {
          dom.repairClonedNode(element0, [], true);
        }
        var morphs = new Array(6);
        morphs[0] = dom.createAttrMorph(element0, 'type');
        morphs[1] = dom.createAttrMorph(element0, 'name');
        morphs[2] = dom.createAttrMorph(element0, 'checked');
        morphs[3] = dom.createAttrMorph(element0, 'disabled');
        morphs[4] = dom.createAttrMorph(element0, 'data-id');
        morphs[5] = dom.createMorphAt(dom.childAt(fragment, [2]), 0, 0);
        return morphs;
      },
      statements: [["attribute", "type", ["get", "type", ["loc", [null, [1, 14], [1, 18]]]]], ["attribute", "name", ["get", "name", ["loc", [null, [1, 28], [1, 32]]]]], ["attribute", "checked", ["get", "checked", ["loc", [null, [1, 45], [1, 52]]]]], ["attribute", "disabled", ["get", "readonly", ["loc", [null, [1, 66], [1, 74]]]]], ["attribute", "data-id", ["get", "data-id", ["loc", [null, [1, 87], [1, 94]]]]], ["content", "label", ["loc", [null, [2, 7], [2, 16]]]]],
      locals: [],
      templates: []
    };
  })());
});
/* jshint ignore:start */



/* jshint ignore:end */

/* jshint ignore:start */

define('dashboard/config/environment', ['ember'], function(Ember) {
  var prefix = 'dashboard';
/* jshint ignore:start */

try {
  var metaName = prefix + '/config/environment';
  var rawConfig = Ember['default'].$('meta[name="' + metaName + '"]').attr('content');
  var config = JSON.parse(unescape(rawConfig));

  return { 'default': config };
}
catch(err) {
  throw new Error('Could not read config from meta tag with name "' + metaName + '".');
}

/* jshint ignore:end */

});

/* jshint ignore:end */

/* jshint ignore:start */

if (!runningTests) {
  require("dashboard/app")["default"].create({"name":"dashboard","version":"0.0.0+52a01558"});
}

/* jshint ignore:end */
//# sourceMappingURL=dashboard.map