/** @module core/config */

const defaultConfigs = {
    serverMode: false,
};

/**
 * Initialize and return configurations for AggHouse.
 * @param {Object} optionalConfigs Optional configurations.
 * @return {Object} Initialized configurations.
 */
function initConfigs(optionalConfigs) {
    return Object.assign({}, defaultConfigs, optionalConfigs);
}

export default {initConfigs};
