/* eslint-env node */

module.exports = function(grunt) {
    grunt.loadNpmTasks('gruntify-eslint');
    require('load-grunt-tasks')(grunt);

    grunt.initConfig({
        eslint: {
            dist: {
                src: ['Gruntfile.js', 'src/**/*.js'],
            },
        },
        browserify: {
            dist: {
                src: 'src/**/*.js',
                dest: 'dist/agg-house.js',
                options: {
                    browserifyOptions: {debug: true},
                    transform: [['babelify', {
                        'presets': ['es2015'],
                    }]],
                },
            },
        },
        uglify: {
            dist: {
                options: {
                    sourceMap: true,
                },
                files: [{
                    src: 'dist/agg-house.js',
                    dest: 'dist/agg-house.min.js',
                }],
            },
        },
        jsdoc: {
            dist: {
                src: ['src/**/*.js'],
                options: {
                    destination: 'docs',
                },
            },
        },
    });

    grunt.registerTask('default', ['eslint', 'browserify', 'uglify']);
};
