import { moduleForComponent, test } from 'ember-qunit';
import hbs from 'htmlbars-inline-precompile';

moduleForComponent('circle-indicator', 'Integration | Component | circle indicator', {
  integration: true
});

test('it renders', function(assert) {
  // Set any properties with this.set('myProperty', 'value');
  // Handle any actions with this.on('myAction', function(val) { ... });

  this.render(hbs`{{circle-indicator}}`);

  assert.equal(this.$().text().trim(), '');
});

test('it displays a checkmark when type is positive', function(assert) {
  this.render(hbs`{{circle-indicator indicatorType="positive"}}`);

  assert.ok(this.$().find('i').hasClass('checkmark'));
});

test('it displays a svg circle when type is negative', function(assert) {
  this.render(hbs`{{circle-indicator indicatorType="negative"}}`);

  assert.ok(this.$().find('svg circle').length);
});

test('it displays a svg circle when type is indeterminate', function(assert) {
  this.render(hbs`{{circle-indicator indicatorType="indeterminate"}}`);

  assert.ok(this.$().find('svg circle').length);
});
