import Ember from 'ember';

export default Ember.Route.extend({
  model(params) {
    return {
      'classId': parseInt(params.id) || '4'
    };
  },

  setupController(controller, model) {
    var students = [];
    var detectorStates = {};
    var detectors = [];
    var aggHouse = new AggHouse();
    aggHouse.loadAggregator(window.__agg_excessive_help);

    var onNewLiveMessage = function(data) {
      if (data.detector_results) {
        data.detector_results.forEach(function(result) {
          aggHouse.processUpdate(result, model.classId);
          if (!students.some(student => student['id'] === result.user_id)) {
            students.pushObject({
              id: result.user_id,
              name: result.user_name
            });
            detectorStates[result.user_id] = {};
          }
          if (!detectors.some(detector => detector['id'] === result.name)) {
            detectors.pushObject({
              id: result.name,
              name: result.name
            });
          }
          detectorStates[result.user_id][result.name] = result.value;
        });
        controller.set('detectorStates', Object.assign({}, detectorStates));
        // test code below

        controller.set('notificationMessage', 'Aggregator[excessive-help]: ' + JSON.stringify(aggHouse.getData('excessive-help')));
      }
      if (data.class) {
        controller.set('className', data.class.name);
      }
    };

    controller.set('className', 'Class Dashboard');
    controller.set('classId', model.classId);
    controller.set('detectorStates', detectorStates);
    controller.set('detectors', detectors);
    controller.set('liveError', '');
    controller.set('menu', "detector");
    controller.set('onNewLiveMessage', onNewLiveMessage);
    controller.set('rawData', 'Loading...');
    controller.set('students', students);
  }
});
