import Ember from 'ember';
import CircleIndicator from '../components/circle-indicator/constants';

export function getSkillMastery(params/*, hash*/) {
  var skillMasteries = params[0];
  var skillId = params[1];
  var studentId = params[2];
  if (skillMasteries[skillId] && skillMasteries[skillId][studentId]) {
    var studentInfo = skillMasteries[skillId][studentId];
    if (studentInfo.percentage > 0.95) {
      return CircleIndicator.Type.POSITIVE;
    } else if (studentInfo.opportunity < 10) {
      return CircleIndicator.Type.INDETERMINATE;
    } else {
      return CircleIndicator.Type.NEGATIVE;
    }
  }
  return CircleIndicator.Type.INDETERMINATE;
}

export default Ember.Helper.helper(getSkillMastery);
