import Ember from 'ember';
import CircleIndicator from '../components/circle-indicator/constants';

export function getDetectorState(params/*, hash*/) {
  var detectorStates = params[0];
  var studentId = params[1];
  var detectorId = params[2];
  var rawData = params[3];
  if (detectorStates && detectorStates[studentId] && detectorStates[studentId][detectorId]) {
    var detectorState = detectorStates[studentId][detectorId];
    if (rawData === true) {
      return detectorState;
    } else if (detectorId === 'help_model') {
      if (detectorState === 'preferred' || detectorState === 'acceptable') {
        return CircleIndicator.Type.POSITIVE;
      } else {
        return CircleIndicator.Type.NEGATIVE;
      }
    } else if (detectorId === 'current_attempt_count') {
      return parseInt(detectorState) > 3 ? CircleIndicator.Type.NEGATIVE : CircleIndicator.Type.POSITIVE;
    } else {
      return CircleIndicator.Type.INDETERMINATE;
    }
  }
  return rawData ? undefined : CircleIndicator.Type.INDETERMINATE;
}

export default Ember.Helper.helper(getDetectorState);
