import Ember from 'ember';

var self = this;

export default Ember.Component.extend({
  actions: {
    hideSeat(studentId) {
      var options = this.options.load();
      delete options.seats['seat-' + studentId];
      this.set('seatingChartOptions', options);
      this.options.save(options);
    },
    reset() {
      var options = {
        height: 400,
        seats: {}
      };
      this.set('seatingChartOptions', options);
      this.options.save(options);
    },
    showSeat(studentId) {
      var options = this.options.load();
      options.seats['seat-' + studentId] = {
        left: 0,
        top: 0
      };
      this.set('seatingChartOptions', options);
      this.options.save(options);
      window.setTimeout(function() {
        $('.movable-seat[data-id="seat-' + studentId + '"]').css({
          zIndex: ++self.currZIndex
        });
      }, 0);
    }
  },
  currZIndex: 100,
  options: {
    _KEY: 'dashboard:seating-chart-options:' + document.location.pathname,
    load: function() {
      var options = localStorage.getItem(this._KEY);
      return options ? JSON.parse(options) : {
        height: 400,
        seats: {}
      };
    },
    save: function(options) {
      localStorage.setItem(this._KEY, JSON.stringify(options));
    }
  },
  init() {
    // Call super init
    this._super(...arguments);

    this.set('seatingChartOptions', this.options.load());
  },
  didInsertElement() {
    this._super(...arguments);

    $(this.element).find('.seat-container').css({
      height: this.get('seatingChartOptions').height
    });

    var seats = this.get('seatingChartOptions').seats;
    $(this.element).find('.movable-seat').each(function(i, ele) {
      var seatId = $(ele).data('id');
      if (seatId in seats) {
        var seatOptions = seats[seatId];
        $(ele).data(seatOptions);
        ele.style.transform = 'translate(' + seatOptions.left + 'px, ' + seatOptions.top + 'px)';
      }
    });

    interact('.seat-container').resizable({
      preserveAspectRatio: false,
      edges: {left: false, right: false, bottom: true, top: false}
    }).on('resizemove', function(e) {
      var target = e.target,
          newHeight = e.rect.height > 400 ? e.rect.height : 400;
      $(target).data('height', newHeight).css({
        height: newHeight
      });
    }).on('resizeend', function(e) {
      var options = self.get('seatingChartOptions');
      options.height = $(e.target).data('height');
      self.set('seatingChartOptions', options);
      self.options.save(options);
    });

    interact('.movable-seat').draggable({
      autoScroll: true,
      restrict: {
        restriction: "parent",
        elementRect: { top: 0, left: 0, bottom: 1, right: 1},
      },
      onstart: function(e) {
        $(e.target).css({
          zIndex: ++self.currZIndex
        });
      },
      onmove: function(e) {
        var target = e.target,
            x = ($(target).data('left') || 0) + e.dx,
            y = ($(target).data('top') || 0) + e.dy;
        $(target).data({
          'left': x,
          'top': y
        });
        target.style.transform = 'translate(' + x + 'px, ' + y + 'px)';
      },
      onend: function(e) {
        var target = e.target,
            targetId = $(target).data('id'),
            seatOptions = {
              left: $(target).data('left'),
              top: $(target).data('top')
            };
        var options = self.get('seatingChartOptions');
        options.seats[targetId] = seatOptions;
        self.set('seatingChartOptions', options);
        self.options.save(options);
      }
    });
  },
  didRender() {
    this._super(...arguments);
    self = this; // keep `self` up-to-date after DOM redraw.
  },
});
