import Ember from 'ember';

export default Ember.Component.extend({
  init() {
    this._super(...arguments);
  },
  didInsertElement() {
    this._super(...arguments);
    $(this.element).find('div.segment').hover(function() {
      $(this.element).data('hovering', true);
    }, function() {
      $(this.element).data('hovering', false);
    });
    this.didUpdateAttrs();
  },
  didUpdateAttrs() {
    this._super(...arguments);
    if (!$(this.element).find('div.segment').data('hovering')) {
      var height = this.$().find('div.segment').prop('scrollHeight');
      $(this.element).find('div.segment').animate({
        scrollTop: height + 'px'
      });
    }
  }
});
