import Ember from 'ember';

export default Ember.Component.extend({
  actions: {
    dismiss(notificationId) {
      var notification = this._notificationQueue.filter(
        notification => notification.id === notificationId);
      this._notificationQueue.removeObjects(notification);
    },
    dismissAll() {
      this.set('notifications', this._notificationQueue = []);
    }
  },
  init() {
    this._dismissDelay = this.get('dismiss') || 0;
    this._super(...arguments);
    this._notificationQueue = [];
    this._notificationCount = 0;
    this.set('notifications', this._notificationQueue);
  },
  didUpdateAttrs() {
    var notificationText = this.get('message');
    var notification = {
      id: ++this._notificationCount,
      message: notificationText,
      time: Date.now()
    };
    this._notificationQueue.insertAt(0, notification);
    if (this._dismissDelay > 0) {
      var self = this;
      setTimeout(function() {
        self._notificationQueue.removeObject(notification);
      }, this._dismissDelay);
    }
  }
});
