import Ember from 'ember';
import LiveConnection from './constants';

export default Ember.Component.extend({
  init() {
    this._super(...arguments);
    var raw = '';
    var self = this;
    var classId = self.get('classId');
    var pull = self.get('method') === 'pull';
    var callback = self.get('onNewMessage');
    var handleData = function(data) {
      self.set('error', '');
      try {
        if (typeof data !== 'object') {
          data = JSON.parse(data);
        }
        raw += JSON.stringify(data, null, '  ') + '\n';
        self.set('raw', raw);
        callback(data);
      } catch (err) {
        console.error(err);
        self.set('error', LiveConnection.Errors.ERROR_UNKNOWN);
        return false;
      }
    };
    
    var connect = function() {
      if (!window.EventSource || pull) {
        $.ajaxSetup({xhrFields: {withCredentials: true}});
        var refreshData = function() {
          $.get(LiveConnection.Config.END_POINT.replace('{classId}', classId),
            handleData).fail(function() {
            self.set('error', LiveConnection.Errors.ERROR_CONNECTION_FAILURE);
          }).always(function() {
            setTimeout(refreshData, LiveConnection.Config.PULL_REFRESH_INTERVAL);
          });
        };
        refreshData();
      } else {
        var source = new EventSource(LiveConnection.Config.END_POINT.
          replace('{classId}', classId) + 'stream', {withCredentials: true});
        source.addEventListener('class', function(e) {
          handleData(e.data);
        }, false);
        source.addEventListener('detector_results', function(e) {
          handleData(e.data);
        }, false);
        source.addEventListener("error", function() {
          if (source.readyState === 2) {
            pull = true;
            connect();
          }
          self.set('error', LiveConnection.Errors.ERROR_CONNECTION_FAILURE);
        });
      }
    };

    connect();
  }
});
